/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.GuardedRef;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/DBFacadeProvider;", "", "()V", "connectionManager", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "createFacadeWithSingleLeasedConnection", "Lorg/jetbrains/dekaf/core/DBFacade;", "wrappedConnection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRemoteIntermediateFacade", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateFacade;", "withFacade", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "operation", "Lkotlin/Function1;", "intellij.database.impl"})
public final class DBFacadeProvider {
    private static final DatabaseConnectionManager connectionManager;
    public static final DBFacadeProvider INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void withFacade(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Function1<? super DBFacade, Unit> operation) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dataSource.getFamilyId());
        if (rdbms == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        Rdbms rdbms2 = rdbms;
        GuardedRef<DatabaseConnection> guardedRef = connectionManager.build(project, dataSource).create();
        if (guardedRef == null) {
            throw (Throwable)new RuntimeException("Failed to obtain connection");
        }
        try (GuardedRef<DatabaseConnection> connectionRef = guardedRef;){
            DatabaseConnection databaseConnection = connectionRef.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnection, (String)"connectionRef.get()");
            Rdbms rdbms3 = rdbms2;
            Intrinsics.checkExpressionValueIsNotNull((Object)rdbms3, (String)"rdbms");
            DBFacade facade = DBFacadeProvider.createFacadeWithSingleLeasedConnection(databaseConnection, rdbms3);
            try {
                operation.invoke((Object)facade);
            }
            finally {
                facade.disconnect();
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final DBFacade createFacadeWithSingleLeasedConnection(@NotNull DatabaseConnection wrappedConnection, @NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)wrappedConnection, (String)"wrappedConnection");
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        PrimeIntermediateFacade primeIntermediateFacade = INSTANCE.getRemoteIntermediateFacade(wrappedConnection, rdbms);
        AdaptIntermediateFacade integralIntermediateFacade = new AdaptIntermediateFacade(primeIntermediateFacade);
        BaseFacade facade = new BaseFacade((IntegralIntermediateFacade)integralIntermediateFacade);
        facade.connect();
        return (DBFacade)facade;
    }

    private final PrimeIntermediateFacade getRemoteIntermediateFacade(DatabaseConnection wrappedConnection, Rdbms rdbms) {
        PrimeIntermediateFacade remoteFacade;
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)wrappedConnection.getJdbcConnection(), RemoteConnection.class);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            Object object = RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RemoteUtil.castToLocal(j\u2026ediateFacade::class.java)");
            remoteFacade = (PrimeIntermediateFacade)object;
            boolean bl = Intrinsics.areEqual((Object)remoteFacade.rdbms().code, (Object)rdbms.code);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        catch (RemoteException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return remoteFacade;
    }

    private DBFacadeProvider() {
    }

    static {
        DBFacadeProvider dBFacadeProvider;
        INSTANCE = dBFacadeProvider = new DBFacadeProvider();
        DatabaseConnectionManager databaseConnectionManager = DatabaseConnectionManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnectionManager, (String)"DatabaseConnectionManager.getInstance()");
        connectionManager = databaseConnectionManager;
    }
}

