/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.net.BindException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceSshTunnelConfiguration");
    public static final String ELEMENT_NAME = "ssh-properties";
    private final String myProxyHost;
    private final String myProxyPort;
    private final boolean myUseMasterKeyStorage;
    private final String myUser;
    private final AuthType myAuthType;
    private final String myPassword;
    private final String myPrivateKeyPath;
    private final String myPassphrase;
    private final boolean myEnabled;

    public DataSourceSshTunnelConfiguration(@NotNull String proxyHost, @NotNull String proxyPort, boolean useMasterKeyStorage, @NotNull String user, @NotNull AuthType authType, @NotNull String password, @NotNull String privateKeyPath, @NotNull String passphrase, boolean enabled) {
        if (proxyHost == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(0);
        }
        if (proxyPort == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(1);
        }
        if (user == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(2);
        }
        if (authType == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(3);
        }
        if (password == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(4);
        }
        if (privateKeyPath == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(5);
        }
        if (passphrase == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(6);
        }
        this.myProxyHost = proxyHost;
        this.myProxyPort = proxyPort;
        this.myUseMasterKeyStorage = useMasterKeyStorage;
        this.myUser = user;
        this.myPassword = password;
        this.myPrivateKeyPath = privateKeyPath;
        this.myPassphrase = passphrase;
        this.myEnabled = enabled;
        this.myAuthType = authType;
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration configuration;
        if (xmlReader == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(7);
        }
        if (dataSource == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(8);
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String password = "";
        String privateKeyPath = "";
        String passphrase = "";
        String remoteHost = "";
        String remotePort = "";
        String localPort = "";
        boolean enabled = false;
        AuthType authType = AuthType.PASSWORD;
        boolean useMasterKey = false;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name = xmlReader.getNodeName();
            String value = xmlReader.getValue();
            if ("proxy-host".equals(name)) {
                proxyHost = value;
            } else if ("proxy-port".equals(name)) {
                proxyPort = value;
            } else if ("secret-storage".equals(name)) {
                useMasterKey = "MASTER_KEY".equalsIgnoreCase(xmlReader.getValue());
            } else if ("user".equals(name)) {
                user = value;
            } else if ("use-password".equals(name)) {
                authType = StringUtil.parseBoolean((String)value, (boolean)true) ? AuthType.PASSWORD : AuthType.KEY_PAIR;
            } else if ("auth-type".equals(name)) {
                authType = (AuthType)StringUtil.parseEnum((String)value, (Enum)AuthType.PASSWORD, AuthType.class);
            } else if ("private-key-path".equals(name)) {
                privateKeyPath = value;
            } else if ("remote-host".equals(name)) {
                remoteHost = value;
            } else if ("remote-port".equals(name)) {
                remotePort = value;
            } else if ("local-port".equals(name)) {
                localPort = value;
            } else if ("enabled".equals(name)) {
                enabled = StringUtil.parseBoolean((String)value, (boolean)false);
            }
            xmlReader.moveUp();
        }
        if (!(StringUtil.isEmpty((String)remoteHost) || StringUtil.isEmpty((String)remotePort) || StringUtil.isEmpty((String)localPort))) {
            String url = dataSource.getUrl();
            url = url.replace(localPort, remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource.setUrl(url);
        }
        return (configuration = new DataSourceSshTunnelConfiguration(proxyHost, proxyPort, useMasterKey, user, authType, password, privateKeyPath, passphrase, enabled)).isEmpty() ? null : configuration;
    }

    @Nullable
    public Pair<SshSession, Integer> createTunnel(@NotNull LocalDataSource dataSource) throws SshTransportException {
        if (dataSource == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(9);
        }
        if (!this.isEnabled() || dataSource.getDatabaseDriver() == null) {
            return null;
        }
        String connectionUrl = dataSource.getUrl();
        if (connectionUrl == null) {
            return null;
        }
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(dataSource.getDatabaseDriver().getJDBCUrlParsers(), connectionUrl, null);
        if (hostPort == null) {
            throw new UnsupportedOperationException("Unable to find host/port in URL");
        }
        Pair<String, String> pair = DatabaseCredentials.getInstance().getSshCredentials(dataSource);
        SshSession session = this.createSshSession((String)pair.first, (String)pair.second);
        SshConnectionUtil.applyPortForwardings((SshSession)session);
        Session rawSession = session.getRawSession();
        List<Object> portForwardingL = Collections.emptyList();
        try {
            portForwardingL = Arrays.asList(rawSession.getPortForwardingL());
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
        String existing = (String)ContainerUtil.find(portForwardingL, o -> o.endsWith(":" + (String)hostPort.first + ":" + (String)hostPort.second));
        int localPort = -1;
        if (existing != null) {
            localPort = StringUtil.parseInt((String)existing.substring(0, existing.indexOf(58)), (int)-1);
        }
        if (localPort != -1) {
            LOG.info("SSH tunnel reused: " + existing);
        } else {
            block13: {
                try {
                    localPort = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    throw new SshTransportException("Free port not found", (Throwable)e);
                }
                try {
                    session.addLocalTunnel(localPort, (String)hostPort.first, StringUtil.parseInt((String)((String)hostPort.second), (int)-1));
                }
                catch (SshTransportException e) {
                    if (ExceptionUtil.getRootCause((Throwable)e) instanceof BindException) break block13;
                    throw e;
                }
            }
            LOG.info("SSH tunnel created: " + localPort + ":" + (String)hostPort.first + ":" + (String)hostPort.second);
        }
        return Pair.create((Object)session, (Object)localPort);
    }

    @NotNull
    private SshSession createSshSession(@Nullable String password, @Nullable String passphrase) {
        RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
        holder.setHost(this.getProxyHost());
        holder.setPort(StringUtil.parseInt((String)this.getProxyPort(), (int)-1));
        holder.setUserName(this.getUser());
        AuthType type = this.getAuthType();
        holder.setAuthType(type);
        switch (type) {
            case PASSWORD: {
                holder.setPassword(password);
                break;
            }
            case KEY_PAIR: {
                holder.setPrivateKeyFile(DataSourceSshTunnelConfiguration.tildeExpandFilename(this.getPrivateKeyPath()));
                holder.setPassphrase(passphrase);
                break;
            }
            case OPEN_SSH: {
                OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
                if (openSSHConfig == null) break;
                OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(this.getProxyHost());
                if (StringUtil.isEmptyOrSpaces((String)this.getProxyPort())) {
                    DataSourceSshTunnelConfiguration.usePortFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                }
                if (!StringUtil.isEmptyOrSpaces((String)this.getUser())) break;
                DataSourceSshTunnelConfiguration.useUserFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                break;
            }
        }
        ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)holder);
        SshSession sshSession = builder.connect();
        if (sshSession == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(10);
        }
        return sshSession;
    }

    @NotNull
    static String tildeExpandFilename(@NotNull String path) {
        if (path == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(11);
        }
        if ((path = path.trim()).startsWith("~")) {
            String string = SystemProperties.getUserHome() + path.substring(1);
            if (string == null) {
                DataSourceSshTunnelConfiguration.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void usePortFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        int port;
        if (holder == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(14);
        }
        if (hostConfig == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(15);
        }
        if ((port = hostConfig.getPort()) != -1) {
            LOG.info("Use " + port + " port from OpenSSH configuration file");
            holder.setPort(port);
        }
    }

    private static void useUserFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        String user;
        if (holder == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(16);
        }
        if (hostConfig == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)(user = hostConfig.getUser()))) {
            LOG.info("Use \"" + user + "\" user from OpenSSH configuration file");
            holder.setUserName(user);
        }
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(18);
        }
        serializer.startNode(ELEMENT_NAME);
        LocalDataSource.writeTag(serializer, "enabled", Boolean.toString(this.myEnabled));
        LocalDataSource.writeTag(serializer, "proxy-host", this.myProxyHost);
        LocalDataSource.writeTag(serializer, "proxy-port", this.myProxyPort);
        if (this.myUseMasterKeyStorage) {
            LocalDataSource.writeTag(serializer, "secret-storage", StringUtil.toLowerCase((String)"MASTER_KEY"));
        }
        LocalDataSource.writeTag(serializer, "user", this.myUser);
        LocalDataSource.writeTag(serializer, "use-password", Boolean.toString(this.myAuthType == AuthType.PASSWORD));
        LocalDataSource.writeTag(serializer, "auth-type", this.myAuthType.name());
        LocalDataSource.writeTag(serializer, "private-key-path", this.myPrivateKeyPath);
        serializer.endNode();
    }

    @NotNull
    public String getProxyHost() {
        String string = this.myProxyHost;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(21);
        }
        return authType;
    }

    @NotNull
    public String getProxyPort() {
        String string = this.myProxyPort;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getPassword() {
        String string = this.myPassword;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getPrivateKeyPath() {
        String string = this.myPrivateKeyPath;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getPassphrase() {
        String string = this.myPassphrase;
        if (string == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(25);
        }
        return string;
    }

    public boolean isUseMasterKeyStorage() {
        return this.myUseMasterKeyStorage;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            DataSourceSshTunnelConfiguration.$$$reportNull$$$0(26);
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        if (this.myAuthType != configuration.myAuthType) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyHost), (CharSequence)StringUtil.nullize((String)configuration.myProxyHost))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyPort), (CharSequence)StringUtil.nullize((String)configuration.myProxyPort))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myUser), (CharSequence)StringUtil.nullize((String)configuration.myUser))) {
            return false;
        }
        if (this.myUseMasterKeyStorage != configuration.isUseMasterKeyStorage()) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myPrivateKeyPath), (CharSequence)StringUtil.nullize((String)configuration.myPrivateKeyPath));
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myProxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myUser)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myPrivateKeyPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyPort";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateKeyPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passphrase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostConfig";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSshSession";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tildeExpandFilename";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyHost";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getUser";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyPort";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassword";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrivateKeyPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassphrase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTunnel";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tildeExpandFilename";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "usePortFromOpenSSHConfig";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "useUserFromOpenSSHConfig";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

