/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileSystem
extends NewVirtualFileSystem {
    public static final String PROTOCOL = "dbSrc";
    public static final FileAttributes DEFAULT_FOLDER_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    public static final String APP_PROJECT_ID = "app";
    private static final String EMPTY = "&empty;";
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    public static DbSrcFileSystem getInstance() {
        return (DbSrcFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DbSrcFileSystem() {
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
        appConnection.subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(null));
        appConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){
            private volatile boolean appRegistered;

            public void projectOpened(Project project) {
                if (!this.appRegistered) {
                    this.appRegistered = true;
                    DbSrcFileSystem.this.refreshProjectStorage(null);
                }
                DbSrcFileSystem.this.refreshProjectStorage(project);
                project.getMessageBus().connect((Disposable)project).subscribe(DataSourceStorage.TOPIC, (Object)new MyDataSourceUpdater(project));
            }

            public void projectClosed(Project project) {
                DbSrcFileSystem.this.refreshProjectStorage(project);
            }
        });
    }

    private static Project getProject(String projectId) {
        return ((ProjectManagerImpl)ProjectManager.getInstance()).findOpenProjectByHash(projectId);
    }

    void refreshProjectStorage(@Nullable Project project) {
        Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, (String)DbSrcFileSystem.getProjectPath(project));
        NewVirtualFile vfile = (NewVirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
        if (vfile != null) {
            VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
        }
    }

    @NotNull
    public static String getProjectPath(@Nullable Project project) {
        String string = DbSrcFileSystem.getDataSourcePath(project, null);
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getDataSourcePath(@Nullable Project project, @Nullable String dsId) {
        String string = DbSrcFileSystem.getPathFromNormalized(project, dsId, null, ItemType.FOLDER);
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getPath(@Nullable Project project, @Nullable String dsId, @Nullable DasObject object, @Nullable CasingProvider provider, @Nullable ItemType type) {
        String string = DbSrcFileSystem.getPathFromNormalized(project, dsId, ObjectPaths.of(object, provider), type);
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getPathFromNormalized(@Nullable Project project, @Nullable String dsId, @Nullable ObjectPath object, @Nullable ItemType type) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(DbSrcUtils.getProjectId(project));
        if (dsId != null) {
            builder.append("/").append(dsId);
            if (object != null) {
                DbSrcFileSystem.appendPath(builder, object);
                DbSrcFileSystem.appendExt(builder, type);
            }
        }
        String string = builder.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void appendPath(@NotNull StringBuilder builder, @NotNull ObjectPath object) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(4);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(5);
        }
        if (object.parent != null) {
            DbSrcFileSystem.appendPath(builder, object.parent);
        }
        DbSrcFileSystem.appendObj(builder, object);
    }

    private static void appendObj(@NotNull StringBuilder builder, @NotNull ObjectPath object) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(6);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(7);
        }
        builder.append("/").append(DbSrcFileSystem.escapeGroup(object.kind.code())).append("/");
        DbSrcFileSystem.appendName(builder, object, null);
    }

    private static StringBuilder appendName(@NotNull StringBuilder builder, @NotNull ObjectPath object, @Nullable ItemType type) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(8);
        }
        if (object == null) {
            DbSrcFileSystem.$$$reportNull$$$0(9);
        }
        builder.append(DbSrcFileSystem.escapeName(object.name));
        String identity = object.getIdentity();
        if (identity != null) {
            builder.append("@").append(DbSrcFileSystem.escapeName(identity));
        }
        DbSrcFileSystem.appendExt(builder, type);
        return builder;
    }

    private static void appendExt(@NotNull StringBuilder builder, @Nullable ItemType type) {
        if (builder == null) {
            DbSrcFileSystem.$$$reportNull$$$0(10);
        }
        if (type != null && type != ItemType.FOLDER) {
            if (type == ItemType.ORIG) {
                builder.append(".orig");
            }
            builder.append(".sql");
        }
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            DbSrcFileSystem.$$$reportNull$$$0(11);
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        StringBuilder res;
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(13);
        }
        String string = (res = DbSrcFileSystem.processPath(path, new ItemProcessor<StringBuilder>(){

            @Override
            public StringBuilder processProject(@Nullable Project project) {
                return new StringBuilder(project == null ? "Application" : project.getName());
            }

            @Override
            public StringBuilder processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                LocalDataSource source = DbSrcUtils.findDataSource(project, dataSourceId);
                return this.processProject(project).append(File.separator).append(source == null ? dataSourceId : source.getName());
            }

            @Override
            public StringBuilder processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (group2 != null) {
                    res.append(File.separator).append(group2);
                }
                return res;
            }

            @Override
            public StringBuilder processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(3);
                }
                StringBuilder res = this.processPath(project, dataSourceId, path);
                if (original) {
                    res.append("[orig]");
                }
                return res;
            }

            public StringBuilder processPath(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(4);
                }
                StringBuilder res = this.processDataSource(project, dataSourceId);
                return this.processObject(res, path);
            }

            public StringBuilder processObject(@NotNull StringBuilder res, @Nullable ObjectPath path) {
                if (res == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (path == null) {
                    return res;
                }
                return this.processObject(res, path.parent).append(File.separator).append(path.kind).append(File.separator).append(path.name).append(StringUtil.notNullize((String)path.getIdentity()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "res";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processPath";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processObject";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) == null || res.length() == 0 ? path : res.toString();
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            for (DbSrcStorage storage : DbSrcStorageManager.getInstance(project).getActiveStorages()) {
                storage.flushToFs(asynchronous);
            }
        }
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(15);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(16);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(17);
        }
        String string = path.startsWith("/") ? "/" : "";
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(19);
        }
        String string = path.startsWith("/") ? path : "/" + path;
        if (string == null) {
            DbSrcFileSystem.$$$reportNull$$$0(20);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(21);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(22);
        }
        if (copyName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(23);
        }
        throw DbSrcFileSystem.unsupported("copy", file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(24);
        }
        if (dir == null) {
            DbSrcFileSystem.$$$reportNull$$$0(25);
        }
        throw DbSrcFileSystem.unsupported("create directory", parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(26);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(27);
        }
        throw DbSrcFileSystem.unsupported("create file", parent);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(28);
        }
        throw DbSrcFileSystem.unsupported("delete", file);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(29);
        }
        if (newParent == null) {
            DbSrcFileSystem.$$$reportNull$$$0(30);
        }
        throw DbSrcFileSystem.unsupported("move", file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(31);
        }
        if (newName == null) {
            DbSrcFileSystem.$$$reportNull$$$0(32);
        }
        throw DbSrcFileSystem.unsupported("rename", file);
    }

    @NotNull
    private static IOException unsupported(@NotNull String op, @NotNull VirtualFile file) {
        if (op == null) {
            DbSrcFileSystem.$$$reportNull$$$0(33);
        }
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(34);
        }
        IOException iOException = new IOException(StringUtil.capitalize((String)op) + " is unsupported for DbSrcFS: " + file.getUrl());
        if (iOException == null) {
            DbSrcFileSystem.$$$reportNull$$$0(35);
        }
        return iOException;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(36);
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<FileAttributes>(){

            @Override
            public FileAttributes processRoot() {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processProject(@Nullable Project project) {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                DbSrcStorageManager instance;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (instance = DbSrcStorageManager.getInstance(project)).isStored(dataSourceId) ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                boolean exists = group2 != null ? storage.hasGroup(path, group2) : storage.hasChildren(path);
                return exists ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                return (storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null ? null : storage.getSrcAttributes(path, original);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(37);
        }
        return this.getAttributes(file) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(38);
        }
        Object[] listing = ArrayUtil.toStringArray(DbSrcFileSystem.processPath(file, new ItemProcessor<Collection<String>>(){

            @Override
            public Collection<String> processRoot() {
                ArrayList res = ContainerUtil.newArrayList((Object[])new String[]{DbSrcFileSystem.APP_PROJECT_ID});
                for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                    res.add(p.getLocationHash());
                }
                return res;
            }

            @Override
            public Collection<String> processOutOfDate() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> processProject(@Nullable Project project) {
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                return instance.getStoredDataSources();
            }

            @Override
            public Collection<String> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return this.listGroups(project, dataSourceId, null);
            }

            @NotNull
            public Collection<String> listGroups(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    List<String> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                List list = JBIterable.from(storage.listGroups(path)).transform(g -> DbSrcFileSystem.escapeGroup(g.code())).toList();
                if (list == null) {
                    4.$$$reportNull$$$0(3);
                }
                return list;
            }

            @Override
            public Collection<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (group2 == null) {
                    return this.listGroups(project, dataSourceId, path);
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, false);
                if (storage == null) {
                    return Collections.emptyList();
                }
                HashSet res = ContainerUtil.newHashSet();
                Trinity<Collection<ObjectPath>, List<ObjectPath>, List<ObjectPath>> list = storage.list(path, group2);
                if (list == null) {
                    return Collections.emptyList();
                }
                StringBuilder nameBuilder = new StringBuilder();
                for (ObjectPath dir : (Collection)list.first) {
                    if (!storage.hasChildren(dir)) continue;
                    res.add(this.getName(nameBuilder, dir, ItemType.FOLDER));
                }
                for (ObjectPath dir : (List)list.second) {
                    res.add(this.getName(nameBuilder, dir, ItemType.SRC));
                }
                for (ObjectPath dir : (List)list.third) {
                    if (res.add(this.getName(nameBuilder, dir, ItemType.SRC))) continue;
                    res.add(this.getName(nameBuilder, dir, ItemType.ORIG));
                }
                return res;
            }

            @NotNull
            public String getName(StringBuilder nameBuilder, ObjectPath dir, ItemType t) {
                String name = DbSrcFileSystem.appendName(nameBuilder, dir, t).toString();
                nameBuilder.setLength(0);
                String string = name;
                if (string == null) {
                    4.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Override
            public Collection<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(6);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(7);
                }
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listGroups";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "listGroups";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processFolder";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "processFile";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }));
        Arrays.sort(listing);
        if (listing == null) {
            DbSrcFileSystem.$$$reportNull$$$0(39);
        }
        return listing;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(40);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(41);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(42);
        }
        return (attributes = this.getAttributes(file)) != null && attributes.isSymLink();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(43);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.lastModified : 0L;
    }

    public long getLength(@NotNull VirtualFile file) {
        FileAttributes attributes;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(44);
        }
        return (attributes = this.getAttributes(file)) != null ? attributes.length : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, final long timeStamp) throws IOException {
        Object res;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(45);
        }
        if ((res = DbSrcFileSystem.processPath(file, new ItemProcessor<Object>(){

            @Override
            public Object processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                try {
                    storage.setTimestamp(path, !original, timeStamp);
                }
                catch (Throwable th) {
                    return th;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) instanceof IOException) {
            throw (IOException)res;
        }
        ExceptionUtil.rethrowUnchecked((Throwable)((Throwable)ObjectUtils.tryCast((Object)res, Throwable.class)));
        if (res == null) {
            throw DbSrcFileSystem.unsupported("set timestamp", file);
        }
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(46);
        }
        throw DbSrcFileSystem.unsupported("set writable", file);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(47);
        }
        final Ref exc = Ref.create();
        byte[] res = DbSrcFileSystem.processPath(file, new ItemProcessor<byte[]>(){

            @Override
            public byte[] processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContent(path, original);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        byte[] byArray = (byte[])ObjectUtils.chooseNotNull((Object)res, (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
        if (byArray == null) {
            DbSrcFileSystem.$$$reportNull$$$0(48);
        }
        return byArray;
    }

    public boolean isOrphaned(@NotNull VirtualFile file) {
        VirtualFile base;
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(49);
        }
        if (!file.equals(base = this.getBaseFile(file, false))) {
            return false;
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<Boolean>(){

            @Override
            public Boolean processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (original) {
                    return Boolean.FALSE;
                }
                DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, false);
                if (storage == null) {
                    return false;
                }
                return storage.getSrcAttributes(path, true) == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }) == Boolean.TRUE;
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(50);
        }
        return this.getBaseFile(file, staging, false);
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, boolean staging, boolean refresh) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(51);
        }
        if (!file.isValid()) {
            return null;
        }
        String name = file.getName();
        if (name.endsWith(".orig.sql")) {
            if (!staging) {
                return file;
            }
            name = StringUtil.trimEnd((String)name, (String)".orig.sql") + ".sql";
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), name, refresh), (Object)file);
        }
        if (name.endsWith(".sql")) {
            if (staging) {
                return file;
            }
            name = StringUtil.trimEnd((String)name, (String)".sql") + ".orig.sql";
            return (VirtualFile)ObjectUtils.chooseNotNull((Object)DbSrcFileSystem.findChild(file.getParent(), name, refresh), (Object)file);
        }
        return null;
    }

    private static VirtualFile findChild(VirtualFile parent, String name, boolean refresh) {
        return refresh ? ((NewVirtualFile)parent).refreshAndFindChild(name) : parent.findChild(name);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(52);
        }
        final Ref exc = Ref.create();
        InputStream res = DbSrcFileSystem.processPath(file, new ItemProcessor<InputStream>(){

            @Override
            public InputStream processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                DbSrcStorageManager instance;
                DbSrcStorage storage;
                if (dataSourceId == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    8.$$$reportNull$$$0(1);
                }
                if ((storage = (instance = DbSrcStorageManager.getInstance(project)).getStorage(dataSourceId, false)) == null) {
                    return null;
                }
                try {
                    return storage.getContentInputStream(path, original);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        InputStream inputStream = res;
        if (inputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(53);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(54);
        }
        final Ref exc = Ref.create();
        OutputStream res = DbSrcFileSystem.processPath(file, new ItemProcessor<OutputStream>(){

            @Override
            public OutputStream processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (original) {
                    return null;
                }
                DbSrcStorageManager instance = DbSrcStorageManager.getInstance(project);
                DbSrcStorage storage = instance.getStorage(dataSourceId, true);
                try {
                    return storage.getContentOutputStream(path);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$9";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!exc.isNull()) {
            throw (IOException)exc.get();
        }
        if (res == null) {
            throw new FileNotFoundException(file.getUrl());
        }
        OutputStream outputStream = res;
        if (outputStream == null) {
            DbSrcFileSystem.$$$reportNull$$$0(55);
        }
        return outputStream;
    }

    public static <R> R processPath(@NotNull VirtualFile file, @NotNull ItemProcessor<R> processor) {
        if (file == null) {
            DbSrcFileSystem.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            DbSrcFileSystem.$$$reportNull$$$0(57);
        }
        return DbSrcFileSystem.processPath(file.getPath(), processor);
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(58);
        }
        return StringUtil.tokenize((String)path, (String)String.valueOf('/'));
    }

    public static <R> R processPath(@NotNull String path, @NotNull ItemProcessor<R> processor) {
        Project project;
        Iterator<String> it;
        if (path == null) {
            DbSrcFileSystem.$$$reportNull$$$0(59);
        }
        if (processor == null) {
            DbSrcFileSystem.$$$reportNull$$$0(60);
        }
        if (!(it = DbSrcFileSystem.splitPath(path).iterator()).hasNext()) {
            return processor.processRoot();
        }
        String projectStr = it.next();
        boolean app = projectStr.equals(APP_PROJECT_ID);
        Project project2 = project = app ? null : DbSrcFileSystem.getProject(projectStr);
        if (project == null && !app) {
            return processor.processOutOfDate();
        }
        if (!it.hasNext()) {
            return processor.processProject(project);
        }
        String dsId = it.next();
        if (!it.hasNext()) {
            return processor.processDataSource(project, dsId);
        }
        return DbSrcFileSystem.processPathInner(project, dsId, null, it, processor);
    }

    private static <R> R processPathInner(@Nullable Project p, @NotNull String dsId, @Nullable ObjectPath parent, @NotNull Iterator<String> it, @NotNull ItemProcessor<R> processor) {
        int pt;
        String id;
        boolean last;
        String group2;
        ObjectKind kind;
        if (dsId == null) {
            DbSrcFileSystem.$$$reportNull$$$0(61);
        }
        if (it == null) {
            DbSrcFileSystem.$$$reportNull$$$0(62);
        }
        if (processor == null) {
            DbSrcFileSystem.$$$reportNull$$$0(63);
        }
        if ((kind = DbSrcUtils.findKind(group2 = DbSrcFileSystem.unescapeGroup(it.next()))) == null) {
            return processor.processInvalidFolder(p, dsId, parent, null, group2);
        }
        if (!it.hasNext()) {
            return processor.processFolder(p, dsId, parent, kind);
        }
        String name = it.next();
        boolean isFile = name.endsWith(".sql");
        boolean bl = last = !it.hasNext();
        if (!last && isFile) {
            return processor.processInvalidFolder(p, dsId, parent, kind, name);
        }
        int len = name.length();
        boolean orig = false;
        if (isFile) {
            orig = name.endsWith(".orig.sql");
            len -= (orig ? ".orig.sql" : ".sql").length();
        }
        String string = id = (pt = name.indexOf(64)) == -1 ? null : DbSrcFileSystem.unescapeName(name.substring(pt + 1, len));
        if (pt != -1) {
            len = pt;
        }
        name = DbSrcFileSystem.unescapeName(name.substring(0, len));
        ObjectPath cur = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)true, (String)id, (ObjectPath)parent);
        if (isFile) {
            return processor.processFile(p, dsId, cur, orig);
        }
        if (last) {
            return processor.processFolder(p, dsId, cur, null);
        }
        return DbSrcFileSystem.processPathInner(p, dsId, cur, it, processor);
    }

    private static String escapeName(String s) {
        if (s == null) {
            return null;
        }
        if ((s = DbSrcFileSystem.escapeChars(s)).endsWith(".sql") || s.endsWith(".orig")) {
            s = s + "&";
        }
        return s;
    }

    private static String escapeGroup(String s) {
        return DbSrcFileSystem.escapeChars(s);
    }

    private static String escapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescapeName(String s) {
        if (s == null) {
            return null;
        }
        return DbSrcFileSystem.unescapeChars(StringUtil.trimEnd((String)s, (String)"&"));
    }

    private static String unescapeGroup(String s) {
        return DbSrcFileSystem.unescapeChars(s);
    }

    private static String unescapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 57: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsId";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourcePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromNormalized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "unsupported";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendObj";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendExt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unsupported";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isOrphaned";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFile";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 56: 
            case 57: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processPath";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processPathInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDataSourceUpdater
    implements DataSourceStorage.Listener {
        private final Project myProject;

        MyDataSourceUpdater(Project project) {
            this.myProject = project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(0);
            }
            this.refresh(dataSource);
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(1);
            }
            this.refresh(dataSource);
        }

        void refresh(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                MyDataSourceUpdater.$$$reportNull$$$0(2);
            }
            if (this.myProject != null && dataSource.isGlobal()) {
                return;
            }
            String dataSourceId = (String)ObjectUtils.notNull((Object)dataSource.getUniqueId());
            Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)DbSrcFileSystem.this, (String)DbSrcFileSystem.getDataSourcePath(this.myProject, dataSourceId));
            VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)cached.first, (Object)cached.second);
            if (vfile != null) {
                VfsUtil.markDirty((cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                RefreshQueue.getInstance().refresh(true, true, null, new VirtualFile[]{vfile});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataSource";
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ItemProcessor<R> {
        public R processRoot() {
            return null;
        }

        public R processOutOfDate() {
            return null;
        }

        public R processProject(@Nullable Project project) {
            return null;
        }

        public R processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        public R processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(1);
            }
            return null;
        }

        public R processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(2);
            }
            if (path == null) {
                ItemProcessor.$$$reportNull$$$0(3);
            }
            return null;
        }

        public R processInvalidFolder(@Nullable Project p, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2, @NotNull String invalid) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(4);
            }
            if (invalid == null) {
                ItemProcessor.$$$reportNull$$$0(5);
            }
            return this.processOutOfDate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invalid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFolder";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processInvalidFolder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ItemType {
        FOLDER,
        SRC,
        ORIG;

    }
}

