/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import me.xuender.unidecode.Unidecode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class DbSrcBackendUtils {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendUtils.class);
    private static final Tag META_DATA_TAG = new Tag("md");
    private static final Representer REPRESENTER = new Representer(){
        {
            this.addClassTag(DbSrcStorageDsMetadata.MetaData.class, META_DATA_TAG);
            this.representers.put(DbSrcStorageDsMetadata.MetaData.class, new Represent(){

                public Node representData(Object data) {
                    DbSrcStorageDsMetadata.MetaData md = (DbSrcStorageDsMetadata.MetaData)data;
                    return this.representSequence(META_DATA_TAG, Arrays.asList(md.srcVersion, md.contentHash, md.offsets, md.kinds, md.introContentVersion, md.genContentVersion), true);
                }
            });
        }
    };

    public static byte[] serializeMetaData(@NotNull ObjectPath object, @NotNull DbSrcStorageDsMetadata.MetaData metaData) {
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(0);
        }
        if (metaData == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, CharsetToolkit.UTF8_CHARSET);
        try {
            writer.write("#n:");
            writer.write(StringUtil.escapeStringCharacters((String)object.getName()));
            if (object.getIdentity() != null) {
                writer.write("\n#i:");
                writer.write(StringUtil.escapeStringCharacters((String)object.getIdentity()));
            }
            if (metaData != DbSrcStorageDsMetadata.MetaData.EMPTY) {
                writer.write("\n");
                new Yaml(REPRESENTER).dump((Object)metaData, (Writer)writer);
            }
            writer.flush();
            return stream.toByteArray();
        }
        catch (IOException e) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }

    @NotNull
    static DbSrcStorageDsMetadata.MetaData deserializeMetaData(InputStream stream) {
        DbSrcStorageDsMetadata.MetaData metaData;
        try {
            DbSrcStorageDsMetadata.MetaData meta = (DbSrcStorageDsMetadata.MetaData)RemoteUtil.executeWithClassLoader(() -> new Yaml((BaseConstructor)new Constructor(DbSrcStorageDsMetadata.MetaData.class), REPRESENTER).load(stream), (ClassLoader)DbSrcStorageDsMetadata.class.getClassLoader());
            metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)meta, (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            DbSrcStorageDsMetadata.MetaData metaData2 = DbSrcStorageDsMetadata.MetaData.EMPTY;
            if (metaData2 == null) {
                DbSrcBackendUtils.$$$reportNull$$$0(3);
            }
            return metaData2;
        }
        if (metaData == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(2);
        }
        return metaData;
    }

    @NotNull
    static Path getDir(@NotNull String root2, boolean staging, @Nullable ObjectPath object, @Nullable ObjectKind group2, @Nullable String ext) {
        if (root2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(4);
        }
        FileSystem fs = FileSystems.getDefault();
        String sep = fs.getSeparator();
        Path path = fs.getPath(DbSrcBackendUtils.getDir(root2, staging, object, group2, ext, sep), new String[0]);
        if (path == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    private static String getDir(@NotNull String root2, boolean staging, @Nullable ObjectPath object, @Nullable ObjectKind group2, @Nullable String ext, @NotNull String sep) {
        if (root2 == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(6);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(7);
        }
        StringBuilder path = new StringBuilder();
        path.append(root2).append(sep).append(staging ? "_staging_" : "_src_");
        if (object != null) {
            DbSrcBackendUtils.appendPath(path.append(sep), object, 0, sep);
        }
        if (group2 != null) {
            path.append(sep).append(group2.code());
        } else if (ext != null) {
            path.append(ext);
        }
        String string = path.toString();
        if (string == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void appendPath(@NotNull StringBuilder res, @NotNull ObjectPath object, int start, @NotNull String sep) {
        if (res == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(9);
        }
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(10);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(11);
        }
        DbSrcBackendUtils.appendPathInner(res, object, start, sep);
    }

    private static int appendPathInner(@NotNull StringBuilder res, @NotNull ObjectPath object, int start, @NotNull String sep) {
        int d;
        if (res == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(12);
        }
        if (object == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(13);
        }
        if (sep == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(14);
        }
        int n = d = object.parent == null ? 0 : DbSrcBackendUtils.appendPathInner(res, object.parent, start, sep);
        if (d >= start) {
            if (d != start) {
                res.append(sep);
            }
            res.append(object.kind.code()).append(sep);
            DbSrcBackendUtils.appendSimpleName(res, object.name, object.getIdentity());
        }
        return d + 1;
    }

    public static String getSimpleName(@NotNull String name, @Nullable String identity) {
        if (name == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(15);
        }
        StringBuilder builder = new StringBuilder();
        DbSrcBackendUtils.appendSimpleName(builder, name, identity);
        return builder.toString();
    }

    private static void appendSimpleName(@NotNull StringBuilder res, @NotNull String name, @Nullable String identity) {
        if (res == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(16);
        }
        if (name == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(17);
        }
        String trans = Unidecode.decode((String)name);
        int l = trans.length();
        for (int i2 = 0; i2 < l; ++i2) {
            char c = trans.charAt(i2);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '.') {
                res.append(c);
                continue;
            }
            res.append('_');
        }
        res.append(".");
        int hc = name.hashCode() + Comparing.hashcode((Object)identity) * 31;
        byte[] bytes = new byte[]{(byte)(hc & 0xFF), (byte)(hc >>> 8 & 0xFF), (byte)(hc >>> 16 & 0xFF), (byte)(hc >>> 24 & 0xFF)};
        for (byte b : Base64.getUrlEncoder().encode(bytes)) {
            if (b == 61) break;
            res.append((char)b);
        }
    }

    @NotNull
    public static ObjectPath createPath(@Nullable ObjectPath parent, @NotNull String name, @NotNull ObjectKind kind, @Nullable String identity) {
        if (name == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(18);
        }
        if (kind == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(19);
        }
        ObjectPath objectPath = ObjectPath.create((String)name, (ObjectKind)kind, (boolean)true, (String)identity, (ObjectPath)parent);
        if (objectPath == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(20);
        }
        return objectPath;
    }

    @Nullable
    static Pair<String, String> extractNameAndIdentity(byte[] data) {
        int end = DbSrcBackendUtils.getPropertyLineEnd(data, 0, 'n');
        if (end == -1) {
            return null;
        }
        String name = DbUtil.intern((String)DbSrcBackendUtils.toStr(data, 3, end));
        String identity = null;
        if (end + 1 < data.length) {
            int s = end;
            if (data[s] == 13 && data[s + 1] == 10) {
                ++s;
            }
            if ((end = DbSrcBackendUtils.getPropertyLineEnd(data, s + 1, 'i')) != -1) {
                identity = DbUtil.intern((String)DbSrcBackendUtils.toStr(data, s + 4, end));
            }
        }
        return Pair.create((Object)name, identity);
    }

    private static String toStr(byte[] data, int start, int end) {
        return StringUtil.unescapeStringCharacters((String)new String(data, start, end - start));
    }

    private static int getPropertyLineEnd(byte[] data, int start, char l) {
        if (start + 2 >= data.length || data[start] != 35 || data[start + 1] != l || data[start + 2] != 58) {
            return -1;
        }
        for (int i2 = start + 3; i2 < data.length; ++i2) {
            byte c = data[i2];
            if (c != 13 && c != 10) continue;
            return i2;
        }
        return data.length;
    }

    @NotNull
    public static <T> List<T> clearAndGet(@NotNull Iterable<T> set) {
        if (set == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(21);
        }
        ArrayList values2 = ContainerUtil.newArrayList();
        Iterator<T> it = set.iterator();
        while (it.hasNext()) {
            values2.add(it.next());
            it.remove();
        }
        ArrayList arrayList = values2;
        if (arrayList == null) {
            DbSrcBackendUtils.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeMetaData";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDir";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serializeMetaData";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 22: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDir";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendPathInner";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendSimpleName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearAndGet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InputStreamWrapper
    extends InputStream {
        private final InputStream delegate;

        public InputStreamWrapper(@NotNull InputStream delegate) {
            if (delegate == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(1);
            }
            return this.delegate.read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(2);
            }
            return this.delegate.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendUtils$InputStreamWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

