/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.util.ErrorHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionParamEditor<T>
extends ParamEditorBase<ProgressFieldWithCompletion<T>> {
    private static final Key<CompletionParamEditor> PARAM_EDITOR_KEY = Key.create((String)"CompletionParamEditor");
    protected static final Key<Boolean> FORCED_KEY = Key.create((String)"FORCED_KEY");
    private final CompletionProvider myProvider;
    private boolean mySupersedeTasks;
    private boolean myValidateOnDirtyCompletion;
    private boolean myReportErrorOnAutoPopup;
    protected List<T> myModel;
    protected final MyUpdater myUpdater;
    private boolean myDirty;
    private boolean myFailed;
    private String myUpdateTitle;
    private String myForceRefreshTitle;
    private final ActionGroup myContextMenu;

    public CompletionParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            CompletionParamEditor.$$$reportNull$$$0(0);
        }
        if (interchange == null) {
            CompletionParamEditor.$$$reportNull$$$0(1);
        }
        super(new ProgressFieldWithCompletion(interchange.getProject()), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, label, new AnAction[0]);
        this.mySupersedeTasks = false;
        this.myValidateOnDirtyCompletion = false;
        this.myReportErrorOnAutoPopup = false;
        this.myModel = Collections.emptyList();
        this.myUpdater = new MyUpdater();
        this.myDirty = true;
        this.myFailed = false;
        this.myUpdateTitle = "Updating";
        this.myForceRefreshTitle = null;
        this.myContextMenu = new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                List items = CompletionParamEditor.this.getContextMenuEntries().toList();
                AnAction[] anActionArray = items.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$1", "getChildren"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.getEditorComponent()));
        this.myProvider = new CompletionProvider();
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().installProvider((TextFieldWithAutoCompletionListProvider)this.myProvider);
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                CompletionParamEditor.this.fireChanged();
            }
        });
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().addSettingsProvider(editor -> {
            EditorPopupHandler handler = EditorActionUtil.createEditorPopupHandler((ActionGroup)this.myContextMenu);
            editor.addEditorMouseListener((EditorMouseListener)handler);
            PARAM_EDITOR_KEY.set((UserDataHolder)editor, (Object)this);
        });
    }

    @NotNull
    protected JBIterable<AnAction> getContextMenuEntries() {
        if (this.myForceRefreshTitle == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                CompletionParamEditor.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)MyForceRefresh.INSTANCE);
        if (jBIterable == null) {
            CompletionParamEditor.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public void setSupersedeTasks(boolean supersedeTasks) {
        this.mySupersedeTasks = supersedeTasks;
    }

    public void setReportErrorOnAutoPopup(boolean reportErrorOnAutoPopup) {
        this.myReportErrorOnAutoPopup = reportErrorOnAutoPopup;
    }

    public void setValidateOnDirtyCompletion(boolean validateOnDirtyCompletion) {
        this.myValidateOnDirtyCompletion = validateOnDirtyCompletion;
    }

    protected void addUpdateOnShow() {
        new UiNotifyConnector(this.getEditorComponent(), new Activatable(){

            public void showNotify() {
                CompletionParamEditor.this.updateModelAtShow();
            }

            public void hideNotify() {
            }
        });
    }

    protected void onCompletion(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionParamEditor.$$$reportNull$$$0(4);
        }
        if (!this.myValidateOnDirtyCompletion || !this.myDirty && parameters.getCompletionType() == CompletionType.BASIC && (!this.myFailed || parameters.isAutoPopup())) {
            return;
        }
        this.myDirty = false;
        AsyncUtil.markAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), true);
        this.updateModelSync(parameters.isAutoPopup());
    }

    protected void updateNowIfVisible() {
        if (((ProgressFieldWithCompletion)this.getEditorComponent()).isVisible()) {
            this.updateModelAsync();
        } else {
            this.setDirty(true);
        }
    }

    protected void setDirty(boolean dirty) {
        this.myDirty = dirty;
    }

    protected void setUpdateTitle(String updateTitle) {
        this.myUpdateTitle = updateTitle;
    }

    protected void resetVariants() {
        this.myModel = Collections.emptyList();
        this.myProvider.setItems(this.myModel);
        this.setDirty(true);
    }

    protected void setVariantsAndCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(5);
        }
        this.setCompletionVariants(variants);
        this.setVariants(variants);
    }

    protected void setVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(6);
        }
        this.myModel = variants;
    }

    protected void setCompletionVariants(@NotNull List<T> variants) {
        if (variants == null) {
            CompletionParamEditor.$$$reportNull$$$0(7);
        }
        this.myProvider.setItems(variants);
        this.setDirty(false);
    }

    @Override
    public void setActive(boolean active) {
        ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().setBackground(CompletionParamEditor.getBackground(active));
    }

    @Nullable
    public T getItemByText(@NotNull String text2) {
        if (text2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(8);
        }
        for (T item : this.myModel) {
            if (!text2.equals(this.getText(item))) continue;
            return item;
        }
        for (T item : this.myModel) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)text2, (CharSequence)this.getText(item))) continue;
            return item;
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        String string = ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText();
        if (string == null) {
            CompletionParamEditor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            CompletionParamEditor.$$$reportNull$$$0(10);
        }
        if (!text2.equals(((ProgressFieldWithCompletion)this.getEditorComponent()).getField().getText())) {
            ((ProgressFieldWithCompletion)this.getEditorComponent()).getField().setText(text2);
        }
    }

    @NotNull
    protected abstract CompletionStage<List<T>> getVariants(@NotNull Map<Key, ?> var1, @NotNull ErrorHandler var2);

    protected void updateModelAsync() {
        this.myUpdater.update(true, Collections.emptyMap());
    }

    protected void updateModelForce() {
        this.myUpdater.update(false, Collections.singletonMap(FORCED_KEY, Boolean.TRUE));
    }

    protected void updateModelSync(boolean isAutoPopup) {
        this.myUpdater.updateSync(isAutoPopup, Collections.emptyMap());
    }

    protected void updateModelAtShow() {
        this.updateModelAsync();
    }

    @NotNull
    protected abstract String getText(@NotNull T var1);

    @Nullable
    protected String getTailText(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    protected String getTypeText(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    protected Icon getIcon(@NotNull T item) {
        if (item == null) {
            CompletionParamEditor.$$$reportNull$$$0(13);
        }
        return null;
    }

    public void setForceRefresh(@Nullable String forceRefreshTitle) {
        this.myForceRefreshTitle = forceRefreshTitle;
    }

    public boolean canRefresh() {
        return this.myUpdater.myRunning == null || this.mySupersedeTasks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextMenuEntries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onCompletion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVariantsAndCompletionVariants";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionVariants";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemByText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTailText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyForceRefresh
    extends DumbAwareAction {
        public static final AnAction INSTANCE = new MyForceRefresh();

        public MyForceRefresh() {
            super("Refresh", "", AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            CompletionParamEditor editor = this.getParamEditor(e.getDataContext());
            if (editor == null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(editor.canRefresh());
            presentation.setText(editor.myForceRefreshTitle);
        }

        public void actionPerformed(AnActionEvent e) {
            CompletionParamEditor editor = this.getParamEditor(e.getDataContext());
            if (editor == null) {
                return;
            }
            editor.updateModelForce();
        }

        @Nullable
        CompletionParamEditor getParamEditor(@NotNull DataContext context) {
            Editor editor;
            if (context == null) {
                MyForceRefresh.$$$reportNull$$$0(0);
            }
            if ((editor = (Editor)CommonDataKeys.EDITOR.getData(context)) == null) {
                return null;
            }
            return (CompletionParamEditor)PARAM_EDITOR_KEY.get((UserDataHolder)editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyForceRefresh", "getParamEditor"));
        }
    }

    public static class ProgressFieldWithCompletion<T>
    extends JPanel
    implements Disposable,
    Runnable {
        private AsyncProcessIcon myBusyIcon = new AsyncProcessIcon("updating");
        private boolean myBusy;
        private final TextFieldWithAutoCompletion<T> myField;

        public ProgressFieldWithCompletion(Project project) {
            this.setLayout(new OverlayLayout(this));
            this.myField = new TextFieldWithAutoCompletion(project, TextFieldWithAutoCompletion.EMPTY_COMPLETION, true, null);
            this.myBusyIcon.setVisible(false);
            this.myBusyIcon.suspend();
            this.add((Component)this.myBusyIcon);
            this.add((Component)this.myField);
            Disposer.register((Disposable)this, (Disposable)this.myBusyIcon);
        }

        @NotNull
        public TextFieldWithAutoCompletion<T> getField() {
            TextFieldWithAutoCompletion<T> textFieldWithAutoCompletion = this.myField;
            if (textFieldWithAutoCompletion == null) {
                ProgressFieldWithCompletion.$$$reportNull$$$0(0);
            }
            return textFieldWithAutoCompletion;
        }

        public void dispose() {
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.updateBusyLocation();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.updateBusyLocation();
        }

        public void setBusy(boolean busy) {
            if (this.myBusy == busy) {
                return;
            }
            this.myBusy = busy;
            UIUtil.invokeLaterIfNeeded((Runnable)this);
        }

        @Override
        public void run() {
            this.myBusyIcon.setVisible(this.myBusy);
            if (this.myBusy) {
                this.myBusyIcon.resume();
            } else {
                this.myBusyIcon.suspend();
            }
            this.revalidate();
        }

        public void updateBusyLocation() {
            Rectangle rec;
            if (this.myField.getEditor() != null) {
                JComponent component = this.myField.getEditor().getComponent();
                rec = SwingUtilities.convertRectangle(component, component.getVisibleRect(), this);
            } else {
                rec = this.myField.getVisibleRect();
            }
            Dimension iconSize = this.myBusyIcon.getPreferredSize();
            int displacement = Math.max((rec.height - iconSize.height) / 2, 0);
            Rectangle newBounds = new Rectangle(rec.x + rec.width - iconSize.width - displacement, rec.y + displacement, iconSize.width, iconSize.height);
            if (!newBounds.equals(this.myBusyIcon.getBounds())) {
                this.myBusyIcon.setBounds(newBounds);
                SwingUtilities.invokeLater(() -> this.repaint());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/CompletionParamEditor$ProgressFieldWithCompletion", "getField"));
        }
    }

    private class MyUpdater {
        private volatile CompletableFuture myRunning;

        private MyUpdater() {
        }

        public void update(boolean isAutoPopup, @NotNull Map<Key, ?> options) {
            if (options == null) {
                MyUpdater.$$$reportNull$$$0(0);
            }
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (options == null) {
                    MyUpdater.$$$reportNull$$$0(11);
                }
                if (CompletionParamEditor.this.mySupersedeTasks || this.myRunning == null) {
                    this.runTask(isAutoPopup, options, AsyncUtil.POOL_EXECUTOR);
                }
            }, (ModalityState)ModalityState.defaultModalityState());
        }

        private CompletableFuture<Void> runTask(boolean isAutoPopup, @NotNull Map<Key, ?> options, @NotNull Executor executor) {
            if (options == null) {
                MyUpdater.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                MyUpdater.$$$reportNull$$$0(2);
            }
            ErrorHandler errorHandler = new ErrorHandler();
            CompletableFuture<Void> result2 = new CompletableFuture<Void>();
            this.startBusy(result2);
            AsyncUtil.supplyAsync(() -> {
                if (options == null) {
                    MyUpdater.$$$reportNull$$$0(10);
                }
                return this.computeVariants(options, errorHandler);
            }, executor).handle((res, th) -> {
                CompletionParamEditor.this.myFailed = th != null;
                if (th != null) {
                    if (!AsyncUtil.isCancellation(th)) {
                        errorHandler.addError(null, (Throwable)th);
                    }
                    if (errorHandler.hasErrors()) {
                        if (!isAutoPopup || CompletionParamEditor.this.myReportErrorOnAutoPopup) {
                            CompletionParamEditor.this.getInterchange().showError(errorHandler.getSummary(), this);
                        }
                    } else {
                        CompletionParamEditor.this.myDirty = true;
                    }
                } else if (res != null) {
                    CompletionParamEditor.this.setCompletionVariants(res);
                    GuiUtils.invokeLaterIfNeeded(() -> CompletionParamEditor.this.setVariants(res), (ModalityState)ModalityState.defaultModalityState());
                }
                return null;
            }).whenComplete((r, th) -> {
                if (th != null) {
                    result2.completeExceptionally((Throwable)th);
                } else {
                    result2.complete(null);
                }
            });
            return result2;
        }

        @NotNull
        private CompletionStage<List<T>> computeVariants(@NotNull Map<Key, ?> options, @NotNull ErrorHandler errorHandler) {
            ProgressIndicator current;
            if (options == null) {
                MyUpdater.$$$reportNull$$$0(3);
            }
            if (errorHandler == null) {
                MyUpdater.$$$reportNull$$$0(4);
            }
            if ((current = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null && AsyncUtil.isAsyncFriendly(current)) {
                CompletionStage completionStage = CompletionParamEditor.this.getVariants(options, errorHandler);
                if (completionStage == null) {
                    MyUpdater.$$$reportNull$$$0(5);
                }
                return completionStage;
            }
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)UIUtil.invokeAndWaitIfNeeded(() -> AsyncUtil.createBackgroundIndicator(CompletionParamEditor.this.getInterchange().getProject(), CompletionParamEditor.this.myUpdateTitle));
            CompletionStage completionStage = AsyncUtil.runTask(() -> {
                if (options == null) {
                    MyUpdater.$$$reportNull$$$0(8);
                }
                if (errorHandler == null) {
                    MyUpdater.$$$reportNull$$$0(9);
                }
                return CompletionParamEditor.this.getVariants(options, errorHandler);
            }, indicator);
            if (completionStage == null) {
                MyUpdater.$$$reportNull$$$0(6);
            }
            return completionStage;
        }

        private void stopBusy(CompletableFuture completion) {
            if (this.myRunning == completion) {
                this.myRunning = null;
                ((ProgressFieldWithCompletion)CompletionParamEditor.this.getEditorComponent()).setBusy(false);
            }
        }

        private void startBusy(CompletableFuture<?> completion) {
            CompletableFuture old = this.myRunning;
            this.myRunning = completion;
            if (old != null) {
                old.cancel(true);
            }
            ((ProgressFieldWithCompletion)CompletionParamEditor.this.getEditorComponent()).setBusy(true);
            completion.whenComplete((r, th) -> this.stopBusy(completion));
        }

        public void updateSync(boolean isAutoPopup, @NotNull Map<Key, ?> options) {
            block5: {
                if (options == null) {
                    MyUpdater.$$$reportNull$$$0(7);
                }
                if (CompletionParamEditor.this.mySupersedeTasks || this.myRunning == null) {
                    try {
                        this.runTask(isAutoPopup, options, Runnable::run).toCompletableFuture().get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (CancellationException | ExecutionException e) {
                        if (AsyncUtil.isCancellation(e)) break block5;
                        CompletionParamEditor.this.getInterchange().showError(e.getMessage(), this);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$MyUpdater";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computeVariants";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateSync";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$computeVariants$6";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$runTask$1";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$update$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<T> {
        protected CompletionProvider() {
            super(null);
        }

        @NotNull
        public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            if (!cached) {
                CompletionParamEditor.this.onCompletion(parameters);
            }
            Collection collection = super.getItems(prefix, cached, parameters);
            if (collection == null) {
                CompletionProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Nullable
        protected Icon getIcon(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(1);
            }
            return CompletionParamEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(2);
            }
            String string = CompletionParamEditor.this.getText(item);
            if (string == null) {
                CompletionProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(4);
            }
            return CompletionParamEditor.this.getTailText(item);
        }

        @Nullable
        protected String getTypeText(@NotNull T item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(5);
            }
            return CompletionParamEditor.this.getTypeText(item);
        }

        public int compare(T item1, T item2) {
            return StringUtil.naturalCompare((String)this.getLookupString(item1), (String)this.getLookupString(item2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItems";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/CompletionParamEditor$CompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

