/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LazyPasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicJdbcUrlEditor
implements UrlEditorModelBase.StateChangeListener {
    @NotNull
    private final JComponent myPanel;
    @Nullable
    private DatabaseDriver myDriver;
    @Nullable
    private DatabaseDriver myActualDriver;
    private final List<UrlPropertiesPanel> myUrlPropertiesPanels;
    @NotNull
    private final EditorTextField myUrlField;
    @NotNull
    private final Runnable myChangedCallback;
    @NotNull
    private final ComboBox<String> myPanelsSwitcher;
    @NotNull
    private final DataSourceConfigurable myConfigurable;
    @NotNull
    private final MyInspectionConsumer myInspectionsPane;
    private JCheckBox myDomainAuthCheckBox;
    private JCheckBox myRememberCheckBox;
    private JBTextField myUserField;
    private LazyPasswordField myPasswordField;
    private JComponent myAuthPanel;
    private JComponent myUrlPanel;
    private SwingActionLink myDriverLink;
    private final Map<String, String> myInterchangeProperties;
    private boolean myEditUrl;
    private int myCurrentPropPanel;
    private boolean myPersistentPropertyChanged;
    @NotNull
    private String myApprovedUser;
    @Nullable
    private char[] myApprovedPassword;
    @NotNull
    private final JComponent myConstructorPanel;
    private UrlEditorModel myModel;
    private boolean myUpdating;
    private Collection<UrlEditorInspector> myInspectors;

    public DynamicJdbcUrlEditor(@NotNull DataSourceConfigurable configurable, @NotNull Runnable changedCallback) {
        if (configurable == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(0);
        }
        if (changedCallback == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(1);
        }
        this.myUrlPropertiesPanels = new ArrayList<UrlPropertiesPanel>();
        this.myInterchangeProperties = ContainerUtil.newLinkedHashMap();
        this.myEditUrl = true;
        this.myApprovedUser = "";
        this.myConfigurable = configurable;
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(3, 6));
        this.myChangedCallback = changedCallback;
        this.myDriver = null;
        this.myActualDriver = null;
        this.myModel = this.createModelForDriver(null);
        this.createAuthBox();
        JButton testConnectionButton = new JButton();
        testConnectionButton.setAction(configurable.getTestAction());
        this.myDriverLink = new SwingActionLink((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicJdbcUrlEditor.this.myConfigurable.getController().navigateTo(DynamicJdbcUrlEditor.this.myDriver);
            }
        });
        this.myConstructorPanel = new JPanel();
        this.myConstructorPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)DynamicJdbcUrlEditor.getVSpacing()));
        this.myPanel.add((Component)this.myConstructorPanel, UrlPropertiesPanel.createRowConstraints(0));
        this.myPanelsSwitcher = new ComboBox();
        this.myPanelsSwitcher.setEditable(false);
        this.myPanelsSwitcher.setSelectedIndex(-1);
        this.myPanelsSwitcher.addItemListener(this.delayed(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getStateChange() == 1) {
                    if (DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.myModel.selectGroup(Math.max(0, DynamicJdbcUrlEditor.this.myPanelsSwitcher.getSelectedIndex()));
                    DynamicJdbcUrlEditor.this.myModel.commit(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$2", "itemStateChanged"));
            }
        }));
        this.myUrlField = new EditorTextField("", this.myConfigurable.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myUrlField.addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        this.myUrlField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.setUrlFieldActive(true);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                DynamicJdbcUrlEditor.this.setUrlFieldActive(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusGained";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focusLost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                DynamicJdbcUrlEditor.this.myModel.setUrl(DynamicJdbcUrlEditor.this.myUrlField.getText());
                DynamicJdbcUrlEditor.this.myModel.commit(true);
            }
        });
        boolean URL_ROW = true;
        this.myInspectionsPane = new MyInspectionConsumer();
        GridLayoutManager urlLayout = new GridLayoutManager(2, 6);
        urlLayout.setVGap(0);
        JPanel urlPanel = new JPanel((LayoutManager)urlLayout);
        JBLabel urlLabel = new JBLabel("URL:");
        urlPanel.add((Component)urlLabel, UrlPropertiesPanel.createLabelConstraints(0, 0, urlLabel.getPreferredSize().getWidth()));
        this.myUrlPanel = new Box(0);
        urlPanel.add((Component)this.myUrlPanel, UrlPropertiesPanel.createSimpleConstraints(0, 1, 5));
        Box underUrl = new Box(1);
        JBLabel underLabel = new JBLabel(" Overrides settings above", UIUtil.ComponentStyle.MINI);
        underUrl.add((Component)underLabel);
        underUrl.add(Box.createVerticalStrut(4));
        Box buttonAndInfo = new Box(0);
        underLabel.setAlignmentX(0.0f);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.myInspectionsPane, "West");
        buttonAndInfo.setAlignmentX(0.0f);
        buttonAndInfo.add(testConnectionButton);
        buttonAndInfo.add(Box.createHorizontalStrut(10));
        buttonAndInfo.add(new DataSourceUiUtil.StatusPanel());
        buttonAndInfo.add(Box.createHorizontalStrut(10));
        buttonAndInfo.add(wrapper);
        underUrl.add(buttonAndInfo);
        urlPanel.add((Component)underUrl, UrlPropertiesPanel.createConstraints(1, 1, 5, 9, 1, -1, false));
        this.myPanel.add((Component)urlPanel, UrlPropertiesPanel.createRowConstraints(1));
        JPanel driverPanel = new JPanel((LayoutManager)urlLayout);
        JBLabel driverLabel = new JBLabel("Driver:");
        driverPanel.add((Component)driverLabel, UrlPropertiesPanel.createLabelConstraints(0, 0, driverLabel.getPreferredSize().getWidth()));
        driverPanel.add((Component)this.myDriverLink, UrlPropertiesPanel.createSimpleConstraints(0, 1, 5));
        this.myPanel.add((Component)driverPanel, UrlPropertiesPanel.createRowConstraints(2));
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel == null ? null : panel.getDataInterchange());
    }

    @NotNull
    private UrlEditorModel createModelForDriver(@Nullable DatabaseDriver driver) {
        UrlEditorModel model = new UrlEditorModel(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers());
        model.addListener(this, this.myConfigurable);
        UrlEditorModel urlEditorModel = model;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(2);
        }
        return urlEditorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(@Nullable Object arg) {
        if (arg == Boolean.FALSE) {
            return;
        }
        this.myUpdating = true;
        try {
            String password;
            if (!this.myUrlField.getText().equals(this.myModel.getUrl())) {
                this.myUrlField.setText(this.myModel.getUrl());
                this.myUrlField.setCaretPosition(0);
            }
            this.setCurrentTag(this.myModel.getActiveGroupId());
            UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
            if (panel != null) {
                for (String param : this.myModel.getParameters()) {
                    panel.getDataInterchange().putProperty(param, StringUtil.nullize((String)this.myModel.getParameter(param)));
                }
            }
            String user = StringUtil.defaultIfEmpty((String)this.myModel.getParameter("user"), (String)this.myApprovedUser);
            if (!this.myUserField.getText().equals(user)) {
                this.myUserField.setText(user);
            }
            if (StringUtil.isEmpty((String)(password = this.myModel.getParameter("password")))) {
                this.myPasswordField.setPassword(this.myApprovedPassword);
            } else {
                this.myPasswordField.setPassword(password);
            }
            this.updateUrlFieldState();
            this.myChangedCallback.run();
        }
        finally {
            this.myUpdating = false;
        }
        this.inspect();
    }

    private void inspect() {
        if (this.myDriver == null || this.myInspectionsPane.isUpdating()) {
            return;
        }
        this.myInspectionsPane.clear();
        for (UrlEditorInspector inspector : this.getInspectors()) {
            inspector.runInspection(this.myDriver, this.myModel, this.myInspectionsPane);
        }
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel == null ? null : panel.getDataInterchange());
    }

    @NotNull
    private Collection<UrlEditorInspector> getInspectors() {
        if (this.myInspectors == null) {
            this.myInspectors = UrlEditorInspector.inspectorsFor(this.myDriver);
        }
        Collection<UrlEditorInspector> collection = this.myInspectors;
        if (collection == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void onActivity() {
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel != null) {
            panel.getDataInterchange().fireUserDataChanged(DataInterchange.ACTIVITY);
        }
    }

    private static int getVSpacing() {
        return 12;
    }

    public boolean isUrlOnly() {
        return this.myModel.isUrlOnly();
    }

    public void requestUrlFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myUrlField, true));
    }

    public String getAnonymizedUrl() {
        JdbcUrlParser parser;
        if (!(!this.myModel.isParserValid() || StringUtil.isEmpty((String)this.myModel.getParameter("user")) && StringUtil.isEmpty((String)this.myModel.getParameter("password")) || (parser = JdbcUrlParserUtil.stateful(this.myModel.getCurrentParser())) == null)) {
            parser.setUrlText(this.getUrl());
            if (parser.isValid()) {
                parser.setParameter("user", "");
                parser.setParameter("password", "");
                return parser.getUrlText();
            }
        }
        return this.getUrl();
    }

    public String getUrl() {
        return this.myUrlField.getText();
    }

    @NotNull
    public String getIdentifier() {
        JdbcUrlParser parser;
        StatelessJdbcUrlParser sparser = this.myModel.getMeaningfullParser();
        JdbcUrlParser jdbcUrlParser = parser = sparser == null ? null : sparser.createStatefull();
        if (parser != null) {
            parser.setUrlText(this.getUrl());
        }
        if (parser == null || !parser.isValid()) {
            String string = this.getUrl();
            if (string == null) {
                DynamicJdbcUrlEditor.$$$reportNull$$$0(4);
            }
            return string;
        }
        EnumSet<StatelessJdbcUrlParser.LocationType> locations = sparser.getPossibleLocations();
        StringBuilder identifier = new StringBuilder();
        if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.REMOTE)) {
            String databaseName = parser.getParameter("database");
            String hostName = parser.getParameter("host");
            if (!StringUtil.isEmpty((String)databaseName)) {
                identifier.append(new File(databaseName).getName());
            }
            if (!StringUtil.isEmpty((String)hostName)) {
                identifier.append("@").append(hostName);
            }
        } else if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.FILE)) {
            String file = StringUtil.notNullize((String)parser.getParameter("file"));
            identifier.append(new File(file).getName());
        } else if (locations.contains((Object)StatelessJdbcUrlParser.LocationType.DIRECTORY)) {
            String path = StringUtil.notNullize((String)parser.getParameter("path"));
            identifier.append(new File(path).getName());
        } else {
            identifier.append(StringUtil.notNullize((String)parser.getParameter("database")));
        }
        String string = identifier.toString();
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String generateNameFromParameters() {
        if (this.myActualDriver == null || this.myActualDriver.isPredefined()) {
            String string = this.getIdentifier();
            if (string == null) {
                DynamicJdbcUrlEditor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.myActualDriver.getName() + " - " + this.getIdentifier();
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    public void updateDriverLink() {
        List<SimpleClasspathElement> cp = ((LocalDataSource)this.myConfigurable.getDataSource()).getClasspathElements();
        boolean noJars = cp.isEmpty() || this.myActualDriver == null || cp != this.myActualDriver.getClasspathElements();
        String s1 = noJars ? null : "Custom Jars";
        String s2 = this.myActualDriver == null ? null : this.myActualDriver.getName();
        this.myDriverLink.setText(StringUtil.join(Arrays.asList(s1, s2), (String)" and "));
    }

    private void updatePanel(@NotNull DataInterchange interchange, boolean persistentOnly) {
        if (interchange == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, String> entry : this.myInterchangeProperties.entrySet()) {
            if (persistentOnly && !interchange.getPersistentProperties().contains(entry.getKey())) continue;
            interchange.putProperty(entry.getKey(), entry.getValue());
        }
    }

    private void panelPropertiesChanged(@Nullable UrlPropertiesPanel panel) {
        if (panel != this.getPropertyPanel(this.myCurrentPropPanel) || panel == null) {
            return;
        }
        this.myInterchangeProperties.clear();
        for (String prop : panel.getDataInterchange().getPersistentProperties()) {
            String val = panel.getDataInterchange().getProperty(prop);
            if (val == null) continue;
            this.myInterchangeProperties.put(prop, val);
        }
        this.myChangedCallback.run();
    }

    public void saveSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(10);
        }
        dataSource.setAuthRequired(this.isCurAuthRequired());
        dataSource.setDatabaseDriver(actual ? (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget(this.myDriver).get() : this.myDriver);
        boolean prevUseMasterKey = dataSource.isUseMasterKeyStorage();
        boolean newUseMasterKey = this.myRememberCheckBox.isSelected();
        dataSource.setUseMasterKeyStorage(newUseMasterKey);
        dataSource.setUsername(this.getUserName());
        if (copyCredentials) {
            boolean changed;
            if (prevUseMasterKey != newUseMasterKey) {
                this.myConfigurable.getSecretService().removeCredentials(dataSource);
            }
            boolean bl = changed = prevUseMasterKey != newUseMasterKey || !Comparing.equal((String)dataSource.getUsername(), (String)this.getUserName()) || this.isPasswordChanged();
            if (dataSource.getUniqueId() == null || changed) {
                this.myConfigurable.getSecretService().setCredentials(dataSource, new Credentials(this.getUserName(), this.getPassword()));
            }
        }
        dataSource.setUrl(this.getAnonymizedUrl());
        dataSource.setAdditionalJdbcProperties(this.myInterchangeProperties);
        dataSource.setDomainAuthentication(this.myDomainAuthCheckBox.isEnabled() && this.myDomainAuthCheckBox.isSelected());
        dataSource.setConfiguredByUrl(this.isUrlOnly());
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(11);
        }
        this.myRememberCheckBox.setSelected(dataSource.isUseMasterKeyStorage());
        this.setCredentials(dataSource.getUsername(), null);
        this.myInterchangeProperties.clear();
        this.myInterchangeProperties.putAll(dataSource.getAdditionalJdbcProperties());
        String url = StringUtil.notNullize((String)dataSource.getUrl());
        this.setDriver(dataSource.getDatabaseDriver(), url, dataSource.isConfiguredByUrl());
        if (this.myDomainAuthCheckBox.isEnabled()) {
            this.myDomainAuthCheckBox.setSelected(dataSource.isDomainAuthentication());
        }
        this.updateDriverLink();
    }

    public void setUrl(@NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(12);
        }
        this.myModel.setUrl(url);
        this.myModel.setUrlOnly(isUrlOnly);
        this.myModel.commit(true);
    }

    private void createAuthBox() {
        this.myDomainAuthCheckBox = new JBCheckBox(DatabaseMessages.message((String)"use.windows.domain.authentication", (Object[])new Object[0]));
        this.myUserField = new JBTextField();
        this.myPasswordField = new LazyPasswordField((Getter<char[]>)((Getter)() -> {
            Credentials credentials = this.myConfigurable.getSecretService().getCredentials((DatabaseSystem)this.myConfigurable.getDataSource());
            OneTimeString password = credentials == null ? null : credentials.getPassword();
            return password == null ? null : password.toCharArray();
        }));
        this.myRememberCheckBox = new JBCheckBox(DatabaseMessages.message((String)"remember.password", (Object[])new Object[0]));
        this.myRememberCheckBox.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        javax.swing.event.DocumentListener adapter = this.delayed((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                DynamicJdbcUrlEditor.this.removeCredentialsFromActiveParser();
                DynamicJdbcUrlEditor.this.myModel.commit(true);
            }
        });
        this.myUserField.getDocument().addDocumentListener(adapter);
        this.myPasswordField.getComponent().getDocument().addDocumentListener(adapter);
        DatabaseDriver driver = ((LocalDataSource)this.myConfigurable.getDataSource()).getDatabaseDriver();
        boolean domainAuth = DbImplUtil.supportsDomainAuth(driver);
        this.myDomainAuthCheckBox.setEnabled(domainAuth);
        int offs = domainAuth ? 1 : 0;
        GridLayoutManager layout = new GridLayoutManager(2 + offs, 6);
        this.myAuthPanel = new JPanel((LayoutManager)layout);
        if (offs == 1) {
            this.myAuthPanel.setBorder((Border)JBUI.Borders.emptyTop((int)12));
            this.myAuthPanel.add((Component)this.myDomainAuthCheckBox, UrlPropertiesPanel.createAlignedConstraints(0, 1, 3, 10));
        }
        final JBLabel userLabel = new JBLabel("User:");
        this.myAuthPanel.add((Component)userLabel, UrlPropertiesPanel.createLabelConstraints(offs, 0, userLabel.getPreferredSize().getWidth()));
        final JBLabel passwordLabel = new JBLabel("Password:");
        this.myAuthPanel.add((Component)passwordLabel, UrlPropertiesPanel.createLabelConstraints(offs + 1, 0, passwordLabel.getPreferredSize().getWidth()));
        JPanel fieldsPanel = new JPanel((LayoutManager)new GridLayoutManager(2, 2));
        this.myAuthPanel.add((Component)fieldsPanel, UrlPropertiesPanel.createSimpleConstraints(offs, 1, 2, 5));
        fieldsPanel.add((Component)this.myUserField, UrlPropertiesPanel.notUseParent(UrlPropertiesPanel.createSimpleConstraints(0, 0, 1)));
        fieldsPanel.add((Component)this.myPasswordField.getComponent(), UrlPropertiesPanel.notUseParent(UrlPropertiesPanel.createSimpleConstraints(1, 0, 1)));
        fieldsPanel.add((Component)this.myRememberCheckBox, UrlPropertiesPanel.notUseParent(UrlPropertiesPanel.createAlignedConstraints(1, 1, 1, 8)));
        this.myDomainAuthCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = DynamicJdbcUrlEditor.this.myDomainAuthCheckBox.isSelected();
                DynamicJdbcUrlEditor.this.myUserField.setEnabled(!selected);
                DynamicJdbcUrlEditor.this.myPasswordField.getComponent().setEnabled(!selected);
                DynamicJdbcUrlEditor.this.myRememberCheckBox.setEnabled(!selected);
                userLabel.setEnabled(!selected);
                passwordLabel.setEnabled(!selected);
                DynamicJdbcUrlEditor.this.stateChanged(null);
            }
        });
    }

    @Nullable
    private UrlPropertiesPanel getPropertyPanel(int idx) {
        return idx >= 0 && idx < this.myUrlPropertiesPanels.size() ? this.myUrlPropertiesPanels.get(idx) : null;
    }

    private void setCurrentTag(int idx) {
        if (idx == this.myCurrentPropPanel) {
            return;
        }
        UrlPropertiesPanel curPanel = this.getPropertyPanel(idx);
        this.myCurrentPropPanel = idx;
        this.myConstructorPanel.removeAll();
        if (curPanel != null && !curPanel.isEmpty()) {
            this.myConstructorPanel.setLayout((LayoutManager)new GridLayoutManager(curPanel.isAuthSupported() ? 2 : 1, 6));
            this.myConstructorPanel.add((Component)curPanel, UrlPropertiesPanel.createRowConstraints(0));
            if (curPanel.isAuthSupported()) {
                this.myConstructorPanel.add((Component)this.myAuthPanel, UrlPropertiesPanel.createRowConstraints(1));
            }
            curPanel.setFieldsActive(!this.myEditUrl);
        } else {
            this.myConstructorPanel.setLayout((LayoutManager)new GridLayoutManager(1, 6));
            this.myConstructorPanel.add((Component)this.myAuthPanel, UrlPropertiesPanel.createRowConstraints(0));
        }
        this.myConstructorPanel.repaint();
        this.myPanelsSwitcher.setSelectedIndex(this.myCurrentPropPanel);
        this.myAuthPanel.revalidate();
        this.myUrlField.getParent().revalidate();
    }

    private void setUrlFieldActive(boolean urlActive) {
        if (this.myEditUrl == urlActive) {
            return;
        }
        this.myEditUrl = urlActive;
        this.resetFieldsBackground();
    }

    private void resetFieldsBackground() {
        boolean ignore = this.isUrlOnly();
        this.myUrlField.setBackground(ParamEditorBase.getBackground(this.myEditUrl || ignore));
        this.myUserField.setBackground(ParamEditorBase.getBackground(!this.myEditUrl || ignore));
        this.myPasswordField.getComponent().setBackground(ParamEditorBase.getBackground(!this.myEditUrl || ignore));
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel != null) {
            panel.setFieldsActive(!this.myEditUrl || ignore);
        }
    }

    @NotNull
    private static TextAttributes getErrorAttributes(boolean insert) {
        TextAttributes textAttributes = new TextAttributes(null, null, (Color)JBColor.RED, insert ? EffectType.BOXED : EffectType.WAVE_UNDERSCORE, 0);
        if (textAttributes == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(13);
        }
        return textAttributes;
    }

    private static TextAttributes getCurrentParamAttributes(@NotNull Color fg) {
        if (fg == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(14);
        }
        return new TextAttributes(null, null, fg, EffectType.LINE_UNDERSCORE, 0);
    }

    private void updateUrlFieldState() {
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel != null) {
            Editor editor = this.myUrlField.getEditor();
            if (editor != null) {
                TextAttributes errorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(false);
                TextAttributes insertErrorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(true);
                editor.getMarkupModel().removeAllHighlighters();
                for (TextRange range : this.myModel.getInvalidRanges()) {
                    int s = range.getStartOffset();
                    int e = range.getEndOffset();
                    editor.getMarkupModel().addRangeHighlighter(s, e, 100, s == e ? insertErrorAttributes : errorAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
                String activeParam = panel.getActiveParameter();
                TextAttributes currentParamAttributes = DynamicJdbcUrlEditor.getCurrentParamAttributes(this.myUrlField.getForeground());
                for (String param : this.myModel.getParameters()) {
                    TextRange range = this.myModel.getParameterRange(param);
                    if (range == null) continue;
                    editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, null, HighlighterTargetArea.EXACT_RANGE);
                    if (!param.equals(activeParam)) continue;
                    editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, currentParamAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
            }
        } else {
            Editor editor = this.myUrlField.getEditor();
            if (editor != null) {
                editor.getMarkupModel().removeAllHighlighters();
            }
        }
    }

    private void removeCredentialsFromActiveParser() {
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel != null) {
            this.myApprovedUser = this.myUserField.getText();
            this.myApprovedPassword = this.myPasswordField.getPasswordOpt();
            this.myModel.setParameter("user", "");
            this.myModel.setParameter("password", "");
        }
    }

    private void setCredentials(@NotNull String username, @Nullable char[] password) {
        if (username == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(15);
        }
        this.myApprovedUser = username;
        this.myApprovedPassword = password;
        this.myUpdating = true;
        try {
            this.myUserField.setText(this.myApprovedUser);
            this.myPasswordField.setPassword(this.myApprovedPassword);
        }
        finally {
            this.myUpdating = false;
        }
    }

    @Nullable
    public String getUserName() {
        return this.isAuthSupported() ? this.myUserField.getText() : null;
    }

    public boolean isPasswordChanged() {
        return this.myPasswordField.isModified();
    }

    @Nullable
    public char[] getPassword() {
        if (!this.isAuthSupported()) {
            return null;
        }
        return this.myPasswordField.getPassword();
    }

    private boolean isAuthSupported() {
        UrlPropertiesPanel panel = this.getPropertyPanel(this.myCurrentPropPanel);
        return panel == null || panel.isAuthSupported();
    }

    public boolean isCurAuthRequired() {
        return this.isAuthSupported();
    }

    public void setCanConnect(boolean canConnect) {
        this.myConfigurable.getTestAction().setEnabled(canConnect);
    }

    public void setDriver(@Nullable DatabaseDriver driver, @NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(16);
        }
        this.myInspectors = null;
        this.myDriver = driver;
        DatabaseDriver prevDriver = this.myActualDriver;
        DatabaseDriver databaseDriver = this.myActualDriver = this.myDriver == null ? null : (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget(this.myDriver).get();
        if (prevDriver == null || !((DatabaseDriverImpl)prevDriver).equalConfiguration((DatabaseDriverImpl)this.myActualDriver)) {
            UrlEditorModel newModel = this.createModelForDriver(this.myActualDriver);
            if (this.myModel.getUrl().equals(url)) {
                newModel.assign(this.myModel);
            } else {
                newModel.setUrl(url);
            }
            newModel.setUrlOnly(isUrlOnly);
            this.myModel = newModel;
            newModel.commit(false);
        } else {
            this.myModel.setUrl(url);
            this.myModel.setUrlOnly(isUrlOnly);
            this.myModel.commit(false);
        }
        this.createPanels();
        this.updateDriverLink();
        this.stateChanged(true);
    }

    private void createPanels() {
        for (UrlPropertiesPanel panel : this.myUrlPropertiesPanels) {
            Disposer.dispose((Disposable)panel);
        }
        this.myUrlPropertiesPanels.clear();
        Runnable focusCallback = this::updateUrlFieldState;
        String[] items = new String[this.myModel.getGroupsCount()];
        for (int i2 = 0; i2 < this.myModel.getGroupsCount(); ++i2) {
            DataInterchange interchange = new DataInterchange(this.myConfigurable);
            this.updatePanel(interchange, false);
            final StatelessParametersHolder group2 = this.myModel.getGroup(i2);
            final UrlPropertiesPanel panel = new UrlPropertiesPanel(group2, interchange, focusCallback);
            Disposer.register((Disposable)this.myConfigurable, (Disposable)panel);
            panel.getDataInterchange().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    if (evt == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (panel != DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) || DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = DynamicJdbcUrlEditor.this.myPersistentPropertyChanged | (panel == DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) && panel.getDataInterchange().getPersistentProperties().contains(evt.getPropertyName()));
                    if (group2.getParameters().contains(evt.getPropertyName())) {
                        DynamicJdbcUrlEditor.this.myModel.setParameter(evt.getPropertyName(), StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class))));
                    }
                    DynamicJdbcUrlEditor.this.panelPropertiesChanged(panel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$7", "propertyChange"));
                }
            }, panel);
            panel.getDataInterchange().addUserDataListener(new DataInterchange.UserDataListener(){

                @Override
                public void userDataChanged(@NotNull Key changed) {
                    if (changed == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (panel != DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) || DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.inspect();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$8", "userDataChanged"));
                }
            }, panel);
            panel.getDataInterchange().addGroupedChangeListener(this.delayed(new DataInterchange.NestedChangeListener(){

                @Override
                public void nestedChange(int depth) {
                    if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                        return;
                    }
                    if (DynamicJdbcUrlEditor.this.myPersistentPropertyChanged) {
                        DynamicJdbcUrlEditor.this.panelPropertiesChanged(DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel));
                        DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = false;
                    }
                    if (DynamicJdbcUrlEditor.this.myModel.getState() != UrlEditorModelBase.State.VALID) {
                        DynamicJdbcUrlEditor.this.removeCredentialsFromActiveParser();
                    }
                    DynamicJdbcUrlEditor.this.myModel.commit(true);
                }
            }), panel);
            this.myUrlPropertiesPanels.add(panel);
            items[i2] = this.myModel.getGroupName(i2);
        }
        this.myPanelsSwitcher.setModel(new DefaultComboBoxModel<String>(items));
        this.myPanelsSwitcher.setSelectedIndex(-1);
        this.myUrlPanel.removeAll();
        if (this.myModel.getGroupsCount() > 1) {
            this.myUrlPanel.add((Component)this.myUrlField);
            this.myUrlPanel.add(Box.createHorizontalStrut(5));
            this.myUrlPanel.add((Component)this.myPanelsSwitcher);
        } else {
            this.myUrlPanel.add((Component)this.myUrlField);
        }
        this.setUrlFieldActive(false);
        this.myCurrentPropPanel = -1;
    }

    public void resetCredentials(@NotNull LocalDataSource source) {
        Credentials provided;
        if (source == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(17);
        }
        if (!this.isAuthSupported()) {
            return;
        }
        Credentials saved = this.myConfigurable.getSecretService().getCredentials((DatabaseSystem)this.myConfigurable.getDataSource());
        if (Comparing.equal((Object)saved, (Object)(provided = this.myConfigurable.getSecretService().getCredentials(source)))) {
            this.setCredentials(StringUtil.notNullize((String)(saved == null ? null : saved.getUserName())), null);
        } else {
            OneTimeString password = provided == null ? null : provided.getPassword();
            this.setCredentials(StringUtil.notNullize((String)(provided == null ? null : provided.getUserName())), password == null ? null : password.toCharArray());
        }
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myActualDriver;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myDriver;
    }

    @NotNull
    public UrlEditorModel getEditorModel() {
        UrlEditorModel urlEditorModel = this.myModel;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(18);
        }
        return urlEditorModel;
    }

    private ItemListener delayed(final @NotNull ItemListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(19);
        }
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating || e.getStateChange() != 1) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (l == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    l.itemStateChanged(e);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$10", "lambda$itemStateChanged$0"));
            }
        };
    }

    private javax.swing.event.DocumentListener delayed(final @NotNull javax.swing.event.DocumentListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(20);
        }
        return new javax.swing.event.DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (l == null) {
                        11.$$$reportNull$$$0(2);
                    }
                    l.insertUpdate(e);
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (l == null) {
                        11.$$$reportNull$$$0(1);
                    }
                    l.removeUpdate(e);
                });
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (l == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    l.changedUpdate(e);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "l";
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$changedUpdate$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$removeUpdate$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$insertUpdate$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private DataInterchange.NestedChangeListener delayed(final @NotNull DataInterchange.NestedChangeListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(21);
        }
        return new DataInterchange.NestedChangeListener(){

            @Override
            public void nestedChange(int depth) {
                if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (l == null) {
                        12.$$$reportNull$$$0(0);
                    }
                    l.nestedChange(depth);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$12", "lambda$nestedChange$0"));
            }
        };
    }

    public void forgetPassword() {
        this.myPasswordField.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedCallback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelForDriver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNameFromParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentParamAttributes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCredentials";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setDriver";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resetCredentials";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "delayed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInspectionConsumer
    extends JPanel
    implements UrlEditorInspector.InspectionConsumer {
        private List<Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]>> myWarnings = ContainerUtil.newArrayList();
        private JBLabel myLabel = new JBLabel(AllIcons.Toolwindows.Problems);
        private LinkLabel myMore = LinkLabel.create((String)"More", () -> this.onMore());
        private JComponent myFixesPanel = new Box(0);
        private boolean myUpdating = false;

        public MyInspectionConsumer() {
            super(new BorderLayout(10, 0));
            Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            this.myLabel.setFont(font);
            this.myMore.setFont(font);
            this.add((Component)this.myLabel, "Center");
            this.add((Component)this.myFixesPanel, "East");
        }

        private void onMore() {
            StringBuilder sb = new StringBuilder();
            for (Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning : this.myWarnings) {
                sb.append((String)warning.second).append("\n\n");
            }
            Messages.showInfoMessage((String)sb.toString(), (String)"Warnings");
        }

        @Override
        public void warning(@NotNull String title, @Nullable String more, Pair<String, Consumer<DataInterchange>> ... fixes) {
            if (title == null) {
                MyInspectionConsumer.$$$reportNull$$$0(0);
            }
            if (fixes == null) {
                MyInspectionConsumer.$$$reportNull$$$0(1);
            }
            this.myWarnings.add((Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]>)Trinity.create((Object)title, (Object)more, fixes));
        }

        public void clear() {
            this.myWarnings.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateVisibility(@Nullable DataInterchange active) {
            this.myUpdating = true;
            try {
                if (this.myWarnings.isEmpty()) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                    boolean hasMore = this.myWarnings.size() > 1;
                    for (Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning : this.myWarnings) {
                        hasMore |= warning.second != null;
                    }
                    Trinity<String, String, Pair<String, Consumer<DataInterchange>>[]> warning = this.myWarnings.get(0);
                    this.myLabel.setText("<html>" + StringUtil.escapeXml((String)((String)warning.first)) + "</html>");
                    this.myFixesPanel.removeAll();
                    if (hasMore) {
                        this.myFixesPanel.add((Component)this.myMore);
                    }
                    for (int i2 = 0; i2 < ((Pair[])warning.third).length; ++i2) {
                        Pair fix = ((Pair[])warning.third)[i2];
                        LinkLabel label = new LinkLabel((String)fix.first, null, (a, b) -> {
                            if (active != null) {
                                ((Consumer)fix.second).consume((Object)active);
                            }
                        });
                        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
                        this.myFixesPanel.add(Box.createHorizontalStrut(10));
                        this.myFixesPanel.add((Component)label);
                    }
                }
            }
            finally {
                this.myUpdating = false;
            }
        }

        public boolean isUpdating() {
            return this.myUpdating;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$MyInspectionConsumer";
            objectArray[2] = "warning";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

