/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.NavigatableWithText;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridPomTarget
implements PomNamedTarget,
NavigatableWithText {
    public final DataGrid dataGrid;

    @NotNull
    public static PsiElement wrapDataGrid(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            DataGridPomTarget.$$$reportNull$$$0(0);
        }
        if (dataGrid == null) {
            DataGridPomTarget.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Grid(dataGrid));
        if (psiElement == null) {
            DataGridPomTarget.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement wrapCell(@NotNull Project project, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns2) {
        if (project == null) {
            DataGridPomTarget.$$$reportNull$$$0(3);
        }
        if (dataGrid == null) {
            DataGridPomTarget.$$$reportNull$$$0(4);
        }
        if (rows == null) {
            DataGridPomTarget.$$$reportNull$$$0(5);
        }
        if (columns2 == null) {
            DataGridPomTarget.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Cell(dataGrid, rows, columns2));
        if (psiElement == null) {
            DataGridPomTarget.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement wrapColumn(@NotNull Project project, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (project == null) {
            DataGridPomTarget.$$$reportNull$$$0(8);
        }
        if (dataGrid == null) {
            DataGridPomTarget.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            DataGridPomTarget.$$$reportNull$$$0(10);
        }
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new Column(dataGrid, column2));
        if (psiElement == null) {
            DataGridPomTarget.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Nullable
    public static DataGrid unwrapDataGrid(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t != null ? t.dataGrid : null;
    }

    @Nullable
    public static Cell unwrapCell(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t instanceof Cell ? (Cell)t : null;
    }

    @Nullable
    public static Column unwrapColumn(@Nullable PsiElement element) {
        DataGridPomTarget t = DataGridPomTarget.unwrap(element);
        return t instanceof Column ? (Column)t : null;
    }

    @Nullable
    private static DataGridPomTarget unwrap(@Nullable PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget target2 = ((PomTargetPsiElement)element).getTarget();
        return target2 instanceof DataGridPomTarget ? (DataGridPomTarget)target2 : null;
    }

    DataGridPomTarget(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            DataGridPomTarget.$$$reportNull$$$0(12);
        }
        this.dataGrid = dataGrid;
    }

    public boolean isValid() {
        return true;
    }

    public void navigate(boolean requestFocus) {
        this.dataGrid.scrollSelectionToVisible();
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.dataGrid.getPreferredFocusedComponent(), true));
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    public int hashCode() {
        return this.dataGrid.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.dataGrid.equals(((DataGridPomTarget)o).dataGrid);
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        return "Jump to Data Grid";
    }

    public String getName() {
        return this.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridPomTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridPomTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDataGrid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapCell";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapDataGrid";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapCell";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wrapColumn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Cell
    extends DataGridPomTarget {
        public final ModelIndexSet<DataConsumer.Row> rows;
        public final ModelIndexSet<DataConsumer.Column> columns;

        Cell(DataGrid dataGrid, ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns2) {
            super(dataGrid);
            this.rows = rows;
            this.columns = columns2;
        }

        @Override
        public void navigate(boolean requestFocus) {
            this.dataGrid.getSelectionModel().setRowSelection(this.rows);
            this.dataGrid.getSelectionModel().setColumnSelection(this.columns);
            super.navigate(requestFocus);
        }

        public String toString() {
            ModelIndex r0 = (ModelIndex)this.rows.first();
            ModelIndex c0 = (ModelIndex)this.columns.last();
            ModelIndex r1 = (ModelIndex)this.rows.last();
            ModelIndex c1 = (ModelIndex)this.columns.last();
            if (!(r0.isValid(this.dataGrid) && c0.isValid(this.dataGrid) && r1.isValid(this.dataGrid) && c1.isValid(this.dataGrid))) {
                return "";
            }
            String s = r0.toView(this.dataGrid).asInteger() + 1 + "x" + (c0.toView(this.dataGrid).asInteger() + 1);
            return "[" + (r0.equals(r1) && c0.equals(c1) ? s : s + ".." + (r1.toView(this.dataGrid).asInteger() + 1) + "x" + (c1.toView(this.dataGrid).asInteger() + 1)) + "]";
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.rows.hashCode() + 961 * this.columns.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return super.equals(o) && this.rows.equals(((Cell)o).rows) && this.columns.equals(((Cell)o).columns);
        }
    }

    public static class Column
    extends DataGridPomTarget {
        public final ModelIndex<DataConsumer.Column> column;

        Column(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (dataGrid == null) {
                Column.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                Column.$$$reportNull$$$0(1);
            }
            super(dataGrid);
            this.column = column2;
        }

        public DataConsumer.Column getColumn() {
            return this.dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(this.column);
        }

        @Override
        public void navigate(boolean requestFocus) {
            this.dataGrid.getSelectionModel().setColumnSelection(this.column);
            super.navigate(requestFocus);
        }

        public String toString() {
            return "Column " + this.column.asInteger();
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.column.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return super.equals(o) && this.column.equals(((Column)o).column);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataGrid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DataGridPomTarget$Column";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Grid
    extends DataGridPomTarget {
        public final String title;

        Grid(@NotNull DataGrid dataGrid) {
            if (dataGrid == null) {
                Grid.$$$reportNull$$$0(0);
            }
            super(dataGrid);
            this.title = dataGrid.getDisplayName();
        }

        public String toString() {
            return StringUtil.isNotEmpty((String)this.title) ? this.title : "Table Data";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/datagrid/DataGridPomTarget$Grid", "<init>"));
        }
    }
}

