/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.SessionHolder;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.datagrid.SqlDocumentDataHookUp;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataHookUpManager
extends SessionHolder<DatabaseTableGridDataHookUp, Parameters> {
    private final Project myProject;
    private final Map<VirtualFile, HookUpReference> myVirtualFileBasedHookUps;
    private final Set<HookUpReference> myHookUps;
    private final Object myLock;

    public GridDataHookUpManager(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(0);
        }
        super(DatabaseTableGridDataHookUp.class);
        this.myProject = project;
        this.myVirtualFileBasedHookUps = ContainerUtil.newHashMap();
        this.myHookUps = ContainerUtil.newHashSet();
        this.myLock = new Object();
    }

    public static GridDataHookUpManager getInstance(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(1);
        }
        return (GridDataHookUpManager)ServiceManager.getService((Project)project, GridDataHookUpManager.class);
    }

    @NotNull
    public DatabaseTableGridDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(3);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)this.getOrCreateHookUp(file, tableFile -> {
            DbDataSource dataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)DbImplUtil.findDataSource(this.myProject, tableFile));
            SimpleRequestBroker broker = SimpleRequestBroker.newInstance(this.myProject, tableFile.getName());
            Parameters parameters = new Parameters(this.myProject, broker, (VirtualFile)tableFile);
            DatabaseTableGridDataHookUp hookUp = (DatabaseTableGridDataHookUp)this.openSession(parameters);
            hookUp.setCurrentTx(DataRequest.getInitialTxMarker(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource).isAutoCommit()));
            JdbcEngine engine = new JdbcEngine(this.myProject, broker, (LocalDataSource)dataSource.getDelegate(), null);
            Disposer.register((Disposable)hookUp, (Disposable)engine);
            return hookUp;
        }, parent);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(4);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull CsvTableDataFragmentFile file, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(6);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, file1.getFormat(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(7);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public SqlDocumentDataHookUp getHookUp(@NotNull SqlTableDataFragmentFile file, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(9);
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new SqlDocumentDataHookUp(this.myProject, file1.getDialect(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent);
        if (sqlDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(10);
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull CsvFormat format, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(11);
        }
        if (format == null) {
            GridDataHookUpManager.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(13);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> {
            if (format == null) {
                GridDataHookUpManager.$$$reportNull$$$0(42);
            }
            return new CsvDocumentDataHookUp(this.myProject, format, GridDataHookUpManager.getDocument(file1), null);
        }, parent);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(14);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createDatabaseHookUp(@NotNull DataBus.Consuming messageBus, @NotNull JdbcConsole.SearchPathSender sender, @NotNull Disposable parent) {
        if (messageBus == null) {
            GridDataHookUpManager.$$$reportNull$$$0(15);
        }
        if (sender == null) {
            GridDataHookUpManager.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(17);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ConsoleGridDataHookUp(this.myProject, messageBus, sender), parent);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(18);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull DataBus.Consuming messageBus, @NotNull Disposable parent, @NotNull String query) {
        if (messageBus == null) {
            GridDataHookUpManager.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(20);
        }
        if (query == null) {
            GridDataHookUpManager.$$$reportNull$$$0(21);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ReadOnlyDatabaseGridDataHookUp(this.myProject, messageBus, query), parent);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(22);
        }
        return databaseGridDataHookUp;
    }

    public JpaGridDataHookUp createJpaHookUp(@NotNull DataBus.Consuming messageBus, @NotNull Disposable parent) {
        if (messageBus == null) {
            GridDataHookUpManager.$$$reportNull$$$0(23);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(24);
        }
        return this.registerHookUp(new JpaGridDataHookUp(this.myProject, messageBus), parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> acquire(@NotNull HookUpHandle handle, @NotNull Disposable parent) {
        if (handle == null) {
            GridDataHookUpManager.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(26);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (handle.myRef == null || handle.myRef.myReferenceCount <= 0) {
                return null;
            }
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(handle.myRef));
            handle.myRef.myReferenceCount++;
            return handle.myRef.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HookUpHandle getHandle(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(27);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        HookUpReference res = null;
        for (HookUpReference ref : this.myHookUps) {
            if (ref.myHookUp != hookUp) continue;
            res = ref;
            break;
        }
        HookUpHandle hookUpHandle = new HookUpHandle(res);
        // MONITOREXIT : object
        if (hookUpHandle != null) return hookUpHandle;
        GridDataHookUpManager.$$$reportNull$$$0(28);
        return hookUpHandle;
    }

    @Override
    @NotNull
    protected List<DatabaseTableGridDataHookUp> getActiveSessions(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(29);
        }
        List<DatabaseTableGridDataHookUp> list = this.myVirtualFileBasedHookUps.values().stream().filter(h -> ((HookUpReference)h).myHookUp instanceof DatabaseTableGridDataHookUp).filter(h -> ((HookUpReference)h).myReferenceCount > 0).map(h -> (DatabaseTableGridDataHookUp)((HookUpReference)h).myHookUp).collect(Collectors.toList());
        if (list == null) {
            GridDataHookUpManager.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Override
    protected void register(@NotNull Project project, @NotNull DatabaseTableGridDataHookUp session) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(31);
        }
        if (session == null) {
            GridDataHookUpManager.$$$reportNull$$$0(32);
        }
    }

    @Override
    @NotNull
    protected DatabaseTableGridDataHookUp getSessionInner(@NotNull Parameters parameters) {
        if (parameters == null) {
            GridDataHookUpManager.$$$reportNull$$$0(33);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = new DatabaseTableGridDataHookUp(parameters.project, parameters.messageBus, parameters.file);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(34);
        }
        return databaseTableGridDataHookUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends VirtualFile, H extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> H getOrCreateHookUp(final @NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(35);
        }
        if (hookUpFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(36);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(37);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = this.myVirtualFileBasedHookUps.get(file);
            if (ref == null || ref.myReferenceCount <= 0) {
                GridDataHookUp hookUp = (GridDataHookUp)hookUpFactory.fun(file);
                ref = new HookUpReference(hookUp){

                    @Override
                    public void dispose() {
                        super.dispose();
                        GridDataHookUpManager.this.myVirtualFileBasedHookUps.remove(file);
                    }
                };
                this.myVirtualFileBasedHookUps.put(file, ref);
                this.myHookUps.add(ref);
            }
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            ref.myReferenceCount++;
            return (H)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T registerHookUp(T hookUp, @NotNull Disposable parent) {
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(38);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = new HookUpReference(hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            ref.myReferenceCount++;
            return hookUp;
        }
    }

    private Disposable createHookUpReferenceDisposable(final @NotNull HookUpReference ref) {
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(39);
        }
        return new Disposable(){
            private AtomicBoolean myDisposed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (!this.myDisposed.compareAndSet(false, true)) {
                    return;
                }
                Object object = GridDataHookUpManager.this.myLock;
                synchronized (object) {
                    if (--ref.myReferenceCount <= 0) {
                        Disposer.dispose((Disposable)ref);
                        GridDataHookUpManager.this.myHookUps.remove(ref);
                    }
                }
            }
        };
    }

    @NotNull
    private static Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(40);
        }
        Document document = (Document)ObjectUtils.assertNotNull((Object)FileDocumentManager.getInstance().getDocument(file));
        if (document == null) {
            GridDataHookUpManager.$$$reportNull$$$0(41);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 12: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handle";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseHookUp";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandle";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSessions";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionInner";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHookUp";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseHookUp";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createJpaHookUp";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHandle";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getActiveSessions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSessionInner";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHookUp";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createHookUpReferenceDisposable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHookUp$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Parameters
    extends SessionHolder.Parameters {
        final VirtualFile file;

        Parameters(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull VirtualFile file) {
            if (project == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (messageBus == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            super(project, messageBus);
            this.file = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageBus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/GridDataHookUpManager$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ReadOnlyDatabaseGridDataHookUp
    extends DatabaseGridDataHookUp {
        private final String myQuery;

        private ReadOnlyDatabaseGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull String query) {
            if (project == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (messageBus == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            super(project, messageBus);
            this.myQuery = query;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            DatabaseGridDataHookUp.DatabaseLoader databaseLoader = new DatabaseGridDataHookUp.DatabaseLoader(){

                @Override
                protected boolean canUpdateQueryText() {
                    return true;
                }

                @Override
                protected String createQueryText(@Nullable Integer limit) {
                    return myQuery;
                }
            };
            if (databaseLoader == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            return databaseLoader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageBus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HookUpReference
    implements Disposable {
        private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myHookUp;
        private int myReferenceCount = 0;

        private HookUpReference(GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            this.myHookUp = hookUp;
            if (this.myHookUp instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myHookUp));
            }
        }

        public void dispose() {
        }
    }

    public static class HookUpHandle {
        private final HookUpReference myRef;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookUpHandle handle = (HookUpHandle)o;
            return !(this.myRef != null ? !this.myRef.equals(handle.myRef) : handle.myRef != null);
        }

        public int hashCode() {
            return this.myRef != null ? this.myRef.hashCode() : 0;
        }

        private HookUpHandle(@Nullable HookUpReference ref) {
            this.myRef = ref;
        }
    }
}

