/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ObjectToTextConverter;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportInfo {
    private final CsvFormat myFormat;
    private final DeTable myTable;
    private final String myProducerName;
    private final ImportType myType;
    private final ImportAction.InputType myInputType;
    private final HandleErrorTask.ErrorTaskInfo myErrorTaskInfo;
    private final boolean myLockTable;
    private final List<? extends ColumnDescriptor> myProducers;
    private final Cache myCache;
    private final DatabaseEditorContext myContext;
    private final boolean myInsertAsNull;
    private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
    private List<AutoValueDescriptor> myConsumers;

    private ImportInfo(@Nullable CsvFormat format, @NotNull DeTable table, @NotNull List<AutoValueDescriptor> consumers, @NotNull List<? extends ColumnDescriptor> producers, @NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map2, @NotNull String producerName, @NotNull ImportType importType, @NotNull DatabaseEditorContext context, @NotNull ImportAction.InputType inputType, @NotNull HandleErrorTask.ErrorTaskInfo errorTaskInfo, boolean lockTable, boolean insertAsNull) {
        if (table == null) {
            ImportInfo.$$$reportNull$$$0(0);
        }
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(1);
        }
        if (producers == null) {
            ImportInfo.$$$reportNull$$$0(2);
        }
        if (map2 == null) {
            ImportInfo.$$$reportNull$$$0(3);
        }
        if (producerName == null) {
            ImportInfo.$$$reportNull$$$0(4);
        }
        if (importType == null) {
            ImportInfo.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ImportInfo.$$$reportNull$$$0(6);
        }
        if (inputType == null) {
            ImportInfo.$$$reportNull$$$0(7);
        }
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(8);
        }
        this.myFormat = format;
        this.myTable = table;
        this.myProducers = producers;
        this.myProducerName = producerName;
        this.myType = importType;
        this.myInputType = inputType;
        this.myErrorTaskInfo = errorTaskInfo;
        this.myLockTable = lockTable;
        this.myConsumers = consumers;
        this.myConsumerToProducer = map2;
        this.myContext = context;
        this.myInsertAsNull = insertAsNull;
        this.myCache = new Cache();
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumers() {
        List<AutoValueDescriptor> list = this.myConsumers;
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<AutoValueDescriptor> getConsumersForInsert() {
        List list = ContainerUtil.filter(this.myConsumers, consumer -> this.myConsumerToProducer.get(consumer) != null || !consumer.isComputed() && (consumer.isAutogenerated() || consumer.hasDefault()));
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<? extends ColumnDescriptor> getProducers() {
        List<? extends ColumnDescriptor> list = this.myProducers;
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public ImportAction.InputType getInputType() {
        ImportAction.InputType inputType = this.myInputType;
        if (inputType == null) {
            ImportInfo.$$$reportNull$$$0(12);
        }
        return inputType;
    }

    public boolean isInsertAsNull() {
        return this.myInsertAsNull;
    }

    @Nullable
    public CsvFormat getFormat() {
        return this.myFormat;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTable.getName();
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            ImportInfo.$$$reportNull$$$0(14);
        }
        return databaseEditorContext;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = this.myTable;
        if (deTable == null) {
            ImportInfo.$$$reportNull$$$0(15);
        }
        return deTable;
    }

    @NotNull
    public ImportType getType() {
        ImportType importType = this.myType;
        if (importType == null) {
            ImportInfo.$$$reportNull$$$0(16);
        }
        return importType;
    }

    @NotNull
    public HandleErrorTask.ErrorTaskInfo getErrorTaskInfo() {
        HandleErrorTask.ErrorTaskInfo errorTaskInfo = this.myErrorTaskInfo;
        if (errorTaskInfo == null) {
            ImportInfo.$$$reportNull$$$0(17);
        }
        return errorTaskInfo;
    }

    public boolean shouldLockTable() {
        return this.myLockTable;
    }

    @NotNull
    public String getProducerName() {
        String string = this.myProducerName;
        if (string == null) {
            ImportInfo.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public Cache cache() {
        Cache cache2 = this.myCache;
        if (cache2 == null) {
            ImportInfo.$$$reportNull$$$0(19);
        }
        return cache2;
    }

    public void setConsumers(@NotNull List<ColumnDescriptor> consumers) {
        if (consumers == null) {
            ImportInfo.$$$reportNull$$$0(20);
        }
        ArrayList newConsumers = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < consumers.size(); ++i2) {
            AutoValueDescriptor oldOne = this.myConsumers.get(i2);
            newConsumers.add(ImportUtil.createDescriptor(consumers.get(i2), oldOne.isAutogenerated(), oldOne.hasDefault(), oldOne.isComputed()));
        }
        this.myConsumers = newConsumers;
        LinkedHashMap newMap = ContainerUtilRt.newLinkedHashMap();
        Iterator<Map.Entry<AutoValueDescriptor, ColumnDescriptor>> iterator = this.myConsumerToProducer.entrySet().iterator();
        for (AutoValueDescriptor consumer : this.myConsumers) {
            if (!iterator.hasNext()) break;
            AutoValueDescriptor existingConsumer = iterator.next().getKey();
            ColumnDescriptor producer = this.myConsumerToProducer.get(existingConsumer);
            newMap.put(consumer, producer);
        }
        this.myConsumerToProducer = newMap;
    }

    @NotNull
    private Collection<AutoValueDescriptor> mappedConsumers() {
        List list = ContainerUtil.filter(this.myConsumers, consumer -> this.myConsumerToProducer.get(consumer) != null);
        if (list == null) {
            ImportInfo.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTaskInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumersForInsert";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTaskInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cache";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "mappedConsumers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setConsumers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private CsvFormat myFormat;
        private DeTable myTable;
        private String myProducerName;
        private ImportType myImportType;
        private ImportAction.InputType myInputType;
        private HandleErrorTask.ErrorTaskInfo myErrorTaskInfo;
        private boolean myLockTable;
        private List<? extends ColumnDescriptor> myProducers;
        private DatabaseEditorContext myContext;
        private boolean myInsertAsNull;
        private LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> myConsumerToProducer;
        private List<AutoValueDescriptor> myConsumers;
        private List<DataConsumer.Row> myRows;
        private List<? extends ColumnDescriptor> myVisibleProducers;

        @NotNull
        public Builder rows(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myRows = rows;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder csvFormat(@Nullable CsvFormat format) {
            this.myFormat = format;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder consumer(@NotNull DeTable table) {
            if (table == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myTable = table;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder producerName(@NotNull String producerName) {
            if (producerName == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myProducerName = producerName;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder importType(@NotNull ImportType type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myImportType = type;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder inputType(@NotNull ImportAction.InputType type) {
            if (type == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myInputType = type;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder errorTaskInfo(@NotNull HandleErrorTask.ErrorTaskInfo info) {
            if (info == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myErrorTaskInfo = info;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder lockTable(boolean lockTable) {
            this.myLockTable = lockTable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder producers(@NotNull List<? extends ColumnDescriptor> producers) {
            if (producers == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myProducers = producers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @NotNull
        public Builder visibleProducers(@NotNull List<? extends ColumnDescriptor> visibleProducers) {
            if (visibleProducers == null) {
                Builder.$$$reportNull$$$0(16);
            }
            this.myVisibleProducers = visibleProducers;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder;
        }

        @NotNull
        public Builder editorContext(@NotNull DatabaseEditorContext context) {
            if (context == null) {
                Builder.$$$reportNull$$$0(18);
            }
            this.myContext = context;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return builder;
        }

        @NotNull
        public Builder insertAsNull(boolean insertAsNull) {
            this.myInsertAsNull = insertAsNull;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return builder;
        }

        @NotNull
        public Builder mapping(@NotNull LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> map2) {
            if (map2 == null) {
                Builder.$$$reportNull$$$0(21);
            }
            this.myConsumerToProducer = map2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(22);
            }
            return builder;
        }

        @NotNull
        public Builder consumers(@NotNull List<AutoValueDescriptor> descriptors) {
            if (descriptors == null) {
                Builder.$$$reportNull$$$0(23);
            }
            this.myConsumers = descriptors;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(24);
            }
            return builder;
        }

        @NotNull
        public ImportInfo build() {
            ImportInfo importInfo = new ImportInfo(this.myFormat, this.myTable, this.myConsumers, this.myProducers, this.myConsumerToProducer, this.myProducerName, this.myImportType, this.myContext, this.myInputType, this.myErrorTaskInfo, this.myLockTable, this.myInsertAsNull);
            if (importInfo == null) {
                Builder.$$$reportNull$$$0(25);
            }
            return importInfo;
        }

        public DatabaseEditorContext getContext() {
            return this.myContext;
        }

        public ImportAction.InputType getInputType() {
            return this.myInputType;
        }

        public ImportType getImportType() {
            return this.myImportType;
        }

        public CsvFormat getFormat() {
            return this.myFormat;
        }

        public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
            return this.myConsumerToProducer;
        }

        public List<AutoValueDescriptor> getConsumers() {
            return this.myConsumers;
        }

        public List<? extends ColumnDescriptor> getProducers() {
            return this.myProducers;
        }

        public List<? extends ColumnDescriptor> getVisibleProducers() {
            return this.myVisibleProducers;
        }

        public DeTable getTable() {
            return this.myTable;
        }

        public String getProducerName() {
            return this.myProducerName;
        }

        public List<DataConsumer.Row> getRows() {
            return this.myRows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producerName";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producers";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleProducers";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "csvFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producerName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "importType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inputType";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "errorTaskInfo";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lockTable";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "producers";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visibleProducers";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "editorContext";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertAsNull";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapping";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "consumers";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rows";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "consumer";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "producerName";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "importType";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "inputType";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "errorTaskInfo";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "producers";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visibleProducers";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "editorContext";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "mapping";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "consumers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 17: 
                case 19: 
                case 20: 
                case 22: 
                case 24: 
                case 25: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ConversionException
    extends Exception {
        private static final String ERROR_MASK = "conversion failed: \"%s\" to %s";
        private final int myIndex;

        private ConversionException(@NotNull Object value, @NotNull String typeName, int index) {
            if (value == null) {
                ConversionException.$$$reportNull$$$0(0);
            }
            if (typeName == null) {
                ConversionException.$$$reportNull$$$0(1);
            }
            super(String.format(ERROR_MASK, value, StringUtil.toLowerCase((String)typeName)));
            this.myIndex = index;
        }

        public int getIndex() {
            return this.myIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportInfo$ConversionException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class Cache {
        private final Map<ColumnDescriptor, Integer> myCachedMapping = ContainerUtil.newHashMap();
        private final Map<ColumnDescriptor, Function<Object, Object>> myConverters = ContainerUtil.newHashMap();
        private final ObjectToTextConverter myToTextConverter;

        Cache() {
            this.myToTextConverter = new ObjectToTextConverter(ImportInfo.this.myInputType.getDialect());
        }

        @NotNull
        public Object[] convertLine(@NotNull Object[] objects) throws ConversionException {
            if (objects == null) {
                Cache.$$$reportNull$$$0(0);
            }
            Collection consumers = ImportInfo.this.mappedConsumers();
            Object[] convertedLine = new Object[objects.length];
            for (AutoValueDescriptor consumer : consumers) {
                Object converted;
                int index = this.getProducerIndex(consumer);
                Object o = index == -1 ? null : ObjectFormatter.unwrap(objects[index]);
                ColumnDescriptor producer = (ColumnDescriptor)ImportInfo.this.myProducers.get(index);
                Function<Object, Object> converter = this.getConverter(o, consumer, producer);
                Object object = converted = converter == null ? null : converter.fun(o);
                if (!ImportInfo.this.myInsertAsNull && o != null && converted == null) {
                    Object text2 = this.myToTextConverter.convert(o, producer);
                    throw new ConversionException(text2 == null ? o : text2, consumer.getTypeName(), index);
                }
                convertedLine[index] = DbImplUtil.prepareValue(ImportInfo.this.myContext.getDialect().getFamilyId(), converted);
            }
            if (convertedLine == null) {
                Cache.$$$reportNull$$$0(1);
            }
            return convertedLine;
        }

        @Nullable
        private Function<Object, Object> getConverter(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                Cache.$$$reportNull$$$0(2);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(3);
            }
            if (this.myConverters.containsKey(consumer)) {
                return this.myConverters.get(consumer);
            }
            Function<Object, Object> converter = this.getNoCached(o, consumer, producer);
            this.myConverters.put(consumer, converter);
            return converter;
        }

        @NotNull
        public List<ColumnInfo> getColumnInfos() {
            Collection descriptors = ImportInfo.this.mappedConsumers();
            ArrayList infos = ContainerUtil.newArrayList();
            for (AutoValueDescriptor descriptor : descriptors) {
                int index = this.getProducerIndex(descriptor);
                infos.add(new ColumnInfo(descriptor.getJavaClassName(), descriptor.getTypeName(), descriptor.getType(), index));
            }
            ArrayList arrayList = infos;
            if (arrayList == null) {
                Cache.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Nullable
        private Function<Object, Object> getNoCached(@Nullable Object o, @NotNull ColumnDescriptor consumer, @NotNull ColumnDescriptor producer) {
            if (consumer == null) {
                Cache.$$$reportNull$$$0(5);
            }
            if (producer == null) {
                Cache.$$$reportNull$$$0(6);
            }
            DbDataSource source = ImportInfo.this.myContext.getDataSource();
            return DataTypeConversion.getConverter(ImportInfo.this.myInputType.getDialect(), ImportInfo.this.myContext.getDialect(), ImportInfo.this.myInputType.getProducerSystem(), (DatabaseSystem)source, producer, consumer, o);
        }

        private int getProducerIndex(@NotNull AutoValueDescriptor consumer) {
            if (consumer == null) {
                Cache.$$$reportNull$$$0(7);
            }
            if (this.myCachedMapping.containsKey(consumer)) {
                return this.myCachedMapping.get(consumer);
            }
            ColumnDescriptor producer = (ColumnDescriptor)ImportInfo.this.myConsumerToProducer.get(consumer);
            int result2 = producer == null ? -1 : ContainerUtil.indexOf((List)ImportInfo.this.myProducers, current -> StringUtil.equals((CharSequence)producer.getName(), (CharSequence)current.getName()));
            this.myCachedMapping.put(consumer, result2);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objects";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportInfo$Cache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertLine";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnInfos";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertLine";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getConverter";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getNoCached";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getProducerIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

