/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.Db2Dialect;
import com.intellij.database.dialects.DerbyDialect;
import com.intellij.database.dialects.ExasolDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.H2Dialect;
import com.intellij.database.dialects.HsqldbDialect;
import com.intellij.database.dialects.MssqlDialect;
import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.dialects.OracleDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.dialects.RedshiftDialect;
import com.intellij.database.dialects.SqliteDialect;
import com.intellij.database.dialects.SybaseDialect;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialects {
    @NotNull
    private static final List<DatabaseDialectEx> ourDialects = ContainerUtil.newArrayList();

    @NotNull
    public static Collection<DatabaseDialectEx> getSupportedDialects() {
        List<DatabaseDialectEx> list = ourDialects;
        if (list == null) {
            DatabaseDialects.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static DatabaseDialectEx findByFamily(@Nullable DatabaseFamilyId familyId) {
        if (familyId == null) {
            return null;
        }
        for (DatabaseDialectEx dialect : ourDialects) {
            if (dialect.getFamilyId() != familyId) continue;
            return dialect;
        }
        return null;
    }

    static {
        ourDialects.add(PostgresDialect.INSTANCE);
        ourDialects.add(RedshiftDialect.INSTANCE);
        ourDialects.add(MysqlDialect.INSTANCE);
        ourDialects.add(HsqldbDialect.INSTANCE);
        ourDialects.add(H2Dialect.INSTANCE);
        ourDialects.add(OracleDialect.INSTANCE);
        ourDialects.add(DerbyDialect.INSTANCE);
        ourDialects.add(SybaseDialect.INSTANCE);
        ourDialects.add(MssqlDialect.INSTANCE);
        ourDialects.add(Db2Dialect.INSTANCE);
        ourDialects.add(SqliteDialect.INSTANCE);
        ourDialects.add(ExasolDialect.INSTANCE);
        ourDialects.add(GenericDialect.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DatabaseDialects", "getSupportedDialects"));
    }
}

