/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FormatBasedExtractor
extends TranspositionAwareDefaultExtractor<DatabaseSettings.StdState> {
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("[A-Z]{2,}");
    private final CsvFormat myFormat;

    public FormatBasedExtractor(@NotNull CsvFormat format, @NotNull ObjectFormatter formatter) {
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            FormatBasedExtractor.$$$reportNull$$$0(1);
        }
        super(new DatabaseSettings.StdState(), formatter);
        this.myFormat = format;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        Matcher m = FILE_EXTENSION_PATTERN.matcher(this.myFormat.name);
        String ext = m.find() ? m.group() : null;
        String string = StringUtil.isNotEmpty((String)ext) ? ext.toLowerCase(Locale.ENGLISH) : super.getFileExtension();
        if (string == null) {
            FormatBasedExtractor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, final DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns){
            private final CsvFormatter myFormatter;
            {
                super(FormatBasedExtractor.this, output, dialect2, forceSkipHeader, transpose, allColumns, selectedColumnIndices);
                this.myFormatter = new CsvFormatter(FormatBasedExtractor.this.myFormat);
            }

            @Override
            protected void doAppendData(List<DataConsumer.Row> rows) {
                ArrayList columns2 = ContainerUtil.newArrayList();
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    ContainerUtil.addIfNotNull((Collection)columns2, (Object)columnsMap.get(selectedColumn));
                }
                Object object = rows.iterator();
                while (object.hasNext()) {
                    DataConsumer.Row row = (DataConsumer.Row)object.next();
                    List values2 = ContainerUtil.map((Collection)columns2, column2 -> FormatBasedExtractor.this.getValueAsString(row, (DataConsumer.Column)column2, dialect, false));
                    if (this.myFormatter.requiresRowNumbers()) {
                        values2 = ContainerUtil.prepend((List)values2, (Object[])new Object[]{this.getRowNumber(row)});
                    }
                    this.myOutput.append(this.myFormatter.formatRecord(values2));
                    this.myOutput.append(this.myFormatter.recordSeparator());
                }
            }

            @Override
            protected void doAppendHeader(boolean appendNewLine) {
                if (((FormatBasedExtractor)FormatBasedExtractor.this).myFormat.headerRecord == null) {
                    return;
                }
                ArrayList columnNames = ContainerUtil.newArrayList();
                if (this.myFormatter.requiresRowNumbers()) {
                    columnNames.add(this.getRowNumbersColumn().name);
                }
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    columnNames.add(column2.name);
                }
                this.myOutput.append(this.myFormatter.formatHeader(columnNames));
                this.myOutput.append(this.myFormatter.recordSeparator());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

