/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.tz;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.openapi.util.Comparing;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class TimeZonedTimestamp
extends TimeZonedValue<OffsetDateTime> {
    public TimeZonedTimestamp(@NotNull OffsetDateTime timestamp) {
        if (timestamp == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(0);
        }
        super(timestamp);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeZonedTimestamp)) {
            return false;
        }
        TimeZonedTimestamp tstz = (TimeZonedTimestamp)obj;
        return Comparing.equal(tstz.getValue(), this.getValue());
    }

    @Override
    @NotNull
    public JdbcInjection injection(@NotNull DatabaseFamilyId family) {
        if (family == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(1);
        }
        MyConverter converter = family.isPostgres() ? PgConverter.INSTANCE : OraConverter.INSTANCE;
        String timestamp = converter.getFormatter().format(this);
        JdbcInjection jdbcInjection = converter.injection(timestamp);
        if (jdbcInjection == null) {
            TimeZonedTimestamp.$$$reportNull$$$0(2);
        }
        return jdbcInjection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "injection";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OraConverter
    implements MyConverter {
        private static final OraConverter INSTANCE = new OraConverter();

        private OraConverter() {
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String timestamp) {
            if (timestamp == null) {
                OraConverter.$$$reportNull$$$0(0);
            }
            JdbcInjection.OraTimestampInjection oraTimestampInjection = new JdbcInjection.OraTimestampInjection(timestamp);
            if (oraTimestampInjection == null) {
                OraConverter.$$$reportNull$$$0(1);
            }
            return oraTimestampInjection;
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            Formatter formatter = MyFormatter.INSTANCE;
            if (formatter == null) {
                OraConverter.$$$reportNull$$$0(2);
            }
            return formatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$OraConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$OraConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "injection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyFormatter
        implements Formatter {
            private static final Formatter INSTANCE = new MyFormatter();
            private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 4, SignStyle.NEVER).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NEVER).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NEVER).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2, 2, SignStyle.NEVER).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2, 2, SignStyle.NEVER).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2, 2, SignStyle.NEVER).appendLiteral(".").appendValue(ChronoField.NANO_OF_SECOND, 1, 9, SignStyle.NEVER).appendLiteral(" ").appendPattern("xxx").toFormatter(Locale.US);

            private MyFormatter() {
            }

            @Override
            public Object parse(String value) throws ParseException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object parse(String value, ParsePosition position) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String format(Object value) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)((TimeZonedTimestamp)value).getValue();
                String stringValue = FORMATTER.format(offsetDateTime);
                int era = offsetDateTime.get(ChronoField.ERA);
                return (era == 0 ? "-" : "") + stringValue;
            }
        }
    }

    private static class PgConverter
    implements MyConverter {
        private static final PgConverter INSTANCE = new PgConverter();
        private static final Formatter FORMATTER = FormatterCreator.newZonedTimestampFormat(new ZonedTimestampDelegate(), BoundaryValueResolver.TIMESTAMP_TZ, 9);

        private PgConverter() {
        }

        @Override
        @NotNull
        public JdbcInjection injection(@NotNull String timestamp) {
            if (timestamp == null) {
                PgConverter.$$$reportNull$$$0(0);
            }
            JdbcInjection.PgTimestampInjection pgTimestampInjection = new JdbcInjection.PgTimestampInjection(timestamp);
            if (pgTimestampInjection == null) {
                PgConverter.$$$reportNull$$$0(1);
            }
            return pgTimestampInjection;
        }

        @Override
        @NotNull
        public Formatter getFormatter() {
            Formatter formatter = FORMATTER;
            if (formatter == null) {
                PgConverter.$$$reportNull$$$0(2);
            }
            return formatter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$PgConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTimestamp$PgConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "injection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "injection";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface MyConverter {
        @NotNull
        public JdbcInjection injection(@NotNull String var1);

        @NotNull
        public Formatter getFormatter();
    }
}

