/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.MysqlIntroQueries;
import com.intellij.database.introspection.MysqlIntrospector;
import com.intellij.database.introspection.MysqlIntrospector$MysqlSchemaRetriever$process$;
import com.intellij.database.introspection.MysqlIntrospectorKt;
import com.intellij.database.introspection.PostgresIntrospectorBaseKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.mysql.MysqlEvent;
import com.intellij.database.model.mysql.MysqlModArgument;
import com.intellij.database.model.mysql.MysqlModCollation;
import com.intellij.database.model.mysql.MysqlModEvent;
import com.intellij.database.model.mysql.MysqlModForeignKey;
import com.intellij.database.model.mysql.MysqlModIndex;
import com.intellij.database.model.mysql.MysqlModKey;
import com.intellij.database.model.mysql.MysqlModLikeColumn;
import com.intellij.database.model.mysql.MysqlModLikeTable;
import com.intellij.database.model.mysql.MysqlModModel;
import com.intellij.database.model.mysql.MysqlModRoot;
import com.intellij.database.model.mysql.MysqlModRoutine;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModTable;
import com.intellij.database.model.mysql.MysqlModTableColumn;
import com.intellij.database.model.mysql.MysqlModTrigger;
import com.intellij.database.model.mysql.MysqlModView;
import com.intellij.database.model.mysql.MysqlRoot;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlSchema;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.model.properties.MysqlEventStatus;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.mysql.MysqlNamingService;
import com.intellij.database.util.Casing;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0003:;<B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002JF\u0010 \u001a00!R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003H\u0014JF\u0010&\u001a00'R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0005H\u0014J\b\u0010)\u001a\u00020\u001cH\u0014J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$H\u0014J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u001e\u0010-\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0014J\b\u0010/\u001a\u00020\u001cH\u0016J\u0018\u00100\u001a\u00020\f2\u0006\u0010+\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0005H\u0014J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002J\b\u00104\u001a\u00020\u001cH\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$H\u0002J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020$H\u0002J\u001f\u00107\u001a\u00020\u001c2\u0014\b\u0004\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c09H\u0082\bR\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/mysql/MysqlModModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlModRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "Lcom/intellij/database/model/mysql/MysqlModSchema;", "()V", "builder", "Lcom/intellij/sql/database/SqlObjectBuilder;", "kotlin.jvm.PlatformType", "circumventDbe5060", "", "circumventNoGenExpr", "defProperlyQuoted", "genFromSrc", "packLimit", "", "getPackLimit", "()I", "setPackLimit", "(I)V", "sqlLanguage", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "sqlReader", "Lcom/intellij/sql/script/SqlReader;", "unescapeGenExpr", "applySchemas", "", "newSchemas", "", "Lcom/intellij/database/introspection/MysqlIntroQueries$Schema;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "schema", "initConnectionRelatedState", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "introspectServerObjects", "isPossibleToIntrospectSchemaIncrementally", "quote", "", "def", "retrieveAndApplySchemas", "retrieveCasing", "retrieveCollations", "workWithModel", "modifier", "Lkotlin/Function1;", "MysqlDatabaseRetriever", "MysqlSchemaRetriever", "VERSION", "intellij.database.introspection"})
public final class MysqlIntrospector
extends BaseSingleDatabaseIntrospector<MysqlModModel, MysqlRoot, MysqlModRoot, MysqlSchema, MysqlModSchema> {
    private final SqlReader sqlReader;
    private final SqlLanguageDialect sqlLanguage;
    private final SqlObjectBuilder builder;
    private int packLimit;
    private final boolean circumventDbe5060;
    private final boolean circumventNoGenExpr;
    private boolean genFromSrc;
    private boolean defProperlyQuoted;
    private boolean unescapeGenExpr;

    public final int getPackLimit() {
        return this.packLimit;
    }

    public final void setPackLimit(int n) {
        this.packLimit = n;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull MysqlSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return false;
    }

    private final void workWithModel(Function1<? super MysqlModRoot, Unit> modifier) {
        ((MysqlModModel)this.getModel()).modify(MysqlModRoot.class, new ModelModifier<MysqlModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(MysqlModRoot it) {
                MysqlModRoot mysqlModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModRoot, (String)"it");
                this.$modifier.invoke((Object)mysqlModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        DBFacade dBFacade = this.getDbFacade();
        boolean isMaria = Intrinsics.areEqual((Object)(dBFacade != null && (dBFacade = dBFacade.getConnectionInfo()) != null ? dBFacade.rdbmsName : null), (Object)"MariaDB");
        boolean hasGenColumn = isMaria ? this.getServerVersion().isOrGreater(new int[]{10, 2, 5}) : this.getServerVersion().isOrGreater(new int[]{5, 7});
        Map map2 = this.queryParameters;
        String string = "GENEXPR";
        Boolean bl = hasGenColumn;
        map2.put(string, bl);
        this.genFromSrc = !hasGenColumn && isMaria && this.circumventNoGenExpr && this.getServerVersion().isOrGreater(new int[]{5, 2});
        this.defProperlyQuoted = isMaria && this.getServerVersion().isOrGreater(new int[]{10, 2, 7});
        this.unescapeGenExpr = !isMaria && this.getServerVersion().isOrGreater(new int[]{8});
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemaNames;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = schemaNames = (List)tran.query(MysqlIntroQueries.QUERIES.querySchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemaNames");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        MysqlIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction((InTransaction)new InTransaction<List<? extends MysqlIntroQueries.Schema>>(){

            public final List<? extends MysqlIntroQueries.Schema> run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction tran2 = tran;
                Object object = tran2.query(MysqlIntroQueries.QUERIES.querySchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(QUERIES.querySchemas).run()");
                return (List)object;
            }
        });
        List schemaNames = (List)result$iv;
        this.applySchemas(schemaNames);
    }

    @Override
    public void introspectServerObjects() {
        MysqlIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        dbf$iv.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ MysqlIntrospector this$0;
            {
                this.this$0 = mysqlIntrospector;
            }

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction it = tran;
                MysqlIntrospector.access$retrieveCasing(this.this$0, it);
                MysqlIntrospector.access$retrieveCollations(this.this$0, it);
            }
        });
    }

    private final void applySchemas(List<MysqlIntroQueries.Schema> newSchemas) {
        MysqlIntrospector this_$iv = this;
        ((MysqlModModel)this_$iv.getModel()).modify(MysqlModRoot.class, new ModelModifier<MysqlModRoot>(this, newSchemas){
            final /* synthetic */ MysqlIntrospector this$0;
            final /* synthetic */ List $newSchemas$inlined;
            {
                this.this$0 = mysqlIntrospector;
                this.$newSchemas$inlined = list;
            }

            public final void perform(MysqlModRoot it) {
                MysqlModRoot mysqlModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModRoot, (String)"it");
                MysqlModRoot root2 = mysqlModRoot;
                NamingFamily schemas = root2.getSchemas();
                Function1 it2 = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
                it2.invoke((Object)schemas);
                boolean empty = schemas.isEmpty();
                boolean first = true;
                for (MysqlIntroQueries.Schema s : this.$newSchemas$inlined) {
                    MysqlModSchema schema = (MysqlModSchema)schemas.createOrGet(s.schema_name);
                    String string = s.default_collation_name;
                    schema.setCollation(string != null ? this.this$0.dbIntern(string) : null);
                    if (!first) continue;
                    schema.setCurrent(true);
                    if (empty) {
                        schema.setVisible(true);
                    }
                    first = false;
                }
                it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
                it.invoke((Object)schemas);
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends MysqlSchema> schemas) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        for (MysqlSchema mysqlSchema : schemas) {
            this.introspectOneSchema(tran, mysqlSchema);
        }
    }

    private final void retrieveCasing(DBTransaction tran) {
        Integer casing = (Integer)tran.query(MysqlIntroQueries.QUERIES.queryCasing).run();
        ((MysqlModModel)this.getModel()).modify((ModelModifier<? super MysqlModRoot>)new ModelModifier<MysqlModRoot>(casing){
            final /* synthetic */ Integer $casing;

            public final void perform(MysqlModRoot r) {
                Casing casing;
                Integer n;
                Integer n2 = n = this.$casing;
                if (n2 != null && n2 == 0) {
                    casing = BasicNamespace.EXACT_CASING;
                } else {
                    Integer n3 = n;
                    casing = n3 != null && n3 == 1 ? BasicNamespace.LOWER_CASING : BasicNamespace.MIXED_CASING;
                }
                r.setDefaultCasing(casing);
            }
            {
                this.$casing = n;
            }
        });
    }

    private final void retrieveCollations(DBTransaction tran) {
        List collations = (List)tran.query(MysqlIntroQueries.QUERIES.queryCollations).run();
        ((MysqlModModel)this.getModel()).modify((ModelModifier<? super MysqlModRoot>)new ModelModifier<MysqlModRoot>(this, collations){
            final /* synthetic */ MysqlIntrospector this$0;
            final /* synthetic */ List $collations;

            public final void perform(MysqlModRoot r) {
                Object it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
                it.invoke((Object)r.getCollations());
                for (MysqlIntroQueries.Collation c : this.$collations) {
                    MysqlModCollation collation = (MysqlModCollation)r.getCollations().createOrGet(c.collation_name);
                    String string = c.character_set_name;
                    collation.setCharset(string != null ? this.this$0.dbIntern(string) : null);
                    collation.setDefaultForCharset(c.is_default);
                }
                it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
                it.invoke((Object)r.getCollations());
            }
            {
                this.this$0 = mysqlIntrospector;
                this.$collations = list;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, MysqlSchema schema) {
        void this_$iv;
        MysqlIntrospector mysqlIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        try {
            BaseIntrospector.AbstractSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MysqlRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MysqlDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull MysqlSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new MysqlSchemaRetriever(transaction, schema);
    }

    private final String quote(String def2) {
        String simpleEscaped = StringsKt.replace$default((String)def2, (String)"'", (String)"''", (boolean)false, (int)4, null);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("" + '\'' + StringUtil.escapeStringCharacters((int)simpleEscaped.length(), (String)simpleEscaped, null, (boolean)true, (boolean)false, (StringBuilder)new StringBuilder()) + '\''), (String)"\u001a", (String)"\\Z", (boolean)false, (int)4, null), (String)"\u0000", (String)"\\0", (boolean)false, (int)4, null);
    }

    public MysqlIntrospector() {
        Rdbms rdbms = Mysql.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Mysql.RDBMS");
        super(rdbms, MysqlModModel.class, MysqlModRoot.class, MysqlModSchema.class);
        this.sqlReader = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).createSqlReader();
        Language language = Language.findLanguageByID((String)"MySQL");
        if (language == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialect");
        }
        this.sqlLanguage = (SqlLanguageDialect)language;
        this.builder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)this.sqlLanguage);
        this.packLimit = 1000;
        this.circumventDbe5060 = Registry.is((String)"database.introspection.mysql.dbe5060", (boolean)true);
        this.circumventNoGenExpr = Registry.is((String)"database.introspection.mariadb.noGenExpr", (boolean)true);
    }

    public static final /* synthetic */ void access$setGenFromSrc$p(MysqlIntrospector $this, boolean bl) {
        $this.genFromSrc = bl;
    }

    public static final /* synthetic */ void access$setUnescapeGenExpr$p(MysqlIntrospector $this, boolean bl) {
        $this.unescapeGenExpr = bl;
    }

    public static final /* synthetic */ void access$setDefProperlyQuoted$p(MysqlIntrospector $this, boolean bl) {
        $this.defProperlyQuoted = bl;
    }

    public static final /* synthetic */ void access$retrieveCasing(MysqlIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrieveCasing(tran);
    }

    public static final /* synthetic */ void access$retrieveCollations(MysqlIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrieveCollations(tran);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002$0\u0001R \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J8\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001aH\u0014R%\u0010\u000b\u001a\u0016\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector$MysqlDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/mysql/MysqlModModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlModRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "Lcom/intellij/database/model/mysql/MysqlModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/MysqlIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "nativeDefinitionColumnNumber", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "", "getNativeDefinitionColumnNumber", "()Ljava/util/Map;", "process", "", "retrieveNativeDefinitionsFor", "kind", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.introspection"})
    private final class MysqlDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever {
        @NotNull
        private final Map<ObjectKind, Integer> nativeDefinitionColumnNumber;

        @Override
        public void process() {
        }

        @NotNull
        public final Map<ObjectKind, Integer> getNativeDefinitionColumnNumber() {
            return this.nativeDefinitionColumnNumber;
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Integer n = this.nativeDefinitionColumnNumber.get(kind);
            if (n == null) {
                return;
            }
            int k = n;
            for (BasicElement basicElement : elements) {
                Object object;
                String string;
                Object object2;
                block15: {
                    block14: {
                        Object object3;
                        object2 = basicElement.getSchema();
                        if (object2 == null || (object2 = object2.getRealName()) == null) break block14;
                        Object it = object3 = object2;
                        object2 = '`' + (String)it + "`.";
                        if (object2 != null) break block15;
                    }
                    object2 = "";
                }
                Object q = object2;
                String n2 = "`" + basicElement.getName() + "`";
                BasicElement $i$a$1$let = basicElement;
                if ($i$a$1$let instanceof MysqlTable) {
                    string = "show create table " + (String)q + "" + n2;
                } else if ($i$a$1$let instanceof MysqlView) {
                    string = "show create view " + (String)q + "" + n2;
                } else if ($i$a$1$let instanceof MysqlTrigger) {
                    string = "show create trigger " + (String)q + "" + n2;
                } else if ($i$a$1$let instanceof MysqlEvent) {
                    string = "show create event " + (String)q + "" + n2;
                } else {
                    String string2;
                    if (!($i$a$1$let instanceof MysqlRoutine)) continue;
                    object = ((MysqlRoutine)basicElement).getRoutineKind().name();
                    StringBuilder stringBuilder = new StringBuilder().append("show create ");
                    String string3 = object;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    string = stringBuilder.append(string2).append(' ').append((String)q).append("").append(n2).toString();
                }
                String query = string;
                Object object3 = this.getTransaction().query(query, Layouts.rowOf((RowLayout)Layouts.arrayOf((int)k, String.class))).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"transaction.query(query,\u2026ring::class.java))).run()");
                String[] respond = (String[])object3;
                if (PostgresIntrospectorBaseKt.getLength(respond) < k) continue;
                object = result2;
                String[] stringArray = new String[]{respond[k - 1]};
                object.put(basicElement, stringArray);
            }
        }

        public MysqlDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
            this.nativeDefinitionColumnNumber = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ObjectKind.USER, (Object)1), TuplesKt.to((Object)ObjectKind.SCHEMA, (Object)2), TuplesKt.to((Object)ObjectKind.TABLE, (Object)2), TuplesKt.to((Object)ObjectKind.VIEW, (Object)2), TuplesKt.to((Object)ObjectKind.TRIGGER, (Object)3), TuplesKt.to((Object)ObjectKind.ROUTINE, (Object)3), TuplesKt.to((Object)ObjectKind.SCHEDULED_EVENT, (Object)4)});
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J$\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020605H\u0002J\u0010\u00107\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u00108\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010:\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010;\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010<\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010?\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010@\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010B\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010C\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010D\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020GH\u0002J\u001f\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110I2\b\u0010J\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010KJ\u0010\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u0011H\u0002J\f\u0010N\u001a\u00020\u0011*\u00020\u0011H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector$MysqlSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/mysql/MysqlModModel;", "Lcom/intellij/database/model/mysql/MysqlRoot;", "Lcom/intellij/database/model/mysql/MysqlModRoot;", "Lcom/intellij/database/model/mysql/MysqlSchema;", "Lcom/intellij/database/model/mysql/MysqlModSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/MysqlIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mysql/MysqlSchema;)V", "BUG", "Lkotlin/text/Regex;", "asCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "s", "", "getBody", "src", "getColumnKind", "Lcom/intellij/database/model/properties/MysqlColumnKind;", "extra", "getCreate", "Lcom/intellij/sql/psi/SqlCreateStatement;", "getDefaultExpression", "column", "Lcom/intellij/database/model/mysql/MysqlModLikeColumn;", "c", "Lcom/intellij/database/introspection/MysqlIntroQueries$Column;", "getEventStatus", "Lcom/intellij/database/model/properties/MysqlEventStatus;", "status", "getOnUpdate", "getSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "process", "", "progress", "what", "retrieveBuggedEventSources", "event", "Lcom/intellij/database/model/mysql/MysqlModEvent;", "retrieveBuggedRoutineSources", "routine", "Lcom/intellij/database/model/mysql/MysqlModRoutine;", "retrieveBuggedTriggerSources", "trigger", "Lcom/intellij/database/model/mysql/MysqlModTrigger;", "retrieveColumnGenExprFromTableSrc", "table", "Lcom/intellij/database/model/mysql/MysqlModTable;", "cols", "", "Lcom/intellij/database/model/mysql/MysqlModTableColumn;", "retrieveColumns", "retrieveEventSources", "retrieveEvents", "retrieveIndices", "retrieveRoutineParameters", "retrieveRoutineParametersFromInformationSchema", "retrieveRoutineParametersFromMetaData", "retrieveRoutineSources", "retrieveRoutines", "retrieveTableConstraints", "retrieveTables", "retrieveTriggerSources", "retrieveTriggers", "retrieveViewSources", "setFqn", "o", "Lcom/intellij/database/model/basic/BasicNamedElement;", "splitColNames", "", "cn", "(Ljava/lang/String;)[Ljava/lang/String;", "unescape", "str", "replaceBin", "intellij.database.introspection"})
    private final class MysqlSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        private final Regex BUG;

        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((MysqlSchema)this.getSchema()).getName(), mode};
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            mysqlIntrospector.updateStatus(string3, what);
        }

        @Override
        public void process() {
            this.prepareParameters();
            MysqlSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                {
                    this.this$0 = mysqlSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    MysqlSchemaRetriever.access$retrieveTables(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                {
                    this.this$0 = mysqlSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    MysqlSchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                }
            });
            if (StringsKt.equals((String)((MysqlSchema)this.getSchema()).getName(), (String)"information_schema", (boolean)true)) {
                return;
            }
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                {
                    this.this$0 = mysqlSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    MysqlSchemaRetriever.access$retrieveIndices(this.this$0, schema2);
                    MysqlSchemaRetriever.access$retrieveTableConstraints(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                {
                    this.this$0 = mysqlSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    MysqlSchemaRetriever.access$retrieveTriggers(this.this$0, schema2);
                    MysqlSchemaRetriever.access$retrieveEvents(this.this$0, schema2);
                    MysqlSchemaRetriever.access$retrieveRoutines(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MysqlSchemaRetriever this$0;
                {
                    this.this$0 = mysqlSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MysqlModSchema schema2 = (MysqlModSchema)MS;
                    MysqlSchemaRetriever.access$retrieveRoutineParameters(this.this$0, schema2);
                }
            });
            if (MysqlIntrospector.this.genFromSrc) {
                this_$iv = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                    }

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MysqlModSchema schema2 = (MysqlModSchema)MS;
                        MysqlSchemaRetriever.access$retrieveColumnGenExprFromTableSrc(this.this$0, schema2);
                    }
                });
            }
            if (this.getWithSources$intellij_database_introspection()) {
                this_$iv = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                    final /* synthetic */ MysqlSchemaRetriever this$0;
                    {
                        this.this$0 = mysqlSchemaRetriever;
                    }

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MysqlModSchema schema2 = (MysqlModSchema)MS;
                        MysqlIntrospector this_$iv = this.this$0.MysqlIntrospector.this;
                        this_$iv.getModel().writeSources(new Runnable(schema2, this){
                            final /* synthetic */ MysqlModSchema $schema$inlined;
                            final /* synthetic */ MysqlSchemaRetriever$process$$inlined$inSchema$7 this$0;
                            {
                                this.$schema$inlined = mysqlModSchema;
                                this.this$0 = var2_2;
                            }

                            public final void run() {
                                MysqlSchemaRetriever.access$retrieveViewSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveRoutineSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveTriggerSources(this.this$0.this$0, this.$schema$inlined);
                                MysqlSchemaRetriever.access$retrieveEventSources(this.this$0.this$0, this.$schema$inlined);
                            }
                        });
                    }
                });
            }
        }

        private final void retrieveTables(MysqlModSchema schema) {
            this.progress("tables and views");
            Function1 it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            it.invoke((Object)schema.getTables());
            it.invoke((Object)schema.getViews());
            List ts2 = (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTablesAndViews).withParams(new Object[]{((MysqlSchema)this.getSchema()).getName()}).run();
            for (MysqlIntroQueries.Table t : ts2) {
                NamingFamily namingFamily;
                String type = t.table_type;
                boolean isView = StringUtil.contains((CharSequence)type, (CharSequence)"VIEW");
                if (isView) {
                    NamingFamily namingFamily2 = schema.getViews();
                    namingFamily = namingFamily2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"schema.views");
                } else {
                    NamingFamily namingFamily3 = schema.getTables();
                    namingFamily = namingFamily3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"schema.tables");
                }
                MysqlModLikeTable o = (MysqlModLikeTable)namingFamily.createOrGet(t.table_name);
                o.setSystem(StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM"));
                o.setComment(StringKt.nullize$default((String)t.table_comment, (boolean)false, (int)1, null));
                if (!(o instanceof MysqlModTable)) continue;
                String string = t.engine;
                ((MysqlModTable)o).setEngine(string != null ? MysqlIntrospector.this.dbIntern(string) : null);
                String collation = t.table_collation;
                if (Intrinsics.areEqual((Object)collation, (Object)schema.getCollation())) {
                    collation = null;
                }
                String string2 = collation;
                ((MysqlModTable)o).setCollation(string2 != null ? MysqlIntrospector.this.dbIntern(string2) : null);
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            it.invoke((Object)schema.getTables());
            it.invoke((Object)schema.getViews());
        }

        private final void retrieveIndices(MysqlModSchema schema) {
            this.progress("indices");
            Iterable $receiver$iv = schema.getTables();
            for (Object element$iv : $receiver$iv) {
                MysqlModTable it = (MysqlModTable)element$iv;
                it.getIndices().markChildrenAsSyncPending();
            }
            String schemaName = schema.getName();
            for (MysqlIntroQueries.Index i2 : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryIndices).withParams(new Object[]{schemaName, schemaName}).run()) {
                MysqlModTable table;
                if ((MysqlModTable)schema.getTables().get(i2.table_name) == null) {
                    continue;
                }
                MysqlModIndex index = (MysqlModIndex)table.getIndices().createOrGet(i2.index_name);
                index.setUnique(!i2.non_unique);
                String[] stringArray = this.splitColNames(i2.column_names);
                index.setColNames(Arrays.copyOf(stringArray, stringArray.length));
            }
        }

        /*
         * Unable to fully structure code
         */
        private final CascadeRule asCascadeRule(String s) {
            block7: {
                block6: {
                    v0 = var3_2 = s;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    v1 = v0.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
                    var2_3 = v1;
                    switch (var2_3.hashCode()) {
                        case 1357211269: {
                            if (!var2_3.equals("set null")) ** break;
                            break block6;
                        }
                        case -890131325: {
                            if (!var2_3.equals("set default")) ** break;
                            break;
                        }
                        case 554829492: {
                            if (!var2_3.equals("cascade")) ** break;
                            v2 = CascadeRule.cascade;
                            break block7;
                        }
                    }
                    v2 = CascadeRule.set_default;
                    break block7;
                }
                v2 = CascadeRule.set_null;
                break block7;
                v2 = CascadeRule.no_action;
            }
            return v2;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final void retrieveTableConstraints(MysqlModSchema schema) {
            this.progress("table constraints");
            it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            $receiver$iv = schema.getTables();
            var4_4 = $receiver$iv.iterator();
            while (var4_4.hasNext()) {
                element$iv /* !! */  = var4_4.next();
                t = (MysqlModTable)element$iv /* !! */ ;
                it.invoke((Object)t.getKeys());
                it.invoke((Object)t.getForeignKeys());
            }
            schemaName = schema.getName();
            for (Object c : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryConstraints).withParams(new Object[]{schemaName, schemaName, schemaName}).run()) {
                block14: {
                    block15: {
                        if ((MysqlModTable)schema.getTables().get(c.table_name) == null) {
                            continue;
                        }
                        columnNames = MysqlSchemaRetriever.access$splitColNames(this, c.column_names);
                        v0 = StringKt.nullize((String)c.constraint_name, (boolean)false);
                        if (v0 == null || (v0 = MysqlIntrospector.this.dbIntern(v0)) == null) {
                            continue;
                        }
                        name = v0;
                        v1 = $i$f$forEach = c.constraint_type;
                        if (v1 == null) continue;
                        switch (v1.hashCode()) {
                            case 1284802305: {
                                if (!$i$f$forEach.equals("PRIMARY KEY")) ** break;
                                break;
                            }
                            case -1787199535: {
                                if (!$i$f$forEach.equals("UNIQUE")) ** break;
                                break block14;
                            }
                            case 704200915: {
                                if (!$i$f$forEach.equals("FOREIGN KEY")) ** break;
                                break block15;
                            }
                        }
                        pk = (MysqlModKey)table.getKeys().createOrGet(name);
                        pk.setPrimary(true);
                        pk.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(columnNames, columnNames.length)));
                        pk.setNameSurrogate(Intrinsics.areEqual((Object)name, (Object)"PRIMARY"));
                        ** break;
                    }
                    refColNames = MysqlSchemaRetriever.access$splitColNames(this, c.ref_column_names);
                    fk = (MysqlModForeignKey)table.getForeignKeys().createOrGet(name);
                    fk.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(columnNames, columnNames.length)));
                    fk.setRefSchemaName(c.referenced_table_schema);
                    fk.setRefTableName(c.referenced_table_name);
                    fk.setRefColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(refColNames, refColNames.length)));
                    v2 = c.update_rule;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"c.update_rule");
                    fk.setOnUpdate(MysqlSchemaRetriever.access$asCascadeRule(this, v2));
                    v3 = c.delete_rule;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"c.delete_rule");
                    fk.setOnDelete(MysqlSchemaRetriever.access$asCascadeRule(this, v3));
                    ** break;
                }
                key = (MysqlModKey)table.getKeys().createOrGet(name);
                key.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(columnNames, columnNames.length)));
                index = (MysqlModIndex)table.getIndices().get(name);
                if (index == null || index.isSyncPending()) {
                    v4 = index;
                    if (v4 == null) {
                        v4 = (MysqlModIndex)table.getIndices().createNewOne();
                    }
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    index = v4;
                    index.resetSyncPending();
                    index.setName(name);
                    index.setUnique(true);
                    index.setColNames(CollectionsKt.listOf((Object[])Arrays.copyOf(columnNames, columnNames.length)));
                }
                key.setUnderlyingIndexName(name);
lbl71:
                // 7 sources

            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            $receiver$iv = schema.getTables();
            c = $receiver$iv.iterator();
            while (c.hasNext()) {
                element$iv /* !! */  = c.next();
                t = (MysqlModTable)element$iv /* !! */ ;
                it.invoke((Object)t.getKeys());
                it.invoke((Object)t.getForeignKeys());
            }
            $receiver$iv = schema.getTables();
            for (T element$iv : $receiver$iv) {
                it = (MysqlModTable)element$iv;
                it.getIndices().removeSyncPendingChildren();
                it.getIndices().sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String[] splitColNames(String cn) {
            Object[] objectArray;
            Object[] $receiver$iv;
            if (cn == null) {
                return new String[0];
            }
            Object[] $receiver$iv2 = StringUtil.splitByLines((String)cn);
            MysqlIntrospector this_$iv = MysqlIntrospector.this;
            Object[] $receiver$iv$iv = $receiver$iv = (objectArray = $receiver$iv2);
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                void s$iv;
                int n = index$iv$iv++;
                Object object = item$iv$iv;
                int i$iv = n;
                String string = (String)s$iv;
                int n2 = i$iv;
                Object[] objectArray2 = $receiver$iv;
                void v1 = it;
                String string2 = v1 != null ? MysqlIntrospector.this.dbIntern((String)v1) : null;
                objectArray2[n2] = string2;
            }
            return (String[])objectArray;
        }

        private final void retrieveRoutines(MysqlModSchema schema) {
            this.progress("routines");
            Object it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            it.invoke((Object)schema.getRoutines());
            for (MysqlIntroQueries.Routine r : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutines).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModRoutine routine = (MysqlModRoutine)schema.getRoutines().createOrGet(r.specific_name);
                String string = r.routine_type;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"r.routine_type");
                DasRoutine.Kind type = MysqlIntrospectorKt.access$getType(string);
                routine.setRoutineKind(type);
                if (Intrinsics.areEqual((Object)type, (Object)DasRoutine.Kind.FUNCTION)) {
                    BasicModArgument returnArgument = routine.createOrGetReturnArgument();
                    returnArgument.setDataType(DataTypeFactory.of(r.dtd_identifier));
                }
                routine.setComment(StringKt.nullize$default((String)r.routine_comment, (boolean)false, (int)1, null));
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            it.invoke((Object)schema.getRoutines());
        }

        private final void retrieveRoutineParameters(MysqlModSchema schema) {
            MysqlModRoutine r;
            Object element$iv;
            this.progress("routine parameters");
            String pte = (String)this.getTransaction().query(MysqlIntroQueries.QUERIES.parametersTableExists).run();
            Function1 it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            Object $receiver$iv = schema.getRoutines();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                r = (MysqlModRoutine)element$iv;
                it.invoke((Object)r.getArguments());
            }
            Iterable $receiver$iv2 = schema.getRoutines();
            for (Object element$iv2 : $receiver$iv2) {
                MysqlModRoutine it2 = (MysqlModRoutine)element$iv2;
                if (!Intrinsics.areEqual((Object)it2.getRoutineKind(), (Object)DasRoutine.Kind.FUNCTION)) continue;
                it2.createOrGetReturnArgument();
            }
            if (pte != null) {
                this.retrieveRoutineParametersFromInformationSchema(schema);
            } else {
                this.retrieveRoutineParametersFromMetaData(schema);
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            $receiver$iv = schema.getRoutines();
            iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                r = (MysqlModRoutine)element$iv;
                it.invoke((Object)r.getArguments());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineParametersFromInformationSchema(MysqlModSchema schema) {
            void $receiver$iv;
            DBQueryRunner dBQueryRunner = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutineParams).withParams(new Object[]{schema.getName()});
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModRoutine routine;
                    MysqlIntroQueries.Parameter p = (MysqlIntroQueries.Parameter)element$iv$iv;
                    if ((MysqlModRoutine)schema.getRoutines().get(p.specific_name) == null) {
                        continue;
                    }
                    MysqlModArgument arg = (MysqlModArgument)routine.getArguments().createOrGet(p.parameter_name);
                    arg.setPosition(p.ordinal_position);
                    arg.setDataType(DataTypeFactory.of(p.dtd_identifier));
                    String string = p.parameter_mode;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.parameter_mode");
                    arg.setArgumentDirection(MysqlIntrospectorKt.access$getDirection(string));
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
        }

        private final void retrieveColumnGenExprFromTableSrc(MysqlModSchema schema) {
            THashMap cols = ContainerUtil.newTroveMap((TObjectHashingStrategy)((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
            for (MysqlModTable table : schema.getTables()) {
                for (MysqlModTableColumn c : table.getColumns()) {
                    if (!(Intrinsics.areEqual((Object)((Object)c.getColumnKind()), (Object)((Object)MysqlColumnKind.NORMAL)) ^ true) || c.getDefaultExpression() != null) continue;
                    Map map2 = (Map)cols;
                    String string = c.getName();
                    MysqlModTableColumn mysqlModTableColumn = c;
                    map2.put(string, mysqlModTableColumn);
                }
                if (cols.isEmpty()) continue;
                MysqlModTable mysqlModTable = table;
                Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModTable, (String)"table");
                THashMap tHashMap = cols;
                Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"cols");
                this.retrieveColumnGenExprFromTableSrc(mysqlModTable, (Map)tHashMap);
                cols.clear();
            }
        }

        private final void retrieveColumnGenExprFromTableSrc(MysqlModTable table, Map<String, ? extends MysqlModTableColumn> cols) {
            Object object;
            Object it;
            SqlQuery<String[]> query;
            this.setFqn(table);
            SqlQuery<String[]> sqlQuery = query = MysqlIntroQueries.QUERIES.retrieveOneTableSource;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            SqlCreateStatement sqlCreateStatement = this.performQuery(sqlQuery);
            if (sqlCreateStatement == null || (sqlCreateStatement = (String)ArraysKt.getOrNull((Object[])((Object[])sqlCreateStatement), (int)1)) == null || (sqlCreateStatement = this.getCreate(this.replaceBin((String)(it = (object = sqlCreateStatement))))) == null) {
                return;
            }
            SqlCreateStatement sql = sqlCreateStatement;
            for (SqlColumnDefinition c : sql.getDasChildren(ObjectKind.COLUMN).filter(SqlColumnDefinition.class)) {
                MysqlModTableColumn target2;
                if (cols.get(c.getName()) == null) {
                    continue;
                }
                MysqlIntrospector.this.builder.partialBuild((DasObject)target2, (DasObject)c);
            }
        }

        private final void retrieveRoutineParametersFromMetaData(MysqlModSchema schema) {
            DBTransaction dBTransaction = this.getTransaction();
            if (dBTransaction == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.dekaf.core.DBSession");
            }
            DBSession cfr_ignored_0 = (DBSession)dBTransaction;
            Connection connection = (Connection)((DBSession)this.getTransaction()).getSpecificService(Connection.class, "jdbc-connection");
            if (connection == null) {
                return;
            }
            Connection connection2 = connection;
            try {
                DatabaseMetaData metaData = connection2.getMetaData();
                ResultSet c = metaData.getProcedureColumns(schema.getName(), null, null, null);
                while (c.next()) {
                    MysqlModRoutine routine;
                    String name = c.getString("COLUMN_NAME");
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    if ((MysqlModRoutine)schema.getRoutines().get(c.getString("PROCEDURE_NAME")) == null) {
                        continue;
                    }
                    MysqlModArgument arg = (MysqlModArgument)routine.getArguments().createOrGet(name);
                    String typeName = c.getString("TYPE_NAME");
                    int precision = c.getInt("PRECISION");
                    int length = c.getInt("LENGTH");
                    int charOctetLength = c.getInt("CHAR_OCTET_LENGTH");
                    int size = charOctetLength <= 0 && precision <= 0 ? length : Math.max(charOctetLength, precision);
                    int scale = c.getInt("SCALE");
                    arg.setDataType(DataTypeFactory.of(null, typeName, size, scale, null, null, false, false));
                    arg.setArgumentDirection(MysqlIntrospectorKt.access$getDirection(c.getShort("COLUMN_TYPE")));
                }
            }
            catch (SQLException e) {
                MysqlIntrospector.this.getErrorSink().consume((Object)"Failed to retrieve parameters", (Object)e);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(MysqlModSchema schema) {
            void $receiver$iv;
            MysqlModView v;
            MysqlModTable t;
            Object element$iv;
            this.progress("table columns");
            this.getPreprocessor().setFreeParameters(schema.getName());
            Function1 it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            Object $receiver$iv2 = schema.getTables();
            Iterator iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                t = (MysqlModTable)element$iv;
                it.invoke((Object)t.getColumns());
            }
            $receiver$iv2 = schema.getViews();
            iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                v = (MysqlModView)element$iv;
                it.invoke((Object)v.getColumns());
            }
            it = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryColumns.rewrite((StringOperator)this.getPreprocessor())).withParams(new Object[]{schema.getName()});
            $receiver$iv2 = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModLikeTable table;
                    MysqlIntroQueries.Column c = (MysqlIntroQueries.Column)element$iv$iv;
                    String tableName = c.table_name;
                    MysqlModTable mysqlModTable = (MysqlModTable)schema.getTables().get(tableName);
                    if ((mysqlModTable != null ? (MysqlModLikeTable)mysqlModTable : (MysqlModLikeTable)schema.getViews().get(tableName)) == null) {
                        continue;
                    }
                    table = table;
                    MysqlModLikeColumn column2 = (MysqlModLikeColumn)table.getColumns().createOrGet(c.column_name);
                    column2.setPosition(c.ordinal_position);
                    column2.setNotNull(Intrinsics.areEqual((Object)c.is_nullable, (Object)"YES") ^ true);
                    column2.setDataType(DataTypeFactory.of(c.column_type));
                    column2.setComment(StringKt.nullize$default((String)c.column_comment, (boolean)false, (int)1, null));
                    if (!(column2 instanceof MysqlModTableColumn)) continue;
                    ((MysqlModTableColumn)column2).setColumnKind(this.getColumnKind(c.extra));
                    String string = this.getOnUpdate(c.extra);
                    ((MysqlModTableColumn)column2).setOnUpdate(string != null ? MysqlIntrospector.this.dbIntern(string) : null);
                    String defaultCollation = ((MysqlModTableColumn)column2).getTable().getCollation();
                    if (defaultCollation == null) {
                        defaultCollation = ((MysqlModTableColumn)column2).getTable().getSchema().getCollation();
                    }
                    if (Intrinsics.areEqual((Object)defaultCollation, (Object)c.collation_name)) {
                        c.collation_name = null;
                    }
                    String string2 = c.collation_name;
                    ((MysqlModTableColumn)column2).setCollation(string2 != null ? MysqlIntrospector.this.dbIntern(string2) : null);
                    MysqlModTableColumn mysqlModTableColumn = (MysqlModTableColumn)column2;
                    MysqlIntroQueries.Column column3 = c;
                    Intrinsics.checkExpressionValueIsNotNull((Object)column3, (String)"c");
                    mysqlModTableColumn.setDefaultExpression(this.getDefaultExpression(column2, column3));
                    ((MysqlModTableColumn)column2).setSequenceIdentity(this.getSequenceIdentity(c, column2));
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            $receiver$iv2 = schema.getTables();
            Iterator iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                t = (MysqlModTable)element$iv;
                it.invoke((Object)t.getColumns());
            }
            $receiver$iv2 = schema.getViews();
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                v = (MysqlModView)element$iv;
                it.invoke((Object)v.getColumns());
            }
        }

        private final String getOnUpdate(String extra) {
            if (extra == null) {
                return null;
            }
            Matcher matcher = MysqlIntrospectorKt.access$getON_UPDATE$p().matcher(extra);
            if (!matcher.find()) {
                return null;
            }
            return matcher.group(1);
        }

        private final MysqlColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return MysqlColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL GENERATED", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"STORED GENERATED", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_STORED;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"VIRTUAL", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_VIRTUAL;
            }
            return MysqlColumnKind.NORMAL;
        }

        private final SequenceIdentity getSequenceIdentity(MysqlIntroQueries.Column c, MysqlModLikeColumn column2) {
            if (StringsKt.equals((String)c.extra, (String)"auto_increment", (boolean)true) && column2 instanceof MysqlModTableColumn) {
                return MysqlIntrospectorKt.access$getOurMysqlSequenceIdentity$p();
            }
            return null;
        }

        private final String getDefaultExpression(MysqlModLikeColumn column2, MysqlIntroQueries.Column c) {
            String gen;
            String string = c.generation_expression;
            String string2 = gen = string != null ? this.replaceBin(string) : null;
            if (StringUtil.isNotEmpty((String)gen)) {
                String string3;
                if (MysqlIntrospector.this.unescapeGenExpr) {
                    String string4 = gen;
                    if (string4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string3 = this.unescape(string4);
                } else {
                    string3 = gen;
                }
                return string3;
            }
            String def2 = c.column_default;
            if (MysqlIntrospector.this.defProperlyQuoted || def2 == null) {
                if (Intrinsics.areEqual((Object)def2, (Object)"NULL")) {
                    return null;
                }
                String string5 = def2;
                return string5 != null ? this.replaceBin(string5) : null;
            }
            if (!(column2 instanceof MysqlModTableColumn)) {
                return null;
            }
            String typeName = ((MysqlModTableColumn)column2).getDataType().typeName;
            boolean noQuote = ((MysqlModTableColumn)column2).isComputed() || StringsKt.equals((String)typeName, (String)"bit", (boolean)true) || StringUtil.startsWithIgnoreCase((String)def2, (String)"CURRENT_TIMESTAMP") && (StringsKt.startsWith$default((String)typeName, (String)"datetime", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)typeName, (String)"timestamp", (boolean)false, (int)2, null));
            return noQuote ? def2 : MysqlIntrospector.this.quote(def2);
        }

        private final String replaceBin(@NotNull String $receiver) {
            String string = StringUtil.replace((String)$receiver, (List)CollectionsKt.listOf((Object[])new String[]{"\b", "\u001a", "\u0000"}), (List)CollectionsKt.listOf((Object[])new String[]{"\\b", "\\Z", "\\0"}));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.replace(\n    \u2026tOf(\"\\\\b\", \"\\\\Z\", \"\\\\0\"))");
            return string;
        }

        private final String unescape(String str) {
            StringBuilder buf = new StringBuilder();
            int last = str.length() - 1;
            for (int i2 = 0; i2 <= last; ++i2) {
                char ch = str.charAt(i2);
                if (ch == '\\' && i2 != last && (ch = str.charAt(++i2)) != '\'' && ch != '\\') {
                    buf.append('\\');
                }
                buf.append(ch);
            }
            String string = buf.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buf.toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveViewSources(MysqlModSchema schema) {
            void $receiver$iv;
            this.progress("view sources");
            DBQueryRunner dBQueryRunner = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryViews).withParams(new Object[]{schema.getName()});
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModView view;
                    String viewText;
                    MysqlIntroQueries.View t = (MysqlIntroQueries.View)element$iv$iv;
                    if ((MysqlModView)schema.getViews().get(t.table_name) == null) {
                        continue;
                    }
                    String string = viewText = StringKt.nullize((String)t.view_definition, (boolean)true);
                    view.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutineSources(MysqlModSchema schema) {
            void $receiver$iv;
            this.progress("routine sources");
            ArrayList bugged = ContainerUtil.newArrayList();
            DBQueryRunner dBQueryRunner = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryRoutineSources).withParams(new Object[]{schema.getName()});
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModRoutine routine;
                    CharSequence charSequence;
                    Regex regex;
                    MysqlIntroQueries.Routine r = (MysqlIntroQueries.Routine)element$iv$iv;
                    if ((MysqlModRoutine)schema.getRoutines().get(r.specific_name) == null) {
                        continue;
                    }
                    String routineText = StringKt.nullize((String)r.routine_definition, (boolean)true);
                    if (MysqlIntrospector.this.circumventDbe5060 && routineText != null && (regex = this.BUG).containsMatchIn(charSequence = (CharSequence)routineText)) {
                        bugged.add(routine);
                        continue;
                    }
                    String string = routineText;
                    routine.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
            Collection this_$iv = bugged;
            if (!this_$iv.isEmpty()) {
                this.progress("routine sources (circumventing MySQL bugs)");
                Iterable $receiver$iv2 = bugged;
                for (Object element$iv : $receiver$iv2) {
                    MysqlModRoutine it;
                    MysqlModRoutine mysqlModRoutine = it = (MysqlModRoutine)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModRoutine, (String)"it");
                    this.retrieveBuggedRoutineSources(mysqlModRoutine);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggerSources(MysqlModSchema schema) {
            void $receiver$iv;
            this.progress("trigger sources");
            ArrayList bugged = ContainerUtil.newArrayList();
            DBQueryRunner dBQueryRunner = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTriggerSources).withParams(new Object[]{schema.getName()});
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModTrigger trigger;
                    CharSequence charSequence;
                    Regex regex;
                    MysqlModTable table;
                    MysqlIntroQueries.Trigger t = (MysqlIntroQueries.Trigger)element$iv$iv;
                    if ((MysqlModTable)schema.getTables().get(t.event_object_table) == null) {
                        continue;
                    }
                    if ((MysqlModTrigger)table.getTriggers().get(t.trigger_name) == null) {
                        continue;
                    }
                    String triggerText = StringKt.nullize((String)t.action_statement, (boolean)true);
                    if (MysqlIntrospector.this.circumventDbe5060 && triggerText != null && (regex = this.BUG).containsMatchIn(charSequence = (CharSequence)triggerText)) {
                        bugged.add(trigger);
                        continue;
                    }
                    String string = triggerText;
                    trigger.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
            Collection this_$iv = bugged;
            if (!this_$iv.isEmpty()) {
                this.progress("trigger sources (circumventing MySQL bugs)");
                Iterable $receiver$iv2 = bugged;
                for (Object element$iv : $receiver$iv2) {
                    MysqlModTrigger it;
                    MysqlModTrigger mysqlModTrigger = it = (MysqlModTrigger)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModTrigger, (String)"it");
                    this.retrieveBuggedTriggerSources(mysqlModTrigger);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEventSources(MysqlModSchema schema) {
            void $receiver$iv;
            this.progress("event sources");
            ArrayList bugged = ContainerUtil.newArrayList();
            DBQueryRunner dBQueryRunner = this.getTransaction().query(MysqlIntroQueries.QUERIES.queryEventSources).withParams(new Object[]{schema.getName()});
            MysqlIntrospector mysqlIntrospector = MysqlIntrospector.this;
            int limit$iv = MysqlIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    MysqlModEvent event;
                    CharSequence charSequence;
                    Regex regex;
                    MysqlIntroQueries.Event e = (MysqlIntroQueries.Event)element$iv$iv;
                    if ((MysqlModEvent)schema.getEvents().get(e.event_name) == null) {
                        continue;
                    }
                    String eventText = StringKt.nullize((String)e.event_definition, (boolean)true);
                    if (MysqlIntrospector.this.circumventDbe5060 && eventText != null && (regex = this.BUG).containsMatchIn(charSequence = (CharSequence)eventText)) {
                        bugged.add(event);
                        continue;
                    }
                    String string = eventText;
                    event.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null);
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
            Collection this_$iv = bugged;
            if (!this_$iv.isEmpty()) {
                this.progress("trigger sources (circumventing MySQL bugs)");
                Iterable $receiver$iv2 = bugged;
                for (Object element$iv : $receiver$iv2) {
                    MysqlModEvent it;
                    MysqlModEvent mysqlModEvent = it = (MysqlModEvent)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)mysqlModEvent, (String)"it");
                    this.retrieveBuggedEventSources(mysqlModEvent);
                }
            }
        }

        private final void retrieveBuggedRoutineSources(MysqlModRoutine routine) {
            String src;
            String string;
            SqlQuery<String[]> query;
            this.setFqn(routine);
            SqlQuery<String[]> sqlQuery = query = Intrinsics.areEqual((Object)routine.getRoutineKind(), (Object)DasRoutine.Kind.FUNCTION) ? MysqlIntroQueries.QUERIES.retrieveOneFunctionSource : MysqlIntroQueries.QUERIES.retrieveOneProcedureSource;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            Object object = this.performQuery(sqlQuery);
            if (object != null && (object = (String)ArraysKt.getOrNull((Object[])object, (int)2)) != null) {
                Object object2;
                Object it = object2 = object;
                string = this.getBody((String)it);
            } else {
                string = null;
            }
            String string2 = src = string;
            routine.setSourceText(string2 != null ? BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final void retrieveBuggedTriggerSources(MysqlModTrigger trigger) {
            String src;
            String string;
            SqlQuery<String[]> query;
            this.setFqn(trigger);
            SqlQuery<String[]> sqlQuery = query = MysqlIntroQueries.QUERIES.retrieveOneTriggerSource;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            Object object = this.performQuery(sqlQuery);
            if (object != null && (object = (String)ArraysKt.getOrNull((Object[])object, (int)2)) != null) {
                Object object2;
                Object it = object2 = object;
                string = this.getBody((String)it);
            } else {
                string = null;
            }
            String string2 = src = string;
            trigger.setSourceText(string2 != null ? BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final void retrieveBuggedEventSources(MysqlModEvent event) {
            String src;
            String string;
            SqlQuery<String[]> query;
            this.setFqn(event);
            SqlQuery<String[]> sqlQuery = query = MysqlIntroQueries.QUERIES.retrieveOneEventSource;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            Object object = this.performQuery(sqlQuery);
            if (object != null && (object = (String)ArraysKt.getOrNull((Object[])object, (int)3)) != null) {
                Object object2;
                Object it = object2 = object;
                string = this.getBody((String)it);
            } else {
                string = null;
            }
            String string2 = src = string;
            event.setSourceText(string2 != null ? BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.ORIGINAL_TEXT) : null);
        }

        private final String getBody(String src) {
            SqlCreateStatement sqlCreateStatement = this.getCreate(src);
            if (sqlCreateStatement == null) {
                return null;
            }
            SqlCreateStatement createStatement2 = sqlCreateStatement;
            SqlStatement body = (SqlStatement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)createStatement2), SqlStatement.class);
            if (body == null) {
                MysqlIntrospector.this.getLog().warn("No body found in\n" + src);
                return null;
            }
            return body.getText();
        }

        private final SqlCreateStatement getCreate(String src) {
            try {
                SqlCreateStatement createStatement2 = (SqlCreateStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)MysqlIntrospector.this.sqlReader.getReadOnlyPsi(MysqlIntrospector.this.sqlLanguage, (CharSequence)src))).expandAndSkip((Condition)getCreate.createStatement.1.INSTANCE)).filter(SqlCreateStatement.class).first();
                if (createStatement2 == null) {
                    MysqlIntrospector.this.getLog().warn("No create found in\n" + src);
                    return null;
                }
                return createStatement2;
            }
            catch (RuntimeException e) {
                MysqlIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        private final void setFqn(BasicNamedElement o) {
            Map<String, Object> map2 = this.getQueryParameters();
            StringBuilder stringBuilder = new StringBuilder().append("");
            BasicSchema basicSchema = o.getSchema();
            String string = basicSchema != null ? basicSchema.getName() : null;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.schema?.name!!");
            StringBuilder stringBuilder2 = stringBuilder.append(MysqlNamingService.INSTANCE.nameToScript(string)).append('.');
            String string2 = o.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"o.name");
            map2.put("FQN", stringBuilder2.append(MysqlNamingService.INSTANCE.nameToScript(string2)).toString());
        }

        private final void retrieveTriggers(MysqlModSchema schema) {
            MysqlModTable t;
            this.progress("triggers");
            Object it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            Iterable $receiver$iv = schema.getTables();
            for (Object element$iv : $receiver$iv) {
                t = (MysqlModTable)element$iv;
                it.invoke((Object)t.getTriggers());
            }
            for (MysqlIntroQueries.Trigger t2 : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryTriggers).withParams(new Object[]{schema.getName()}).run()) {
                MysqlModTable table;
                if ((MysqlModTable)schema.getTables().get(t2.event_object_table) == null) {
                    continue;
                }
                MysqlModTrigger trigger = (MysqlModTrigger)table.getTriggers().createOrGet(t2.trigger_name);
                trigger.setTurn(StringsKt.equals((String)t2.action_timing, (String)"before", (boolean)true) ? TrigTurn.BEFORE_ROW : TrigTurn.AFTER_ROW);
                String string = t2.event_manipulation;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"t.event_manipulation");
                trigger.setEvents(SetsKt.setOf((Object)MysqlIntrospectorKt.access$getEvent(string)));
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            $receiver$iv = schema.getTables();
            for (Object element$iv : $receiver$iv) {
                t = (MysqlModTable)element$iv;
                it.invoke((Object)t.getTriggers());
            }
        }

        private final void retrieveEvents(MysqlModSchema schema) {
            this.progress("events");
            Object it = MysqlIntrospectorKt.cleanupFamilies.1.INSTANCE;
            it.invoke((Object)schema.getEvents());
            for (MysqlIntroQueries.Event e : (List)this.getTransaction().query(MysqlIntroQueries.QUERIES.queryEvents).withParams(new Object[]{schema.getName()}).run()) {
                String string;
                MysqlModEvent mysqlModEvent;
                MysqlModEvent event;
                block11: {
                    block8: {
                        String string2;
                        MysqlModEvent mysqlModEvent2;
                        block10: {
                            String it2;
                            block9: {
                                String string3;
                                String string4;
                                String string5;
                                event = (MysqlModEvent)schema.getEvents().createOrGet(e.event_name);
                                event.setComment(e.event_comment);
                                String string6 = e.definer;
                                event.setDefiner(string6 != null ? MysqlIntrospector.this.dbIntern(string6) : null);
                                Boolean bl = e.recurring;
                                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"e.recurring");
                                if (bl.booleanValue()) {
                                    string5 = e.interval_value;
                                    if (string5 == null || (string5 = MysqlIntrospectorKt.access$getSqlString$p(string5)) == null) {
                                        string5 = "";
                                    }
                                } else {
                                    string5 = null;
                                }
                                String ivl = string5;
                                mysqlModEvent = event;
                                if (ivl == null) break block8;
                                mysqlModEvent2 = mysqlModEvent;
                                it2 = string4;
                                string2 = e.interval_field;
                                if (string2 == null) break block9;
                                String f = string3 = string2;
                                string2 = "" + it2 + ' ' + f;
                                if (string2 != null) break block10;
                            }
                            string2 = it2;
                        }
                        String string7 = string2;
                        mysqlModEvent = mysqlModEvent2;
                        string = string7;
                        break block11;
                    }
                    string = null;
                }
                mysqlModEvent.setInterval(string);
                String string8 = e.starts;
                event.setStarts(string8 != null ? MysqlIntrospectorKt.access$getSqlString$p(string8) : null);
                String string9 = e.ends;
                event.setEnds(string9 != null ? MysqlIntrospectorKt.access$getSqlString$p(string9) : null);
                event.setPreserve(e.preserve);
                event.setStatus(this.getEventStatus(e.status));
                event.setLastExecuted(e.last_executed);
            }
            it = MysqlIntrospectorKt.cleanupFamilies.2.INSTANCE;
            it.invoke((Object)schema.getEvents());
        }

        private final MysqlEventStatus getEventStatus(String status) {
            return StringsKt.equals((String)status, (String)"ENABLED", (boolean)false) ? MysqlEventStatus.ENABLED : (StringsKt.equals((String)status, (String)"DISABLED", (boolean)false) ? MysqlEventStatus.DISABLED : (StringsKt.equals((String)status, (String)"SLAVESIDE_DISABLED", (boolean)false) ? MysqlEventStatus.SLAVESIDE_DISABLED : MysqlEventStatus.ENABLED));
        }

        public MysqlSchemaRetriever(@NotNull DBTransaction tran, MysqlSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)MysqlIntrospector.this, tran, (BasicSchema)schema);
            this.BUG = new Regex("['\"`]");
        }

        public static final /* synthetic */ void access$retrieveTables(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveIndices(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveIndices(schema);
        }

        public static final /* synthetic */ void access$retrieveTableConstraints(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTableConstraints(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggers(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTriggers(schema);
        }

        public static final /* synthetic */ void access$retrieveEvents(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveEvents(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutines(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutines(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineParameters(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutineParameters(schema);
        }

        public static final /* synthetic */ void access$retrieveColumnGenExprFromTableSrc(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveColumnGenExprFromTableSrc(schema);
        }

        public static final /* synthetic */ void access$retrieveViewSources(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveRoutineSources(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveRoutineSources(schema);
        }

        public static final /* synthetic */ void access$retrieveTriggerSources(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveTriggerSources(schema);
        }

        public static final /* synthetic */ void access$retrieveEventSources(MysqlSchemaRetriever $this, @NotNull MysqlModSchema schema) {
            $this.retrieveEventSources(schema);
        }

        @NotNull
        public static final /* synthetic */ String[] access$splitColNames(MysqlSchemaRetriever $this, @Nullable String cn) {
            return $this.splitColNames(cn);
        }

        @NotNull
        public static final /* synthetic */ CascadeRule access$asCascadeRule(MysqlSchemaRetriever $this, @NotNull String s) {
            return $this.asCascadeRule(s);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/MysqlIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

