/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.MysqlIntrospectorKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.families.ModFamily;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\n\u001a\u00020\u000b2)\b\u0004\u0010\f\u001a#\u0012\u0019\u0012\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\b\u000f\u0012\u0004\u0012\u00020\u000b0\r2\u000e\b\u0004\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0082\b\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"ON_UPDATE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ourMysqlSequenceIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lorg/jetbrains/annotations/NotNull;", "sqlString", "", "getSqlString", "(Ljava/lang/String;)Ljava/lang/String;", "cleanupFamilies", "", "v", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModFamily;", "Lkotlin/ExtensionFunctionType;", "action", "Lkotlin/Function0;", "getDirection", "Lcom/intellij/database/model/DasArgument$Direction;", "id", "", "mode", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "manipulation", "getType", "Lcom/intellij/database/model/DasRoutine$Kind;", "type", "intellij.database.introspection"})
public final class MysqlIntrospectorKt {
    private static final Pattern ON_UPDATE = Pattern.compile("(?i)on update (\\S+)");
    private static final SequenceIdentity ourMysqlSequenceIdentity = SequenceIdentity.of(1L, null, 1L, null);

    private static final TrigEvent getEvent(String manipulation) {
        if (StringsKt.equals((String)"INSERT", (String)manipulation, (boolean)true)) {
            return TrigEvent.INSERT;
        }
        if (StringsKt.equals((String)"DELETE", (String)manipulation, (boolean)true)) {
            return TrigEvent.DELETE;
        }
        return TrigEvent.UPDATE;
    }

    private static final DasRoutine.Kind getType(String type) {
        if (StringsKt.equals((String)"FUNCTION", (String)type, (boolean)true)) {
            return DasRoutine.Kind.FUNCTION;
        }
        if (StringsKt.equals((String)"PROCEDURE", (String)type, (boolean)true)) {
            return DasRoutine.Kind.PROCEDURE;
        }
        return DasRoutine.Kind.NONE;
    }

    private static final DasArgument.Direction getDirection(String mode) {
        if (StringsKt.equals((String)"INOUT", (String)mode, (boolean)true)) {
            return DasArgument.Direction.INOUT;
        }
        if (StringsKt.equals((String)"OUT", (String)mode, (boolean)true)) {
            return DasArgument.Direction.OUT;
        }
        return DasArgument.Direction.IN;
    }

    private static final DasArgument.Direction getDirection(int id) {
        if (id == 4) {
            return DasArgument.Direction.OUT;
        }
        if (id == 2) {
            return DasArgument.Direction.INOUT;
        }
        return DasArgument.Direction.IN;
    }

    private static final void cleanupFamilies(Function1<? super Function1<? super ModFamily<?>, Unit>, Unit> v, Function0<Unit> action) {
        v.invoke((Object)cleanupFamilies.1.INSTANCE);
        action.invoke();
        v.invoke((Object)cleanupFamilies.2.INSTANCE);
    }

    private static final String getSqlString(@NotNull String $receiver) {
        return '\'' + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + '\'';
    }

    public static final /* synthetic */ void access$cleanupFamilies(@NotNull Function1 v, @NotNull Function0 action) {
        MysqlIntrospectorKt.cleanupFamilies(v, (Function0<Unit>)action);
    }

    @NotNull
    public static final /* synthetic */ DasRoutine.Kind access$getType(@NotNull String type) {
        return MysqlIntrospectorKt.getType(type);
    }

    @NotNull
    public static final /* synthetic */ DasArgument.Direction access$getDirection(@NotNull String mode) {
        return MysqlIntrospectorKt.getDirection(mode);
    }

    @NotNull
    public static final /* synthetic */ DasArgument.Direction access$getDirection(int id) {
        return MysqlIntrospectorKt.getDirection(id);
    }

    public static final /* synthetic */ Pattern access$getON_UPDATE$p() {
        return ON_UPDATE;
    }

    @NotNull
    public static final /* synthetic */ SequenceIdentity access$getOurMysqlSequenceIdentity$p() {
        return ourMysqlSequenceIdentity;
    }

    @NotNull
    public static final /* synthetic */ TrigEvent access$getEvent(@NotNull String manipulation) {
        return MysqlIntrospectorKt.getEvent(manipulation);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(@NotNull String $receiver) {
        return MysqlIntrospectorKt.getSqlString($receiver);
    }
}

