/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.OraIntroQueries;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.introspection.OraIntrospector$OraDatabaseRetriever$WhenMappings;
import com.intellij.database.introspection.OraIntrospector$OraSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.OraIntrospectorFunctions;
import com.intellij.database.introspection.OraObjectCodes;
import com.intellij.database.introspection.PortionType;
import com.intellij.database.introspection.StringListAggregator;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraLikeTable;
import com.intellij.database.model.oracle.OraModCheck;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModClusterColumn;
import com.intellij.database.model.oracle.OraModClusterIndex;
import com.intellij.database.model.oracle.OraModCollectionType;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModForeignKey;
import com.intellij.database.model.oracle.OraModIndex;
import com.intellij.database.model.oracle.OraModInfraColumn;
import com.intellij.database.model.oracle.OraModInnerRoutine;
import com.intellij.database.model.oracle.OraModKey;
import com.intellij.database.model.oracle.OraModLikeColumn;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModMajorObject;
import com.intellij.database.model.oracle.OraModMatLog;
import com.intellij.database.model.oracle.OraModMatView;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModObjectTypeAttribute;
import com.intellij.database.model.oracle.OraModObjectTypeBody;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModPackageBody;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSchemaObject;
import com.intellij.database.model.oracle.OraModSequence;
import com.intellij.database.model.oracle.OraModSingleRoutine;
import com.intellij.database.model.oracle.OraModSourceAware;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.model.oracle.OraModTableTrigger;
import com.intellij.database.model.oracle.OraModTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraSchemaObject;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.util.StringFunKt;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0005789:;B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u001c\u0010\u0017\u001a\u00060\u0018R\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u001c\u0010\u001c\u001a\u00060\u001dR\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0005H\u0014J\b\u0010\u001f\u001a\u00020\u0013H\u0014J9\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'\"\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001aH\u0014J\u001e\u0010,\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001a2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0014J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u001aH\u0014J3\u0010/\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0006022\u0006\u00103\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00104J3\u00105\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020(0'2\u000e\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0006022\u0006\u00103\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00104J\b\u00106\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/database/introspection/OraIntrospector;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "()V", "fast", "", "queries", "Lcom/intellij/database/introspection/OraIntroQueries;", "sqlLanguageDialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "sqlObjectBuilder", "Lcom/intellij/sql/database/SqlObjectBuilder;", "sqlReader", "Lcom/intellij/sql/script/SqlReader;", "applySchemas", "", "scs", "", "Lcom/intellij/database/introspection/LongIdName;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/OraIntrospector$OraSchemaRetriever;", "schema", "initConnectionRelatedState", "introspectFragment", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "", "", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespacesInTran", "tran", "introspectSchemasAuto", "schemas", "introspectSessionState", "processNames", "items", "modelSchemas", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "renew", "([Ljava/lang/String;Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;Z)V", "processTheNames", "retrieveAndApplySchemas", "OraDatabaseFirstRetriever", "OraDatabaseIncRetriever", "OraDatabaseRetriever", "OraSchemaRetriever", "VERSION", "intellij.database.introspection"})
public final class OraIntrospector
extends BaseSingleDatabaseIntrospector<OraModModel, OraRoot, OraModRoot, OraSchema, OraModSchema> {
    private final OraIntroQueries queries;
    private final SqlReader sqlReader;
    private final SqlLanguageDialect sqlLanguageDialect;
    private final SqlObjectBuilder sqlObjectBuilder;
    private boolean fast;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initConnectionRelatedState() {
        void var3_5;
        void this_$iv;
        super.initConnectionRelatedState();
        if (!this.getServerVersion().isOrGreater(new int[]{10}) && this.getDriverVersion().isOrGreater(new int[]{12})) {
            String message = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.getServerVersion(), this.getDriverVersion());
            throw (Throwable)new IllegalStateException(message);
        }
        OraIntrospector message = this;
        OraIntrospector oraIntrospector = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p((BaseIntrospector)this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction((InTransaction)new InTransaction<Boolean>(this){
            final /* synthetic */ OraIntrospector this$0;
            {
                this.this$0 = oraIntrospector;
            }

            public final Boolean run(@NotNull DBTransaction tran) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction tran2 = tran;
                try {
                    Object object = tran2.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkBaseDictionariesAccess).run();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.check\u2026DictionariesAccess).run()");
                    bl = (Boolean)object;
                }
                catch (NoTableOrViewException ntv) {
                    bl = false;
                }
                return bl;
            }
        });
        void var6_6 = var3_5;
        oraIntrospector.fast = (Boolean)var6_6;
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, this.queryParameters);
        BaseIntrospectionFunctions.setOracleFastSlowModeParameters(this.fast, this.queryParameters);
        this.getLog().info(String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using %s mode", this.getServerVersion(), this.getDriverVersion(), this.fast ? "FAST" : "SLOW"));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemas;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = schemas = (List)tran.query(this.queries.retrieveAllSchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemas");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        OraIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        Object result$iv = dbf$iv.inTransaction((InTransaction)new InTransaction<List<? extends LongIdName>>(this){
            final /* synthetic */ OraIntrospector this$0;
            {
                this.this$0 = oraIntrospector;
            }

            public final List<? extends LongIdName> run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction tran2 = tran;
                Object object = tran2.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).retrieveAllSchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(queries.retrieveAllSchemas).run()");
                return (List)object;
            }
        });
        List schemas = (List)result$iv;
        this.applySchemas(schemas);
    }

    private final void applySchemas(List<LongIdName> scs) {
        ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(scs){
            final /* synthetic */ List $scs;

            public final void perform(OraModRoot root2) {
                NamingIdentifyingFamily schemas = root2.getSchemas();
                boolean wasEmpty = schemas.isEmpty();
                boolean beforePublic = true;
                schemas.markChildrenAsSyncPending();
                for (int i2 = 0; i2 < this.$scs.size(); ++i2) {
                    LongIdName sc = (LongIdName)this.$scs.get(i2);
                    OraModSchema schema = (OraModSchema)schemas.renew(sc.id, sc.name);
                    beforePublic &= sc.id != 1L;
                    if (i2 == 0) {
                        schema.setVisible(true);
                    }
                    if (!beforePublic || !wasEmpty) continue;
                    schema.setVisible(true);
                }
                schemas.removeSyncPendingChildren();
            }
            {
                this.$scs = list;
            }
        });
    }

    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.queries.retrieveSessionInfo).run();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        OraIntroQueries.OneSessionInfo sessionInfo = (OraIntroQueries.OneSessionInfo)object;
        ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(sessionInfo){
            final /* synthetic */ OraIntroQueries.OneSessionInfo $sessionInfo;

            public final void perform(OraModRoot root2) {
                OraModSchema currentSchema = (OraModSchema)root2.getSchemas().createOrGet(this.$sessionInfo.current_schema);
                currentSchema.setVisible(true);
                currentSchema.setCurrent(true);
                OraModSchema userSchema = (OraModSchema)root2.getSchemas().createOrGet(this.$sessionInfo.current_user);
                userSchema.setVisible(true);
            }
            {
                this.$sessionInfo = oneSessionInfo;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends OraSchema> schemas) {
        Object retriever2;
        OraIntrospector this_$iv;
        String message$iv;
        String operationName$iv;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        ArrayList schemasToProcess = new ArrayList(schemas);
        Iterator it = schemasToProcess.iterator();
        while (it.hasNext()) {
            OraSchema s = (OraSchema)it.next();
            if (s.getObjectId() != Long.MIN_VALUE || !(Intrinsics.areEqual((Object)s.getName(), (Object)"SYS") ^ true)) continue;
            this.getLog().warn("Oracle schema " + s.getRealName() + " has no object Id");
            it.remove();
        }
        ArrayList<Object> schemas1 = new ArrayList<Object>(schemasToProcess.size());
        ArrayList schemas2 = new ArrayList(schemasToProcess.size());
        for (Object schema : schemasToProcess) {
            (schema.getIntrospectionTimestamp() == null ? schemas1 : schemas2).add(schema);
        }
        if (!schemas1.isEmpty()) {
            Object schema;
            schema = this;
            operationName$iv = "Introspect database stuff completely";
            try {
                OraDatabaseFirstRetriever retriever1 = new OraDatabaseFirstRetriever(tran, (List<? extends OraSchema>)schemas1, false);
                retriever1.process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        if (!schemas2.isEmpty()) {
            this_$iv = this;
            operationName$iv = "Introspect database stuff incrementally";
            try {
                retriever2 = new OraDatabaseIncRetriever(tran, schemas2, false);
                ((OraDatabaseIncRetriever)retriever2).process();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv = "NPE encountered when performing " + operationName$iv;
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
                BaseIntrospector.access$getLog$p(this_$iv).error(message$iv, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
                this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
            }
        }
        for (Object schema : schemasToProcess) {
            void this_$iv2;
            String message$iv2;
            retriever2 = this;
            String operationName$iv2 = "Introspect the schema " + schema.getName() + " stuff completely";
            try {
                OraSchemaRetriever oraSchemaRetriever;
                Object object = schema;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"schema");
                OraSchemaRetriever $receiver = oraSchemaRetriever = new OraSchemaRetriever(tran, (OraSchema)object);
                Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
                $receiver.setMyFromTimestamp$intellij_database_introspection($receiver.getMode$intellij_database_introspection().increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO);
                Long srcExistentVersion = ((OraModModel)this.getModel()).getSchemaSourcesVersion((BasicSchema)schema);
                $receiver.setSrcFromTimestamp$intellij_database_introspection(srcExistentVersion != null && Intrinsics.compare((long)srcExistentVersion, (long)0L) > 0 ? new Timestamp(srcExistentVersion) : BaseIntrospectionFunctions.AGES_AGO);
                OraSchemaRetriever retriever = oraSchemaRetriever;
                retriever.retrieveMain$intellij_database_introspection();
            }
            catch (InterruptedException ie$iv) {
                throw (Throwable)ie$iv;
            }
            catch (DBException d$iv) {
                message$iv2 = "Error encountered when performing " + operationName$iv2 + ": " + d$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)d$iv);
            }
            catch (NullPointerException npe$iv) {
                message$iv2 = "NPE encountered when performing " + operationName$iv2;
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)npe$iv);
                BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv2).error(message$iv2, (Throwable)npe$iv);
            }
            catch (Exception e$iv) {
                message$iv2 = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv2 + ": " + e$iv.getMessage();
                this_$iv2.getErrorSink().consume((Object)message$iv2, (Object)e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        void this_$iv;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
        boolean bl2 = bl = namespace.getModel() == (OraModModel)this.getModel();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = namespace instanceof OraSchema;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        OraSchema schema = (OraSchema)namespace;
        OraIntrospector oraIntrospector = this;
        String operationName$iv = "Introspect fragments " + ArraysKt.joinToString$default((Object[])objectNames, null, null, null, (int)0, null, null, (int)63, null);
        try {
            OraIntrospector this_$iv2 = this;
            DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv2);
            if (dBFacade == null) {
                throw (Throwable)new IllegalStateException("Not attached to DB facade");
            }
            DBFacade dbf$iv = dBFacade;
            dbf$iv.inTransaction(new InTransactionNoResult(this, schema, objectKind, objectNames, withSources){
                final /* synthetic */ OraIntrospector this$0;
                final /* synthetic */ OraSchema $schema$inlined;
                final /* synthetic */ ObjectKind $objectKind$inlined;
                final /* synthetic */ String[] $objectNames$inlined;
                final /* synthetic */ boolean $withSources$inlined;
                {
                    this.this$0 = oraIntrospector;
                    this.$schema$inlined = oraSchema;
                    this.$objectKind$inlined = objectKind;
                    this.$objectNames$inlined = stringArray;
                    this.$withSources$inlined = bl;
                }

                public final void run(@NotNull DBTransaction tran) {
                    Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                    DBTransaction tran2 = tran;
                    OraSchemaRetriever retriever = this.this$0.new OraSchemaRetriever(tran2, this.$schema$inlined);
                    retriever.setMode$intellij_database_introspection(IntrospectionMode.FRAGMENT);
                    retriever.setFragmentKind$intellij_database_introspection(this.$objectKind$inlined);
                    retriever.setFragmentNames$intellij_database_introspection(this.$objectNames$inlined);
                    retriever.setWithSources$intellij_database_introspection(this.$withSources$inlined);
                    retriever.setMyFromTimestamp$intellij_database_introspection(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.setSrcFromTimestamp$intellij_database_introspection(BaseIntrospectionFunctions.AGES_AGO);
                    retriever.retrieveMain$intellij_database_introspection();
                }
            });
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    private final void processNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        long time1 = System.currentTimeMillis();
        this.processTheNames(items, modelSchemas, renew);
        long time2 = System.currentTimeMillis();
        double delta = (double)(time2 - time1) / 1000.0;
        this.getLog().debug("Major names processing took " + delta + " s.");
    }

    /*
     * WARNING - void declaration
     */
    private final void processTheNames(String[] items, ModNamingIdentifyingFamily<? extends OraModSchema> modelSchemas, boolean renew) {
        HashSet<ModNamingIdentifyingFamily> affectedFamilies = new HashSet<ModNamingIdentifyingFamily>();
        int n = 0;
        int n2 = ((Object[])items).length - 1;
        if (n <= n2) {
            while (true) {
                void i2;
                String item = items[i2];
                try {
                    String objectName;
                    String kindCode;
                    OraModSchema schema;
                    String objectIdStr;
                    String schemaIdStr;
                    String string;
                    boolean bl;
                    boolean bl2 = bl = item.length() >= 23;
                    if (_Assertions.ENABLED && !bl) {
                        string = "The item should be at least 23 characters length";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    String $i$a$1$assert = item;
                    int n3 = 0;
                    int n4 = 2;
                    String string2 = $i$a$1$assert;
                    if (string2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n3, n4), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = item;
                    n4 = 2;
                    int n5 = 12;
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(n4, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string4 = item;
                    n5 = 12;
                    int n6 = 22;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n5, n6), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = item;
                    n6 = 22;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n6), (String)"(this as java.lang.String).substring(startIndex)");
                    int schemaId = Integer.parseInt(schemaIdStr);
                    int objectId = Integer.parseInt(objectIdStr);
                    if ((OraModSchema)modelSchemas.getByObjectId((long)schemaId) == null) {
                        String string8 = "Schema should exist, id:" + schemaId;
                        throw (Throwable)new IllegalStateException(string8.toString());
                    }
                    ModNamingIdentifyingFamily family = OraIntrospectorFunctions.access$majorFamilyOf(schema, kindCode);
                    if (renew) {
                        family.renew(objectId, objectName);
                    } else {
                        OraModSchemaObject majorObject = (OraModSchemaObject)family.createOrGet(objectName);
                        majorObject.setObjectId(objectId);
                    }
                    affectedFamilies.add(family);
                }
                catch (NumberFormatException e) {
                    this.getLog().warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        for (ModNamingIdentifyingFamily family : affectedFamilies) {
            family.sort();
        }
    }

    @NotNull
    protected OraDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull OraRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new OraDatabaseFirstRetriever(transaction, CollectionsKt.emptyList(), false);
    }

    @NotNull
    protected OraSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull OraSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new OraSchemaRetriever(transaction, schema);
    }

    public OraIntrospector() {
        Rdbms rdbms = Oracle.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Oracle.RDBMS");
        super(rdbms, OraModModel.class, OraModRoot.class, OraModSchema.class);
        OraIntroQueries oraIntroQueries = OraIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)oraIntroQueries, (String)"QUERIES");
        this.queries = oraIntroQueries;
        SqlReader sqlReader = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).createSqlReader();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReader, (String)"SqlPsiFacade.getInstance\u2026roject).createSqlReader()");
        this.sqlReader = sqlReader;
        Language language = Language.findLanguageByID((String)"Oracle");
        if (language == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialect");
        }
        this.sqlLanguageDialect = (SqlLanguageDialect)language;
        Object object = SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)this.sqlLanguageDialect);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"SqlLanguageObjectBuilder\u2026guage(sqlLanguageDialect)");
        this.sqlObjectBuilder = (SqlObjectBuilder)object;
    }

    public static final /* synthetic */ void access$setFast$p(OraIntrospector $this, boolean bl) {
        $this.fast = bl;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00a4\u0004\u0018\u00002$0\u0001R \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J8\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002J0\u0010\u001a\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0014J0\u0010\u001c\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002J8\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00190\u0017H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "adjustNativeStatements", "", "", "text", "chopListAndRetrieveNativeDefinitions", "", "portionType", "Lcom/intellij/database/introspection/PortionType;", "elements", "", "Lcom/intellij/database/model/oracle/OraSchemaObject;", "result", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "retrieveNativeDefinitions", "", "retrieveNativeDefinitionsPortion", "retrieveNativeDefinitionsPortionSafe", "intellij.database.introspection"})
    protected abstract class OraDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever {
        /*
         * WARNING - void declaration
         */
        @Override
        protected void retrieveNativeDefinitions(@NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            List filteredElements = CollectionsKt.filterIsInstance(elements, OraSchemaObject.class);
            int n = filteredElements.size();
            if (n == 0) {
                return;
            }
            PortionType portionType = OraIntrospectorFunctions.access$applicablePortionTypeFor(n);
            if (Intrinsics.areEqual((Object)((Object)portionType), (Object)((Object)PortionType.ALL))) {
                int stepSize = PortionType.NORMAL.getSize();
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
                int n2 = intProgression.getFirst();
                int n3 = intProgression.getLast();
                int n4 = intProgression.getStep();
                int n5 = n2;
                int n6 = n3;
                if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
                    while (true) {
                        void offset;
                        List portion = filteredElements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                        PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                        this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                        if (offset != n3) {
                            offset += n4;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.retrieveNativeDefinitionsPortionSafe(portionType, filteredElements, result2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void chopListAndRetrieveNativeDefinitions(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            PortionType portionType2;
            switch (OraIntrospector$OraDatabaseRetriever$WhenMappings.$EnumSwitchMapping$0[portionType.ordinal()]) {
                case 1: {
                    portionType2 = PortionType.NORMAL;
                    break;
                }
                case 2: {
                    portionType2 = PortionType.SMALL;
                    break;
                }
                case 3: {
                    portionType2 = PortionType.ONE;
                    break;
                }
                case 4: {
                    throw (Throwable)new IllegalArgumentException("A portion of one element cannot be split into several portions");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PortionType nextPortion = portionType2;
            int stepSize = nextPortion.getSize();
            int n = elements.size();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)n)), (int)stepSize);
            int n2 = intProgression.getFirst();
            int n3 = intProgression.getLast();
            int n4 = intProgression.getStep();
            int n5 = n2;
            int n6 = n3;
            if (n4 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void offset;
                    List<? extends OraSchemaObject> portion = elements.subList((int)offset, Math.min((int)(offset + stepSize), n));
                    PortionType pt = OraIntrospectorFunctions.access$applicablePortionTypeFor(portion.size());
                    this.retrieveNativeDefinitionsPortionSafe(pt, portion, result2);
                    if (offset == n3) break;
                    offset += n4;
                }
            }
        }

        private final void retrieveNativeDefinitionsPortionSafe(PortionType portionType, List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            try {
                this.retrieveNativeDefinitionsPortion(elements, result2);
            }
            catch (DBException e) {
                if (portionType.compareTo((Enum)PortionType.ONE) > 0) {
                    this.chopListAndRetrieveNativeDefinitions(portionType, elements, result2);
                }
                OraSchemaObject element = (OraSchemaObject)CollectionsKt.first(elements);
                String comment = "-- failed to obtain definition for " + element + ":\n--\t" + e.getMessage();
                result2.put(element, new String[]{comment});
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveNativeDefinitionsPortion(List<? extends OraSchemaObject> elements, Map<BasicElement, String[]> result2) {
            String[] stringArray;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)elements;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                stringArray = (String[])item$iv$iv;
                Collection collection2 = collection;
                Long l = it.getObjectId();
                collection2.add(l);
            }
            long[] identifiers = CollectionsKt.toLongArray((Collection)((List)collection));
            this.setQueryParameter("identifiers", identifiers);
            SqlQuery<List<OraIntroQueries.OneNativeDefinition>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveNativeDefinitions;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveNativeDefinitions");
            List<OraIntroQueries.OneNativeDefinition> entries = this.performQuery(sqlQuery);
            MultiMap map2 = new MultiMap();
            for (OraIntroQueries.OneNativeDefinition oneNativeDefinition : entries) {
                Long l = oneNativeDefinition.object_id;
                String string = oneNativeDefinition.text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.text");
                map2.putValues((Object)l, this.adjustNativeStatements(string));
            }
            for (OraSchemaObject oraSchemaObject : elements) {
                Collection thisCollection$iv;
                Map<BasicElement, String[]> map3 = result2;
                Collection $receiver$iv2 = map2.get((Object)oraSchemaObject.getObjectId());
                if ($receiver$iv2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                if (thisCollection$iv.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                map3.put(oraSchemaObject, stringArray);
            }
        }

        private final Collection<String> adjustNativeStatements(String text2) {
            CharSequence charSequence = text2;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String txt = ((Object)StringsKt.trim((CharSequence)string)).toString();
            charSequence = txt;
            if (charSequence.length() == 0) {
                return SetsKt.emptySet();
            }
            CharSequence charSequence2 = txt;
            Pattern pattern = OraIntrospectorFunctions.access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"NATIVE_TRIGGER_DEFINITION_PATTERN");
            if (BaseIntrospectionFunctions.matches(charSequence2, pattern)) {
                int p = StringsKt.indexOf$default((CharSequence)txt, (String)"ALTER TRIGGER \"", (int)0, (boolean)false, (int)6, null);
                if (p > 0) {
                    String string2;
                    String string3 = txt;
                    int n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n, p);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = string3 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt1 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
                    String string7 = string2 = txt;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(p);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                    String string9 = string2 = string8;
                    if (string9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String stmt2 = ((Object)StringsKt.trim((CharSequence)string9)).toString();
                    return CollectionsKt.listOf((Object[])new String[]{stmt1, stmt2});
                }
                Set<String> set = Collections.singleton(txt);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
                return set;
            }
            Set<String> set = Collections.singleton(txt);
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"singleton(txt)");
            return set;
        }

        public OraDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseFirstRetriever;", "Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/introspection/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/model/oracle/OraSchema;", "glutton", "", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "prepareParameters", "", "process", "retrieveAllOrdinaryNames", "retrieveAllSynonyms", "intellij.database.introspection"})
    private final class OraDatabaseFirstRetriever
    extends OraDatabaseRetriever {
        private final List<OraSchema> schemas;
        private final boolean glutton;

        protected void prepareParameters() {
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        @Override
        public void process() {
            this.prepareParameters();
            this.retrieveAllOrdinaryNames();
            this.retrieveAllSynonyms();
        }

        private final void retrieveAllOrdinaryNames() {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            OraDatabaseFirstRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this, items){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ String[] $items$inlined;
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$items$inlined = stringArray;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    for (OraSchema schema : OraDatabaseFirstRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root3.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModSchema");
                        }
                        OraModSchema ms = (OraModSchema)basicModSchema;
                        ms.getSequences().clear();
                        ms.getObjectTypes().clear();
                        ms.getCollectionTypes().clear();
                        ms.getTables().clear();
                        ms.getMatViews().clear();
                        ms.getViews().clear();
                        ms.getPackages().clear();
                        ms.getRoutines().clear();
                    }
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    NamingIdentifyingFamily namingIdentifyingFamily = root3.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items$inlined, (ModNamingIdentifyingFamily)namingIdentifyingFamily, false);
                }
            });
        }

        private final void retrieveAllSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraDatabaseFirstRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(ss){
                final /* synthetic */ List $ss$inlined;
                {
                    this.$ss$inlined = list;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraIntrospectorFunctions.access$processSynonyms(this.$ss$inlined, root3);
                }
            });
        }

        public OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
            super(transaction);
            this.schemas = schemas;
            this.glutton = glutton;
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseFirstRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseIncRetriever;", "Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseRetriever;", "Lcom/intellij/database/introspection/OraIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "Lcom/intellij/database/model/oracle/OraSchema;", "glutton", "", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "since", "Ljava/util/Date;", "determineAndRemoveAllDroppedStuff", "", "prepareParameters", "process", "retrieveAllOrdinaryNames", "root", "Lcom/intellij/database/model/oracle/OraModRoot;", "retrieveAllSynonyms", "intellij.database.introspection"})
    private final class OraDatabaseIncRetriever
    extends OraDatabaseRetriever {
        private Date since;
        private final List<OraSchema> schemas;
        private final boolean glutton;

        /*
         * WARNING - void declaration
         */
        @Override
        public void process() {
            Iterable $receiver$iv$iv;
            this.prepareParameters();
            this.determineAndRemoveAllDroppedStuff();
            Iterable $receiver$iv = this.schemas;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Date date;
                Object element$iv$iv = element$iv$iv$iv;
                OraSchema it = (OraSchema)element$iv$iv;
                if (it.getIntrospectionTimestamp() == null) continue;
                Date it$iv$iv = date;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Object element$iv$iv$iv;
                element$iv$iv$iv = (Date)item$iv$iv;
                Collection collection = destination$iv$iv;
                Long l = it.getTime();
                collection.add(l);
            }
            Long l = (Long)CollectionsKt.min((Iterable)((List)destination$iv$iv));
            long sinceTime = l != null ? l : System.currentTimeMillis();
            this.since = new Timestamp(sinceTime);
            this.setQueryParameter("INC", Boolean.TRUE);
            this.setQueryParameter("SINCE", this.since);
            OraDatabaseIncRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                {
                    this.this$0 = oraDatabaseIncRetriever;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraDatabaseIncRetriever.access$retrieveAllOrdinaryNames(this.this$0, root3);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                {
                    this.this$0 = oraDatabaseIncRetriever;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraDatabaseIncRetriever.access$retrieveAllSynonyms(this.this$0, root3);
                }
            });
        }

        private final void prepareParameters() {
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", this.schemas.stream().map(prepareParameters.1.INSTANCE).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", this.schemas.stream().map(prepareParameters.2.INSTANCE).toArray());
        }

        private final void determineAndRemoveAllDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraDatabaseIncRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this, identifiers){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                final /* synthetic */ TLongHashSet $identifiers$inlined;
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    this.$identifiers$inlined = tLongHashSet;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    for (OraSchema schema : OraDatabaseIncRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root3.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModSchema");
                        }
                        OraModSchema s = (OraModSchema)basicModSchema;
                        OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers$inlined);
                    }
                }
            });
        }

        private final void retrieveAllOrdinaryNames(OraModRoot root2) {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            NamingIdentifyingFamily modelSchemas = root2.getSchemas();
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            NamingIdentifyingFamily namingIdentifyingFamily = modelSchemas;
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"modelSchemas");
            OraIntrospector.this.processNames(items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, true);
        }

        private final void retrieveAllSynonyms(OraModRoot root2) {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospectorFunctions.access$processSynonyms(ss, root2);
        }

        public OraDatabaseIncRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
            super(transaction);
            this.since = BaseIntrospectionFunctions.AGES_AGO;
            this.schemas = schemas;
            this.glutton = glutton;
        }

        public static final /* synthetic */ void access$retrieveAllOrdinaryNames(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllOrdinaryNames(root2);
        }

        public static final /* synthetic */ void access$retrieveAllSynonyms(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllSynonyms(root2);
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseIncRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\u0017\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010F\u001a\u0004\u0018\u00010G2\b\u0010H\u001a\u0004\u0018\u00010IH\u0002J\b\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PH\u0002J&\u0010Q\u001a\u00020K2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0WH\u0002J\b\u0010Y\u001a\u00020KH\u0014J\b\u0010Z\u001a\u00020KH\u0002J\u0018\u0010[\u001a\u00020K2\u0006\u0010M\u001a\u00020N2\u0006\u0010\\\u001a\u00020XH\u0002J\b\u0010]\u001a\u00020^H\u0002J$\u0010_\u001a\u0004\u0018\u0001H`\"\n\b\u0000\u0010`\u0018\u0001*\u00020a2\u0006\u0010b\u001a\u00020XH\u0082\b\u00a2\u0006\u0002\u0010cJ\b\u0010d\u001a\u00020KH\u0014J\b\u0010e\u001a\u00020KH\u0016J\b\u0010f\u001a\u00020KH\u0002J\u0010\u0010g\u001a\u00020K2\u0006\u0010h\u001a\u00020XH\u0014J\b\u0010i\u001a\u00020KH\u0002J\b\u0010j\u001a\u00020KH\u0002J\b\u0010k\u001a\u00020KH\u0002J\b\u0010l\u001a\u00020KH\u0002J\b\u0010m\u001a\u00020KH\u0002J\b\u0010n\u001a\u00020KH\u0002J\b\u0010o\u001a\u00020KH\u0002J\b\u0010p\u001a\u00020KH\u0002J\b\u0010q\u001a\u00020KH\u0002J\b\u0010r\u001a\u00020KH\u0002J\b\u0010s\u001a\u00020KH\u0002J\b\u0010t\u001a\u00020KH\u0002J\b\u0010u\u001a\u00020KH\u0002J\b\u0010v\u001a\u00020KH\u0002J\b\u0010w\u001a\u00020KH\u0002J\b\u0010x\u001a\u00020KH\u0002J\b\u0010y\u001a\u00020KH\u0002J\b\u0010z\u001a\u00020KH\u0002J\b\u0010{\u001a\u00020KH\u0002J\r\u0010|\u001a\u00020KH\u0000\u00a2\u0006\u0002\b}J\b\u0010~\u001a\u00020KH\u0014J\b\u0010\u007f\u001a\u00020KH\u0002J\t\u0010\u0080\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0081\u0001\u001a\n\u0012\u0005\u0012\u00030\u0083\u00010\u0082\u0001H\u0002J\t\u0010\u0084\u0001\u001a\u00020KH\u0002J\t\u0010\u0085\u0001\u001a\u00020KH\u0002J\t\u0010\u0086\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0088\u00010\u0082\u0001H\u0002J\t\u0010\u0089\u0001\u001a\u00020KH\u0002J\t\u0010\u008a\u0001\u001a\u00020KH\u0002J\t\u0010\u008b\u0001\u001a\u00020KH\u0002J\t\u0010\u008c\u0001\u001a\u00020KH\u0002J\t\u0010\u008d\u0001\u001a\u00020KH\u0002J\t\u0010\u008e\u0001\u001a\u00020KH\u0002J\t\u0010\u008f\u0001\u001a\u00020KH\u0002J\t\u0010\u0090\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0091\u0001\u001a\n\u0012\u0005\u0012\u00030\u0092\u00010\u0082\u0001H\u0002J\t\u0010\u0093\u0001\u001a\u00020KH\u0002J\u0011\u0010\u0094\u0001\u001a\n\u0012\u0005\u0012\u00030\u0095\u00010\u0082\u0001H\u0002J\t\u0010\u0096\u0001\u001a\u00020KH\u0002J\u0019\u0010\u0097\u0001\u001a\n\u0012\u0005\u0012\u00030\u0099\u00010\u0098\u00012\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0016\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u009b\u00012\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0002J$\u0010\u009e\u0001\u001a\u00020K2\u000f\u0010\u009f\u0001\u001a\n\u0012\u0005\u0012\u00030\u00a0\u00010\u0098\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001fR\u001a\u0010&\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001fR\u001a\u0010)\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001d\"\u0004\b+\u0010\u001fR\u001a\u0010,\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001d\"\u0004\b.\u0010\u001fR\u001a\u0010/\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001d\"\u0004\b1\u0010\u001fR\u001a\u00102\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001d\"\u0004\b4\u0010\u001fR\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u000206X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00108\"\u0004\b=\u0010:R\u001c\u0010>\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00108\"\u0004\b@\u0010:R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001d\"\u0004\bE\u0010\u001f\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/oracle/OraSchema;)V", "affectedClusters", "Ljava/util/HashSet;", "Lcom/intellij/database/model/oracle/OraCluster;", "affectedDepObjects", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "affectedInnerRoutines", "Lcom/intellij/database/model/basic/BasicRoutine;", "affectedModuleBodies", "Lcom/intellij/database/model/oracle/OraBody;", "affectedModuleSpecs", "Lcom/intellij/database/model/oracle/OraModule;", "affectedSingleRoutines", "affectedTables", "Lcom/intellij/database/model/oracle/OraTable;", "affectsClusters", "", "getAffectsClusters$intellij_database_introspection", "()Z", "setAffectsClusters$intellij_database_introspection", "(Z)V", "affectsMatLogs", "getAffectsMatLogs$intellij_database_introspection", "setAffectsMatLogs$intellij_database_introspection", "affectsMatViews", "getAffectsMatViews$intellij_database_introspection", "setAffectsMatViews$intellij_database_introspection", "affectsModulesOrBodies", "getAffectsModulesOrBodies$intellij_database_introspection", "setAffectsModulesOrBodies$intellij_database_introspection", "affectsTables", "getAffectsTables$intellij_database_introspection", "setAffectsTables$intellij_database_introspection", "affectsTriggers", "getAffectsTriggers$intellij_database_introspection", "setAffectsTriggers$intellij_database_introspection", "affectsViews", "getAffectsViews$intellij_database_introspection", "setAffectsViews$intellij_database_introspection", "haveDefaults", "getHaveDefaults$intellij_database_introspection", "setHaveDefaults$intellij_database_introspection", "myBeginTimestamp", "Ljava/sql/Timestamp;", "getMyBeginTimestamp$intellij_database_introspection", "()Ljava/sql/Timestamp;", "setMyBeginTimestamp$intellij_database_introspection", "(Ljava/sql/Timestamp;)V", "myFromTimestamp", "getMyFromTimestamp$intellij_database_introspection", "setMyFromTimestamp$intellij_database_introspection", "srcFromTimestamp", "getSrcFromTimestamp$intellij_database_introspection", "setSrcFromTimestamp$intellij_database_introspection", "tablesToReorderDetails", "Lcom/intellij/database/model/oracle/OraLikeTable;", "toStop", "getToStop$intellij_database_introspection", "setToStop$intellij_database_introspection", "adjustBigIntegerForSequence", "Ljava/math/BigInteger;", "bigDecimalValue", "Ljava/math/BigDecimal;", "adjustInnerRoutines", "", "applyClusterInfo", "cluster", "Lcom/intellij/database/model/oracle/OraModCluster;", "c", "Lcom/intellij/database/introspection/OraIntroQueries$OneCluster;", "applyIndexingItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "index", "Lcom/intellij/database/model/oracle/OraModIndex;", "items", "", "", "clearSchema", "determineAndRemoveDroppedStuff", "extractClusterColumns", "text", "getSourceLineWidthLimit", "", "parseStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "src", "(Ljava/lang/String;)Lcom/intellij/sql/psi/SqlStatement;", "prepareParameters", "process", "reorderTableDetails", "reportRetrieving", "what", "retrieveChecks", "retrieveClusterIndices", "retrieveClusters", "retrieveCollectionTypes", "retrieveColumnDefaults", "retrieveColumns", "retrieveComments", "retrieveConstraintColumns", "retrieveDependencies", "retrieveEntireSchema", "retrieveErrors", "retrieveForeignKeys", "retrieveFragment", "retrieveFragmentNewObjectNames", "retrieveIndices", "retrieveIndicesColumns", "retrieveInnerRoutines", "retrieveInnerRoutinesArguments", "retrieveKeys", "retrieveMain", "retrieveMain$intellij_database_introspection", "retrieveMainContent", "retrieveMatLogs", "retrieveMatViews", "retrieveObfuscatedSources", "", "Lcom/intellij/database/introspection/OraIntroQueries$OneObfuscatedSrc;", "retrieveObjectTypeAttributes", "retrieveObjectTypes", "retrievePackages", "retrieveProgramSources", "Lcom/intellij/database/introspection/OraIntroQueries$OneSrcLine;", "retrieveSchemaInfo", "retrieveSequences", "retrieveSingleRoutines", "retrieveSingleRoutinesArguments", "retrieveSources", "retrieveSynonyms", "retrieveTableClusterColumns", "retrieveTables", "retrieveTriggerSources", "Lcom/intellij/database/introspection/OraIntroQueries$OneTriggerSource;", "retrieveTriggers", "retrieveViewSources", "Lcom/intellij/database/introspection/OraIntroQueries$OneViewSource;", "retrieveViews", "seanceRelatedTablesAndViews", "", "Lcom/intellij/database/model/oracle/OraModLikeTable;", "trigTurnOf", "Lcom/intellij/database/model/TrigTurn;", "turn", "", "updateInvalidStatus", "family", "Lcom/intellij/database/model/basic/BasicModElement;", "invalids", "Lgnu/trove/TLongHashSet;", "intellij.database.introspection"})
    protected final class OraSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        @NotNull
        private Timestamp myFromTimestamp;
        @Nullable
        private Timestamp myBeginTimestamp;
        @Nullable
        private Timestamp srcFromTimestamp;
        private boolean affectsClusters;
        private boolean affectsTables;
        private boolean affectsMatLogs;
        private boolean affectsMatViews;
        private boolean affectsViews;
        private boolean affectsTriggers;
        private boolean affectsModulesOrBodies;
        private boolean haveDefaults;
        private boolean toStop;
        private final HashSet<OraLikeTable> tablesToReorderDetails;
        private final HashSet<OraCluster> affectedClusters;
        private final HashSet<OraModule> affectedModuleSpecs;
        private final HashSet<OraBody> affectedModuleBodies;
        private final HashSet<BasicRoutine> affectedInnerRoutines;
        private final HashSet<BasicRoutine> affectedSingleRoutines;
        private final HashSet<BasicSchemaObject> affectedDepObjects;
        private final HashSet<OraTable> affectedTables;

        @NotNull
        public final Timestamp getMyFromTimestamp$intellij_database_introspection() {
            return this.myFromTimestamp;
        }

        public final void setMyFromTimestamp$intellij_database_introspection(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.myFromTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getMyBeginTimestamp$intellij_database_introspection() {
            return this.myBeginTimestamp;
        }

        public final void setMyBeginTimestamp$intellij_database_introspection(@Nullable Timestamp timestamp) {
            this.myBeginTimestamp = timestamp;
        }

        @Nullable
        public final Timestamp getSrcFromTimestamp$intellij_database_introspection() {
            return this.srcFromTimestamp;
        }

        public final void setSrcFromTimestamp$intellij_database_introspection(@Nullable Timestamp timestamp) {
            this.srcFromTimestamp = timestamp;
        }

        public final boolean getAffectsClusters$intellij_database_introspection() {
            return this.affectsClusters;
        }

        public final void setAffectsClusters$intellij_database_introspection(boolean bl) {
            this.affectsClusters = bl;
        }

        public final boolean getAffectsTables$intellij_database_introspection() {
            return this.affectsTables;
        }

        public final void setAffectsTables$intellij_database_introspection(boolean bl) {
            this.affectsTables = bl;
        }

        public final boolean getAffectsMatLogs$intellij_database_introspection() {
            return this.affectsMatLogs;
        }

        public final void setAffectsMatLogs$intellij_database_introspection(boolean bl) {
            this.affectsMatLogs = bl;
        }

        public final boolean getAffectsMatViews$intellij_database_introspection() {
            return this.affectsMatViews;
        }

        public final void setAffectsMatViews$intellij_database_introspection(boolean bl) {
            this.affectsMatViews = bl;
        }

        public final boolean getAffectsViews$intellij_database_introspection() {
            return this.affectsViews;
        }

        public final void setAffectsViews$intellij_database_introspection(boolean bl) {
            this.affectsViews = bl;
        }

        public final boolean getAffectsTriggers$intellij_database_introspection() {
            return this.affectsTriggers;
        }

        public final void setAffectsTriggers$intellij_database_introspection(boolean bl) {
            this.affectsTriggers = bl;
        }

        public final boolean getAffectsModulesOrBodies$intellij_database_introspection() {
            return this.affectsModulesOrBodies;
        }

        public final void setAffectsModulesOrBodies$intellij_database_introspection(boolean bl) {
            this.affectsModulesOrBodies = bl;
        }

        public final boolean getHaveDefaults$intellij_database_introspection() {
            return this.haveDefaults;
        }

        public final void setHaveDefaults$intellij_database_introspection(boolean bl) {
            this.haveDefaults = bl;
        }

        public final boolean getToStop$intellij_database_introspection() {
            return this.toStop;
        }

        public final void setToStop$intellij_database_introspection(boolean bl) {
            this.toStop = bl;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(this.getFragmentKind$intellij_database_introspection());
            this.setQueryParameter("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter("major_object_names", this.getFragmentNames$intellij_database_introspection());
            this.setQueryParameter("src_since", this.srcFromTimestamp);
        }

        @Override
        public void process() {
            this.retrieveMain$intellij_database_introspection();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveMain$intellij_database_introspection();
        }

        public final void retrieveMain$intellij_database_introspection() {
            this.prepareParameters();
            if (this.getMode$intellij_database_introspection().fragment) {
                this.retrieveFragment();
            } else {
                this.retrieveEntireSchema();
            }
        }

        private final void retrieveEntireSchema() {
            boolean bl;
            boolean skipSystemSchema;
            boolean bl2 = skipSystemSchema = this.getMode$intellij_database_introspection().increment && OraIntrospectorFunctions.access$getSYSTEM_SCHEMAS$p().contains(((OraSchema)this.getSchema()).getName()) && !OraIntrospector.this.getConsiderSystemSchemasReinstrospection() && !((OraSchema)this.getSchema()).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            Timestamp beginTimestamp = (Timestamp)this.getTransaction().query(((OraIntrospector)OraIntrospector.this).queries.askForTimeNow).run();
            boolean bl3 = bl = beginTimestamp != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Failed to obtain the current timestamp from the database";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.myBeginTimestamp = beginTimestamp;
            this.reportRetrieving("schema information");
            this.retrieveSchemaInfo();
            if (this.toStop) {
                return;
            }
            Date modifiedTimestamp = ((OraSchema)this.getSchema()).getModifiedTimestamp();
            Timestamp srcFromTimestamp1 = this.srcFromTimestamp;
            boolean bl4 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp) && (!this.getWithSources$intellij_database_introspection() || srcFromTimestamp1 != null && !srcFromTimestamp1.before(modifiedTimestamp));
            if (this.toStop) {
                return;
            }
            this.retrieveSequences();
            this.retrieveObjectTypes();
            this.retrieveCollectionTypes();
            this.retrieveObjectTypeAttributes();
            this.retrieveClusters();
            this.retrieveTables();
            this.retrieveMatLogs();
            this.retrieveMatViews();
            this.retrieveViews();
            this.retrieveColumns();
            this.retrieveColumnDefaults();
            this.retrieveClusterIndices();
            this.retrieveTableClusterColumns();
            this.retrieveIndices();
            this.retrieveIndicesColumns();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveChecks();
            this.retrieveConstraintColumns();
            this.reorderTableDetails();
            this.retrieveTriggers();
            this.retrievePackages();
            this.retrieveInnerRoutines();
            this.retrieveInnerRoutinesArguments();
            this.adjustInnerRoutines();
            this.retrieveSingleRoutines();
            this.retrieveSingleRoutinesArguments();
            this.retrieveComments();
            this.retrieveDependencies();
            this.retrieveSources();
            this.retrieveErrors();
            this.reportRetrieving("finishing the schema...");
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(beginTimestamp){
                final /* synthetic */ Timestamp $beginTimestamp$inlined;
                {
                    this.$beginTimestamp$inlined = timestamp;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.$beginTimestamp$inlined);
                }
            });
            if (this.getWithSources$intellij_database_introspection()) {
                ((OraModModel)this.getModel()).setSchemaSourcesVersion((BasicSchema)this.getSchema(), beginTimestamp.getTime());
            }
        }

        private final void retrieveFragment() {
            this.retrieveFragmentNewObjectNames();
            this.determineAndRemoveDroppedStuff();
            ObjectKind objectKind = this.getFragmentKind$intellij_database_introspection();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                this.retrieveSequences();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CLUSTER)) {
                this.retrieveClusters();
                this.retrieveColumns();
                this.retrieveClusterIndices();
                this.retrieveTableClusterColumns();
                this.retrieveIndicesColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
                this.retrieveColumnDefaults();
                this.retrieveComments();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveChecks();
                this.retrieveConstraintColumns();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_LOG)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) {
                this.retrieveTables();
                this.retrieveMatLogs();
                this.retrieveMatViews();
                this.retrieveColumns();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveConstraintColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                this.retrieveViews();
                this.retrieveColumns();
                this.retrieveComments();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                this.retrieveSingleRoutines();
                this.retrieveSingleRoutinesArguments();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) {
                this.retrievePackages();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
                this.retrieveObjectTypes();
                this.retrieveObjectTypeAttributes();
                this.retrieveInnerRoutines();
                this.retrieveInnerRoutinesArguments();
                this.adjustInnerRoutines();
                this.retrieveDependencies();
                this.retrieveSources();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE)) {
                this.retrieveCollectionTypes();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                this.retrieveSynonyms();
            }
        }

        private final void retrieveFragmentNewObjectNames() {
            SqlQuery<String[]> listIdsQuery;
            ObjectKind fragmentKind = this.getFragmentKind$intellij_database_introspection();
            SqlQuery<String[]> sqlQuery = listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).queries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).queries.listFragmentRegularIds;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"listIdsQuery");
            String[] items = this.performQuery(sqlQuery);
            ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(this, items){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ String[] $items;

                public final void perform(OraModRoot root2) {
                    OraIntrospector oraIntrospector = this.this$0.OraIntrospector.this;
                    NamingIdentifyingFamily namingIdentifyingFamily = root2.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospector.access$processNames(oraIntrospector, this.$items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, true);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$items = stringArray;
                }
            });
        }

        private final void determineAndRemoveDroppedStuff() {
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(identifiers){
                final /* synthetic */ TLongHashSet $identifiers$inlined;
                {
                    this.$identifiers$inlined = tLongHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema s = (OraModSchema)MS;
                    OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers$inlined);
                }
            });
        }

        @Override
        protected void clearSchema() {
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;
                {
                    this.this$0 = oraSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.dropChildren();
                    schema2.setCreatedTimestamp(null);
                    schema2.setModifiedTimestamp(null);
                    schema2.setIntrospectionTimestamp(null);
                    ((OraModModel)this.this$0.getModel()).setSchemaSourcesVersion(schema2, null);
                }
            });
        }

        private final void retrieveSchemaInfo() {
            boolean schemaIsPublic = Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC");
            SqlQuery<OraIntroQueries.OneSchemaInfo> sqlQuery = schemaIsPublic ? ((OraIntrospector)OraIntrospector.this).queries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).queries.retrieveSchemaInfo;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (schemaIsPublic) quer\u2026ueries.retrieveSchemaInfo");
            OraIntroQueries.OneSchemaInfo info = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(info){
                final /* synthetic */ OraIntroQueries.OneSchemaInfo $info$inlined;
                {
                    this.$info$inlined = oneSchemaInfo;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setObjectId(this.$info$inlined.user_id);
                    schema2.setCreatedTimestamp(this.$info$inlined.created_timestamp);
                    schema2.setModifiedTimestamp(this.$info$inlined.modified_timestamp);
                }
            });
            this.setQueryParameter("SCHEMA_ID", info.user_id);
        }

        private final void retrieveSequences() {
            if (((OraSchema)this.getSchema()).getSequences().isEmpty()) {
                return;
            }
            this.reportRetrieving("Sequences");
            SqlQuery<List<OraIntroQueries.OneSequence>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSequences;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSequences");
            List<OraIntroQueries.OneSequence> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss$inlined = list;
                }

                /*
                 * Unable to fully structure code
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (OraModSchema)v0;
                    for (OraIntroQueries.OneSequence s : this.$ss$inlined) {
                        sequence = (OraModSequence)schema.getSequences().renew(s.object_id, s.sequence_name);
                        sequence.setSequenceIdentity(SequenceIdentity.of(OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.min_value), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.last_number), BigInteger.valueOf(s.increment_by), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.max_value)));
                        sequence.setOrdered(s.order_flag);
                        sequence.setCycled(s.cycle_flag);
                        v1 = s.cache_size;
                        sequence.setCacheSize(v1 != null ? v1 : 0);
                        sequence.setBelongsToColumn(s.generated);
                        if (!s.generated) ** GOTO lbl-1000
                        v2 = s.sequence_name;
                        v3 = OraIntrospectorFunctions.access$getSEQUENCE_SURROGATE_NAME_PATTERN$p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"SEQUENCE_SURROGATE_NAME_PATTERN");
                        if (BaseIntrospectionFunctions.matches(v2, v3)) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        sequence.setNameSurrogate(v4);
                        sequence.setCreatedTimestamp(s.created_timestamp);
                        sequence.setModifiedTimestamp(s.modified_timestamp);
                    }
                    schema.getSequences().sort();
                }
            });
        }

        private final BigInteger adjustBigIntegerForSequence(BigDecimal bigDecimalValue) {
            BigInteger bigInteger;
            String str;
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            switch (str = bi.toString()) {
                case "99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-99999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                case "-9999999999999999999999999999": {
                    bigInteger = null;
                    break;
                }
                default: {
                    bigInteger = bi;
                }
            }
            return bigInteger;
        }

        private final void retrieveObjectTypes() {
            if (((OraSchema)this.getSchema()).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Types");
            SqlQuery<List<OraIntroQueries.OneObjectType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypes");
            List<OraIntroQueries.OneObjectType> ots = this.performQuery(sqlQuery);
            if (ots.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ots){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ots$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ots$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneObjectType ot : this.$ots$inlined) {
                        OraModObjectType oType = (OraModObjectType)schema2.getObjectTypes().renew(ot.object_id, ot.type_name);
                        oType.setSuperSchemaName(ot.supertype_schema_name);
                        oType.setSuperObjectName(ot.supertype_name);
                        oType.setCreatedTimestamp(ot.created_timestamp);
                        oType.setModifiedTimestamp(ot.modified_timestamp);
                        oType.setIncomplete(ot.is_incomplete);
                        oType.setFinal(ot.is_final);
                        oType.setInstantiable(ot.is_instantiable);
                        if (ot.body_object_id != 0L) {
                            OraModObjectTypeBody body = (OraModObjectTypeBody)oType.getBodies().createOrGet();
                            body.setObjectId(ot.body_object_id);
                            body.setName(ot.type_name);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body, ot.body_created_timestamp, ot.body_modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body);
                        } else {
                            oType.getBodies().clear();
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(oType);
                        }
                        OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(oType);
                    }
                    schema2.getObjectTypes().sort();
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveCollectionTypes() {
            if (((OraSchema)this.getSchema()).getCollectionTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Collection Types");
            SqlQuery<List<OraIntroQueries.OneCollectionType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCollectionTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveCollectionTypes");
            List<OraIntroQueries.OneCollectionType> cts = this.performQuery(sqlQuery);
            if (cts.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cts){
                final /* synthetic */ List $cts$inlined;
                {
                    this.$cts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCollectionType ct : this.$cts$inlined) {
                        OraModCollectionType cType = (OraModCollectionType)schema2.getCollectionTypes().renew(ct.object_id, ct.type_name);
                        cType.setArray(ct.collection_kind == 'A');
                        cType.setUpperBound(ct.upper_bound);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema2, ct.data_type_schema_name, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                        cType.setElementType(type);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(cType, ct.created_timestamp, ct.modified_timestamp);
                    }
                    schema2.getCollectionTypes().sort();
                }
            });
        }

        private final void retrieveObjectTypeAttributes() {
            if (((OraSchema)this.getSchema()).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Type Attributes");
            SqlQuery<List<OraIntroQueries.OneObjectTypeAttribute>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypeAttributes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypeAttributes");
            List<OraIntroQueries.OneObjectTypeAttribute> attrs = this.performQuery(sqlQuery);
            if (attrs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(attrs){
                final /* synthetic */ List $attrs$inlined;
                {
                    this.$attrs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    HashSet<OraModObjectType> affectedObjectTypes = new HashSet<OraModObjectType>(schema2.getObjectTypes().size());
                    for (OraIntroQueries.OneObjectTypeAttribute ota : this.$attrs$inlined) {
                        OraModObjectType ot = (OraModObjectType)schema2.getObjectTypes().createOrGet(ota.type_name);
                        OraModObjectTypeAttribute attr = (OraModObjectTypeAttribute)ot.getAttributes().createOrGet(ota.attr_name);
                        attr.setPosition(ota.position);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema2, ota.data_type_schema, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                        attr.setDataType(type);
                        affectedObjectTypes.add(ot);
                    }
                    for (OraModObjectType objectType : affectedObjectTypes) {
                        objectType.getAttributes().sort();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveClusters() {
            void cs;
            if (((OraSchema)this.getSchema()).getClusters().isEmpty()) {
                return;
            }
            this.reportRetrieving("Clusters");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = CollectionsKt.emptyList();
            boolean ora31603 = false;
            try {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusters;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClusters");
                cs.element = this.performQuery(sqlQuery);
            }
            catch (DBException e) {
                if (e.vendorErrorCode == 31603) {
                    ora31603 = true;
                    String schemaName = ((OraSchema)this.getSchema()).getName();
                    OraIntrospector.this.getLog().warn("Oracle schema " + schemaName + ": Unable to retrieve CLUSTER details because the user has no SELECT_CATALOG_ROLE.");
                    Notification notification = new Notification("Oracle Introspector Unable To Retrieve Cluster Details", AllIcons.Ide.Notification.WarningEvents, "Cluster details not retrieved", null, "Oracle Introspector is unable to retrieve details of clusters in schema " + schemaName + ".\n" + "In order to retrieve these details, grant the user the SELECT_CATALOG_ROLE, " + "then re-sync the data source again (use the 'Forget Cached Schemas' action).", NotificationType.WARNING, null);
                    Notifications.Bus.notify((Notification)notification);
                }
                throw (Throwable)e;
            }
            if (ora31603) {
                SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClustersWhenNoPermissions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClustersWhenNoPermissions");
                cs.element = this.performQuery(sqlQuery);
            }
            if (((List)cs.element).isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, (Ref.ObjectRef)cs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Ref.ObjectRef $cs$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cs$inlined = objectRef;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCluster c : (List)this.$cs$inlined.element) {
                        OraModCluster cluster;
                        OraModCluster oraModCluster = cluster = (OraModCluster)schema2.getClusters().createOrGet(c.id);
                        Intrinsics.checkExpressionValueIsNotNull((Object)oraModCluster, (String)"cluster");
                        OraSchemaRetriever.access$applyClusterInfo(this.this$0, oraModCluster, c);
                        OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(cluster);
                    }
                }
            });
            this.affectsClusters = true;
        }

        private final void applyClusterInfo(OraModCluster cluster, OraIntroQueries.OneCluster c) {
            String string;
            cluster.setClusterType(ClusterType.of((char)c.type_code));
            cluster.setSingleTable(c.single_table);
            cluster.setBlockSize(c.block_size);
            OraModCluster oraModCluster = cluster;
            String string2 = c.hash_expression;
            if (string2 != null) {
                String string3 = string2;
                OraModCluster oraModCluster2 = oraModCluster;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                oraModCluster = oraModCluster2;
                string = string5;
            } else {
                string = null;
            }
            oraModCluster.setHashExpression(string);
            cluster.setHashCardinality(c.hash_cardinality);
            cluster.setTablespaceName(c.tablespace_name);
            String decompiled_text = c.decompiled_text;
            if (decompiled_text != null) {
                String string6 = c.decompiled_text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"c.decompiled_text");
                this.extractClusterColumns(cluster, string6);
            }
        }

        private final void extractClusterColumns(OraModCluster cluster, String text2) {
            SqlStatement sqlStatement;
            PositioningNamingFamily columns2 = cluster.getColumns();
            OraSchemaRetriever this_$iv = this;
            try {
                sqlStatement = (SqlStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this_$iv.OraIntrospector.this.sqlReader.getReadOnlyPsi(this_$iv.OraIntrospector.this.sqlLanguageDialect, (CharSequence)text2))).expandAndSkip((Condition)parseStatement.1.INSTANCE)).filter(SqlCreateStatement.class).first();
            }
            catch (Exception e$iv) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this_$iv.OraIntrospector.this.getLog().error((Throwable)e$iv);
                }
                this_$iv.OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e$iv);
                sqlStatement = null;
            }
            SqlCreateStatement statement = (SqlCreateStatement)sqlStatement;
            if (statement == null || Intrinsics.areEqual((Object)statement.getKind(), (Object)ObjectKind.CLUSTER) ^ true) {
                columns2.clear();
                return;
            }
            columns2.markChildrenAsSyncPending();
            JBIterable parsedColumns = statement.getDasChildren(ObjectKind.COLUMN);
            for (DasObject c : parsedColumns) {
                OraModClusterColumn column2 = (OraModClusterColumn)columns2.createOrGet(c.getName());
                OraIntrospector.this.sqlObjectBuilder.partialBuild((DasObject)column2, c);
            }
            columns2.removeSyncPendingChildren();
            columns2.sort();
        }

        private final void retrieveTables() {
            if (((OraSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTables;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(sqlQuery);
            if (tabs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, tabs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $tabs$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$tabs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneTable tab : this.$tabs$inlined) {
                        TableOrganization tableOrganization;
                        String tableName = tab.table_name;
                        OraModTable table = (OraModTable)schema2.getTables().renew(tab.object_id, tableName);
                        table.setMasterTableName(tab.master_table_name);
                        table.setClusterName(tab.cluster_name);
                        table.setTemporary(tab.is_temp);
                        table.setTemporaryPreserve(tab.is_temp_preserved);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(table, tab.created_timestamp, tab.modified_timestamp);
                        OraModCluster cluster = tab.cluster_name != null ? (OraModCluster)schema2.getClusters().get(tab.cluster_name) : null;
                        boolean clusterIsIndexed = cluster != null && cluster.getHashCardinality() == 0;
                        switch (tab.organization_kind) {
                            case 'I': {
                                tableOrganization = TableOrganization.INDEX;
                                break;
                            }
                            case 'C': {
                                if (clusterIsIndexed) {
                                    tableOrganization = TableOrganization.ORA_CLUSTERED_BY_INDEX;
                                    break;
                                }
                                tableOrganization = TableOrganization.ORA_CLUSTERED_BY_HASH;
                                break;
                            }
                            default: {
                                tableOrganization = TableOrganization.DEFAULT;
                            }
                        }
                        table.setOrganization(tableOrganization);
                        table.setRowTypeSchemaName(tab.row_type_schema_name);
                        table.setRowTypeObjectName(tab.row_type_name);
                        table.setTableType(tab.is_mat_log ? OraTableType.MAT_LOG : (tab.is_mat_view ? OraTableType.MAT_VIEW : OraTableType.BASIC));
                        table.setNameSurrogate(tab.is_mat_log);
                        if (tab.has_mat_log) {
                            table.getMatLogs().createOrGet();
                        } else {
                            table.getMatLogs().clear();
                        }
                        table.getChecks().clear();
                        table.getForeignKeys().clear();
                        table.getKeys().clear();
                        OraSchemaRetriever.access$getAffectedTables$p(this.this$0).add(table);
                        this.this$0.setAffectsMatLogs$intellij_database_introspection(this.this$0.getAffectsMatLogs$intellij_database_introspection() || tab.is_mat_log || tab.has_mat_log);
                        this.this$0.setAffectsMatViews$intellij_database_introspection(this.this$0.getAffectsMatViews$intellij_database_introspection() || tab.is_mat_view);
                    }
                    schema2.getTables().sort();
                }
            });
            this.affectsTables = true;
        }

        private final void retrieveMatLogs() {
            if (!this.affectsMatLogs) {
                return;
            }
            this.reportRetrieving("Materialized Logs");
            SqlQuery<List<OraIntroQueries.OneMatLog>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatLogs;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatLogs");
            List<OraIntroQueries.OneMatLog> mls = this.performQuery(sqlQuery);
            if (mls.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(mls){
                final /* synthetic */ List $mls$inlined;
                {
                    this.$mls$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneMatLog m : this.$mls$inlined) {
                        OraModTable table;
                        if ((OraModTable)schema2.getTables().get(m.table_name) == null) {
                            continue;
                        }
                        OraModMatLog ml = (OraModMatLog)table.getMatLogs().createOrGet();
                        ml.setName(m.log_name);
                        ml.setNameSurrogate(true);
                        ml.setWithRowId(m.with_rowid);
                        ml.setWithObjectId(m.with_object_id);
                        ml.setWithPrimaryKey(m.with_primary_key);
                        ml.setWithSequence(m.with_sequence);
                        ml.setWithNewValues(m.with_new_values);
                    }
                }
            });
        }

        private final void retrieveMatViews() {
            if (((OraSchema)this.getSchema()).getMatViews().isEmpty() && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Materialized Views");
            SqlQuery<List<OraIntroQueries.OneMatView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveMatViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveMatViews");
            List<OraIntroQueries.OneMatView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneMatView v : this.$vs$inlined) {
                        OraModMatView view = (OraModMatView)schema2.getMatViews().renew(v.object_id, v.view_name);
                        view.setPrebuilt(v.prebuilt);
                        view.setModifiable(v.modifiable);
                        view.setRefreshMode(OraMatViewRefreshMode.byCode(v.refresh_mode));
                        view.setRefreshMethod(OraMatViewRefreshMethod.byCode(v.refresh_method));
                        view.setInvalid(v.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view, v.created_timestamp, v.modified_timestamp);
                        if (Intrinsics.areEqual((Object)((Object)this.this$0.getMode$intellij_database_introspection()), (Object)((Object)IntrospectionMode.INCREMENT))) {
                            OraModTable oraModTable = (OraModTable)schema2.getTables().get(v.view_name);
                            if (oraModTable != null) {
                                oraModTable.setTableType(OraTableType.MAT_VIEW);
                            }
                        }
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
            });
            this.affectsMatViews = true;
        }

        private final void retrieveViews() {
            if (((OraSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViews");
            List<OraIntroQueries.OneView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneView v : this.$vs$inlined) {
                        OraModView view = (OraModView)schema2.getViews().renew(v.object_id, v.view_name);
                        view.setModifiable(v.modifiable);
                        view.setInvalid(v.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view, v.created_timestamp, v.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view);
                    }
                }
            });
            this.affectsViews = true;
        }

        private final void retrieveColumns() {
            this.haveDefaults = false;
            if (!(this.affectsClusters || this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            SqlQuery<List<OraIntroQueries.OneColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumns");
            List<OraIntroQueries.OneColumn> cols = this.performQuery(sqlQuery);
            if (cols.isEmpty()) {
                return;
            }
            HashSet affectedTables = new HashSet();
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cols, affectedTables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cols$inlined;
                final /* synthetic */ HashSet $affectedTables$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cols$inlined = list;
                    this.$affectedTables$inlined = hashSet;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (OraModSchema)v0;
                    major = null;
                    major_id = -9223372036854775808L;
                    for (OraIntroQueries.OneColumn col : this.$cols$inlined) {
                        block10: {
                            if (col.major_id == major_id) break block10;
                            var8_7 = schema;
                            objectId$iv = col.major_id;
                            v1 /* !! */  = $receiver$iv.getDatabase();
                            if (v1 /* !! */  == null) ** GOTO lbl-1000
                            $receiver$iv$iv = v1 /* !! */ ;
                            v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v2 instanceof OraModMajorObject)) {
                                v2 = null;
                            }
                            if ((v1 /* !! */  = (OraModMajorObject)v2) != null) {
                                $receiver$iv$iv = v1 /* !! */ ;
                                v3 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 /* !! */  = major = null;
                            }
                            if (major == null) continue;
                            major_id = col.major_id;
                            $receiver$iv = major;
                            if (!($receiver$iv instanceof OraModLikeTable)) continue;
                            ((OraModLikeTable)major).getColumns().markChildrenAsSyncPending();
                            this.$affectedTables$inlined.add(major);
                        }
                        v4 = $receiver$iv = major != null;
                        if (_Assertions.ENABLED && !$receiver$iv) {
                            var13_13 = "Assertion failed";
                            throw (Throwable)new AssertionError(var13_13);
                        }
                        var13_13 = major;
                        if (!(var13_13 instanceof OraModLikeTable)) continue;
                        tableColumns = ((OraModLikeTable)major).getColumns();
                        v5 = tableColumns.createOrGet(col.column_name);
                        Intrinsics.checkExpressionValueIsNotNull(v5, (String)"tableColumns.createOrGet(col.column_name)");
                        column = (OraModInfraColumn)v5;
                        column.resetSyncPending();
                        column.setPosition(col.column_position);
                        type = OraIntrospectorFunctions.access$makeDataType(schema, col.data_type_schema_name, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                        column.setDataType(type);
                        if (column instanceof OraModLikeColumn) {
                            ((OraModLikeColumn)column).setNotNull(col.mandatory);
                        }
                        if (!(column instanceof OraModTableColumn)) continue;
                        ((OraModTableColumn)column).setAutoInc(col.identity_column);
                        ((OraModTableColumn)column).setDefaultOnNull(col.default_on_null);
                        if (col.has_default_expression && !col.identity_column) {
                            this.this$0.setHaveDefaults$intellij_database_introspection(true);
                            continue;
                        }
                        ((OraModTableColumn)column).setDefaultExpression(null);
                    }
                    if (this.this$0.getMode$intellij_database_introspection().increment || this.this$0.getMode$intellij_database_introspection().fragment) {
                        var6_5 = this.$affectedTables$inlined.iterator();
                        while (var6_5.hasNext()) {
                            v6 = affectedTable = (OraLikeTable)var6_5.next();
                            if (v6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModLikeTable");
                            }
                            ((OraModLikeTable)v6).getColumns().removeSyncPendingChildren();
                        }
                    }
                }
            });
            this.tablesToReorderDetails.addAll(affectedTables);
        }

        private final void retrieveColumnDefaults() {
            if (!this.haveDefaults) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            SqlQuery<List<OraIntroQueries.OneColumnDefault>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumnDefaults;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumnDefaults");
            List<OraIntroQueries.OneColumnDefault> rows = this.performQuery(sqlQuery);
            if (rows.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(rows){
                final /* synthetic */ List $rows$inlined;
                {
                    this.$rows$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneColumnDefault col : this.$rows$inlined) {
                        OraModTableColumn column2;
                        OraModTable table;
                        if ((OraModTable)schema2.getTables().get(col.table_name) == null) {
                            continue;
                        }
                        if ((OraModTableColumn)table.getColumns().get(col.column_name) == null) {
                            continue;
                        }
                        column2.setDefaultExpression(col.default_expression);
                    }
                }
            });
        }

        private final void retrieveClusterIndices() {
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery;
            if (((OraSchema)this.getSchema()).getClusters().isEmpty()) {
                return;
            }
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesFast;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> query = sqlQuery;
            this.reportRetrieving("Cluster Indices");
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery2 = query;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneClusterIndex> inds = this.performQuery(sqlQuery2);
            if (inds.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, inds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $inds$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$inds$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneClusterIndex ind : this.$inds$inlined) {
                        OraModCluster cluster;
                        if ((OraModCluster)schema2.getClusters().get(ind.cluster_name) == null) {
                            continue;
                        }
                        OraModClusterIndex index = (OraModClusterIndex)cluster.getIndices().createOrGet();
                        index.setObjectId(ind.index_id);
                        index.setName(ind.index_name);
                        CharSequence charSequence = ind.index_name;
                        Pattern pattern = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_NAME_PATTERN");
                        index.setNameSurrogate(BaseIntrospectionFunctions.matches(charSequence, pattern));
                        index.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index, ind.created_timestamp, ind.modified_timestamp);
                        if (!this.this$0.getMode$intellij_database_introspection().fragment) continue;
                        index.setColNames(CollectionsKt.emptyList());
                    }
                }
            });
        }

        private final void retrieveTableClusterColumns() {
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> query;
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery;
            if (((OraSchema)this.getSchema()).getClusters().isEmpty() || this.affectedTables.isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables' clustered columns");
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsAdmin;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTableClusterColumnsUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneTableClusterColumn>> sqlQuery2 = query = sqlQuery;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneTableClusterColumn> cols = this.performQuery(sqlQuery2);
            if (cols.isEmpty()) {
                return;
            }
            StringListAggregator g = new StringListAggregator();
            for (OraIntroQueries.OneTableClusterColumn col : cols) {
                String string = col.table_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col.table_name");
                String string2 = col.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"col.column_name");
                g.add(string, string2);
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(g){
                final /* synthetic */ StringListAggregator $g$inlined;
                {
                    this.$g$inlined = stringListAggregator;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Map<K, CV> map2 = this.$g$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String tableName = (String)entry2.getKey();
                        entry2 = entry;
                        List colNames = (List)entry2.getValue();
                        OraModTable oraModTable = (OraModTable)schema2.getTables().get(tableName);
                        if (oraModTable == null) continue;
                        oraModTable.setClusterColNames(colNames);
                    }
                }
            });
        }

        private final void retrieveIndices() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Indices");
            SqlQuery<List<OraIntroQueries.OneIndex>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndices");
            List<OraIntroQueries.OneIndex> indices = this.performQuery(sqlQuery);
            if (indices.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, indices){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $indices$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$indices$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneIndex ind : this.$indices$inlined) {
                        OraModTable table;
                        if ((OraModTable)schema2.getTables().get(ind.table_name) == null) {
                            continue;
                        }
                        OraModIndex index = (OraModIndex)table.getIndices().renew(ind.object_id, ind.index_name);
                        CharSequence charSequence = ind.index_name;
                        Pattern pattern = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_NAME_PATTERN");
                        index.setNameSurrogate(BaseIntrospectionFunctions.matches(charSequence, pattern) || Intrinsics.areEqual((Object)((Object)table.getTableType()), (Object)((Object)OraTableType.MAT_VIEW)));
                        index.setUnique(ind.uniqueness);
                        index.setClustering(ind.clustering);
                        index.setFunctionBased(ind.function_based);
                        index.setBitmap(ind.bitmap);
                        index.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index, ind.created_timestamp, ind.modified_timestamp);
                        if (this.this$0.getMode$intellij_database_introspection().fragment) {
                            index.setColNames(CollectionsKt.emptyList());
                        }
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
            });
        }

        private final void retrieveIndicesColumns() {
            StringListAggregator stringListAggregator;
            String string;
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndicesColumns");
            List<OraIntroQueries.OneIndexItem> ics = this.performQuery(sqlQuery);
            if (ics.isEmpty()) {
                return;
            }
            StringListAggregator columns2 = new StringListAggregator();
            boolean hasExpressions = false;
            for (OraIntroQueries.OneIndexItem ic : ics) {
                String key2 = ic.table_name + '\uffff' + ic.index_name;
                String string2 = ic.item;
                if (string2 == null) {
                    string2 = "???[" + ic.column_position + ']';
                }
                String item = string2;
                char c = ic.direction;
                string = key2;
                stringListAggregator = columns2;
                String string3 = String.valueOf(c) + item;
                stringListAggregator.add(string, string3);
                CharSequence charSequence = item;
                Pattern pattern = OraIntrospectorFunctions.access$getINDEX_EXPRESSION_STUB_PATTERN$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"INDEX_EXPRESSION_STUB_PATTERN");
                boolean isExpression = BaseIntrospectionFunctions.matches(charSequence, pattern);
                hasExpressions = hasExpressions || isExpression;
            }
            if (hasExpressions) {
                SqlQuery<List<OraIntroQueries.OneIndexItem>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesExpressions;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveIndicesExpressions");
                List<OraIntroQueries.OneIndexItem> ies = this.performQuery(sqlQuery2);
                for (OraIntroQueries.OneIndexItem ie : ies) {
                    String string4;
                    String key3 = ie.table_name + '\uffff' + ie.index_name;
                    short position = ie.column_position;
                    char c = ie.direction;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ie.item, (String)"ie.item");
                    int n = position - 1;
                    string = key3;
                    stringListAggregator = columns2;
                    String string5 = String.valueOf(c) + string4;
                    stringListAggregator.set(string, n, string5);
                }
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, columns2){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $columns$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$columns$inlined = stringListAggregator;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Map<K, CV> map2 = this.$columns$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraModIndex index;
                        String indexName;
                        OraModTable table;
                        String tableName;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String key2 = (String)entry2.getKey();
                        entry2 = entry;
                        List items = (List)entry2.getValue();
                        int d_pos = StringsKt.indexOf$default((CharSequence)key2, (char)'\uffff', (int)0, (boolean)false, (int)6, null);
                        if (d_pos < 0) continue;
                        String string = key2;
                        int n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, d_pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = key2;
                        int n2 = d_pos + 1;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        if ((OraModTable)schema2.getTables().get(tableName) == null) {
                            continue;
                        }
                        if ((OraModIndex)table.getIndices().get(indexName) == null) {
                            continue;
                        }
                        OraSchemaRetriever.access$applyIndexingItems(this.this$0, table, index, items);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
            });
        }

        private final void applyIndexingItems(BasicTable table, OraModIndex index, List<String> items) {
            int n = items.size();
            if (n == 0) {
                index.setColNames(CollectionsKt.emptyList());
                index.setReverseColNames(SetsKt.emptySet());
                return;
            }
            if (index.isFunctionBased()) {
                ArrayList<String> expressions = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                TreeSet tableColumnNames = new TreeSet(table.getColumns().getNames());
                for (String item : items) {
                    String string;
                    if (item.length() < 2) continue;
                    String string2 = item;
                    int n2 = 1;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String c = OraIntrospectorFunctions.access$unquoteNameIfPossible(string4);
                    boolean isColumn = tableColumnNames.contains(c);
                    if (isColumn) {
                        string = c;
                    } else {
                        char c2 = '\u001b';
                        string = String.valueOf(c2) + c;
                    }
                    String x = string;
                    expressions.add(x);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(x);
                }
                index.setColNames((List<String>)expressions);
                Collection collection = reverse;
                OraModIndex oraModIndex = index;
                boolean bl = !collection.isEmpty();
                oraModIndex.setReverseColNames(bl ? (Set)reverse : SetsKt.emptySet());
            } else {
                ArrayList<String> columns2 = new ArrayList<String>(n);
                TreeSet<String> reverse = new TreeSet<String>();
                for (String item : items) {
                    String c;
                    if (item.length() < 2) continue;
                    String string = item;
                    int n3 = 1;
                    String string5 = string;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                    columns2.add(c);
                    if (item.charAt(0) != '-') continue;
                    reverse.add(c);
                }
                index.setColNames((List<String>)columns2);
                Collection collection = reverse;
                OraModIndex oraModIndex = index;
                boolean bl = !collection.isEmpty();
                oraModIndex.setReverseColNames(bl ? (Set)reverse : SetsKt.emptySet());
            }
        }

        private final void retrieveKeys() {
            if (!this.affectsTables && !this.affectsMatViews) {
                return;
            }
            this.reportRetrieving("Keys");
            SqlQuery<List<OraIntroQueries.OneKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveKeys");
            List<OraIntroQueries.OneKey> keys = this.performQuery(sqlQuery);
            if (keys.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(keys){
                final /* synthetic */ List $keys$inlined;
                {
                    this.$keys$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneKey k : this.$keys$inlined) {
                        if (k.table_name == null || k.constraint_name == null) continue;
                        OraModTable table = (OraModTable)schema2.getTables().createOrGet(k.table_name);
                        OraModKey key2 = (OraModKey)table.getKeys().createOrGet(k.constraint_name);
                        key2.setColNames(CollectionsKt.emptyList());
                        key2.setNameSurrogate(k.is_surrogate_name);
                        key2.setPrimary(k.is_pk);
                        key2.setDeferrable(k.is_deferrable);
                        key2.setInitiallyDeferred(k.is_initially_deferred);
                        key2.setModifiedTimestamp(k.modified_timestamp);
                        key2.setUnderlyingIndexName(k.index_name);
                    }
                }
            });
        }

        private final void retrieveForeignKeys() {
            SqlQuery<List<OraIntroQueries.OneForeignKey>> query;
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            SqlQuery<List<OraIntroQueries.OneForeignKey>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeysSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneForeignKey> fks = this.performQuery(sqlQuery);
            if (fks.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(fks){
                final /* synthetic */ List $fks$inlined;
                {
                    this.$fks$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    OraModRoot database = schema2.getParent();
                    for (OraIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        CascadeRule cascadeRule;
                        OraModTable table;
                        if ((fk.table_id > 0L ? (OraModTable)schema2.getTables().getByObjectId(fk.table_id) : (OraModTable)schema2.getTables().get(fk.table_name)) == null) {
                            continue;
                        }
                        table = table;
                        OraModForeignKey fkey = (OraModForeignKey)table.getForeignKeys().createOrGet(fk.constraint_name);
                        fkey.setColNames(CollectionsKt.emptyList());
                        String string = fk.ref_schema_name;
                        if (string == null) {
                            OraModSchema oraModSchema = (OraModSchema)database.getSchemas().getByObjectId(fk.ref_schema_id);
                            string = oraModSchema != null ? oraModSchema.getName() : null;
                        }
                        fkey.setRefSchemaName(string);
                        fkey.setRefTableName(fk.ref_table_name);
                        fkey.setRefKeyName(fk.ref_key_name);
                        fkey.setNameSurrogate(fk.is_surrogate_name);
                        fkey.setDeferrable(fk.is_deferrable);
                        fkey.setInitiallyDeferred(fk.is_initially_deferred);
                        switch (fk.cascade_rule) {
                            case 'C': {
                                cascadeRule = CascadeRule.cascade;
                                break;
                            }
                            case 'N': {
                                cascadeRule = CascadeRule.set_null;
                                break;
                            }
                            default: {
                                cascadeRule = CascadeRule.restrict;
                            }
                        }
                        fkey.setOnDelete(cascadeRule);
                        fkey.setModifiedTimestamp(fk.modified_timestamp);
                    }
                }
            });
        }

        private final void retrieveChecks() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            SqlQuery<List<OraIntroQueries.OneCheck>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveChecks;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveChecks");
            List<OraIntroQueries.OneCheck> cks = this.performQuery(sqlQuery);
            if (cks.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cks){
                final /* synthetic */ List $cks$inlined;
                {
                    this.$cks$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCheck ck : this.$cks$inlined) {
                        if (ck.predicate == null || ck.is_surrogate_name && OraIntrospectorFunctions.access$getAUTO_NOT_NULL_CHECK_PATTERN$p().matcher(ck.predicate).matches()) continue;
                        OraModTable table = (OraModTable)schema2.getTables().createOrGet(ck.table_name);
                        OraModCheck check = (OraModCheck)table.getChecks().createOrGet(ck.constraint_name);
                        check.setColNames(CollectionsKt.emptyList());
                        check.setNameSurrogate(ck.is_surrogate_name);
                        check.setPredicate(ck.predicate);
                        check.setModifiedTimestamp(ck.modified_timestamp);
                    }
                }
            });
        }

        private final void retrieveConstraintColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneConstraintColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveConstraintColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveConstraintColumns");
            List<OraIntroQueries.OneConstraintColumn> ccs = this.performQuery(sqlQuery);
            if (ccs.isEmpty()) {
                return;
            }
            StringListAggregator agg = new StringListAggregator();
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                String key2 = cc.table_name + '\uffff' + cc.constraint_name;
                String string = cc.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cc.column_name");
                agg.add(key2, string);
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, agg){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $agg$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$agg$inlined = stringListAggregator;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Map<K, CV> map2 = this.$agg$inlined.getResult();
                    for (Map.Entry<K, CV> entry : map2.entrySet()) {
                        OraModConstraint constraint;
                        OraModTable table;
                        void tableName;
                        Object object = entry;
                        String key2 = (String)object.getKey();
                        object = entry;
                        List colNames = (List)object.getValue();
                        Object object2 = StringFunKt.unPair(key2, '\uffff');
                        object = (String)object2.component1();
                        String constraintName = (String)object2.component2();
                        object2 = (CharSequence)tableName;
                        if (object2.length() == 0 || (object2 = (CharSequence)constraintName).length() == 0) continue;
                        if ((OraModTable)schema2.getTables().get((String)tableName) == null) {
                            continue;
                        }
                        if (OraIntrospectorFunctions.access$findModConstraint(table, constraintName) == null) {
                            continue;
                        }
                        constraint.setColNames(colNames);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
            });
        }

        private final void reorderTableDetails() {
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;
                {
                    this.this$0 = oraSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraLikeTable table : OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0)) {
                        OraLikeTable oraLikeTable = table;
                        if (oraLikeTable instanceof OraModTable) {
                            ((OraModTable)table).getColumns().sort();
                            ((OraModTable)table).getIndices().sort();
                            ((OraModTable)table).getKeys().sort();
                            ((OraModTable)table).getForeignKeys().sort();
                            ((OraModTable)table).getChecks().sort();
                            continue;
                        }
                        if (!(oraLikeTable instanceof OraModLikeTable)) continue;
                        ((OraModLikeTable)table).getColumns().sort();
                    }
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers() {
            void also_retrieve_update_columns;
            if (!(this.affectsTables || this.affectsMatViews || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Triggers");
            SqlQuery<List<OraIntroQueries.OneTrigger>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggers");
            List<OraIntroQueries.OneTrigger> ts2 = this.performQuery(sqlQuery);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet tables = new HashSet(ts2.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ts2, (Ref.BooleanRef)also_retrieve_update_columns, tables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ts$inlined;
                final /* synthetic */ Ref.BooleanRef $also_retrieve_update_columns$inlined;
                final /* synthetic */ HashSet $tables$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ts$inlined = list;
                    this.$also_retrieve_update_columns$inlined = booleanRef;
                    this.$tables$inlined = hashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneTrigger trig : this.$ts$inlined) {
                        OraModLikeTable table;
                        String string = trig.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                            continue;
                        }
                        OraModTrigger trigger = (OraModTrigger)table.getTriggers().renew(trig.trigger_id, trig.trigger_name);
                        trigger.setEvents(TrigEvent.of((String)trig.events));
                        trigger.setTurn(OraSchemaRetriever.access$trigTurnOf(this.this$0, trig.turn));
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(trigger, trig.created_timestamp, trig.modified_timestamp);
                        if (trigger instanceof OraModTableTrigger) {
                            ((OraModTableTrigger)trigger).setCondition(StringKt.nullize((String)trig.condition, (boolean)true));
                        }
                        this.$also_retrieve_update_columns$inlined.element |= trig.has_on_update_columns;
                        this.$tables$inlined.add(table);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(trigger);
                    }
                }
            });
            if (also_retrieve_update_columns.element) {
                SqlQuery<List<String[]>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerUpdateColumns;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveTriggerUpdateColumns");
                List<String[]> cols = this.performQuery(sqlQuery2);
                StringListAggregator columns2 = new StringListAggregator();
                for (String[] col : cols) {
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null) continue;
                    String key2 = tableName + '\uffff' + triggerName;
                    columns2.add(key2, columnName);
                }
                OraSchemaRetriever this_$iv2 = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(columns2){
                    final /* synthetic */ StringListAggregator $columns$inlined;
                    {
                        this.$columns$inlined = stringListAggregator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        OraModSchema schema2 = (OraModSchema)MS;
                        Map<K, CV> map2 = this.$columns$inlined.getResult();
                        for (Map.Entry<K, CV> entry : map2.entrySet()) {
                            OraModTrigger trigger;
                            OraModLikeTable table;
                            void tableName;
                            Object object = entry;
                            String key2 = (String)object.getKey();
                            object = entry;
                            List names = (List)object.getValue();
                            Object object2 = StringFunKt.unPair(key2, '\uffff');
                            object = (String)object2.component1();
                            String triggerName = (String)object2.component2();
                            object2 = (CharSequence)tableName;
                            if (object2.length() == 0 || (object2 = (CharSequence)triggerName).length() == 0) continue;
                            if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, (String)tableName) == null) {
                                continue;
                            }
                            if ((OraModTrigger)table.getTriggers().get(triggerName) == null) {
                                continue;
                            }
                            trigger.setColNames(names);
                        }
                    }
                });
            }
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(tables){
                final /* synthetic */ HashSet $tables$inlined;
                {
                    this.$tables$inlined = hashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraModLikeTable table : this.$tables$inlined) {
                        table.getTriggers().sort();
                    }
                }
            });
            this.affectsTriggers = true;
        }

        private final TrigTurn trigTurnOf(short turn) {
            TrigTurn trigTurn;
            switch (turn) {
                case -2: {
                    trigTurn = TrigTurn.BEFORE_STMT;
                    break;
                }
                case -1: {
                    trigTurn = TrigTurn.BEFORE_ROW;
                    break;
                }
                case 1: {
                    trigTurn = TrigTurn.AFTER_ROW;
                    break;
                }
                case 2: {
                    trigTurn = TrigTurn.AFTER_STMT;
                    break;
                }
                case 0: {
                    trigTurn = TrigTurn.INSTEAD_OF;
                    break;
                }
                default: {
                    trigTurn = null;
                }
            }
            return trigTurn;
        }

        private final void retrievePackages() {
            if (((OraSchema)this.getSchema()).getPackages().isEmpty()) {
                return;
            }
            this.reportRetrieving("Packages");
            SqlQuery<List<OraIntroQueries.OnePackage>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePackages;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrievePackages");
            List<OraIntroQueries.OnePackage> packages = this.performQuery(sqlQuery);
            if (packages.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, packages){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $packages$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$packages$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OnePackage p : this.$packages$inlined) {
                        OraModPackage pack;
                        if (!p.is_body) {
                            pack = (OraModPackage)schema2.getPackages().renew(p.object_id, p.package_name);
                            pack.setInvalid(p.is_invalid);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(pack, p.created_timestamp, p.modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).add(pack);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(pack);
                            continue;
                        }
                        pack = (OraModPackage)schema2.getPackages().createOrGet(p.package_name);
                        OraModPackageBody body = (OraModPackageBody)pack.getBodies().createOrGet();
                        body.setObjectId(p.object_id);
                        body.setInvalid(p.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body, p.created_timestamp, p.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedModuleBodies$p(this.this$0).add(body);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body);
                    }
                    schema2.getPackages().sort();
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveInnerRoutines() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutines");
            List<OraIntroQueries.OneInnerRoutine> routines = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModModule");
                        }
                        ((OraModModule)oraModule).getRoutines().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutine r : this.$routines$inlined) {
                        OraModModule module = null;
                        if (r.module_kind == 'T' || r.module_kind == 'Z') {
                            module = (OraModModule)schema2.getObjectTypes().get(r.module_name);
                        }
                        if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                            module = (OraModModule)schema2.getPackages().get(r.module_name);
                        }
                        if (module == null) continue;
                        OraModInnerRoutine routine = (OraModInnerRoutine)module.getRoutines().createOrGet(r.routine_name);
                        routine.setDeterministic(r.is_deterministic);
                        OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0).add(routine);
                    }
                    boolean toReorder = this.this$0.OraIntrospector.this.getServerVersion().get(0) < 11;
                    Iterator<E> iterator2 = OraSchemaRetriever.access$getAffectedModuleSpecs$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator2.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModModule");
                        }
                        NamingFamily moduleRoutines = ((OraModModule)oraModule).getRoutines();
                        moduleRoutines.removeSyncPendingChildren();
                        if (!toReorder) continue;
                        moduleRoutines.sort();
                    }
                }
            });
        }

        private final void retrieveInnerRoutinesArguments() {
            if (this.affectedModuleSpecs.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            List list = this.affectedModuleSpecs.stream().flatMap(retrieveInnerRoutinesArguments.oldAffectedRoutines.1.INSTANCE).map(retrieveInnerRoutinesArguments.oldAffectedRoutines.2.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"affectedModuleSpecs.stre\u2026lect(Collectors.toList())");
            Iterable oldAffectedRoutines2 = list;
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutineArguments");
            List<OraIntroQueries.OneInnerRoutineArgument> args2 = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(oldAffectedRoutines2, args2){
                final /* synthetic */ Iterable $oldAffectedRoutines$inlined;
                final /* synthetic */ List $args$inlined;
                {
                    this.$oldAffectedRoutines$inlined = iterable;
                    this.$args$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraModRoutine r : this.$oldAffectedRoutines$inlined) {
                        r.getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutineArgument a : this.$args$inlined) {
                        OraModInnerRoutine routine;
                        OraModModule m;
                        if (a.package_name == null || a.routine_name == null) continue;
                        String string = a.package_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.package_name");
                        if (OraIntrospectorFunctions.access$findModuleByName(schema2, string) == null) {
                            continue;
                        }
                        if ((OraModInnerRoutine)m.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema2;
                        OraModRoutine oraModRoutine = routine;
                        short s = a.position;
                        String string2 = a.arg_name;
                        char c = a.arg_direction;
                        String string3 = a.data_type_schema_name;
                        String string4 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, s, string2, c, string3, string4);
                    }
                    for (OraModRoutine r : this.$oldAffectedRoutines$inlined) {
                        r.getArguments().removeSyncPendingChildren();
                    }
                }
            });
        }

        private final void adjustInnerRoutines() {
            if (this.affectedInnerRoutines.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;
                {
                    this.this$0 = oraSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (BasicRoutine routine : OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0)) {
                        if (!(routine instanceof BasicModRoutine)) continue;
                        ((BasicModRoutine)routine).setRoutineKind(((BasicModRoutine)routine).getReturnArgument() == null ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    }
                }
            });
        }

        private final void retrieveSingleRoutines() {
            if (((OraSchema)this.getSchema()).getRoutines().isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions");
            SqlQuery<List<OraIntroQueries.OneSingleRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutines");
            List<OraIntroQueries.OneSingleRoutine> routines = this.performQuery(sqlQuery);
            if (routines.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneSingleRoutine r : this.$routines$inlined) {
                        OraModSingleRoutine routine = (OraModSingleRoutine)schema2.getRoutines().renew(r.object_id, r.name);
                        routine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                        routine.setInvalid(r.is_invalid);
                        routine.setDeterministic(r.is_deterministic);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(routine, r.created_timestamp, r.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).add(routine);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(routine);
                    }
                    schema2.getRoutines().sort();
                }
            });
        }

        private final void retrieveSingleRoutinesArguments() {
            if (this.affectedSingleRoutines.isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutineArguments");
            List<OraIntroQueries.OneSingleRoutineArgument> args2 = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, args2){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $args$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$args$inlined = list;
                }

                public final void perform(MS schema) {
                    BasicRoutine r;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModRoutine");
                        }
                        ((OraModRoutine)basicRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneSingleRoutineArgument a : this.$args$inlined) {
                        OraModSingleRoutine routine;
                        if (a.routine_name == null) continue;
                        if ((OraModSingleRoutine)schema2.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema2;
                        OraModRoutine oraModRoutine = routine;
                        short s = a.position;
                        String string = a.arg_name;
                        char c = a.arg_direction;
                        String string2 = a.data_type_schema_name;
                        String string3 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, s, string, c, string2, string3);
                    }
                    iterator = OraSchemaRetriever.access$getAffectedSingleRoutines$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        BasicRoutine basicRoutine = r = (BasicRoutine)iterator.next();
                        if (basicRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModRoutine");
                        }
                        ((OraModRoutine)basicRoutine).getArguments().removeSyncPendingChildren();
                    }
                }
            });
        }

        private final void retrieveComments() {
            long hash;
            if (((OraSchema)this.getSchema()).getTables().isEmpty() && ((OraSchema)this.getSchema()).getMatViews().isEmpty() && ((OraSchema)this.getSchema()).getViews().isEmpty()) {
                if (((OraSchema)this.getSchema()).getCommentsHash() != 0L) {
                    OraSchemaRetriever this_$iv = this;
                    BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            OraModSchema schema2 = (OraModSchema)MS;
                            schema2.setCommentsHash(0L);
                        }
                    });
                }
                return;
            }
            this.reportRetrieving("Comments");
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateCommentsHash;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.calculateCommentsHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getCommentsHash()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneComment>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveComments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveComments");
            List<OraIntroQueries.OneComment> comments = this.performQuery(sqlQuery2);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, hash, comments){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ long $hash$inlined;
                final /* synthetic */ List $comments$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$hash$inlined = l;
                    this.$comments$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setCommentsHash(Intrinsics.areEqual((Object)((Object)this.this$0.getMode$intellij_database_introspection()), (Object)((Object)IntrospectionMode.FRAGMENT)) ? -1L : this.$hash$inlined);
                    HashSet<BasicModNamedElement> touched = new HashSet<BasicModNamedElement>();
                    for (OraIntroQueries.OneComment c : this.$comments$inlined) {
                        OraModLikeColumn column2;
                        OraModLikeTable table;
                        String string = c.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                            continue;
                        }
                        if (c.column_name == null) {
                            table.setComment(c.comments);
                            touched.add(table);
                            continue;
                        }
                        if ((OraModLikeColumn)table.getColumns().get(c.column_name) == null) {
                            continue;
                        }
                        column2.setComment(c.comments);
                        touched.add(column2);
                    }
                    for (OraModLikeTable t : OraSchemaRetriever.access$seanceRelatedTablesAndViews(this.this$0, schema2)) {
                        if (!touched.contains(t)) {
                            t.setComment(null);
                        }
                        for (OraModLikeColumn column3 : t.getColumns()) {
                            if (touched.contains(column3)) continue;
                            column3.setComment(null);
                        }
                    }
                }
            });
        }

        private final Iterable<OraModLikeTable> seanceRelatedTablesAndViews(OraModSchema schema) {
            if (Intrinsics.areEqual((Object)((Object)this.getMode$intellij_database_introspection()), (Object)((Object)IntrospectionMode.FRAGMENT))) {
                JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables()).filter((Condition)new Condition<OraModTable>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModTable it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames$intellij_database_introspection(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getMatViews()).filter((Condition)new Condition<OraModMatView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModMatView it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames$intellij_database_introspection(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getViews()).filter((Condition)new Condition<OraModView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModView it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames$intellij_database_introspection(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraModL\u2026.name in fragmentNames })");
                return (Iterable)jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables())).append((Iterable)JBIterable.from((Iterable)schema.getMatViews())).append((Iterable)JBIterable.from((Iterable)schema.getViews()));
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.empty<OraModL\u2026rable.from(schema.views))");
            return (Iterable)jBIterable;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDependencies() {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            SqlQuery<List<OraIntroQueries.OneDependency>> query;
            if (this.affectedDepObjects.isEmpty()) {
                return;
            }
            if (Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"SYS") || Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC")) {
                return;
            }
            this.reportRetrieving("Dependencies");
            SqlQuery<List<OraIntroQueries.OneDependency>> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveDependenciesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            List<OraIntroQueries.OneDependency> deps = this.performQuery(sqlQuery);
            if (deps.isEmpty()) {
                return;
            }
            Iterable iterable = $receiver$iv = (Iterable)deps;
            Map destination$iv$iv = new LinkedHashMap();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Object object;
                OraIntroQueries.OneDependency it = (OraIntroQueries.OneDependency)element$iv$iv;
                Map $receiver$iv$iv$iv = destination$iv$iv;
                Long key$iv$iv = it.object_id;
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                it = (OraIntroQueries.OneDependency)element$iv$iv;
                List list = list$iv$iv;
                Long l = it.referenced_id;
                list.add(l);
            }
            Map g = destination$iv$iv;
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(g){
                final /* synthetic */ Map $g$inlined;
                {
                    this.$g$inlined = map2;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    BasicDatabase basicDatabase = schema2.getDatabase();
                    if (basicDatabase == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModDatabase");
                    }
                    BasicModDatabase db = (BasicModDatabase)basicDatabase;
                    Map map2 = this.$g$inlined;
                    for (Map.Entry<K, V> d : map2.entrySet()) {
                        BasicIdentifiedElement o = db.findIdentifiedElement(((Number)d.getKey()).longValue());
                        if (!(o instanceof OraModSourceAware) || ((OraModSourceAware)o).getSchema() != schema2) continue;
                        BasicElement parent = ((OraModSourceAware)o).getDasParent();
                        BasicElement basicElement = parent;
                        if (!(basicElement instanceof BasicIdentifiedElement)) {
                            basicElement = null;
                        }
                        BasicIdentifiedElement basicIdentifiedElement = (BasicIdentifiedElement)basicElement;
                        long parentId = basicIdentifiedElement != null ? basicIdentifiedElement.getObjectId() : Long.MIN_VALUE;
                        ((OraModSourceAware)o).setDependsOnIds(SetsKt.minus((Set)CollectionsKt.toSet((Iterable)((Iterable)d.getValue())), (Object)parentId));
                    }
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveSources() {
            if (!this.getWithSources$intellij_database_introspection()) {
                return;
            }
            hV = ((OraSchema)this.getSchema()).getViews().hasChildren() != false || ((OraSchema)this.getSchema()).getMatViews().hasChildren() != false;
            hT = ModelFun.hasTriggers(this.getSchema());
            if (((OraSchema)this.getSchema()).getPackages().hasChildren() || ((OraSchema)this.getSchema()).getRoutines().hasChildren()) ** GOTO lbl-1000
            var4_3 = (BasicElement)this.getSchema();
            v0 = ObjectKind.OBJECT_TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"OBJECT_TYPE");
            var5_4 = v0;
            v1 = ObjectKind.BODY;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"BODY");
            kindOfLevel2$iv = v1;
            v2 = $receiver$iv;
            if (v2 == null || (v2 = v2.familyOf((ObjectKind)kindOfLevel1$iv)) == null || (v2 = v2.jbi()) == null || (v2 = v2.flatten((Function)new Function<BasicElement, Iterable<? extends T>>(kindOfLevel2$iv){
                final /* synthetic */ ObjectKind $kindOfLevel2;
                {
                    this.$kindOfLevel2 = objectKind;
                }

                @NotNull
                public final JBIterable<? extends BasicElement> fun(BasicElement it) {
                    JBIterable jBIterable = it.familyOf(this.$kindOfLevel2);
                    if (jBIterable == null || (jBIterable = jBIterable.jbi()) == null) {
                        jBIterable = JBIterable.empty();
                    }
                    return jBIterable;
                }
            })) == null || (v2 = v2.filter(BasicElement.class)) == null) {
                v3 = JBIterable.empty();
                v2 = v3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"JBIterable.empty()");
            }
            if (v2.isNotEmpty()) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = hP = false;
            }
            if (!(hV || hT || hP)) {
                return;
            }
            viewBodies = this.retrieveViewSources();
            triggerBodies = this.retrieveTriggerSources();
            programLines = this.retrieveProgramSources();
            obfuscations = this.retrieveObfuscatedSources();
            if (viewBodies.isEmpty() && triggerBodies.isEmpty() && programLines.isEmpty() && obfuscations.isEmpty()) {
                return;
            }
            this.reportRetrieving("applying sources");
            this_$iv = OraIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, viewBodies, triggerBodies, programLines, obfuscations){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $viewBodies$inlined;
                final /* synthetic */ Collection $triggerBodies$inlined;
                final /* synthetic */ Collection $programLines$inlined;
                final /* synthetic */ Collection $obfuscations$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$viewBodies$inlined = collection;
                    this.$triggerBodies$inlined = collection2;
                    this.$programLines$inlined = collection3;
                    this.$obfuscations$inlined = collection4;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Collection theType;
                    Object this_$iv;
                    Collection collection = this.$viewBodies$inlined;
                    if (!collection.isEmpty()) {
                        this_$iv = this.this$0;
                        BaseIntrospector.AbstractSchemaRetriever.access$getModel$p((BaseIntrospector.AbstractSchemaRetriever)this_$iv).modify((BasicElement)((BaseIntrospector.AbstractSchemaRetriever)this_$iv).getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneViewSource v : this.this$0.$viewBodies$inlined) {
                                    OraModView oraModView = (OraModView)schema2.getViews().get(v.view_name);
                                    BasicModSourceAware view = oraModView != null ? (BasicModSourceAware)oraModView : (BasicModSourceAware)schema2.getMatViews().get(v.view_name);
                                    if (view == null) continue;
                                    OraIntrospectorFunctions.access$applyViewSources(view, v.text);
                                }
                            }
                        });
                    }
                    if (!(this_$iv = this.$triggerBodies$inlined).isEmpty()) {
                        this_$iv = this.this$0;
                        BaseIntrospector.AbstractSchemaRetriever.access$getModel$p((BaseIntrospector.AbstractSchemaRetriever)this_$iv).modify((BasicElement)((BaseIntrospector.AbstractSchemaRetriever)this_$iv).getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneTriggerSource trig : this.this$0.$triggerBodies$inlined) {
                                    OraModTrigger trigger;
                                    OraModLikeTable table;
                                    String string = trig.table_name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                                    if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                                        continue;
                                    }
                                    if ((OraModTrigger)table.getTriggers().get(trig.trigger_name) == null) {
                                        continue;
                                    }
                                    String text2 = trig.trigger_body;
                                    trigger.setSourceText(text2 != null ? (CompositeText)new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                }
                            }
                        });
                    }
                    if (!(this_$iv = this.$programLines$inlined).isEmpty()) {
                        void theName;
                        this_$iv = new Ref.ObjectRef();
                        ((Ref.ObjectRef)this_$iv).element = "";
                        Ref.ObjectRef $i$f$inSchema = new Ref.ObjectRef();
                        $i$f$inSchema.element = "";
                        StringBuilder buf = new StringBuilder();
                        OraSchemaRetriever this_$iv2 = this.this$0;
                        BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), (ModelModifier)new ModelModifier<MS>((Ref.ObjectRef)theType, (Ref.ObjectRef)theName, buf, this){
                            final /* synthetic */ Ref.ObjectRef $theType$inlined;
                            final /* synthetic */ Ref.ObjectRef $theName$inlined;
                            final /* synthetic */ StringBuilder $buf$inlined;
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.$theType$inlined = objectRef;
                                this.$theName$inlined = objectRef2;
                                this.$buf$inlined = stringBuilder;
                                this.this$0 = var4_4;
                            }

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneSrcLine line : this.this$0.$programLines$inlined) {
                                    boolean theSame;
                                    boolean bl = theSame = Intrinsics.areEqual((Object)((String)this.$theType$inlined.element), (Object)line.type) && Intrinsics.areEqual((Object)((String)this.$theName$inlined.element), (Object)line.name);
                                    if (!theSame) {
                                        String string = (String)this.$theType$inlined.element;
                                        String string2 = (String)this.$theName$inlined.element;
                                        String string3 = this.$buf$inlined.toString();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"buf.toString()");
                                        OraIntrospectorFunctions.access$applySources(schema2, string, string2, string3);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.type, (String)"line.type");
                                        this.$theType$inlined.element = this.$theType$inlined.element;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.name, (String)"line.name");
                                        this.$theName$inlined.element = this.$theName$inlined.element;
                                        this.$buf$inlined.delete(0, this.$buf$inlined.length());
                                    }
                                    this.$buf$inlined.append(line.text);
                                }
                                String string = (String)this.$theType$inlined.element;
                                String string4 = (String)this.$theName$inlined.element;
                                String string5 = this.$buf$inlined.toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"buf.toString()");
                                OraIntrospectorFunctions.access$applySources(schema2, string, string4, string5);
                            }
                        });
                    }
                    if (!(theType = this.$obfuscations$inlined).isEmpty()) {
                        this_$iv = this.this$0;
                        BaseIntrospector.AbstractSchemaRetriever.access$getModel$p((BaseIntrospector.AbstractSchemaRetriever)this_$iv).modify((BasicElement)((BaseIntrospector.AbstractSchemaRetriever)this_$iv).getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final void perform(MS schema) {
                                v0 = schema;
                                Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                                schema = (OraModSchema)v0;
                                for (OraIntroQueries.OneObfuscatedSrc o : this.this$0.$obfuscations$inlined) {
                                    block14: {
                                        block9: {
                                            block10: {
                                                block13: {
                                                    block11: {
                                                        block12: {
                                                            v1 = var5_5 = o.type;
                                                            if (v1 == null) break block9;
                                                            switch (v1.hashCode()) {
                                                                case 1691390643: {
                                                                    if (!var5_5.equals("PROCEDURE")) ** break;
                                                                    break block10;
                                                                }
                                                                case -89079770: {
                                                                    if (!var5_5.equals("PACKAGE")) ** break;
                                                                    break block11;
                                                                }
                                                                case -1018163512: {
                                                                    if (!var5_5.equals("TYPE BODY")) ** break;
                                                                    break block12;
                                                                }
                                                                case 2590522: {
                                                                    if (!var5_5.equals("TYPE")) ** break;
                                                                    break;
                                                                }
                                                                case 411142492: {
                                                                    if (!var5_5.equals("PACKAGE BODY")) ** break;
                                                                    break block13;
                                                                }
                                                                case -2131401768: {
                                                                    if (!var5_5.equals("FUNCTION")) ** break;
                                                                    break block10;
                                                                }
                                                            }
                                                            v2 = (OraModSourceAware)schema.getObjectTypes().get(o.name);
                                                            break block14;
                                                        }
                                                        v3 = (OraModObjectType)schema.getObjectTypes().get(o.name);
                                                        v2 = v3 != null && (v3 = v3.getBodies()) != null ? (OraModObjectTypeBody)v3.get() : null;
                                                        break block14;
                                                    }
                                                    v2 = (OraModSourceAware)schema.getPackages().get(o.name);
                                                    break block14;
                                                }
                                                v4 = (OraModPackage)schema.getPackages().get(o.name);
                                                v2 = v4 != null && (v4 = v4.getBodies()) != null ? (OraModPackageBody)v4.get() : null;
                                                break block14;
                                            }
                                            v2 = (OraModSourceAware)schema.getRoutines().get(o.name);
                                            break block14;
                                        }
                                        v2 = null;
                                    }
                                    if ((sourceAware = v2) == null) continue;
                                    sourceAware.setSourceText(null);
                                    sourceAware.setObfuscated(true);
                                }
                            }
                        });
                    }
                }
            });
        }

        private final Collection<OraIntroQueries.OneViewSource> retrieveViewSources() {
            Collection views;
            if (this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("View Sources");
                SqlQuery<List<OraIntroQueries.OneViewSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViewSources");
                views = this.performQuery(sqlQuery);
            } else {
                views = SetsKt.emptySet();
            }
            return views;
        }

        private final Collection<OraIntroQueries.OneTriggerSource> retrieveTriggerSources() {
            Collection triggers;
            if (this.affectsTables || this.affectsMatViews || this.affectsViews) {
                this.reportRetrieving("Trigger Sources");
                SqlQuery<List<OraIntroQueries.OneTriggerSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggerSources");
                triggers = this.performQuery(sqlQuery);
            } else {
                triggers = SetsKt.emptySet();
            }
            return triggers;
        }

        private final Collection<OraIntroQueries.OneSrcLine> retrieveProgramSources() {
            Collection lines;
            Collection collection;
            if (this.affectsModulesOrBodies || !(collection = (Collection)this.affectedSingleRoutines).isEmpty() || this.affectsTriggers) {
                this.reportRetrieving("Procedures and Functions Sources");
                this.setQueryParameter("source_line_width_limit", this.getSourceLineWidthLimit());
                SqlQuery<List<OraIntroQueries.OneSrcLine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSources");
                lines = this.performQuery(sqlQuery);
            } else {
                lines = SetsKt.emptySet();
            }
            return lines;
        }

        private final int getSourceLineWidthLimit() {
            RegistryValue limitRegVal = Registry.get((String)"database.introspection.oracle.source.line.limit");
            int limit = limitRegVal.asInteger();
            if (limit == 0) {
                limit = 4000;
            }
            if (limit > 4000) {
                limit = 4000;
            }
            if (limit < 80) {
                limit = 80;
            }
            return limit;
        }

        private final Collection<OraIntroQueries.OneObfuscatedSrc> retrieveObfuscatedSources() {
            Collection collection;
            if (this.affectsModulesOrBodies || !(collection = (Collection)this.affectedSingleRoutines).isEmpty() || this.affectsTriggers) {
                this.reportRetrieving("Obfuscated Procedures and Functions");
                SqlQuery<List<OraIntroQueries.OneObfuscatedSrc>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.listObfuscatedSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.listObfuscatedSources");
                List<OraIntroQueries.OneObfuscatedSrc> list = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"performQuery(queries.listObfuscatedSources)");
                return list;
            }
            return CollectionsKt.emptyList();
        }

        private final void retrieveSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveFragmentSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveFragmentSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(ss){
                final /* synthetic */ List $ss$inlined;
                {
                    this.$ss$inlined = list;
                }

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    List list = this.$ss$inlined;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ss");
                    OraIntrospectorFunctions.access$processSynonyms(list, root3);
                }
            });
        }

        private final void retrieveErrors() {
            SqlQuery<long[]> invalidObjectsQuery;
            this.reportRetrieving("Statuses and Errors");
            SqlQuery<long[]> sqlQuery = invalidObjectsQuery = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"invalidObjectsQuery");
            long[] invalidObjectsAr = this.performQuery(sqlQuery);
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, invalids){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $invalids$inlined;
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$invalids$inlined = tLongHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getObjectTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily, this.$invalids$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getPackages();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.packages");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily2, this.$invalids$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily3 = schema2.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.routines");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily3, this.$invalids$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily4 = schema2.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.tables");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily4, this.$invalids$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily5 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily5, this.$invalids$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily6 = schema2.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.synonyms");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, namingIdentifyingFamily6, this.$invalids$inlined);
                }
            });
            if (invalids.isEmpty()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneError>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveErrors;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveErrors");
            List<OraIntroQueries.OneError> errs = this.performQuery(sqlQuery2);
            if (errs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv2 = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(errs){
                final /* synthetic */ List $errs$inlined;
                {
                    this.$errs$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    MultiMap map2 = new MultiMap();
                    for (OraIntroQueries.OneError err : this.$errs$inlined) {
                        BasicModSourceAware src = null;
                        switch (err.type_code) {
                            case 'R': {
                                src = (BasicModSourceAware)schema2.getRoutines().get(err.name);
                                break;
                            }
                            case 'V': {
                                src = (BasicModSourceAware)schema2.getViews().get(err.name);
                                break;
                            }
                            case 'T': {
                                OraModObjectType m = (OraModObjectType)schema2.getObjectTypes().get(err.name);
                                if (m == null) break;
                                src = err.is_body ? (BasicModSourceAware)m.getBodies().get() : (BasicModSourceAware)m;
                                break;
                            }
                            case 'P': {
                                OraModPackage p = (OraModPackage)schema2.getPackages().get(err.name);
                                if (p == null) break;
                                src = err.is_body ? (BasicModSourceAware)p.getBodies().get() : (BasicModSourceAware)p;
                                break;
                            }
                            case 'G': {
                                String string = err.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"err.name");
                                src = OraIntrospectorFunctions.access$findTrigger(schema2, string);
                            }
                        }
                        if (src == null) continue;
                        SourceError error2 = SourceError.of(err.line, err.position, err.message);
                        map2.putValue((Object)src, (Object)error2);
                    }
                    Iterator<E> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry;
                        Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                        BasicModSourceAware key2 = (BasicModSourceAware)entry2.getKey();
                        entry2 = entry;
                        Collection value = (Collection)entry2.getValue();
                        key2.setErrors((List)ImmutableList.copyOf((Collection)value));
                    }
                }
            });
        }

        private final void updateInvalidStatus(Iterable<? extends BasicModElement> family, TLongHashSet invalids) {
            for (BasicModElement basicModElement : family) {
                BasicModElement basicModElement2;
                if (basicModElement instanceof BasicModSourceAware && basicModElement instanceof BasicIdentifiedElement) {
                    boolean invalid = invalids.contains(((BasicIdentifiedElement)((Object)basicModElement)).getObjectId());
                    ((BasicModSourceAware)basicModElement).setInvalid(invalid);
                    if (!invalid) {
                        ((BasicModSourceAware)basicModElement).setErrors(ModelConsts.NO_ERRORS);
                    }
                }
                if ((basicModElement2 = basicModElement) instanceof OraModLikeTable) {
                    NamingIdentifyingFamily namingIdentifyingFamily = ((OraModLikeTable)basicModElement).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"e.triggers");
                    this.updateInvalidStatus(namingIdentifyingFamily, invalids);
                    continue;
                }
                if (basicModElement2 instanceof OraModObjectType) {
                    SingletonFamily singletonFamily = ((OraModObjectType)basicModElement).getBodies();
                    Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"e.bodies");
                    this.updateInvalidStatus(singletonFamily, invalids);
                    continue;
                }
                if (!(basicModElement2 instanceof OraModPackage)) continue;
                SingletonFamily singletonFamily = ((OraModPackage)basicModElement).getBodies();
                Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"e.bodies");
                this.updateInvalidStatus(singletonFamily, invalids);
            }
        }

        private final <T extends SqlStatement> T parseStatement(String src) {
            try {
                SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)OraIntrospector.this.sqlReader.getReadOnlyPsi(OraIntrospector.this.sqlLanguageDialect, (CharSequence)src))).expandAndSkip((Condition)parseStatement.1.INSTANCE);
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return (T)((SqlStatement)syntaxTraverser.filter(SqlStatement.class).first());
            }
            catch (Exception e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OraIntrospector.this.getLog().error((Throwable)e);
                }
                OraIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        @Override
        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            String modeStr = this.getMode$intellij_database_introspection().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((OraSchema)this.getSchema()).getName(), modeStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026)\", schema.name, modeStr)");
            OraIntrospector.this.updateStatus(string, what);
        }

        public OraSchemaRetriever(@NotNull DBTransaction transaction, OraSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)OraIntrospector.this, transaction, (BasicSchema)schema);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedModuleSpecs = new HashSet();
            this.affectedModuleBodies = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedSingleRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.affectedTables = new HashSet();
        }

        @Nullable
        public static final /* synthetic */ BigInteger access$adjustBigIntegerForSequence(OraSchemaRetriever $this, @Nullable BigDecimal bigDecimalValue) {
            return $this.adjustBigIntegerForSequence(bigDecimalValue);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedModuleBodies$p(OraSchemaRetriever $this) {
            return $this.affectedModuleBodies;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedDepObjects$p(OraSchemaRetriever $this) {
            return $this.affectedDepObjects;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedModuleSpecs$p(OraSchemaRetriever $this) {
            return $this.affectedModuleSpecs;
        }

        public static final /* synthetic */ void access$applyClusterInfo(OraSchemaRetriever $this, @NotNull OraModCluster cluster, @NotNull OraIntroQueries.OneCluster c) {
            $this.applyClusterInfo(cluster, c);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedClusters$p(OraSchemaRetriever $this) {
            return $this.affectedClusters;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedTables$p(OraSchemaRetriever $this) {
            return $this.affectedTables;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getTablesToReorderDetails$p(OraSchemaRetriever $this) {
            return $this.tablesToReorderDetails;
        }

        public static final /* synthetic */ void access$applyIndexingItems(OraSchemaRetriever $this, @NotNull BasicTable table, @NotNull OraModIndex index, @NotNull List items) {
            $this.applyIndexingItems(table, index, items);
        }

        @Nullable
        public static final /* synthetic */ TrigTurn access$trigTurnOf(OraSchemaRetriever $this, short turn) {
            return $this.trigTurnOf(turn);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedInnerRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedInnerRoutines;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedSingleRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedSingleRoutines;
        }

        @NotNull
        public static final /* synthetic */ Iterable access$seanceRelatedTablesAndViews(OraSchemaRetriever $this, @NotNull OraModSchema schema) {
            return $this.seanceRelatedTablesAndViews(schema);
        }

        public static final /* synthetic */ void access$updateInvalidStatus(OraSchemaRetriever $this, @NotNull Iterable family, @NotNull TLongHashSet invalids) {
            $this.updateInvalidStatus(family, invalids);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

