/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.PostgresIntroQueries;
import com.intellij.database.introspection.PostgresIntrospector;
import com.intellij.database.introspection.PostgresIntrospectorBaseKt;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.postgres.PostgresModMatView;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u0006*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0015H\u0082\u0004\u00a2\u0006\u0002\u0010\u001e\u001a\f\u0010\u001f\u001a\u00020\u0017*\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REL_FOREIGN_TABLE", "", "REL_MAT_VIEW", "assignSequenceParams", "", "sequence", "Lcom/intellij/database/model/postgres/PostgresModSequence;", "s", "Lcom/intellij/database/introspection/PostgresIntroQueries$OneSequence;", "cascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "c", "makeTrigEvents", "", "Lcom/intellij/database/model/TrigEvent;", "bits", "", "parseListOfLongs", "", "", "str", "", "parseSmallSetOfLongs", "applySourceText", "Lcom/intellij/database/model/postgres/PostgresModMatView;", "sourceText", "orNullIf", "defaultVal", "(Ljava/lang/Long;J)Ljava/lang/Long;", "unquoteSingleName", "intellij.database.introspection"})
public final class PostgresIntrospectorKt {
    private static final Logger LOG = Logger.getInstance(PostgresIntrospector.class);
    private static final char REL_MAT_VIEW = 'm';
    private static final char REL_FOREIGN_TABLE = 'f';

    private static final Set<Long> parseSmallSetOfLongs(String str) {
        Set set;
        List<Long> list = PostgresIntrospectorKt.parseListOfLongs(str);
        switch (list.size()) {
            case 0: {
                set = SetsKt.emptySet();
                break;
            }
            case 1: {
                Set set2 = Collections.singleton(CollectionsKt.first(list));
                set = set2;
                Intrinsics.checkExpressionValueIsNotNull(set2, (String)"java.util.Collections.singleton(list.first())");
                break;
            }
            default: {
                set = new TreeSet(list);
            }
        }
        return set;
    }

    private static final List<Long> parseListOfLongs(String str) {
        List<Object> list;
        String[] strings = PostgresIntrospectorBaseKt.parseArrayOfStrings(str);
        int n = PostgresIntrospectorBaseKt.getLength(strings);
        if (n == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Long> list2 = new ArrayList<Long>(n);
        for (String string : strings) {
            try {
                CharSequence charSequence = string;
                String string2 = charSequence;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String s = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                charSequence = s;
                if (charSequence.length() == 0) continue;
                long value = Long.parseLong(s);
                list2.add(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (list2.size()) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                List<Object> list3 = Collections.singletonList(CollectionsKt.first((List)list2));
                list = list3;
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"java.util.Collections.singletonList(list.first())");
                break;
            }
            default: {
                list = list2;
            }
        }
        return list;
    }

    private static final Set<TrigEvent> makeTrigEvents(byte bits) {
        byte $receiver$iv;
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        byte by = bits;
        int that$iv = 4;
        byte $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.INSERT);
        }
        $receiver$iv = bits;
        that$iv = 8;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.DELETE);
        }
        $receiver$iv = bits;
        that$iv = 16;
        $receiver$iv$iv = $receiver$iv;
        if ((Byte.toUnsignedInt($receiver$iv$iv) & that$iv) != 0) {
            events.add(TrigEvent.UPDATE);
        }
        EnumSet<TrigEvent> enumSet = events;
        Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"events");
        return enumSet;
    }

    private static final void assignSequenceParams(PostgresModSequence sequence, PostgresIntroQueries.OneSequence s) {
        if (s.min_value == null) {
            return;
        }
        Long next = PostgresIntrospectorKt.orNullIf(s.next_value, 1L);
        Long min = PostgresIntrospectorKt.orNullIf(s.min_value, 1L);
        Long max = PostgresIntrospectorKt.orNullIf(s.max_value, Long.MAX_VALUE);
        Long inc = PostgresIntrospectorKt.orNullIf(s.inc_value, 1L);
        sequence.setSequenceIdentity(SequenceIdentity.of(min, next, inc, max));
        sequence.setCycled(s.cycle_option);
        Long l = s.cache_size;
        sequence.setCacheSize(l != null ? l : 1L);
        sequence.setDataType(s.data_type);
    }

    private static final Long orNullIf(@Nullable Long $receiver, long defaultVal) {
        Long l = $receiver;
        return l != null && l == defaultVal ? null : $receiver;
    }

    private static final void applySourceText(@NotNull PostgresModMatView $receiver, String sourceText) {
        CharSequence charSequence;
        if (sourceText == null || (charSequence = (CharSequence)sourceText).length() == 0) {
            $receiver.setSourceText(null);
            return;
        }
        String head = "CREATE MATERIALIZED VIEW " + PostgresIntrospectorBaseKt.nameToScript($receiver.getName()) + " AS ";
        String string = sourceText;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String body = stringBuilder.append(PostgresIntrospectorBaseKt.removeSuffix(string2, ';')).append('\n').toString();
        $receiver.setSourceText(new SimpleCompositeText(head, CompositeText.Kind.FIXED_TEXT, body, CompositeText.Kind.ORIGINAL_TEXT));
    }

    private static final CascadeRule cascadeRule(char c) {
        CascadeRule cascadeRule;
        switch (c) {
            case 'c': {
                cascadeRule = CascadeRule.cascade;
                break;
            }
            case 'd': {
                cascadeRule = CascadeRule.set_default;
                break;
            }
            case 'n': {
                cascadeRule = CascadeRule.set_null;
                break;
            }
            case 'r': {
                cascadeRule = CascadeRule.restrict;
                break;
            }
            default: {
                cascadeRule = CascadeRule.no_action;
            }
        }
        return cascadeRule;
    }

    private static final String unquoteSingleName(@NotNull String $receiver) {
        int n = $receiver.length();
        if (n >= 2 && $receiver.charAt(0) == '\"' && $receiver.charAt(n - 1) == '\"') {
            String string = $receiver;
            int n2 = 1;
            int n3 = n - 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, n3);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return StringsKt.replace$default((String)string3, (String)"\"\"", (String)"\"", (boolean)false, (int)4, null);
        }
        return $receiver;
    }

    public static final /* synthetic */ void access$assignSequenceParams(@NotNull PostgresModSequence sequence, @NotNull PostgresIntroQueries.OneSequence s) {
        PostgresIntrospectorKt.assignSequenceParams(sequence, s);
    }

    @NotNull
    public static final /* synthetic */ List access$parseListOfLongs(@Nullable String str) {
        return PostgresIntrospectorKt.parseListOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ Set access$parseSmallSetOfLongs(@Nullable String str) {
        return PostgresIntrospectorKt.parseSmallSetOfLongs(str);
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteSingleName(@NotNull String $receiver) {
        return PostgresIntrospectorKt.unquoteSingleName($receiver);
    }

    @NotNull
    public static final /* synthetic */ CascadeRule access$cascadeRule(char c) {
        return PostgresIntrospectorKt.cascadeRule(c);
    }

    @NotNull
    public static final /* synthetic */ Set access$makeTrigEvents(byte bits) {
        return PostgresIntrospectorKt.makeTrigEvents(bits);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PostgresModMatView $receiver, @Nullable String sourceText) {
        PostgresIntrospectorKt.applySourceText($receiver, sourceText);
    }
}

