/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModLocalTable;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgresbase.PostgresBaseModDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseModForeignKey;
import com.intellij.database.model.postgresbase.PostgresBaseModSchema;
import com.intellij.database.model.postgresbase.PostgresBaseModTable;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.database.model.postgresbase.PostgresBaseTableColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u00a8\u0006\n"}, d2={"addSuccessor", "", "Lcom/intellij/database/model/postgres/PostgresModTable;", "id", "", "findModTableByObjectId", "Lcom/intellij/database/model/postgresbase/PostgresBaseModTable;", "Lcom/intellij/database/model/postgresbase/PostgresBaseModSchema;", "resolveReference", "Lcom/intellij/database/model/postgresbase/PostgresBaseModForeignKey;", "intellij.database.model.impl"})
@JvmName(name="PostgresModModelFun")
public final class PostgresModModelFun {
    public static final void addSuccessor(@NotNull PostgresModTable $receiver, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Long> ids = $receiver.getSuccessorIds();
        if (!ids.contains(id)) {
            $receiver.setSuccessorIds(SetsKt.plus(ids, (Object)id));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void resolveReference(@NotNull PostgresBaseModForeignKey $receiver) {
        PostgresBaseTable refTable;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicMajorObject basicMajorObject = $receiver.getMajorObject();
        BasicSchema basicSchema = basicMajorObject != null ? basicMajorObject.getSchema() : null;
        if (!(basicSchema instanceof PostgresBaseSchema)) {
            basicSchema = null;
        }
        PostgresBaseSchema postgresBaseSchema = (PostgresBaseSchema)basicSchema;
        if (postgresBaseSchema == null) {
            return;
        }
        PostgresBaseSchema schema = postgresBaseSchema;
        BasicDatabase basicDatabase = schema.getDatabase();
        if (basicDatabase == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgresbase.PostgresBaseModDatabase");
        }
        PostgresBaseTable postgresBaseTable = refTable = PostgresModelFun.findTableByObjectId((PostgresBaseModDatabase)basicDatabase, $receiver.getRefTableId(), schema);
        PostgresBaseSchema refSchema = postgresBaseTable != null ? postgresBaseTable.getSchema() : null;
        $receiver.setRefSchemaName(refSchema != null && Intrinsics.areEqual((Object)refSchema, (Object)schema) ^ true ? refSchema.getRealName() : null);
        PostgresBaseTable postgresBaseTable2 = refTable;
        $receiver.setRefTableName(postgresBaseTable2 != null ? postgresBaseTable2.getRealName() : null);
        if (refTable != null) {
            BasicKey refKey;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = $receiver.getRefColPositions();
            void var6_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p;
                Short s = (Short)item$iv$iv;
                Collection collection = destination$iv$iv;
                PositioningNamingFamily<? extends PostgresBaseTableColumn> positioningNamingFamily = refTable.getColumns();
                void v7 = p;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"p");
                PostgresBaseTableColumn postgresBaseTableColumn = (PostgresBaseTableColumn)positioningNamingFamily.getByNaturalPosition(v7.shortValue());
                String string = postgresBaseTableColumn != null ? postgresBaseTableColumn.getName() : null;
                collection.add(string);
            }
            List columnNames = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
            $receiver.setRefColNames(columnNames);
            BasicTableOrView basicTableOrView = refTable;
            List<String> list = $receiver.getRefColNames();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"refColNames");
            BasicKey basicKey = refKey = ModelFun.findKey(basicTableOrView, list);
            $receiver.setRefKeyName(basicKey != null ? basicKey.getRealName() : null);
        }
    }

    @Nullable
    public static final PostgresBaseModTable findModTableByObjectId(@NotNull PostgresBaseModSchema $receiver, long id) {
        PostgresBaseModTable postgresBaseModTable;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresBaseModSchema postgresBaseModSchema = $receiver;
        if (postgresBaseModSchema instanceof PostgresModSchema) {
            PostgresModLocalTable postgresModLocalTable = (PostgresModLocalTable)((PostgresModSchema)$receiver).getTables().getByObjectId(id);
            postgresBaseModTable = postgresModLocalTable != null ? (PostgresBaseModTable)postgresModLocalTable : (PostgresBaseModTable)((PostgresModSchema)$receiver).getForeignTables().getByObjectId(id);
        } else {
            postgresBaseModTable = (PostgresBaseModTable)$receiver.getTables().getByObjectId(id);
        }
        return postgresBaseModTable;
    }
}

