/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraLikeTable;
import com.intellij.database.model.oracle.OraMajorObject;
import com.intellij.database.model.oracle.OraMatViewColumn;
import com.intellij.database.model.oracle.OraMatViewTrigger;
import com.intellij.database.model.oracle.OraMixinMatView;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.model.oracle.OraStoredSchemaObject;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraMatView
extends OraMajorObject,
OraLikeTable,
OraStoredSchemaObject,
BasicMatView,
OraSourceAware,
OraMixinMatView {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.MAT_VIEW;
        if (objectKind == null) {
            OraMatView.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getParent() {
        return this.getSchema();
    }

    default public @NotNull @Nullable NamingIdentifyingFamily<? extends OraMatView> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull @NotNull PositioningNamingFamily<? extends OraMatViewColumn> getColumns();

    @NotNull
    public @NotNull @NotNull NamingIdentifyingFamily<? extends OraMatViewTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.TRIGGER);
        if (list == null) {
            OraMatView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull @NotNull @NotNull List<? extends Family<? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getTriggers());
        if (list == null) {
            OraMatView.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeObjectName() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            OraMatView.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    default public boolean isObfuscated() {
        return false;
    }

    @Override
    @NotNull
    default public Set<Long> getDependsOnIds() {
        Set<Long> set = Collections.emptySet();
        if (set == null) {
            OraMatView.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public String getTablespaceName() {
        return null;
    }

    default public boolean isPrebuilt() {
        return false;
    }

    default public boolean isModifiable() {
        return false;
    }

    @Override
    @NotNull
    default public OraMatViewRefreshMode getRefreshMode() {
        OraMatViewRefreshMode oraMatViewRefreshMode = OraMatViewRefreshMode.REFRESH_NEVER;
        if (oraMatViewRefreshMode == null) {
            OraMatView.$$$reportNull$$$0(5);
        }
        return oraMatViewRefreshMode;
    }

    @Override
    @NotNull
    default public OraMatViewRefreshMethod getRefreshMethod() {
        OraMatViewRefreshMethod oraMatViewRefreshMethod = OraMatViewRefreshMethod.REFRESH_NEVER;
        if (oraMatViewRefreshMethod == null) {
            OraMatView.$$$reportNull$$$0(6);
        }
        return oraMatViewRefreshMethod;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        OraMatViewRefreshMethod refreshMethod;
        OraMatViewRefreshMode refreshMode;
        boolean modifiable;
        boolean prebuilt;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean obfuscated;
        boolean invalid;
        boolean system;
        String rowTypeObjectName;
        String rowTypeSchemaName;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer == null) {
            OraMatView.$$$reportNull$$$0(7);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((rowTypeSchemaName = this.getRowTypeSchemaName()) != null) {
            consumer.accept("RowTypeSchemaName", PropertyConverter.export(rowTypeSchemaName));
        }
        if ((rowTypeObjectName = this.getRowTypeObjectName()) != null) {
            consumer.accept("RowTypeObjectName", PropertyConverter.export(rowTypeObjectName));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer.accept("Obfuscated", PropertyConverter.export(obfuscated));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer.accept("DependsOnIds", PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if (prebuilt = this.isPrebuilt()) {
            consumer.accept("Prebuilt", PropertyConverter.export(prebuilt));
        }
        if (modifiable = this.isModifiable()) {
            consumer.accept("Modifiable", PropertyConverter.export(modifiable));
        }
        if ((refreshMode = this.getRefreshMode()) != null && refreshMode != OraMatViewRefreshMode.REFRESH_NEVER) {
            consumer.accept("RefreshMode", PropertyConverter.export(refreshMode));
        }
        if ((refreshMethod = this.getRefreshMethod()) != null && refreshMethod != OraMatViewRefreshMethod.REFRESH_NEVER) {
            consumer.accept("RefreshMethod", PropertyConverter.export(refreshMethod));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "RowTypeSchemaName", "RowTypeObjectName", "System", "Errors", "Invalid", "Obfuscated", "DependsOnIds", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "Prebuilt", "Modifiable", "RefreshMode", "RefreshMethod");
        if (list == null) {
            OraMatView.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraMatView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependsOnIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefreshMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefreshMethod";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraMatView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

