/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.ExasolScriptType;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.model.properties.MsServerType;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.model.properties.MysqlEventStatus;
import com.intellij.database.model.properties.OraMatViewRefreshMethod;
import com.intellij.database.model.properties.OraMatViewRefreshMode;
import com.intellij.database.model.properties.OraTableType;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.util.CalendarFun;
import com.intellij.database.util.Casing;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final Logger ourLog = Logger.getInstance(PropertyConverter.class);

    public static String export(boolean value) {
        return value ? "1" : "0";
    }

    public static String export(byte value) {
        return Byte.toString(value);
    }

    public static String export(short value) {
        return Short.toString(value);
    }

    public static String export(int value) {
        return Integer.toString(value);
    }

    public static String export(long value) {
        return Long.toString(value);
    }

    public static String export(float value) {
        return Float.toString(value);
    }

    public static String export(double value) {
        return Double.toString(value);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.nullize((String)string);
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            PropertyConverter.$$$reportNull$$$0(1);
        }
        return CalendarFun.export(timestamp);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            PropertyConverter.$$$reportNull$$$0(2);
        }
        return kind.code();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(3);
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            PropertyConverter.$$$reportNull$$$0(4);
        }
        return si.getSpecification();
    }

    public static String export(@NotNull Enum item) {
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(5);
        }
        return item.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    public static String export(@NotNull DasArgument.Direction dir) {
        if (dir == null) {
            PropertyConverter.$$$reportNull$$$0(6);
        }
        return Character.toString(dir.code);
    }

    public static String export(@NotNull Casing casing) {
        if (casing == null) {
            PropertyConverter.$$$reportNull$$$0(7);
        }
        return casing.specification();
    }

    public static String export(@NotNull TableOrganization org) {
        if (org == null) {
            PropertyConverter.$$$reportNull$$$0(8);
        }
        return org.code;
    }

    public static String exportEnumCode(@NotNull Enum item) {
        Object value;
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(9);
        }
        Class<?> clazz = item.getClass();
        try {
            Field field = clazz.getField("code");
            value = field.get(item);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize an item " + item.name() + " of class " + clazz.getName(), e);
        }
        return value != null ? value.toString() : null;
    }

    @Nullable
    public static String exportListOfShort(@NotNull List<Short> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(10);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfLong(@NotNull List<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(11);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportSetOfLong(@NotNull Set<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(12);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportCollectionOfNumber(@NotNull Collection<? extends Number> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(13);
        }
        int n = numbers.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return numbers.iterator().next().toString();
            }
        }
        return StringUtil.join(numbers, (String)",");
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(14);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportListOfNameValue(@NotNull List<NameValue> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(15);
        }
        if (strings.isEmpty()) {
            return null;
        }
        return StringUtil.join(strings, nv -> nv.getName() + "\n" + nv.getValue(), (String)"\n");
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(16);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(17);
        }
        int n = strings.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return strings.iterator().next();
            }
        }
        return StringUtil.join(strings, (String)"\n");
    }

    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            PropertyConverter.$$$reportNull$$$0(18);
        }
        StringBuilder b = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b.append(event.code);
        }
        return b.toString();
    }

    public static boolean importBoolean(String text2) {
        char c = text2 != null && !text2.isEmpty() ? text2.charAt(0) : (char)'\u0000';
        c = Character.toUpperCase(c);
        return c >= '1' && c <= '9' || c == 'Y' || c == 'T' || c == '+';
    }

    public static byte importByte(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static String importString(String text2) {
        return text2;
    }

    public static ObjectKind importObjectKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return (ObjectKind)ObjectKind.ourKinds.get(text2.trim().toLowerCase(Locale.ENGLISH));
    }

    public static DataType importDataType(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DataTypeFactory.deserialize(text2);
    }

    public static <E extends Enum> E importEnumByCode(Class<E> enumClass, String text2) {
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        Enum enumItem = null;
        try {
            Object o;
            Method methodWithChar = PropertyConverter.getStaticMethod(enumClass, "of", Character.TYPE);
            Method methodWithString = PropertyConverter.getStaticMethod(enumClass, "of", String.class);
            if (methodWithChar == null && methodWithString == null) {
                throw new IllegalArgumentException(String.format("Cannot import property of type %s: no static method of.", enumClass));
            }
            if (length == 1) {
                if (methodWithChar != null) {
                    Character c = Character.valueOf(text2.charAt(0));
                    o = methodWithChar.invoke(null, c);
                } else {
                    o = methodWithString.invoke(null, text2);
                }
            } else if (methodWithString != null) {
                o = methodWithString.invoke(null, text2);
            } else {
                Character c = Character.valueOf(text2.charAt(0));
                o = methodWithChar.invoke(null, c);
            }
            enumItem = (Enum)o;
        }
        catch (Exception e) {
            String message = String.format("Failed to import property value \"%s\" as enum %s: exception %s: %s", text2, enumClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (ourLog.isDebugEnabled()) {
                ourLog.warn(message, (Throwable)e);
            }
            ourLog.warn(message);
        }
        return (E)enumItem;
    }

    public static DasRoutine.Kind importDasRoutineKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar((char)text2.charAt(0));
    }

    public static DasArgument.Direction importDasArgumentDirection(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DasArgument.Direction.of((char)text2.charAt(0));
    }

    @Contract(value="null -> null")
    public static Date importDate(String text2) {
        if (text2 == null) {
            return null;
        }
        return CalendarFun.importSqlDateTime(text2);
    }

    @NotNull
    public static List<Short> importListOfShort(String text2) {
        List<Long> listOfLong = PropertyConverter.importListOfLong(text2);
        ArrayList<Short> listOfShort = new ArrayList<Short>(listOfLong.size());
        for (long value : listOfLong) {
            if (value < -32768L || value > 32767L) continue;
            listOfShort.add(new Short((short)value));
        }
        ArrayList<Short> arrayList = listOfShort;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public static Set<Long> importSetOfLong(String text2) {
        Set<Long> set = PropertyConverter.convertListToSet(PropertyConverter.importListOfLong(text2));
        if (set == null) {
            PropertyConverter.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public static List<Long> importListOfLong(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<Long> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(21);
            }
            return list;
        }
        List strings = StringUtil.split((String)text2, (String)",");
        int n = strings.size();
        if (n == 0) {
            List<Long> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayList<Long> numbers = new ArrayList<Long>(n);
        for (String string : strings) {
            try {
                Long value = Long.parseLong(string);
                numbers.add(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        switch (numbers.size()) {
            case 0: {
                List<Long> list = Collections.emptyList();
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(23);
                }
                return list;
            }
            case 1: {
                List<Long> list = Collections.singletonList(numbers.get(0));
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(24);
                }
                return list;
            }
        }
        ArrayList<Long> arrayList = numbers;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static Set<String> importSetOfString(String text2) {
        if (text2 == null || text2.length() == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(26);
            }
            return set;
        }
        List items = StringUtil.split((String)text2, (String)"\n");
        Set<String> set = PropertyConverter.convertListToSet(items);
        if (set == null) {
            PropertyConverter.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    public static <T> Set<T> convertListToSet(@NotNull List<T> items) {
        if (items == null) {
            PropertyConverter.$$$reportNull$$$0(28);
        }
        int n = items.size();
        switch (n) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(29);
                }
                return set;
            }
            case 1: {
                Set<T> set = Collections.singleton(items.get(0));
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(30);
                }
                return set;
            }
        }
        TreeSet<T> treeSet = new TreeSet<T>(items);
        if (treeSet == null) {
            PropertyConverter.$$$reportNull$$$0(31);
        }
        return treeSet;
    }

    @NotNull
    public static List<String> importListOfString(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(32);
            }
            return list;
        }
        List list = StringUtil.split((String)text2, (String)"\n");
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    public static List<NameValue> importListOfNameValue(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValue> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(34);
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayList();
        StringTokenizer tok = new StringTokenizer(text2, "\n", false);
        while (tok.hasMoreTokens()) {
            res.add(new NameValue(tok.nextToken(), tok.hasMoreTokens() ? tok.nextToken() : ""));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    public static SequenceIdentity importSequenceIdentity(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text2);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text2) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text2.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            PropertyConverter.$$$reportNull$$$0(36);
        }
        return enumSet;
    }

    public static TrigEvent importTrigEvent(String text2) {
        return PropertyConverter.importEnum(TrigEvent.class, text2);
    }

    public static TrigTurn importTrigTurn(String text2) {
        return PropertyConverter.importEnum(TrigTurn.class, text2);
    }

    public static CascadeRule importCascadeRule(String text2) {
        return PropertyConverter.importEnumLC(CascadeRule.class, text2);
    }

    public static Casing importCasing(String text2) {
        return Casing.of((String)text2);
    }

    public static TableOrganization importTableOrganization(String text2) {
        return TableOrganization.byCode(text2);
    }

    public static ClusterType importClusterType(String text2) {
        return ClusterType.of((String)text2);
    }

    public static PostgresDataTypeSubKind importPostgresDataTypeSubKind(String text2) {
        return PropertyConverter.importEnum(PostgresDataTypeSubKind.class, text2);
    }

    public static PostgresDataTypeSubCategory importPostgresDataTypeSubCategory(String text2) {
        return PropertyConverter.importEnum(PostgresDataTypeSubCategory.class, text2);
    }

    public static PostgresCheckOption importPostgresCheckOption(String text2) {
        return PropertyConverter.importEnum(PostgresCheckOption.class, text2);
    }

    public static PostgresOperatorKind importPostgresOperatorKind(String text2) {
        return PropertyConverter.importEnum(PostgresOperatorKind.class, text2);
    }

    public static PostgresFireMode importPostgresFireMode(String text2) {
        return PropertyConverter.importEnum(PostgresFireMode.class, text2);
    }

    public static MysqlEventStatus importMysqlEventStatus(String text2) {
        return PropertyConverter.importEnum(MysqlEventStatus.class, text2);
    }

    public static MsServerType importMsServerType(String text2) {
        return PropertyConverter.importEnum(MsServerType.class, text2);
    }

    public static MsRoutineType importMsRoutineType(String text2) {
        return PropertyConverter.importEnum(MsRoutineType.class, text2);
    }

    public static OraTableType importOraTableType(String text2) {
        return PropertyConverter.importEnum(OraTableType.class, text2);
    }

    public static OraMatViewRefreshMode importOraMatViewRefreshMode(String text2) {
        return PropertyConverter.importEnum(OraMatViewRefreshMode.class, text2);
    }

    public static OraMatViewRefreshMethod importOraMatViewRefreshMethod(String text2) {
        return PropertyConverter.importEnum(OraMatViewRefreshMethod.class, text2);
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = text2.trim().replace('-', '_').toUpperCase(Locale.ENGLISH);
        return Enum.valueOf(enumClass, big);
    }

    public static <E extends Enum<E>> E importEnumLC(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = text2.trim().replace('-', '_');
        return Enum.valueOf(enumClass, big);
    }

    @Nullable
    public static RedshiftTableDistStyle importRedshiftTableDistStyle(String style) {
        return PropertyConverter.importEnum(RedshiftTableDistStyle.class, style);
    }

    @Nullable
    public static PostgresVolatilityKind importPostgresVolatilityKind(String kind) {
        return PropertyConverter.importEnum(PostgresVolatilityKind.class, kind);
    }

    @Nullable
    public static PostgresRoutineConcurrencyKind importPostgresRoutineConcurrencyKind(String kind) {
        return PropertyConverter.importEnum(PostgresRoutineConcurrencyKind.class, kind);
    }

    @Nullable
    public static RedshiftTableBackupMode importRedshiftTableBackupMode(String kind) {
        return PropertyConverter.importEnum(RedshiftTableBackupMode.class, kind);
    }

    @Nullable
    public static RedshiftExternalTableStorageType importRedshiftExternalTableStorageType(String type) {
        return PropertyConverter.importEnum(RedshiftExternalTableStorageType.class, type);
    }

    @Nullable
    public static SqliteOnConflictAlgorithm importSqliteOnConflictAlgorithm(String kind) {
        return PropertyConverter.importEnum(SqliteOnConflictAlgorithm.class, kind);
    }

    @Nullable
    public static MysqlColumnKind importMysqlColumnKind(String kind) {
        return PropertyConverter.importEnum(MysqlColumnKind.class, kind);
    }

    @Nullable
    public static ExasolScriptType importExasolScriptType(String kind) {
        return PropertyConverter.importEnum(ExasolScriptType.class, kind);
    }

    public static <E extends Enum> Method getStaticMethod(@NotNull Class<E> clazz, @NotNull String name, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            PropertyConverter.$$$reportNull$$$0(37);
        }
        if (name == null) {
            PropertyConverter.$$$reportNull$$$0(38);
        }
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Method %s.%s(%s) must be static", clazz.getSimpleName(), name, StringUtil.join((Object[])parameterTypes, t -> t.getSimpleName(), (String)", ")));
        }
        method.setAccessible(true);
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dt";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "si";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numbers";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfShort";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfLong";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfLong";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfString";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "convertListToSet";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfString";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfTrigEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportEnumCode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfShort";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfLong";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfLong";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfNumber";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfTrigEvent";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertListToSet";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

