/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFiltersGroup
extends ActionGroup
implements DumbAware {
    private static final FilterTemplate[] NULL_FILTER_TEMPLATES = new FilterTemplate[]{new NullFilterTemplate(false), new NullFilterTemplate(true)};
    private static final FilterTemplate[] FILTER_TEMPLATES = new FilterTemplate[]{new FilterTemplate("="), new FilterTemplate("<>"), new FilterTemplate(">"), new FilterTemplate("<"), new LikeFilterTemplate(false), new LikeFilterTemplate(true)};

    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = dataGrid != null && dataGrid.isFilteringSupported();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        DataGrid dataGrid;
        DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        if (selectionModel.getSelectedColumnCount() != 1 || selectionModel.getSelectedRowCount() != 1) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        DataConsumer.Row row = (DataConsumer.Row)model.getRow(selectionModel.getSelectedRow());
        DataConsumer.Column column2 = (DataConsumer.Column)model.getColumn(selectionModel.getSelectedColumn());
        if (row == null || column2 == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFiltersGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> children = new ArrayList<AnAction>();
        ColumnFiltersGroup.addActions(NULL_FILTER_TEMPLATES, children, dataGrid, row, column2);
        children.add((AnAction)new Separator());
        ColumnFiltersGroup.addActions(FILTER_TEMPLATES, children, dataGrid, row, column2);
        children.add((AnAction)new Separator());
        ColumnFiltersGroup.addActions(FILTER_TEMPLATES, children, dataGrid, null, column2);
        AnAction[] anActionArray = children.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ColumnFiltersGroup.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    private static void addActions(FilterTemplate[] templates, List<AnAction> actions, DataGrid grid, DataConsumer.Row row, DataConsumer.Column column2) {
        for (FilterTemplate template : templates) {
            ContainerUtil.addIfNotNull(actions, (Object)((Object)ColumnFiltersGroup.createFilterAction(template, grid, row, column2)));
        }
    }

    private static ColumnFilterAction createFilterAction(FilterTemplate template, DataGrid grid, DataConsumer.Row row, DataConsumer.Column column2) {
        PreparedColumnFilterExpression preparedExpression = template.prepare(grid, row, column2);
        return preparedExpression == null ? null : new ColumnFilterAction(preparedExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ColumnFiltersGroup", "getChildren"));
    }

    private static class ColumnFilterAction
    extends DumbAwareAction {
        private final PreparedColumnFilterExpression myPreparedExpression;

        private ColumnFilterAction(PreparedColumnFilterExpression expression) {
            super(expression.getPresentableText());
            this.myPreparedExpression = expression;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                ColumnFilterAction.$$$reportNull$$$0(0);
            }
            if ((dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext())) == null) {
                return;
            }
            int completionOffset = this.myPreparedExpression.getCompletionOffset();
            dataGrid.setFilterText(this.myPreparedExpression.getText(), completionOffset);
            if (completionOffset == -1) {
                dataGrid.applyFilter();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ColumnFiltersGroup$ColumnFilterAction", "actionPerformed"));
        }
    }

    private static class PreparedColumnFilterExpression {
        private final String myText;
        private final int myCompletionOffset;

        public PreparedColumnFilterExpression(String text2, int completionOffset) {
            this.myText = text2;
            this.myCompletionOffset = completionOffset;
        }

        public String getText() {
            return this.myText;
        }

        public int getCompletionOffset() {
            return this.myCompletionOffset;
        }

        public String getPresentableText() {
            String fullPresentableText = this.myCompletionOffset == -1 ? this.myText : this.myText.substring(0, this.myCompletionOffset) + "..." + this.myText.substring(this.myCompletionOffset, this.myText.length());
            return StringUtil.first((String)fullPresentableText, (int)50, (boolean)true);
        }
    }

    private static class NullFilterTemplate
    extends FilterTemplate {
        public NullFilterTemplate(boolean isNotNull) {
            super("IS" + (isNotNull ? " NOT" : ""));
        }

        @Override
        @Nullable
        protected String getValueLiteral(DataGrid grid, DataConsumer.Column column2, DataConsumer.Row row) {
            return "NULL";
        }

        @Override
        protected boolean isAvailableFor(DataConsumer.Row row, DataConsumer.Column column2) {
            return true;
        }
    }

    private static class LikeFilterTemplate
    extends FilterTemplate {
        public LikeFilterTemplate(boolean isNotLike) {
            super((isNotLike ? "NOT " : "") + "LIKE", "'%", "%'");
        }

        @Override
        @Nullable
        protected String getValueLiteral(DataGrid grid, DataConsumer.Column column2, DataConsumer.Row row) {
            return row == null ? null : grid.getObjectFormatter().getPlainValue(column2, row, (DatabaseDialect)DataGridUtil.getDatabaseDialect(grid));
        }

        @Override
        protected boolean isAvailableFor(DataConsumer.Row row, DataConsumer.Column column2) {
            return super.isAvailableFor(row, column2) && JdbcUtil.isStringType((int)column2.type);
        }
    }

    private static class FilterTemplate {
        private final String myOperator;
        private final String myValuePrefix;
        private final String myValueSuffix;

        public FilterTemplate(String operator) {
            this(operator, "", "");
        }

        protected FilterTemplate(String operator, String valuePrefix, String valueSuffix) {
            this.myOperator = operator;
            this.myValuePrefix = valuePrefix;
            this.myValueSuffix = valueSuffix;
        }

        @Nullable
        public PreparedColumnFilterExpression prepare(DataGrid grid, DataConsumer.Row row, DataConsumer.Column column2) {
            if (!this.isAvailableFor(row, column2)) {
                return null;
            }
            DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
            int completionOffset = -1;
            DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)DataGridUtil.getDatabaseTable(grid));
            builder.identifier(column2.name).space().plain(this.myOperator).space();
            builder.plain(this.myValuePrefix);
            String valueLiteral = this.getValueLiteral(grid, column2, row);
            if (valueLiteral != null) {
                builder.plain(valueLiteral);
            } else {
                completionOffset = builder.length();
            }
            builder.plain(this.myValueSuffix);
            String filterExpressionText = builder.getStatement();
            return filterExpressionText.contains("\n") ? null : new PreparedColumnFilterExpression(filterExpressionText, completionOffset);
        }

        protected boolean isAvailableFor(DataConsumer.Row row, DataConsumer.Column column2) {
            return row == null || row.values[column2.columnNum] != null;
        }

        @Nullable(value="null means the value is yet to be entered")
        protected @Nullable(value="null means the value is yet to be entered") String getValueLiteral(DataGrid grid, DataConsumer.Column column2, DataConsumer.Row row) {
            boolean shouldQuote;
            String unquoted;
            String string = unquoted = row == null ? null : grid.getObjectFormatter().getValueLiteral(row, column2, DataGridUtil.getDatabaseDialect(grid), false);
            if (unquoted == null) {
                return null;
            }
            boolean bl = shouldQuote = !JdbcUtil.isNumberType((int)column2.type);
            if (DataGridUtil.getDatabaseDialect(grid).getFamilyId().isMysql() && column2.type == -7) {
                shouldQuote = false;
            }
            return shouldQuote ? '\'' + unquoted + '\'' : unquoted;
        }
    }
}

