/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.run.session.SessionView;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SessionLogger
extends MeasuringDataAuditor {
    protected final SessionView<?> myView;

    public SessionLogger(@NotNull SessionView<?> view) {
        if (view == null) {
            SessionLogger.$$$reportNull$$$0(0);
        }
        this.myView = view;
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            SessionLogger.$$$reportNull$$$0(2);
        }
        super.jobSubmitted(request, producer);
        if (request instanceof DataRequest.TxRequest || SessionLogger.isLazySchemaSwitch(request)) {
            return;
        }
        this.showView();
    }

    @Override
    public void print(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        this.myView.getHistoryLogger().print(context, message);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myView.getProject());
        if (statusBar != null) {
            statusBar.setInfo(message, this.myView.getToolWindowId());
        }
    }

    @Override
    public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(4);
        }
        this.myView.getHistoryLogger().warn(context, message);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(5);
        }
        super.error(context, message, th);
        Pair<String, Throwable> report = this.getLogMessageAndThrowable(message, th);
        this.myView.getHistoryLogger().error(context, (String)report.first, (Throwable)report.second);
        this.bringAttentionToOutput(context, true);
    }

    @Override
    public void beforeStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(6);
        }
        super.beforeStatement(context);
        this.myView.addRequestToHistory(context);
    }

    @Override
    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, boolean isError) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(7);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            Object session;
            if (context == null) {
                SessionLogger.$$$reportNull$$$0(16);
            }
            if (!(session = this.myView.getSession()).isValid()) {
                return;
            }
            boolean focusOnError = this.shouldFocusOnError(context);
            boolean wasShowing = this.myView.isShowing();
            Consumer runnable = aVoid -> {
                boolean focus;
                if (!session.isValid()) {
                    return;
                }
                Content content = this.myView.getOutputContent();
                if (content == null) {
                    return;
                }
                this.myView.getUi().setBouncing(content, true);
                boolean bl = focus = !wasShowing || isError && focusOnError;
                if (!focus) {
                    return;
                }
                this.myView.getUi().selectAndFocus(content, false, false);
                this.myView.getHistoryLogger().scrollToEnd();
            };
            if (this.shouldShow(context)) {
                this.myView.show(true, false).done(runnable);
                return;
            }
            runnable.consume(null);
        });
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(8);
        }
        boolean hasErrors = this.getStat((DataRequest.Context)context).errorCount > 0L;
        NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
        String query = context.getQuery();
        String text2 = (query.isEmpty() ? "Request" : StringUtil.trimMiddle((String)query, (int)60)) + "... <a href=\"\">finished!</a>";
        SessionLogger.fireBackToConsoleNotification(this.myView, type, text2);
    }

    @NotNull
    protected Pair<String, Throwable> getLogMessageAndThrowable(@Nullable String message, @Nullable Throwable throwable) {
        Pair pair = Pair.create((Object)message, (Object)throwable);
        if (pair == null) {
            SessionLogger.$$$reportNull$$$0(9);
        }
        return pair;
    }

    protected boolean shouldFocusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(10);
        }
        return true;
    }

    protected boolean shouldShow(@NotNull DataRequest.Context context) {
        if (context == null) {
            SessionLogger.$$$reportNull$$$0(11);
        }
        return false;
    }

    private static void fireBackToConsoleNotification(@NotNull SessionView<?> view, @NotNull NotificationType type, @NotNull String text2) {
        if (view == null) {
            SessionLogger.$$$reportNull$$$0(12);
        }
        if (type == null) {
            SessionLogger.$$$reportNull$$$0(13);
        }
        if (text2 == null) {
            SessionLogger.$$$reportNull$$$0(14);
        }
        String title = view.getTitle();
        final WeakReference viewRef = new WeakReference(view);
        DatabaseNotifications.DATABASE_LONG_RUNNING_GROUP.createNotification(title, text2, type, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                SessionView view;
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((view = (SessionView)viewRef.get()) != null) {
                    view.show(true, false);
                } else {
                    notification.expire();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/audit/SessionLogger$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(view.getProject());
        SystemNotifications.getInstance().notify("SessionLogger", title, text2);
    }

    private void showView() {
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (!this.myView.getSession().isValid()) {
                return;
            }
            if (this.myView.getContent().getManager() == null) {
                this.myView.show(this.shouldActivate(), false);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    protected boolean shouldActivate() {
        return true;
    }

    private static boolean isLazySchemaSwitch(@NotNull DataRequest request) {
        if (request == null) {
            SessionLogger.$$$reportNull$$$0(15);
        }
        return request instanceof DataRequest.SchemaSwitchRequest && !((DataRequest.SchemaSwitchRequest)request).forced;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/audit/SessionLogger";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/audit/SessionLogger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessageAndThrowable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jobSubmitted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionToOutput";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionByNotification";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldFocusOnError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldShow";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireBackToConsoleNotification";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLazySchemaSwitch";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$bringAttentionToOutput$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

