/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BoundaryValueResolver {
    ALWAYS_NULL{

        @Override
        @NotNull
        Object createJdbcNegativeInfinityValue() {
            throw new UnsupportedOperationException("Should never happens");
        }

        @Override
        @NotNull
        Object createJdbcPositiveInfinityValue() {
            throw new UnsupportedOperationException("Should never happens");
        }

        @Override
        @NotNull
        java.util.Date getPresentablePositiveInfinity() {
            throw new UnsupportedOperationException("Should never happens");
        }

        @Override
        @NotNull
        java.util.Date getPresentableNegativeInfinity() {
            throw new UnsupportedOperationException("Should never happens");
        }

        @Override
        boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                1.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                1.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "object";
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPositiveInfinity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isNegativeInfinity";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    DATE((Class)Date.class, DatabaseFamilyId::isPostgres, "infinity", "-infinity", new String[]{"date", "daterange"}){

        @Override
        @NotNull
        Object createJdbcPositiveInfinityValue() {
            Date date = Infinity.PG_POSITIVE_INFINITY_DATE;
            if (date == null) {
                2.$$$reportNull$$$0(0);
            }
            return date;
        }

        @Override
        @NotNull
        Object createJdbcNegativeInfinityValue() {
            Date date = Infinity.PG_NEGATIVE_INFINITY_DATE;
            if (date == null) {
                2.$$$reportNull$$$0(1);
            }
            return date;
        }

        @Override
        boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                2.$$$reportNull$$$0(2);
            }
            return object instanceof java.util.Date && ((java.util.Date)object).getTime() >= Infinity.PG_DATE_MIN_POSITIVE_INFINITY_TIME;
        }

        @Override
        boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                2.$$$reportNull$$$0(3);
            }
            return object instanceof java.util.Date && ((java.util.Date)object).getTime() <= Infinity.PG_DATE_MAX_NEGATIVE_INFINITY_TIME;
        }

        @Override
        @NotNull
        Date getPresentablePositiveInfinity() {
            Date date = Date.valueOf(Infinity.PG_POSITIVE_INF_DATE);
            if (date == null) {
                2.$$$reportNull$$$0(4);
            }
            return date;
        }

        @Override
        @NotNull
        Date getPresentableNegativeInfinity() {
            Date date = Date.valueOf(Infinity.PG_NEGATIVE_INF_DATE);
            if (date == null) {
                2.$$$reportNull$$$0(5);
            }
            return date;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$2";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    TIMESTAMP((Class)Timestamp.class, DatabaseFamilyId::isPostgres, "infinity", "-infinity", new String[]{"timestamp", "tsrange"}){

        @Override
        @NotNull
        Object createJdbcPositiveInfinityValue() {
            Timestamp timestamp = Infinity.PG_POSITIVE_INFINITY_TIMESTAMP;
            if (timestamp == null) {
                3.$$$reportNull$$$0(0);
            }
            return timestamp;
        }

        @Override
        @NotNull
        Object createJdbcNegativeInfinityValue() {
            Timestamp timestamp = Infinity.PG_NEGATIVE_INFINITY_TIMESTAMP;
            if (timestamp == null) {
                3.$$$reportNull$$$0(1);
            }
            return timestamp;
        }

        @Override
        boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                3.$$$reportNull$$$0(2);
            }
            return object instanceof Timestamp && ((Timestamp)object).getTime() >= Infinity.PG_TIMESTAMP_MIN_POSITIVE_INFINITY_TIME;
        }

        @Override
        boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                3.$$$reportNull$$$0(3);
            }
            return object instanceof Timestamp && ((Timestamp)object).getTime() <= Infinity.PG_TIMESTAMP_MAX_NEGATIVE_INFINITY_TIME;
        }

        @Override
        @NotNull
        java.util.Date getPresentablePositiveInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_POSITIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                3.$$$reportNull$$$0(4);
            }
            return timestamp;
        }

        @Override
        @NotNull
        java.util.Date getPresentableNegativeInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_NEGATIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                3.$$$reportNull$$$0(5);
            }
            return timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$3";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$3";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    TIMESTAMP_TZ((Class)TimeZonedTimestamp.class, DatabaseFamilyId::isPostgres, "infinity", "-infinity", new String[]{"timestamptz", "tstzrange"}){

        @Override
        @NotNull
        Object createJdbcNegativeInfinityValue() {
            TimeZonedTimestamp timeZonedTimestamp = Infinity.PG_NEGATIVE_INFINITY_TIMESTAMP_TZ;
            if (timeZonedTimestamp == null) {
                4.$$$reportNull$$$0(0);
            }
            return timeZonedTimestamp;
        }

        @Override
        @NotNull
        Object createJdbcPositiveInfinityValue() {
            TimeZonedTimestamp timeZonedTimestamp = Infinity.PG_POSITIVE_INFINITY_TIMESTAMP_TZ;
            if (timeZonedTimestamp == null) {
                4.$$$reportNull$$$0(1);
            }
            return timeZonedTimestamp;
        }

        @Override
        boolean isPositiveInfinity(@NotNull Object object) {
            if (object == null) {
                4.$$$reportNull$$$0(2);
            }
            return object instanceof TimeZonedTimestamp && this.toLocalDateTime((TimeZonedTimestamp)object).compareTo(Infinity.PG_MAX_TIMESTAMP) > 0;
        }

        @Override
        boolean isNegativeInfinity(@NotNull Object object) {
            if (object == null) {
                4.$$$reportNull$$$0(3);
            }
            return object instanceof TimeZonedTimestamp && this.toLocalDateTime((TimeZonedTimestamp)object).compareTo(Infinity.PG_MIN_TIMESTAMP) < 0;
        }

        @NotNull
        private LocalDateTime toLocalDateTime(@NotNull TimeZonedTimestamp object) {
            if (object == null) {
                4.$$$reportNull$$$0(4);
            }
            LocalDateTime localDateTime = ((OffsetDateTime)object.getValue()).withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
            if (localDateTime == null) {
                4.$$$reportNull$$$0(5);
            }
            return localDateTime;
        }

        @Override
        @NotNull
        java.util.Date getPresentablePositiveInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_POSITIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                4.$$$reportNull$$$0(6);
            }
            return timestamp;
        }

        @Override
        @NotNull
        java.util.Date getPresentableNegativeInfinity() {
            Timestamp timestamp = Timestamp.valueOf(Infinity.PG_NEGATIVE_INF_TIMESTAMP);
            if (timestamp == null) {
                4.$$$reportNull$$$0(7);
            }
            return timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$4";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcNegativeInfinityValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createJdbcPositiveInfinityValue";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$4";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toLocalDateTime";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePositiveInfinity";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableNegativeInfinity";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPositiveInfinity";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isNegativeInfinity";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "toLocalDateTime";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private final String[] myTypeNames;
    private final Class<?> myObjectClass;
    private final Condition<DatabaseFamilyId> myFamilyChecker;
    private final String myPositiveInfinityString;
    private final String myNegativeInfinityString;

    private BoundaryValueResolver() {
        this(null, null, null, null, new String[0]);
    }

    private BoundaryValueResolver(@Nullable Class<?> objectClass, @Nullable Condition<DatabaseFamilyId> familyChecker, @NotNull String positiveInfinityString, String negativeInfinityString, String ... typeNames) {
        if (typeNames == null) {
            BoundaryValueResolver.$$$reportNull$$$0(0);
        }
        this.myObjectClass = objectClass;
        this.myFamilyChecker = BoundaryValueResolver.notNull(familyChecker);
        this.myTypeNames = typeNames;
        this.myPositiveInfinityString = positiveInfinityString;
        this.myNegativeInfinityString = negativeInfinityString;
    }

    @Nullable
    public String resolve(@NotNull Object value) {
        if (value == null) {
            BoundaryValueResolver.$$$reportNull$$$0(1);
        }
        return this.myObjectClass != null && this.myObjectClass.isInstance(value) ? this.getInfinityString(value) : null;
    }

    @NotNull
    public java.util.Date bound(@NotNull Object object) {
        if (object == null) {
            BoundaryValueResolver.$$$reportNull$$$0(2);
        }
        java.util.Date date = this.isPositiveInfinity(object) ? this.getPresentablePositiveInfinity() : (this.isNegativeInfinity(object) ? this.getPresentableNegativeInfinity() : BoundaryValueResolver.getLegacyDate(object));
        if (date == null) {
            BoundaryValueResolver.$$$reportNull$$$0(3);
        }
        return date;
    }

    @Nullable
    public Object createFromInfinityString(@NotNull String value) {
        if (value == null) {
            BoundaryValueResolver.$$$reportNull$$$0(4);
        }
        return StringUtil.equalsIgnoreWhitespaces((CharSequence)value, (CharSequence)this.myPositiveInfinityString) ? this.createJdbcPositiveInfinityValue() : (StringUtil.equalsIgnoreWhitespaces((CharSequence)value, (CharSequence)this.myNegativeInfinityString) ? this.createJdbcNegativeInfinityValue() : null);
    }

    @NotNull
    public static BoundaryValueResolver getResolver(@Nullable DatabaseFamilyId family, @Nullable DataConsumer.Column column2) {
        for (BoundaryValueResolver resolver : BoundaryValueResolver.values()) {
            boolean columnTypeEquals = StringUtil.findIgnoreCase((String)(column2 == null ? null : column2.typeName), (String[])resolver.myTypeNames);
            if (!resolver.myFamilyChecker.value((Object)family) || !columnTypeEquals) continue;
            BoundaryValueResolver boundaryValueResolver = resolver;
            if (boundaryValueResolver == null) {
                BoundaryValueResolver.$$$reportNull$$$0(5);
            }
            return boundaryValueResolver;
        }
        BoundaryValueResolver boundaryValueResolver = ALWAYS_NULL;
        if (boundaryValueResolver == null) {
            BoundaryValueResolver.$$$reportNull$$$0(6);
        }
        return boundaryValueResolver;
    }

    @Nullable
    public static String getInfinityString(@Nullable DatabaseFamilyId family, @Nullable DataConsumer.Column column2, @NotNull Object object) {
        if (object == null) {
            BoundaryValueResolver.$$$reportNull$$$0(7);
        }
        return BoundaryValueResolver.getResolver(family, column2).getInfinityString(object);
    }

    @Nullable
    public String getInfinityString(@Nullable Object value) {
        return value != null && this.isPositiveInfinity(value) ? this.myPositiveInfinityString : (value != null && this.isNegativeInfinity(value) ? this.myNegativeInfinityString : null);
    }

    @NotNull
    abstract java.util.Date getPresentablePositiveInfinity();

    @NotNull
    abstract java.util.Date getPresentableNegativeInfinity();

    @NotNull
    abstract Object createJdbcPositiveInfinityValue();

    @NotNull
    abstract Object createJdbcNegativeInfinityValue();

    abstract boolean isPositiveInfinity(@NotNull Object var1);

    abstract boolean isNegativeInfinity(@NotNull Object var1);

    @NotNull
    static java.util.Date getLegacyDate(@NotNull Object object) {
        if (object == null) {
            BoundaryValueResolver.$$$reportNull$$$0(8);
        }
        java.util.Date date = (java.util.Date)Rules.MAP.get(object.getClass()).fun(object);
        if (date == null) {
            BoundaryValueResolver.$$$reportNull$$$0(9);
        }
        return date;
    }

    @NotNull
    private static Condition<DatabaseFamilyId> notNull(@Nullable Condition<DatabaseFamilyId> condition) {
        Condition condition2 = condition == null ? Conditions.alwaysFalse() : id -> id != null && condition.value(id);
        if (condition2 == null) {
            BoundaryValueResolver.$$$reportNull$$$0(10);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "bound";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyDate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bound";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromInfinityString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInfinityString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Rules {
        static final Map<Class<?>, Function<Object, java.util.Date>> MAP = ContainerUtil.immutableMapBuilder().put(java.util.Date.class, o -> (java.util.Date)o).put(Date.class, o -> (java.util.Date)o).put(Timestamp.class, o -> (java.util.Date)o).put(TimeZonedTimestamp.class, o -> Timestamp.valueOf(((OffsetDateTime)((TimeZonedTimestamp)o).getValue()).toLocalDateTime())).build();

        Rules() {
        }
    }

    static class Infinity {
        static final String PG_POSITIVE_INFINITY = "infinity";
        static final String PG_NEGATIVE_INFINITY = "-infinity";
        static final LocalDateTime PG_MAX_TIMESTAMP = LocalDateTime.of(294276, 12, 31, 23, 59, 59, 999999999);
        static final LocalDateTime PG_MIN_TIMESTAMP = LocalDateTime.of(4713, 1, 1, 0, 0, 0, 0).with(ChronoField.ERA, 0L);
        static final LocalDateTime PG_POSITIVE_INF_TIMESTAMP = PG_MAX_TIMESTAMP.plus(1L, ChronoUnit.NANOS);
        static final LocalDateTime PG_NEGATIVE_INF_TIMESTAMP = PG_MIN_TIMESTAMP.minus(1L, ChronoUnit.NANOS);
        static final LocalDate PG_MAX_DATE = LocalDate.of(5874897, 12, 31);
        static final LocalDate PG_MIN_DATE = LocalDate.of(4713, 1, 1).with(ChronoField.ERA, 0L);
        static final LocalDate PG_POSITIVE_INF_DATE = PG_MAX_DATE.plus(1L, ChronoUnit.DAYS);
        static final LocalDate PG_NEGATIVE_INF_DATE = PG_MIN_DATE.minus(1L, ChronoUnit.DAYS);
        static final long PG_POSITIVE_INFINITY_TIME = 9223372036825200000L;
        static final long PG_NEGATIVE_INFINITY_TIME = -9223372036832400000L;
        static final long PG_TIMESTAMP_MIN_POSITIVE_INFINITY_TIME = Timestamp.valueOf(PG_POSITIVE_INF_TIMESTAMP).getTime();
        static final long PG_TIMESTAMP_MAX_NEGATIVE_INFINITY_TIME = Timestamp.valueOf(PG_NEGATIVE_INF_TIMESTAMP).getTime();
        static final long PG_DATE_MIN_POSITIVE_INFINITY_TIME = Date.valueOf(PG_POSITIVE_INF_DATE).getTime();
        static final long PG_DATE_MAX_NEGATIVE_INFINITY_TIME = Date.valueOf(PG_NEGATIVE_INF_DATE).getTime();
        static final Timestamp PG_POSITIVE_INFINITY_TIMESTAMP = new Timestamp(9223372036825200000L);
        static final Timestamp PG_NEGATIVE_INFINITY_TIMESTAMP = new Timestamp(-9223372036832400000L);
        static final Date PG_POSITIVE_INFINITY_DATE = new Date(9223372036825200000L);
        static final Date PG_NEGATIVE_INFINITY_DATE = new Date(-9223372036832400000L);
        static final TimeZonedTimestamp PG_POSITIVE_INFINITY_TIMESTAMP_TZ = new TimeZonedTimestamp(PG_POSITIVE_INF_TIMESTAMP.atOffset(ZoneOffset.UTC)){

            @Override
            @NotNull
            public JdbcInjection injection(@NotNull DatabaseFamilyId family) {
                if (family == null) {
                    1.$$$reportNull$$$0(0);
                }
                JdbcInjection.PgTimestampInjection pgTimestampInjection = new JdbcInjection.PgTimestampInjection(Infinity.PG_POSITIVE_INFINITY);
                if (pgTimestampInjection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pgTimestampInjection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "family";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$Infinity$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$Infinity$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "injection";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "injection";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        static final TimeZonedTimestamp PG_NEGATIVE_INFINITY_TIMESTAMP_TZ = new TimeZonedTimestamp(PG_NEGATIVE_INF_TIMESTAMP.atOffset(ZoneOffset.UTC)){

            @Override
            @NotNull
            public JdbcInjection injection(@NotNull DatabaseFamilyId family) {
                if (family == null) {
                    2.$$$reportNull$$$0(0);
                }
                JdbcInjection.PgTimestampInjection pgTimestampInjection = new JdbcInjection.PgTimestampInjection(Infinity.PG_NEGATIVE_INFINITY);
                if (pgTimestampInjection == null) {
                    2.$$$reportNull$$$0(1);
                }
                return pgTimestampInjection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "family";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$Infinity$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$Infinity$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "injection";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "injection";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };

        Infinity() {
        }
    }
}

