/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator$CreateScenarioBuilder$WhenMappings;
import com.intellij.database.scripting.BaseCreatingGenerator$WhenMappings;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingConstraintContext;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 b2\u00020\u0001:\u0002bcB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\bH\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\u00060\u0015R\u00020\u0000H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dH\u0014J\u001e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u001dH\u0014J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0014J\u0016\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0014J\u0016\u0010-\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0+H\u0014J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0014J\u0016\u00105\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002060+H\u0014J\u0016\u00107\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002080+H\u0014J\u0016\u00109\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+H\u0014J\u0016\u0010:\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020;0+H\u0014J\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020;H\u0014J\u0010\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?H\u0014J\u0016\u0010@\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020%0+H\u0014J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020BH\u0014J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0014J\u0016\u0010D\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002030+H\u0014J\u0010\u0010E\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020;H\u0014J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GH\u0014J\u0010\u0010I\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010J\u001a\u00020\b2\b\u0010K\u001a\u0004\u0018\u0001062\u0006\u0010L\u001a\u000208H\u0014J\u0014\u0010M\u001a\u0004\u0018\u00010\u00112\b\u0010N\u001a\u0004\u0018\u00010OH\u0014J\u0012\u0010P\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010Q\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010R\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020SH\u0014J\u0012\u0010T\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010U\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010V\u001a\u00020\u00112\u0006\u0010K\u001a\u000206H\u0014J\u0010\u0010W\u001a\u00020\u00112\u0006\u0010L\u001a\u000208H\u0014J\u0012\u0010X\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0012\u0010[\u001a\u0004\u0018\u00010\u00112\u0006\u0010>\u001a\u00020?H\u0014J\u0010\u0010\\\u001a\u00020]2\u0006\u0010$\u001a\u00020%H\u0014J\b\u0010^\u001a\u00020\u000bH\u0016J\u0018\u0010_\u001a\u00020\u00112\u0006\u0010K\u001a\u0002062\u0006\u0010!\u001a\u00020\u0011H\u0014J\b\u0010`\u001a\u00020\bH\u0014J\u0016\u0010a\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180+H\u0004R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006d"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "isExact", "", "()Z", "addInnerConstraintNameAndIndent", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "addOuterConstraintNameAndIndent", "allowReferenceOnPrimaryKeyWithoutColumns", "createOrReplace", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "elementKindNameForCreate", "element", "Lcom/intellij/database/model/basic/BasicElement;", "gatherSequenceIdentityParameters", "identity", "Lcom/intellij/database/model/SequenceIdentity;", "parameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateAdditionalTableItems", "table", "Lcom/intellij/database/model/basic/BasicTable;", "generateCascadeRules", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateCheck", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/basic/BasicCheck;", "generateColumn", "generateColumnComment", "generateComment", "generateDeferrability", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateForeignKey", "generateIndex", "Lcom/intellij/database/model/basic/BasicIndex;", "generateKey", "Lcom/intellij/database/model/basic/BasicKey;", "generateSequence", "generateSourceAwareElement", "Lcom/intellij/database/model/basic/BasicSourceAware;", "generateSourceAwareUsingSources", "generateSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateTable", "generateTableComment", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTableOutsideStuff", "generateTrigger", "generateUnspecificSourceAwareElement", "getEdgeFixers", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "ifNotExists", "isIndexExplicitFor", "index", "key", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeColumnDefinition", "makeColumnSpecification", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeDeferrability", "makeForeignKeyReference", "makeIndexWord", "makeKeyWord", "makeNormalColumnSpecification", "makeOperation", "Lcom/intellij/database/scripting/Operation;", "makeSynonymTargetSpec", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "prepareScenario", "scriptIndexColumn", "shouldCollectColumnElements", "weDontKnowHowToGenerateThis", "Companion", "CreateScenarioBuilder", "intellij.database.scripting"})
public class BaseCreatingGenerator
extends AbstractCodeGenerator {
    private final boolean isExact;
    @NotNull
    private static final OperationType CREATE;
    private static final Companion.CREATE_FK_FIXER.1 CREATE_FK_FIXER;
    private static final List<Companion.CREATE_FK_FIXER.1> CREATE_FIXERS;
    public static final Companion Companion;

    protected final boolean isExact() {
        return this.isExact;
    }

    @Override
    public void prepareScenario() {
        this.createScenarioBuilder().prepareScenario();
    }

    @NotNull
    protected CreateScenarioBuilder createScenarioBuilder() {
        return new CreateScenarioBuilder();
    }

    @Override
    @NotNull
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.createScenarioBuilder().makeCreateOperation(element, this.getScenario().getRoot());
    }

    @Override
    @NotNull
    protected List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return BaseCreatingGenerator.Companion.getCREATE_FIXERS();
    }

    protected void generateSequence(@NotNull ElementProducer<BasicSequence> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicSequence sequence = producer.getElement();
        if (sequence instanceof BasicNamedElement && ((BasicNamedElement)((Object)sequence)).isNameSurrogate()) {
            return;
        }
        String name = this.currentScopeName(sequence);
        ArrayList parameters = new ArrayList();
        this.gatherSequenceIdentityParameters(sequence, (List<String>)parameters);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, sequence, name, parameters){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicSequence $sequence;
            final /* synthetic */ String $name;
            final /* synthetic */ ArrayList $parameters;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                CharSequence[] charSequenceArray = new CharSequence[4];
                ObjectKind objectKind = ObjectKind.SEQUENCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SEQUENCE");
                charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                String string = this.this$0.elementKindNameForCreate(this.$sequence);
                charSequenceArray[1] = string != null ? (CharSequence)string : (CharSequence)"sequence";
                ObjectKind objectKind2 = ObjectKind.SEQUENCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.SEQUENCE");
                charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                charSequenceArray[3] = this.$name;
                codeTextBuilder.phrase(charSequenceArray);
                Collection collection = this.$parameters;
                if (!collection.isEmpty()) {
                    AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ generateSequence.1 this$0;

                        public final void invoke() {
                            for (String p : this.this$0.$parameters) {
                                CodeTextBuilder.append$default(this.this$0.this$0.getBuilder(), p, null, false, 6, null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }, 1, null);
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$sequence = basicSequence;
                this.$name = string;
                this.$parameters = arrayList;
                super(0);
            }
        }, 3, null);
    }

    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        SequenceIdentity i2;
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        SequenceIdentity sequenceIdentity = sequence.getSequenceIdentity();
        if (sequenceIdentity == null) {
            return;
        }
        SequenceIdentity sequenceIdentity2 = i2 = sequenceIdentity;
        Intrinsics.checkExpressionValueIsNotNull((Object)sequenceIdentity2, (String)"i");
        this.gatherSequenceIdentityParameters(sequenceIdentity2, parameters);
    }

    protected void gatherSequenceIdentityParameters(@NotNull SequenceIdentity identity, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        int sign = identity.increment.signum();
        switch (sign) {
            case 1: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null && Intrinsics.areEqual((Object)identity.min, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("minvalue " + identity.min);
                }
                if (Intrinsics.areEqual((Object)identity.increment, (Object)BigInteger.ONE) ^ true) {
                    parameters.add("increment by " + identity.increment);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
                break;
            }
            case -1: {
                if (identity.next != null && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.max != null) {
                    parameters.add("maxvalue " + identity.max);
                }
                parameters.add("increment by " + identity.increment);
                if (identity.min == null) break;
                parameters.add("minvalue " + identity.min);
                break;
            }
            default: {
                if (identity.next != null && Intrinsics.areEqual((Object)identity.next, (Object)BigInteger.ONE) ^ true && this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CURRENT_SEQUENCE_VALUE).booleanValue()) {
                    parameters.add("start with " + identity.next);
                }
                if (identity.min != null) {
                    parameters.add("minvalue " + identity.min);
                }
                if (identity.max == null) break;
                parameters.add("maxvalue " + identity.max);
            }
        }
    }

    protected void generateTable(@NotNull ElementProducer<BasicTable> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, producer){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ ElementProducer $producer;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void header;
                HeaderFooter headerFooter = this.this$0.makeTableHeaderFooter((BasicTable)this.$producer.getElement());
                String string = headerFooter.component1();
                String footer = headerFooter.component2();
                CodeTextBuilder.append$default(this.this$0.getBuilder(), (CharSequence)header, null, false, 6, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                this.this$0.coding(ScriptLocus.IN_TABLE, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateTable.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $receiver$iv;
                        Iterable iterable = this.this$0.$producer.getNestedOperations();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                        for (T element$iv : $receiver$iv) {
                            Operation p1 = (Operation)element$iv;
                            baseCreatingGenerator.produce(p1);
                        }
                        this.this$0.this$0.generateAdditionalTableItems((BasicTable)this.this$0.$producer.getElement());
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
                this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                CodeTextBuilder.append$default(this.this$0.getBuilder(), footer, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$producer = elementProducer;
                super(0);
            }
        }, 3, null);
        if (Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE)) || Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT))) {
            this.generateTableOutsideStuff(producer.getElement());
        }
    }

    protected void generateAdditionalTableItems(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    protected void generateTableOutsideStuff(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        if (table.getComment() != null) {
            this.generateComment(table);
        }
        for (BasicTableOrViewColumn column2 : table.getColumns()) {
            if (column2.getComment() == null) continue;
            BasicTableOrViewColumn basicTableOrViewColumn = column2;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
            this.generateComment(basicTableOrViewColumn);
        }
    }

    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String name = this.currentScopeName(table);
        String temporary = table.isTemporary() ? "temporary" : null;
        String[] stringArray = new String[5];
        ObjectKind objectKind = table.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
        stringArray[0] = this.createOrReplace(objectKind);
        stringArray[1] = temporary;
        String string = this.elementKindNameForCreate(table);
        if (string == null) {
            string = "table";
        }
        stringArray[2] = string;
        ObjectKind objectKind2 = table.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
        stringArray[3] = this.ifNotExists(objectKind2);
        stringArray[4] = name;
        String h = ScriptingUtilsKt.phrase(stringArray);
        return new HeaderFooter(h, null);
    }

    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE) ? "sequence" : null);
    }

    protected void generateColumn(@NotNull ElementProducer<BasicLikeColumn> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicLikeColumn column2 = producer.getElement();
        String string = this.makeColumnDefinition(column2);
        if (string == null) {
            return;
        }
        String line = string;
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[this.getLocus().ordinal()]) {
            case 1: {
                CodeTextBuilder.append$default(this.getBuilder(), line, null, false, 6, null);
                this.coding(ScriptLocus.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this, producer){
                    final /* synthetic */ BaseCreatingGenerator this$0;
                    final /* synthetic */ ElementProducer $producer;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $receiver$iv;
                        Iterable iterable = this.$producer.getNestedOperations();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                        for (T element$iv : $receiver$iv) {
                            Operation p1 = (Operation)element$iv;
                            baseCreatingGenerator.produce(p1);
                        }
                    }
                    {
                        this.this$0 = baseCreatingGenerator;
                        this.$producer = elementProducer;
                        super(0);
                    }
                }));
                this.getBuilder().addSuffixToTheLastLine(',');
                break;
            }
            case 2: {
                BasicScriptable basicScriptable;
                BasicLikeColumn basicLikeColumn = column2;
                if (!(basicLikeColumn instanceof BasicTableColumn)) {
                    basicLikeColumn = null;
                }
                if ((basicScriptable = (BasicTableColumn)basicLikeColumn) == null || (basicScriptable = basicScriptable.getTable()) == null) {
                    return;
                }
                BasicScriptable table = basicScriptable;
                String tableName = this.currentScopeName(table);
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, line, producer){
                    final /* synthetic */ BaseCreatingGenerator this$0;
                    final /* synthetic */ String $tableName;
                    final /* synthetic */ String $line;
                    final /* synthetic */ ElementProducer $producer;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        this.this$0.getBuilder().phrase("alter table", this.$tableName);
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().phrase("add", this.$line);
                            this.this$0.coding(ScriptLocus.IN_COLUMN, true, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ generateColumn.2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke() {
                                    void $receiver$iv;
                                    Iterable iterable = this.this$0.$producer.getNestedOperations();
                                    BaseCreatingGenerator baseCreatingGenerator = this.this$0.this$0;
                                    for (T element$iv : $receiver$iv) {
                                        Operation p1 = (Operation)element$iv;
                                        baseCreatingGenerator.produce(p1);
                                    }
                                }
                            }));
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                    {
                        this.this$0 = baseCreatingGenerator;
                        this.$tableName = string;
                        this.$line = string2;
                        this.$producer = elementProducer;
                        super(0);
                    }
                }, 3, null);
                if (column2.getComment() == null) break;
                this.generateColumnComment(column2);
                break;
            }
            default: {
                this.getBuilder().phrase("Here should be column", line);
            }
        }
    }

    protected boolean shouldCollectColumnElements() {
        return Intrinsics.areEqual((Object)((Object)this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN)) && Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String string = column2.getName();
        BaseCreatingGenerator this_$iv = this;
        String name = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        String specification = this.makeColumnSpecification(column2);
        return ScriptingUtilsKt.concatWithSpace(name, specification);
    }

    @Nullable
    protected String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof BasicTableColumn && ((BasicTableColumn)column2).isComputed() && ((BasicTableColumn)column2).getDefaultExpression() != null ? this.makeComputedColumnSpecification((BasicTableOrViewColumn)column2) : this.makeNormalColumnSpecification(column2);
    }

    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        boolean autoInc = column2 instanceof BasicTableColumn && ((BasicTableColumn)column2).isAutoInc();
        String specification = this.generalColumnSpecification(column2);
        if (column2.getDefaultExpression() != null) {
            specification = specification + " default " + column2.getDefaultExpression();
        }
        if (column2.isNotNull() && !autoInc) {
            specification = specification + " not null";
        }
        if (!column2.isNotNull() && this.getHelper().isNullExplicit(column2) && !autoInc) {
            specification = specification + " null";
        }
        return specification;
    }

    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DataType dataType = column2.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        return this.script(dataType);
    }

    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return "as " + column2.getDefault();
    }

    protected void generateIndex(@NotNull ElementProducer<BasicIndex> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicIndex index = producer.getElement();
        String w = this.makeIndexWord(index);
        String condition = index.getCondition();
        StringBuilder b = new StringBuilder();
        for (String col : index.getColNames()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.append(", ");
            }
            String string = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"col");
            b.append(this.scriptIndexColumn(index, string));
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, index, b, condition){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $w;
            final /* synthetic */ BasicIndex $index;
            final /* synthetic */ StringBuilder $b;
            final /* synthetic */ String $condition;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$1[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                        break;
                    }
                    case 2: {
                        String s = this.this$0.getUseName(this.$index) ? "" + this.$w + ' ' + this.$index.getName() + " (" + this.$b + ')' : "" + this.$w + " (" + this.$b + ')';
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), s, null, false, 6, null);
                        break;
                    }
                    default: {
                        BasicLikeTable basicLikeTable = this.$index.getLikeTable();
                        String tableName = basicLikeTable != null ? this.this$0.currentScopeName(basicLikeTable) : null;
                        String indexName = this.this$0.currentScopeName(this.$index);
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        CharSequence[] charSequenceArray = new CharSequence[4];
                        ObjectKind objectKind = ObjectKind.INDEX;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
                        charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                        charSequenceArray[1] = this.$w;
                        ObjectKind objectKind2 = ObjectKind.INDEX;
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"ObjectKind.INDEX");
                        charSequenceArray[2] = this.this$0.ifNotExists(objectKind2);
                        charSequenceArray[3] = indexName;
                        codeTextBuilder.phrase(charSequenceArray);
                        CodeTextBuilder this_$iv = this.this$0.getBuilder();
                        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                        try {
                            this.this$0.getBuilder().phrase("on " + tableName + " (" + this.$b + ')');
                            this.this$0.getBuilder().phrase(ScriptingUtilsKt.concatIfNotNull("where ", this.$condition));
                            break;
                        }
                        finally {
                            this_$iv.unindent();
                        }
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$w = string;
                this.$index = basicIndex;
                this.$b = stringBuilder;
                this.$condition = string2;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column2) {
        String s;
        String string;
        boolean dirs;
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        CharSequence charSequence = column2;
        if (charSequence.length() == 0) {
            return "???";
        }
        Set<String> descendants = index.getReverseColNames();
        Collection collection = descendants;
        boolean bl = dirs = !collection.isEmpty();
        if (column2.charAt(0) == '\u001b') {
            String string2 = column2;
            int n = 1;
            int n2 = column2.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            void $receiver$iv;
            String string4 = column2;
            BaseCreatingGenerator this_$iv = this;
            string = s = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        }
        if (dirs) {
            s = s + (descendants.contains(column2) ? " desc" : " asc");
        }
        return s;
    }

    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index) {
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        return index.isUnique() ? "unique index" : "index";
    }

    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return key2.isPrimary() ? "primary key" : "unique";
    }

    protected void generateKey(@NotNull ElementProducer<BasicKey> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicKey key2 = producer.getElement();
        String w = this.makeKeyWord(key2);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, w){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicKey $key;
            final /* synthetic */ String $w;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$2[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$key);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$w, null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                        break;
                    }
                    case 2: {
                        void this_$iv2;
                        void $receiver$iv2;
                        this.this$0.addInnerConstraintNameAndIndent(this.$key);
                        Iterable iterable = this.$key.getColNames();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append(this.$w).append(" (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractCodeGenerator)this_$iv2){
                            final /* synthetic */ AbstractCodeGenerator this$0;

                            @NotNull
                            public final String invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                String $receiver$iv = it;
                                AbstractCodeGenerator this_$iv = this.this$0;
                                return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                            }
                            {
                                this.this$0 = abstractCodeGenerator;
                                super(1);
                            }
                        }), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(")").toString(), null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                        break;
                    }
                    default: {
                        void this_$iv;
                        void $receiver$iv;
                        String string;
                        String string2;
                        CodeTextBuilder codeTextBuilder;
                        StringBuilder stringBuilder;
                        Object $receiver$iv2;
                        CodeTextBuilder codeTextBuilder2 = this.this$0.getBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder().append("alter table ");
                        String string3 = this.$key.getTableName();
                        if (string3 != null) {
                            $receiver$iv2 = string3;
                            BaseCreatingGenerator this_$iv2 = this.this$0;
                            stringBuilder = stringBuilder2;
                            codeTextBuilder = codeTextBuilder2;
                            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)$receiver$iv2);
                            codeTextBuilder2 = codeTextBuilder;
                            stringBuilder2 = stringBuilder;
                            string = string2;
                        } else {
                            string = null;
                        }
                        CodeTextBuilder.append$default(codeTextBuilder2, stringBuilder2.append(string).toString(), null, false, 6, null);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$key);
                        String w1 = !this.this$0.getUseName(this.$key) ? "add " : "";
                        Iterable $i$f$getScr = this.$key.getColNames();
                        $receiver$iv2 = this.this$0;
                        stringBuilder = new StringBuilder().append(w1).append(this.$w).append(" (");
                        codeTextBuilder = this.this$0.getBuilder();
                        string2 = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string2).append(")").toString(), null, false, 6, null);
                        this.this$0.generateDeferrability(this.$key);
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$key = basicKey;
                this.$w = string;
                super(0);
            }
        }, 3, null);
    }

    protected boolean isIndexExplicitFor(@Nullable BasicIndex index, @NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return index != null && this.getUseName(index) && Intrinsics.areEqual((Object)index.getName(), (Object)key2.getName()) ^ true;
    }

    protected void generateForeignKey(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String reference = this.makeForeignKeyReference(fk);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, fk, reference){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicForeignKey $fk;
            final /* synthetic */ String $reference;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$3[this.this$0.getLocus().ordinal()]) {
                    case 1: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$reference, null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                        break;
                    }
                    case 2: {
                        void this_$iv;
                        void $receiver$iv;
                        this.this$0.addInnerConstraintNameAndIndent(this.$fk);
                        Iterable iterable = this.$fk.getColNames();
                        BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append("foreign key (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                        this.this$0.getBuilder().addSuffixToTheLastLine(',');
                        break;
                    }
                    default: {
                        void this_$iv;
                        void $receiver$iv;
                        BaseCreatingGenerator $receiver$iv2;
                        PostgresTable table;
                        Object object;
                        DasTable dasTable = this.$fk.getTable();
                        if (!(dasTable instanceof PostgresTable)) {
                            dasTable = null;
                        }
                        if ((object = (table = (PostgresTable)dasTable)) == null || (object = this.this$0.currentScopeName((BasicElement)object)) == null) {
                            String string = this.$fk.getTableName();
                            if (string != null) {
                                String string2 = string;
                                BaseCreatingGenerator this_$iv2 = this.this$0;
                                object = AbstractCodeGenerator.access$getNaming$p(this_$iv2).nameToScript((String)((Object)$receiver$iv2));
                            } else {
                                object = null;
                            }
                        }
                        Object tableName = object;
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter table " + (String)tableName, null, false, 6, null);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$fk);
                        String w1 = !this.this$0.getUseName(this.$fk) ? "add " : "";
                        Iterable $i$f$getScr = this.$fk.getColNames();
                        $receiver$iv2 = this.this$0;
                        StringBuilder stringBuilder = new StringBuilder().append(w1).append("foreign key (");
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(") ").append(this.$reference).toString(), null, false, 6, null);
                        this.this$0.generateCascadeRules(this.$fk);
                        this.this$0.generateDeferrability(this.$fk);
                    }
                }
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$fk = basicForeignKey;
                this.$reference = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected String makeForeignKeyReference(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        domSchemaName = ModelFun.getSchemaName(fk);
        refSchemaName = fk.getRefSchemaName();
        if (refSchemaName == null) ** GOTO lbl-1000
        if (Intrinsics.areEqual((Object)refSchemaName, (Object)domSchemaName) ^ true) ** GOTO lbl-1000
        v0 = this.getContext().getCurrentSchema();
        if (Intrinsics.areEqual((Object)refSchemaName, (Object)(v0 != null ? v0.getRealName() : null)) ^ true) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = toQualify = false;
        }
        if (toQualify) {
            v2 = new StringBuilder();
            v3 = refSchemaName;
            if (v3 != null) {
                var7_5 = v3;
                var6_6 = this;
                var11_8 = v2;
                var12_9 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                v2 = var11_8;
                v4 = var12_9;
            } else {
                v4 = null;
            }
            v5 = v2.append(v4).append(".");
            v6 = fk.getRefTableName();
            if (v6 != null) {
                $receiver$iv = v6;
                this_$iv = this;
                var11_8 = v5;
                var12_9 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                v5 = var11_8;
                v7 = var12_9;
            } else {
                v7 = null;
            }
            v8 = v5.append(v7).toString();
        } else {
            v9 = fk.getRefTableName();
            if (v9 != null) {
                $receiver$iv = v9;
                this_$iv = this;
                v8 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            } else {
                v8 = null;
            }
        }
        refTableScr = v8;
        omitReferencedColumns = ModelFun.getRefToPrimaryKey(fk) != false && this.allowReferenceOnPrimaryKeyWithoutColumns() != false;
        v10 = new StringBuilder().append("references ").append(refTableScr);
        if (omitReferencedColumns) {
            v11 = "";
        } else {
            var9_11 = fk.getRefColNames();
            $i$f$getScr = this;
            var12_9 = new StringBuilder().append(" (");
            var11_8 = v10;
            var13_13 = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new /* invalid duplicate definition of identical inner class */), (int)31, null);
            v10 = var11_8;
            v11 = var12_9.append(var13_13).append(")").toString();
        }
        reference = v10.append(v11).toString();
        return reference;
    }

    protected boolean allowReferenceOnPrimaryKeyWithoutColumns() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCascadeRules(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        String c1 = ScriptingUtilsKt.concatIfNotNull("on update ", this.makeCascadeRuleKeyword(fk.getOnUpdate()));
        String c2 = ScriptingUtilsKt.concatIfNotNull("on delete ", this.makeCascadeRuleKeyword(fk.getOnDelete()));
        String c = ScriptingUtilsKt.phrase(c1, c2);
        if (c != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), c, null, false, 6, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        CascadeRule cascadeRule = rule;
        if (cascadeRule == null) return null;
        switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$4[cascadeRule.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                String string = rule.keyWord;
                return string;
            }
            default: {
                return null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateCheck(@NotNull ElementProducer<BasicCheck> producer) {
        void w1;
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicCheck check = producer.getElement();
        String def2 = "check (" + check.getPredicate() + ")";
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, check, (Ref.ObjectRef)w1, def2){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ BasicCheck $check;
            final /* synthetic */ Ref.ObjectRef $w1;
            final /* synthetic */ String $def;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                switch (BaseCreatingGenerator$WhenMappings.$EnumSwitchMapping$5[this.this$0.getLocus().ordinal()]) {
                    case 1: 
                    case 2: {
                        this.this$0.addInnerConstraintNameAndIndent(this.$check);
                        break;
                    }
                    default: {
                        CharSequence charSequence;
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "alter table";
                        CharSequence[] charSequenceArray2 = charSequenceArray;
                        CharSequence[] charSequenceArray3 = charSequenceArray;
                        int n = 1;
                        Object object = this.$check.getLikeTable();
                        if (object != null && (object = this.this$0.currentScopeName((BasicElement)object)) != null) {
                            charSequence = (CharSequence)object;
                        } else {
                            String string;
                            String string2 = this.$check.getTableName();
                            if (string2 != null) {
                                void $receiver$iv;
                                void this_$iv;
                                String string3 = string2;
                                BaseCreatingGenerator baseCreatingGenerator = this.this$0;
                                int n2 = n;
                                CharSequence[] charSequenceArray4 = charSequenceArray2;
                                CharSequence[] charSequenceArray5 = charSequenceArray3;
                                CodeTextBuilder codeTextBuilder2 = codeTextBuilder;
                                String string4 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                                codeTextBuilder = codeTextBuilder2;
                                charSequenceArray3 = charSequenceArray5;
                                charSequenceArray2 = charSequenceArray4;
                                n = n2;
                                string = string4;
                            } else {
                                string = null;
                            }
                            charSequence = string;
                        }
                        charSequenceArray2[n] = charSequence;
                        codeTextBuilder.phrase(charSequenceArray3);
                        CodeTextBuilder.indent$default(this.this$0.getBuilder(), null, 1, null);
                        this.this$0.addOuterConstraintNameAndIndent(this.$check);
                        if (this.this$0.getUseName(this.$check)) break;
                        this.$w1.element = "add ";
                    }
                }
                this.this$0.generateDeferrability(this.$check);
                String text2 = (String)this.$w1.element + this.$def;
                if (Intrinsics.areEqual((Object)((Object)this.this$0.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE))) {
                    text2 = text2 + ',';
                }
                CodeTextBuilder.append$default(this.this$0.getBuilder(), text2, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$check = basicCheck;
                this.$w1 = objectRef;
                this.$def = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        String dfr = this.makeDeferrability(constraint);
        if (dfr != null) {
            CodeTextBuilder this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), dfr, null, false, 6, null);
            }
            finally {
                this_$iv.unindent();
            }
        }
    }

    @Nullable
    protected String makeDeferrability(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        return constraint.isDeferrable() ? (constraint.isInitiallyDeferred() ? "deferrable initially deferred" : "deferrable") : null;
    }

    /*
     * WARNING - void declaration
     */
    protected void addInnerConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            void $receiver$iv;
            String string = constraint.getName();
            BaseCreatingGenerator this_$iv = this;
            String name = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
            CodeTextBuilder.append$default(this.getBuilder(), "constraint " + name, null, false, 6, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    protected void addOuterConstraintNameAndIndent(@NotNull BasicConstraint constraint) {
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        if (this.getUseName(constraint)) {
            String name = this.currentScopeName(constraint);
            CodeTextBuilder.append$default(this.getBuilder(), "add constraint " + name, null, false, 6, null);
            CodeTextBuilder.indent$default(this.getBuilder(), null, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateTrigger(@NotNull ElementProducer<BasicTrigger> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicTrigger trigger = producer.getElement();
        if (trigger instanceof BasicSourceAware) {
            void this_$iv;
            ElementProducer<BasicTrigger> elementProducer = producer;
            BaseCreatingGenerator baseCreatingGenerator = this;
            boolean bl = Intrinsics.areEqual((Object)trigger, this_$iv.getElement());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ElementProducer<BasicTrigger> elementProducer2 = elementProducer;
            baseCreatingGenerator.generateSourceAwareElement(elementProducer2);
            if (trigger.isDisabled()) {
                this.generateDisableTrigger(trigger);
            }
        } else {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
                final /* synthetic */ BaseCreatingGenerator this$0;
                final /* synthetic */ BasicTrigger $trigger;

                public final void invoke() {
                    String triggerName = this.$trigger instanceof BasicSchemaObject ? this.this$0.currentScopeName(this.$trigger) : this.this$0.currentScopeName(this.$trigger);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- Unknown how to generate trigger " + triggerName, null, false, 6, null);
                }
                {
                    this.this$0 = baseCreatingGenerator;
                    this.$trigger = basicTrigger;
                    super(0);
                }
            }, 3, null);
        }
    }

    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String name = trigger instanceof BasicSchemaObject ? this.currentScopeName(trigger) : this.currentScopeName(trigger);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $name;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "alter trigger " + this.$name + " disable", null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$name = string;
                super(0);
            }
        }, 3, null);
    }

    protected void generateSourceAwareElement(@NotNull ElementProducer<BasicSourceAware> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicSourceAware element = producer.getElement();
        this.generateSourceAwareUsingSources(element);
        if (element.getComment() != null) {
            this.generateComment(element);
            if (element instanceof BasicView) {
                PositioningNamingFamily columns2 = ((BasicView)element).getColumns();
                Iterator iterator = columns2.iterator();
                while (iterator.hasNext()) {
                    BasicTableOrViewColumn column2;
                    BasicTableOrViewColumn basicTableOrViewColumn = column2 = (BasicTableOrViewColumn)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
                    this.generateComment(basicTableOrViewColumn);
                }
            }
        }
    }

    protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.generateUnspecificSourceAwareElement(element);
    }

    protected void generateUnspecificSourceAwareElement(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        CompositeText st = element.getSourceText();
        if (st != null) {
            JBIterable jBIterable = JBIterable.from(st.getFragments()).split(JBIterable.Split.OFF, (Condition)generateUnspecificSourceAwareElement.statements.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(st.fragm\u2026eText.Kind.SQL_DELIMITER}");
            JBIterable statements2 = jBIterable;
            for (JBIterable statementFragments : statements2) {
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, statementFragments){
                    final /* synthetic */ BaseCreatingGenerator this$0;
                    final /* synthetic */ JBIterable $statementFragments;

                    public final void invoke() {
                        for (CompositeText.Fragment fragment : this.$statementFragments) {
                            this.this$0.getBuilder().append(fragment);
                        }
                    }
                    {
                        this.this$0 = baseCreatingGenerator;
                        this.$statementFragments = jBIterable;
                        super(0);
                    }
                }, 3, null);
            }
        }
    }

    protected void generateComment(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTableOrView) {
            this.generateTableComment((BasicTableOrView)element);
        } else if (basicElement instanceof BasicTableOrViewColumn) {
            this.generateColumnComment((BasicLikeColumn)element);
        }
    }

    protected void generateTableComment(@NotNull BasicTableOrView table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String string = table.getComment();
        if (string == null || (string = this.getSqlString(string)) == null) {
            return;
        }
        String comment = string;
        ObjectKind kind = table.getKind();
        String w = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ? "materialized view" : kind.code();
        String name = table instanceof BasicSchemaObject ? this.currentScopeName(table) : this.currentScopeName(table);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, w, name, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $w;
            final /* synthetic */ String $name;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on " + this.$w + ' ' + this.$name + " is " + this.$comment, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$w = string;
                this.$name = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void generateColumnComment(@NotNull BasicLikeColumn column2) {
        void $receiver$iv;
        BasicSchemaObject parent;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        DasObject dasObject = column2.getDbParent();
        if (!(dasObject instanceof BasicSchemaObject)) {
            dasObject = null;
        }
        if ((object = (parent = (BasicSchemaObject)dasObject)) == null || (object = this.currentScopeName((BasicElement)object)) == null) {
            return;
        }
        Object parentName = object;
        String string = column2.getName();
        BaseCreatingGenerator this_$iv = this;
        String columnName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        String string2 = column2.getComment();
        if (string2 == null || (string2 = this.getSqlString(string2)) == null) {
            return;
        }
        String comment = string2;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (String)parentName, columnName, comment){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $parentName;
            final /* synthetic */ String $columnName;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), "comment on column " + this.$parentName + '.' + this.$columnName + " is " + this.$comment, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$parentName = string;
                this.$columnName = string2;
                this.$comment = string3;
                super(0);
            }
        }, 3, null);
    }

    protected void generateSynonym(@NotNull BasicSynonym synonym) {
        String text2;
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        String targetSpec = this.makeSynonymTargetSpec(synonym);
        String name = this.currentScopeName(synonym);
        if (targetSpec != null) {
            String[] stringArray = new String[5];
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SYNONYM");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = "synonym";
            stringArray[2] = name;
            stringArray[3] = "for";
            stringArray[4] = targetSpec;
            String string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            text2 = string;
        } else {
            text2 = "-- unknown what the synonym " + name + " references on :(";
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text2){
            final /* synthetic */ BaseCreatingGenerator this$0;
            final /* synthetic */ String $text;

            public final void invoke() {
                CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$text, null, false, 6, null);
            }
            {
                this.this$0 = baseCreatingGenerator;
                this.$text = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected String makeSynonymTargetSpec(@NotNull BasicSynonym synonym) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        BasicMajorObject targetObject = synonym.getTargetObject();
        if (targetObject != null) {
            return this.currentScopeName(targetObject);
        }
        String schemaName = synonym.getTargetSchemaName();
        String string2 = synonym.getTargetObjectName();
        if (string2 == null) {
            return null;
        }
        String objectName = string2;
        if (schemaName == null) {
            void $receiver$iv;
            String string3 = objectName;
            BaseCreatingGenerator this_$iv = this;
            string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        } else {
            String $receiver$iv = schemaName;
            BaseCreatingGenerator this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            $receiver$iv = objectName;
            this_$iv = this;
            stringBuilder = stringBuilder.append(string4).append(".");
            string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            string = stringBuilder.append(string4).toString();
        }
        return string;
    }

    protected final void weDontKnowHowToGenerateThis(@NotNull ElementProducer<BasicElement> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicElement element = producer.getElement();
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        StringBuilder stringBuilder = new StringBuilder().append("-- we don't know how to generate ").append(element.getKind().code()).append(' ');
        String string = element.getRealName();
        if (string == null) {
            string = "<with-no-name>";
        }
        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string).append(" (class ").append(element.getClass().getSimpleName()).append(") :( --").toString(), null, false, 6, null);
    }

    @NotNull
    public final String createOrReplace(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false && this.getHelper().getSupportsCreateOrReplace().contains(kind) ? "create or replace" : "create";
    }

    @Nullable
    public final String ifNotExists(@NotNull ObjectKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_IF_NOT_EXISTS) != false && this.getHelper().getSupportsCreateIfNotExists().contains(kind) ? "if not exists" : null;
    }

    public BaseCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
        this.isExact = Intrinsics.areEqual((Object)((Object)this.getCategory()), (Object)((Object)ScriptCategory.CREATE_DEFINITION));
    }

    static {
        Companion = new Companion(null);
        CREATE = new OperationType("create");
        CREATE_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                BasicForeignKey basicForeignKey;
                void $receiver$iv;
                BasicLikeTable basicLikeTable;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op2.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation = op1;
                Object t$iv = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
                    if (!(basicElement instanceof BasicLikeTable)) {
                        basicElement = null;
                    }
                    basicLikeTable = (BasicLikeTable)basicElement;
                } else {
                    basicLikeTable = null;
                }
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op2;
                OperationType t$iv2 = BaseCreatingGenerator.Companion.getCREATE();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
                    if (!(basicElement instanceof BasicForeignKey)) {
                        basicElement = null;
                    }
                    basicForeignKey = (BasicForeignKey)basicElement;
                } else {
                    basicForeignKey = null;
                }
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                op2.setParent((Node)root2);
                return true;
            }
        };
        CREATE_FIXERS = CollectionsKt.listOf((Object)BaseCreatingGenerator.Companion.getCREATE_FK_FIXER());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0004J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u001a\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0014J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0006H\u0014JF\u0010'\u001a\u00020\u0006\"\b\b\u0000\u0010(*\u00020\u00052\u0006\u0010\u0010\u001a\u0002H(2\u0006\u0010 \u001a\u00020\u00062\u001d\u0010)\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0+\u0012\u0004\u0012\u00020,0*\u00a2\u0006\u0002\b-H\u0004\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0018\u00100\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u00101\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u0002022\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u00103\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u0002042\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u00105\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u0002062\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u00107\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u0002082\u0006\u0010 \u001a\u00020\u0006H\u0014J\u0018\u00109\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020:2\u0006\u0010 \u001a\u00020\u0006H\u0014J$\u0010;\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00062\b\b\u0002\u0010<\u001a\u00020\u000fH\u0014J\u0006\u0010=\u001a\u00020,J\u001c\u0010>\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0006H\u0004R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006?"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "", "(Lcom/intellij/database/scripting/BaseCreatingGenerator;)V", "prepared", "Ljava/util/HashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "()Ljava/util/HashMap;", "tableElementsApplicableInExactTask", "", "Lcom/intellij/database/model/ObjectKind;", "getTableElementsApplicableInExactTask", "()Ljava/util/Set;", "canCreateInColumn", "", "element", "canCreateInTable", "canCreateIndexInCurrentContext", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "canGenerateElementRightNow", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "canGenerateInnerElement", "getSingleColumnElements", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeCreateCheck", "Lcom/intellij/database/model/basic/BasicCheck;", "root", "makeCreateForeignKey", "Lcom/intellij/database/model/basic/BasicForeignKey;", "makeCreateIndex", "makeCreateKey", "Lcom/intellij/database/model/basic/BasicKey;", "makeCreateLikeColumn", "makeCreateNode", "T", "delegate", "Lkotlin/Function1;", "Lcom/intellij/database/scripting/ElementProducer;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/scripting/Operation;Lkotlin/jvm/functions/Function1;)Lcom/intellij/database/scripting/Operation;", "makeCreateOperation", "makeCreateOther", "makeCreateSequence", "Lcom/intellij/database/model/basic/BasicSequence;", "makeCreateSourceAware", "Lcom/intellij/database/model/basic/BasicSourceAware;", "makeCreateSynonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "makeCreateTable", "Lcom/intellij/database/model/basic/BasicTable;", "makeCreateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "prepareElement", "forceRoot", "prepareScenario", "defaultCreateNode", "intellij.database.scripting"})
    protected class CreateScenarioBuilder {
        @NotNull
        private final HashMap<BasicElement, Operation> prepared = new HashMap();
        @NotNull
        private final Set<ObjectKind> tableElementsApplicableInExactTask = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK});

        @NotNull
        protected final HashMap<BasicElement, Operation> getPrepared() {
            return this.prepared;
        }

        public final void prepareScenario() {
            ScriptingTask scriptingTask = BaseCreatingGenerator.this.getTask();
            if (scriptingTask == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.ScriptingSingleModelTask");
            }
            ScriptingSingleModelTask task = (ScriptingSingleModelTask)scriptingTask;
            Iterable $receiver$iv = task.getElements();
            for (Object element$iv : $receiver$iv) {
                BasicElement it = (BasicElement)element$iv;
                if (it instanceof BasicTable && ((BasicTable)it).isSystem() || it.isAutoCreated()) continue;
                CreateScenarioBuilder.prepareElement$default(this, it, BaseCreatingGenerator.this.getScenario().getRoot(), false, 4, null);
            }
        }

        @Nullable
        protected Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
            Operation operation;
            block5: {
                block4: {
                    Operation operation2;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    operation = this.prepared.get(element);
                    if (operation == null) break block4;
                    Operation $receiver = operation2 = operation;
                    if (forceRoot) {
                        $receiver.setParent((Node)root2);
                    }
                    if ((operation = operation2) != null) break block5;
                }
                operation = this.makeCreateOperation(element, root2);
            }
            return operation;
        }

        @Nullable
        public static /* bridge */ /* synthetic */ Operation prepareElement$default(CreateScenarioBuilder createScenarioBuilder, BasicElement basicElement, Operation operation, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return createScenarioBuilder.prepareElement(basicElement, operation, bl);
        }

        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof BasicSequence ? this.makeCreateSequence((BasicSequence)element, root2) : (basicElement instanceof BasicTable ? this.makeCreateTable((BasicTable)element, root2) : (basicElement instanceof BasicLikeColumn ? this.makeCreateLikeColumn((BasicLikeColumn)element, root2) : (basicElement instanceof BasicIndex ? this.makeCreateIndex((BasicIndex)element, root2) : (basicElement instanceof BasicKey ? this.makeCreateKey((BasicKey)element, root2) : (basicElement instanceof BasicForeignKey ? this.makeCreateForeignKey((BasicForeignKey)element, root2) : (basicElement instanceof BasicCheck ? this.makeCreateCheck((BasicCheck)element, root2) : (basicElement instanceof BasicTrigger ? this.makeCreateTrigger((BasicTrigger)element, root2) : (basicElement instanceof BasicSourceAware ? this.makeCreateSourceAware((BasicSourceAware)element, root2) : (basicElement instanceof BasicSynonym ? this.makeCreateSynonym((BasicSynonym)element, root2) : this.makeCreateOther(element, root2))))))))));
        }

        @NotNull
        protected final <T extends BasicElement> Operation makeCreateNode(@NotNull T element, @NotNull Operation root2, @NotNull Function1<? super ElementProducer<T>, Unit> delegate) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            return this.defaultCreateNode(new Operation(new ElementProducer<T>(Companion.getCREATE(), element, delegate)), element, root2);
        }

        @NotNull
        protected final Operation defaultCreateNode(@NotNull Operation $receiver, @NotNull BasicElement element, @NotNull Operation root2) {
            BasicElement it;
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver2 = operation = $receiver;
            $receiver2.setParent((Node)root2);
            Map map2 = this.prepared;
            BasicElement basicElement = element;
            Operation operation2 = $receiver2;
            map2.put(basicElement, operation2);
            BasicElement basicElement2 = element.getParent();
            BasicElement p = basicElement2 != null ? (Intrinsics.areEqual((Object)(it = (basicElement = basicElement2)).getKind(), (Object)ObjectKind.ROOT) ? null : it) : null;
            ScenarioOperations.requires($receiver2, ScenarioOperations.opt(EffectType.Existent, p));
            Iterable<? extends BasicElement> iterable = element.getPredecessors();
            Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"element.predecessors");
            ScenarioOperations.requires($receiver2, ScenarioOperations.invoke(EffectType.Existent, iterable));
            ScenarioOperations.provides($receiver2, ScenarioOperations.invoke(EffectType.Existent, element));
            return operation;
        }

        @NotNull
        protected Operation makeCreateSynonym(@NotNull BasicSynonym element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSynonym>, Unit>(this, element){
                final /* synthetic */ CreateScenarioBuilder this$0;
                final /* synthetic */ BasicSynonym $element;

                public final void invoke(@NotNull ElementProducer<BasicSynonym> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateSynonym(this.$element);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    this.$element = basicSynonym;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateSourceAware(@NotNull BasicSourceAware element, @NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSourceAware>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicSourceAware> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateSourceAwareElement($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
            Iterable $receiver$iv = (Iterable)element.getChildren();
            for (Object element$iv : $receiver$iv) {
                BasicElement it = (BasicElement)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getKind(), (Object)ObjectKind.ARGUMENT) ^ true)) continue;
                BasicElement basicElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                CreateScenarioBuilder.prepareElement$default(this, basicElement, root2, false, 4, null);
            }
            return operation;
        }

        @NotNull
        protected Operation makeCreateTrigger(@NotNull BasicTrigger element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicTrigger>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicTrigger> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateTrigger($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateCheck(@NotNull BasicCheck element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicCheck>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicCheck> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateCheck($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateForeignKey(@NotNull BasicForeignKey element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicForeignKey>, Unit>(this, element){
                final /* synthetic */ CreateScenarioBuilder this$0;
                final /* synthetic */ BasicForeignKey $element;

                public final void invoke(@NotNull ElementProducer<BasicForeignKey> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateForeignKey(this.$element);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    this.$element = basicForeignKey;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateKey(@NotNull BasicKey element, @NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicKey>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicKey> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateKey($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
            BasicIndex index = element.getUnderlyingIndex();
            if (index != null && !BaseCreatingGenerator.this.isIndexExplicitFor(index, element)) {
                CreateScenarioBuilder.prepareElement$default(this, index, $receiver, false, 4, null);
            }
            return operation;
        }

        @NotNull
        protected Operation makeCreateIndex(@NotNull BasicIndex element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicIndex>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicIndex> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateIndex($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateLikeColumn(@NotNull BasicLikeColumn element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicLikeColumn>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicLikeColumn> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateColumn($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateTable(@NotNull BasicTable element, @NotNull Operation root2) {
            BasicKey key2;
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicTable>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicTable> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateTable($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
            Iterable $receiver$iv = element.getKeys();
            for (Object element$iv : $receiver$iv) {
                key2 = (BasicKey)element$iv;
                BasicIndex basicIndex = key2.getUnderlyingIndex();
                BasicKey basicKey = key2;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"key");
                if (!BaseCreatingGenerator.this.isIndexExplicitFor(basicIndex, basicKey)) continue;
                CreateScenarioBuilder.prepareElement$default(this, key2, root2, false, 4, null);
            }
            $receiver$iv = element.getColumns();
            for (Object element$iv : $receiver$iv) {
                Operation $i$a$1$forEach;
                BasicTableOrViewColumn column2;
                BasicTableOrViewColumn basicTableOrViewColumn = column2 = (BasicTableOrViewColumn)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicTableOrViewColumn, (String)"column");
                if (CreateScenarioBuilder.prepareElement$default(this, basicTableOrViewColumn, $receiver, false, 4, null) == null) continue;
                Operation $receiver2 = $i$a$1$forEach;
                Iterable<BasicElement> $receiver$iv2 = this.getSingleColumnElements(column2);
                Iterator<BasicElement> iterator = $receiver$iv2.iterator();
                while (iterator.hasNext()) {
                    BasicElement element$iv2;
                    BasicElement it = element$iv2 = iterator.next();
                    CreateScenarioBuilder.prepareElement$default(this, it, $receiver2, false, 4, null);
                }
            }
            $receiver$iv = element.getKeys();
            for (Object element$iv : $receiver$iv) {
                BasicKey basicKey = key2 = (BasicKey)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"key");
                CreateScenarioBuilder.prepareElement$default(this, basicKey, $receiver, false, 4, null);
            }
            for (BasicElement child : element.getChildren()) {
                if (!this.tableElementsApplicableInExactTask.contains(child.getKind()) && BaseCreatingGenerator.this.isExact()) continue;
                BasicElement basicElement = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                if (this.canCreateInTable(basicElement)) {
                    CreateScenarioBuilder.prepareElement$default(this, child, $receiver, false, 4, null);
                    continue;
                }
                CreateScenarioBuilder.prepareElement$default(this, child, root2, false, 4, null);
            }
            return operation;
        }

        @NotNull
        protected Operation makeCreateSequence(@NotNull BasicSequence element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSequence>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicSequence> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.generateSequence($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeCreateOther(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeCreateNode(element, root2, (Function1)new Function1<ElementProducer<BasicElement>, Unit>(this){
                final /* synthetic */ CreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicElement> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseCreatingGenerator.this.weDontKnowHowToGenerateThis($receiver);
                }
                {
                    this.this$0 = createScenarioBuilder;
                    super(1);
                }
            });
        }

        protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
            switch (BaseCreatingGenerator$CreateScenarioBuilder$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
                case 1: {
                    if (!(element instanceof BasicConstraint) || Intrinsics.areEqual((Object)((Object)BaseCreatingGenerator.this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_AFTER_TABLE))) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (element instanceof BasicTableOrViewColumn || element instanceof BasicConstraint && BaseCreatingGenerator.this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT).compareTo((Enum)ScriptingConstraintContext.CONSTRAINT_IN_TABLE) <= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    if (element instanceof BasicConstraint && Intrinsics.areEqual((Object)((Object)BaseCreatingGenerator.this.getContext().getOptions().get(ScriptingOptionStatic.SCRIPTING_CONSTRAINT_CONTEXT)), (Object)((Object)ScriptingConstraintContext.CONSTRAINT_IN_COLUMN))) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        protected final Set<ObjectKind> getTableElementsApplicableInExactTask() {
            return this.tableElementsApplicableInExactTask;
        }

        protected final boolean canCreateInColumn(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return this.canGenerateHere(ScriptLocus.IN_COLUMN, element);
        }

        protected boolean canCreateInTable(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return this.canGenerateHere(ScriptLocus.IN_TABLE, element);
        }

        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column2) {
            Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
            BasicLikeTable basicLikeTable = column2.getLikeTable();
            if (basicLikeTable == null) {
                return SetsKt.emptySet();
            }
            BasicLikeTable table = basicLikeTable;
            JBIterable jBIterable = table.getChildren().filter(BasicConstraint.class).filter((Condition)new Condition<BasicConstraint>(this, column2){
                final /* synthetic */ CreateScenarioBuilder this$0;
                final /* synthetic */ BasicLikeColumn $column;

                public final boolean value(BasicConstraint it) {
                    BasicConstraint basicConstraint = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraint, (String)"it");
                    return this.this$0.canCreateInColumn(basicConstraint) && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
                }
                {
                    this.this$0 = createScenarioBuilder;
                    this.$column = basicLikeColumn;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n        .\u2026.first() == column.name }");
            return (Iterable)jBIterable;
        }

        protected boolean canCreateIndexInCurrentContext(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            return Intrinsics.areEqual((Object)((Object)BaseCreatingGenerator.this.getLocus()), (Object)((Object)ScriptLocus.IN_STATEMENT)) || Intrinsics.areEqual((Object)((Object)BaseCreatingGenerator.this.getLocus()), (Object)((Object)ScriptLocus.OUTSIDE));
        }

        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof BasicMinorObject && BaseCreatingGenerator.this.getLocus().compareTo((Enum)ScriptLocus.IN_TABLE) < 0) {
                return ((BasicMinorObject)element).getMajorObject() == null;
            }
            return true;
        }

        protected boolean canGenerateInnerElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return element instanceof BasicSchemaObject || element instanceof BasicSourceAware;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b*\u0001\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion;", "", "()V", "CREATE", "Lcom/intellij/database/scripting/OperationType;", "getCREATE", "()Lcom/intellij/database/scripting/OperationType;", "CREATE_FIXERS", "", "com/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1", "getCREATE_FIXERS", "()Ljava/util/List;", "CREATE_FK_FIXER", "getCREATE_FK_FIXER", "()Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$Companion$CREATE_FK_FIXER$1;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getCREATE() {
            return CREATE;
        }

        private final CREATE_FK_FIXER.1 getCREATE_FK_FIXER() {
            return CREATE_FK_FIXER;
        }

        private final List<CREATE_FK_FIXER.1> getCREATE_FIXERS() {
            return CREATE_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

