/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.Node;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 92\u00020\u0001:\u00029:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0004J\f\u0010\u0010\u001a\u00060\u0011R\u00020\u0000H\u0014J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0014J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0014J\u0016\u0010\u001b\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0014J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015H\u0014J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020 0\u0015H\u0014J\u0016\u0010!\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\"0\u0015H\u0014J\u0016\u0010#\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020$0\u0015H\u0014J\u0016\u0010%\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020&0\u0015H\u0014J\u0016\u0010'\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020(0\u0015H\u0014J\u0016\u0010)\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020*0\u0015H\u0014J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0014J\u0016\u0010.\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020/0\u0015H\u0014J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0014J\n\u00103\u001a\u0004\u0018\u00010\u000eH\u0004J\u0012\u00104\u001a\u0004\u0018\u00010\n2\u0006\u0010,\u001a\u000205H\u0017J\b\u00106\u001a\u00020\u0013H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u000eH\u0004J\u0010\u00108\u001a\u00020\u00132\u0006\u0010,\u001a\u000205H\u0004\u00a8\u0006;"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "breakDropFkEdge", "", "root", "Lcom/intellij/database/scripting/Operation;", "opFk", "opTgt", "cascade", "", "cascadeConstraints", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseDropGenerator$DropScenarioBuilder;", "generateDatabase", "", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/basic/BasicDatabase;", "generateIndex", "Lcom/intellij/database/model/basic/BasicIndex;", "generateRoutine", "Lcom/intellij/database/model/basic/BasicRoutine;", "generateSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "generateSequence", "Lcom/intellij/database/model/basic/BasicSequence;", "generateSynonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "generateTableColumn", "Lcom/intellij/database/model/basic/BasicTableColumn;", "generateTableForeignKey", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateTableKey", "Lcom/intellij/database/model/basic/BasicKey;", "generateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateUnspecifiedMajorObject", "element", "Lcom/intellij/database/model/basic/BasicMajorObject;", "generateView", "Lcom/intellij/database/model/basic/BasicView;", "getEdgeFixers", "", "Lcom/intellij/database/scripting/AbstractCodeGenerator$EdgeFixer;", "ifExists", "makeOperation", "Lcom/intellij/database/model/basic/BasicElement;", "prepareScenario", "restrictCascade", "unknownHowToDrop", "Companion", "DropScenarioBuilder", "intellij.database.scripting"})
public class BaseDropGenerator
extends AbstractCodeGenerator {
    @NotNull
    private static final OperationType DROP;
    private static final Companion.DROP_FK_FIXER.1 DROP_FK_FIXER;
    private static final List<Companion.DROP_FK_FIXER.1> DROP_FIXERS;
    public static final Companion Companion;

    @Override
    public void prepareScenario() {
        this.createScenarioBuilder().prepareScenario();
    }

    @NotNull
    protected DropScenarioBuilder createScenarioBuilder() {
        return new DropScenarioBuilder();
    }

    @Override
    @Nullable
    public Operation makeOperation(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        DropScenarioBuilder builder = this.createScenarioBuilder();
        Operation res = builder.makeDropOperation(element, this.getScenario().getRoot());
        JBTreeTraverser<BasicElement> jBTreeTraverser = element.getModel();
        if (jBTreeTraverser != null && (jBTreeTraverser = jBTreeTraverser.traverser(true)) != null) {
            Iterable $receiver$iv = (Iterable)jBTreeTraverser;
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                builder.fillDropDependants(basicElement);
            }
        }
        return res;
    }

    @Override
    @NotNull
    protected List<AbstractCodeGenerator.EdgeFixer> getEdgeFixers() {
        return BaseDropGenerator.Companion.getDROP_FIXERS();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean breakDropFkEdge(Operation root2, Operation opFk, Operation opTgt) {
        BasicForeignKey basicForeignKey;
        void $receiver$iv;
        BasicLikeTable basicLikeTable;
        void $receiver$iv2;
        if (Intrinsics.areEqual((Object)((Operation)opFk.getParent()), (Object)root2)) {
            return false;
        }
        Operation operation = opTgt;
        Object t$iv = Companion.getDROP();
        if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
            BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
            if (!(basicElement instanceof BasicLikeTable)) {
                basicElement = null;
            }
            basicLikeTable = (BasicLikeTable)basicElement;
        } else {
            basicLikeTable = null;
        }
        if (basicLikeTable == null) {
            return false;
        }
        BasicLikeTable tgt = basicLikeTable;
        t$iv = opFk;
        OperationType t$iv2 = Companion.getDROP();
        if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
            BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
            if (!(basicElement instanceof BasicForeignKey)) {
                basicElement = null;
            }
            basicForeignKey = (BasicForeignKey)basicElement;
        } else {
            basicForeignKey = null;
        }
        if (basicForeignKey == null) {
            return false;
        }
        BasicForeignKey fk = basicForeignKey;
        if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
            return false;
        }
        opFk.setParent((Node)root2);
        return true;
    }

    protected void generateUnspecifiedMajorObject(@NotNull BasicMajorObject element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindName = StringUtil.toLowerCase((String)element.getKind().name());
        String objectName = this.currentScopeName(element);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, objectName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $objectName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("drop", this.$kindName, this.$objectName);
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$objectName = string2;
                super(0);
            }
        }, 3, null);
    }

    protected void generateDatabase(@NotNull ElementProducer<BasicDatabase> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateSequence(@NotNull ElementProducer<BasicSequence> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateSynonym(@NotNull ElementProducer<BasicSynonym> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateIndex(@NotNull ElementProducer<BasicIndex> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateTable(@NotNull ElementProducer<BasicTable> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateTrigger(@NotNull ElementProducer<BasicTrigger> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateTableForeignKey(@NotNull ElementProducer<BasicForeignKey> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateTableKey(@NotNull ElementProducer<BasicKey> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateTableColumn(@NotNull ElementProducer<BasicTableColumn> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateRoutine(@NotNull ElementProducer<BasicRoutine> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateView(@NotNull ElementProducer<BasicView> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    protected void generateSchema(@NotNull ElementProducer<BasicSchema> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        this.unknownHowToDrop(producer.getElement());
    }

    /*
     * WARNING - void declaration
     */
    protected final void unknownHowToDrop(@NotNull BasicElement element) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String kindName = element.getKind().name();
        String string = element.getName();
        BaseDropGenerator this_$iv = this;
        String elementName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, kindName, elementName){
            final /* synthetic */ BaseDropGenerator this$0;
            final /* synthetic */ String $kindName;
            final /* synthetic */ String $elementName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("-- unknown how to drop " + this.$kindName + ' ' + this.$elementName + " :(");
            }
            {
                this.this$0 = baseDropGenerator;
                this.$kindName = string;
                this.$elementName = string2;
                super(0);
            }
        }, 3, null);
    }

    @Nullable
    protected final String ifExists() {
        return this.getContext().getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
    }

    @Nullable
    protected final String cascade() {
        return this.getContext().getOptions().get(ScriptingOptionStatic.DROP_CASCADE) != false ? "cascade" : null;
    }

    @Nullable
    protected final String restrictCascade() {
        return this.cascade();
    }

    @Nullable
    protected final String cascadeConstraints() {
        String string;
        String string2 = this.cascade();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            string = "cascade constraints";
        } else {
            string = null;
        }
        return string;
    }

    public BaseDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        DROP = new OperationType("drop");
        DROP_FK_FIXER = new AbstractCodeGenerator.EdgeFixer(){

            /*
             * WARNING - void declaration
             */
            public boolean fix(@NotNull Operation root2, @NotNull Operation op1, @NotNull Operation op2) {
                BasicForeignKey basicForeignKey;
                void $receiver$iv;
                BasicLikeTable basicLikeTable;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)op1, (String)"op1");
                Intrinsics.checkParameterIsNotNull((Object)op2, (String)"op2");
                if (Intrinsics.areEqual((Object)((Operation)op1.getParent()), (Object)root2)) {
                    return false;
                }
                Operation operation = op2;
                Object t$iv = BaseDropGenerator.Companion.getDROP();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv2), (Object)t$iv)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv2);
                    if (!(basicElement instanceof BasicLikeTable)) {
                        basicElement = null;
                    }
                    basicLikeTable = (BasicLikeTable)basicElement;
                } else {
                    basicLikeTable = null;
                }
                if (basicLikeTable == null) {
                    return false;
                }
                BasicLikeTable tgt = basicLikeTable;
                t$iv = op1;
                OperationType t$iv2 = BaseDropGenerator.Companion.getDROP();
                if (Intrinsics.areEqual((Object)ScenarioOperations.type((Operation)$receiver$iv), (Object)t$iv2)) {
                    BasicElement basicElement = ScenarioOperations.element((Operation)$receiver$iv);
                    if (!(basicElement instanceof BasicForeignKey)) {
                        basicElement = null;
                    }
                    basicForeignKey = (BasicForeignKey)basicElement;
                } else {
                    basicForeignKey = null;
                }
                if (basicForeignKey == null) {
                    return false;
                }
                BasicForeignKey fk = basicForeignKey;
                if (Intrinsics.areEqual((Object)fk.getRefTable(), (Object)tgt) ^ true) {
                    return false;
                }
                op1.setParent((Node)root2);
                return true;
            }

            public boolean isBackward() {
                return true;
            }
        };
        DROP_FIXERS = CollectionsKt.listOf((Object)BaseDropGenerator.Companion.getDROP_FK_FIXER());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0006H\u0014JF\u0010\u0012\u001a\u00020\u0006\"\b\b\u0000\u0010\u0013*\u00020\u00052\u0006\u0010\r\u001a\u0002H\u00132\u0006\u0010\u000f\u001a\u00020\u00062\u001d\u0010\u0014\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u0016\u0012\u0004\u0012\u00020\n0\u0015\u00a2\u0006\u0002\b\u0017H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\r\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010*\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J\u0018\u0010,\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0004J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u0006H\u0014J$\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u00100\u001a\u000201H\u0014J\u0006\u00102\u001a\u00020\nJ\u001c\u00103\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0004R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00064"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$DropScenarioBuilder;", "", "(Lcom/intellij/database/scripting/BaseDropGenerator;)V", "prepared", "Ljava/util/LinkedHashMap;", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Operation;", "getPrepared", "()Ljava/util/LinkedHashMap;", "fillDropDependants", "", "e", "makeDropDatabase", "element", "Lcom/intellij/database/model/basic/BasicDatabase;", "root", "makeDropIndex", "Lcom/intellij/database/model/basic/BasicIndex;", "makeDropNode", "T", "delegate", "Lkotlin/Function1;", "Lcom/intellij/database/scripting/ElementProducer;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/scripting/Operation;Lkotlin/jvm/functions/Function1;)Lcom/intellij/database/scripting/Operation;", "makeDropOperation", "makeDropRoutine", "Lcom/intellij/database/model/basic/BasicRoutine;", "makeDropSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "makeDropSequence", "Lcom/intellij/database/model/basic/BasicSequence;", "makeDropSynonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "makeDropTable", "Lcom/intellij/database/model/basic/BasicTable;", "makeDropTableColumn", "Lcom/intellij/database/model/basic/BasicTableColumn;", "makeDropTableForeignKey", "Lcom/intellij/database/model/basic/BasicForeignKey;", "makeDropTableKey", "Lcom/intellij/database/model/basic/BasicKey;", "makeDropTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "makeDropUnknownOperation", "makeDropView", "Lcom/intellij/database/model/basic/BasicView;", "prepareElement", "forceRoot", "", "prepareScenario", "defaultDropNode", "intellij.database.scripting"})
    protected class DropScenarioBuilder {
        @NotNull
        private final LinkedHashMap<BasicElement, Operation> prepared = new LinkedHashMap();

        @NotNull
        protected final LinkedHashMap<BasicElement, Operation> getPrepared() {
            return this.prepared;
        }

        public final void prepareScenario() {
            BasicElement it;
            ScriptingTask scriptingTask = BaseDropGenerator.this.getTask();
            if (scriptingTask == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.ScriptingSingleModelTask");
            }
            ScriptingSingleModelTask task = (ScriptingSingleModelTask)scriptingTask;
            Iterable $receiver$iv = task.getElements();
            for (Object element$iv : $receiver$iv) {
                it = (BasicElement)element$iv;
                DropScenarioBuilder.prepareElement$default(this, it, BaseDropGenerator.this.getScenario().getRoot(), false, 4, null);
            }
            $receiver$iv = this.prepared.keySet();
            for (Object element$iv : $receiver$iv) {
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                this.fillDropDependants(basicElement);
            }
        }

        public final void fillDropDependants(@NotNull BasicElement e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Iterable<? extends BasicElement> $receiver$iv = e.getPredecessors();
            Iterator<? extends BasicElement> iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                BasicElement element$iv;
                BasicElement it = element$iv = iterator.next();
                Operation operation = this.prepared.get(it);
                if (operation == null) continue;
                ScenarioOperations.requires(operation, ScenarioOperations.invoke(EffectType.Unexistent, e));
            }
        }

        @Nullable
        protected Operation prepareElement(@NotNull BasicElement element, @NotNull Operation root2, boolean forceRoot) {
            Operation operation;
            block5: {
                block4: {
                    Operation operation2;
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                    operation = this.prepared.get(element);
                    if (operation == null) break block4;
                    Operation $receiver = operation2 = operation;
                    if (forceRoot) {
                        $receiver.setParent((Node)root2);
                    }
                    if ((operation = operation2) != null) break block5;
                }
                operation = this.makeDropOperation(element, root2);
            }
            return operation;
        }

        @Nullable
        public static /* bridge */ /* synthetic */ Operation prepareElement$default(DropScenarioBuilder dropScenarioBuilder, BasicElement basicElement, Operation operation, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareElement");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return dropScenarioBuilder.prepareElement(basicElement, operation, bl);
        }

        @NotNull
        public Operation makeDropOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof BasicSchema ? this.makeDropSchema((BasicSchema)element, root2) : (basicElement instanceof BasicTable ? this.makeDropTable((BasicTable)element, root2) : (basicElement instanceof BasicView ? this.makeDropView((BasicView)element, root2) : (basicElement instanceof BasicRoutine ? this.makeDropRoutine((BasicRoutine)element, root2) : (basicElement instanceof BasicTableColumn ? this.makeDropTableColumn((BasicTableColumn)element, root2) : (basicElement instanceof BasicKey ? this.makeDropTableKey((BasicKey)element, root2) : (basicElement instanceof BasicForeignKey ? this.makeDropTableForeignKey((BasicForeignKey)element, root2) : (basicElement instanceof BasicDatabase ? this.makeDropDatabase((BasicDatabase)element, root2) : (basicElement instanceof BasicIndex ? this.makeDropIndex((BasicIndex)element, root2) : (basicElement instanceof BasicSequence ? this.makeDropSequence((BasicSequence)element, root2) : (basicElement instanceof BasicSynonym ? this.makeDropSynonym((BasicSynonym)element, root2) : (basicElement instanceof BasicTrigger ? this.makeDropTrigger((BasicTrigger)element, root2) : this.makeDropUnknownOperation(element, root2))))))))))));
        }

        @NotNull
        protected Operation makeDropDatabase(@NotNull BasicDatabase element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicDatabase>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicDatabase> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateDatabase($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropIndex(@NotNull BasicIndex element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicIndex>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicIndex> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateIndex($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropSequence(@NotNull BasicSequence element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSequence>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicSequence> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateSequence($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropSynonym(@NotNull BasicSynonym element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSynonym>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicSynonym> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateSynonym($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropTrigger(@NotNull BasicTrigger element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicTrigger>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicTrigger> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateTrigger($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropTable(@NotNull BasicTable element, @NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver = operation = this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicTable>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicTable> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateTable($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
            Iterable $receiver$iv = (Iterable)element.getChildren();
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                DropScenarioBuilder.prepareElement$default(this, basicElement, $receiver, false, 4, null);
            }
            return operation;
        }

        @NotNull
        protected Operation makeDropSchema(@NotNull BasicSchema element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicSchema>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicSchema> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateSchema($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropView(@NotNull BasicView element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicView>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicView> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateView($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropRoutine(@NotNull BasicRoutine element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicRoutine>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicRoutine> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateRoutine($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropTableColumn(@NotNull BasicTableColumn element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicTableColumn>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicTableColumn> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateTableColumn($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropTableKey(@NotNull BasicKey element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicKey>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicKey> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateTableKey($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected Operation makeDropTableForeignKey(@NotNull BasicForeignKey element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<BasicForeignKey>, Unit>(this){
                final /* synthetic */ DropScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<BasicForeignKey> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.generateTableForeignKey($receiver);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    super(1);
                }
            });
        }

        @NotNull
        protected final Operation makeDropUnknownOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return this.makeDropNode(element, root2, (Function1)new Function1<ElementProducer<BasicElement>, Unit>(this, element){
                final /* synthetic */ DropScenarioBuilder this$0;
                final /* synthetic */ BasicElement $element;

                public final void invoke(@NotNull ElementProducer<BasicElement> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    this.this$0.BaseDropGenerator.this.unknownHowToDrop(this.$element);
                }
                {
                    this.this$0 = dropScenarioBuilder;
                    this.$element = basicElement;
                    super(1);
                }
            });
        }

        @NotNull
        protected final <T extends BasicElement> Operation makeDropNode(@NotNull T element, @NotNull Operation root2, @NotNull Function1<? super ElementProducer<T>, Unit> delegate) {
            Intrinsics.checkParameterIsNotNull(element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            return this.defaultDropNode(new Operation(new ElementProducer<T>(Companion.getDROP(), element, delegate)), element, root2);
        }

        @NotNull
        protected final Operation defaultDropNode(@NotNull Operation $receiver, @NotNull BasicElement element, @NotNull Operation root2) {
            Operation operation;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            Operation $receiver2 = operation = $receiver;
            $receiver2.setParent((Node)root2);
            Map map2 = this.prepared;
            BasicElement basicElement = element;
            Operation operation2 = $receiver2;
            map2.put(basicElement, operation2);
            JBIterable<? extends BasicElement> jBIterable = element.getChildren();
            Intrinsics.checkExpressionValueIsNotNull(jBIterable, (String)"element.children");
            ScenarioOperations.requires($receiver2, ScenarioOperations.invoke(EffectType.Unexistent, (Iterable)jBIterable));
            ScenarioOperations.provides($receiver2, ScenarioOperations.invoke(EffectType.Unexistent, element));
            return operation;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b*\u0001\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/BaseDropGenerator$Companion;", "", "()V", "DROP", "Lcom/intellij/database/scripting/OperationType;", "getDROP", "()Lcom/intellij/database/scripting/OperationType;", "DROP_FIXERS", "", "com/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1", "getDROP_FIXERS", "()Ljava/util/List;", "DROP_FK_FIXER", "getDROP_FK_FIXER", "()Lcom/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1;", "Lcom/intellij/database/scripting/BaseDropGenerator$Companion$DROP_FK_FIXER$1;", "intellij.database.scripting"})
    public static final class Companion {
        @NotNull
        public final OperationType getDROP() {
            return DROP;
        }

        private final DROP_FK_FIXER.1 getDROP_FK_FIXER() {
            return DROP_FK_FIXER;
        }

        private final List<DROP_FK_FIXER.1> getDROP_FIXERS() {
            return DROP_FIXERS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

