/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.util.BasicPaths;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B4\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u001d\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0000\"\n\b\u0001\u0010\u0012\u0018\u0001*\u00020\u00022\u0006\u0010\u0013\u001a\u0002H\u0012H\u0087\b\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016R(\u0010\u0007\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/scripting/ElementProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/scripting/Producer;", "type", "Lcom/intellij/database/scripting/OperationType;", "element", "delegate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/scripting/OperationType;Lcom/intellij/database/model/basic/BasicElement;Lkotlin/jvm/functions/Function1;)V", "getDelegate", "()Lkotlin/jvm/functions/Function1;", "getElement", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "cast", "U", "e", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/scripting/ElementProducer;", "getPreliminaryOrder", "", "getPreliminaryOrderPart", "produce", "shortText", "toString", "intellij.database.scripting"})
public final class ElementProducer<T extends BasicElement>
extends Producer {
    @NotNull
    private final T element;
    @NotNull
    private final Function1<ElementProducer<T>, Unit> delegate;

    private final <U extends BasicElement> ElementProducer<U> cast(U e) {
        boolean bl = Intrinsics.areEqual(e, this.getElement());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ElementProducer elementProducer = this;
        if (elementProducer == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.scripting.ElementProducer<U>");
        }
        return elementProducer;
    }

    @Override
    public void produce() {
        this.delegate.invoke((Object)this);
    }

    @Override
    @NotNull
    public String getPreliminaryOrder() {
        StringBuilder b = new StringBuilder(60);
        for (Object e = this.element; e != null; e = e.getParent()) {
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.insert(0, '.');
            }
            b.insert(0, this.getPreliminaryOrderPart((BasicElement)e));
            if (e instanceof BasicMajorObject) break;
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private final String getPreliminaryOrderPart(BasicElement element) {
        String string;
        String kindOrder = ScriptingUtilsKt.orderString(element.getKind());
        BasicElement basicElement = element;
        if (basicElement instanceof BasicArrangedElement) {
            string = "#" + ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)element).getPosition());
        } else if (basicElement instanceof BasicIdentifiedElement) {
            string = ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)element).getObjectId()) + "_" + ((BasicIdentifiedElement)element).getRealName();
        } else if (basicElement instanceof BasicNamedElement) {
            StringBuilder stringBuilder = new StringBuilder().append("?_");
            String string2 = ((BasicNamedElement)element).getRealName();
            if (string2 == null) {
                string2 = "???";
            }
            string = stringBuilder.append((Object)string2).toString();
        } else {
            string = "?????";
        }
        String elementOrder = string;
        return kindOrder + "_" + elementOrder;
    }

    @Override
    @NotNull
    public String shortText() {
        return "" + this.getType().getDebugName() + ' ' + this.element.getKind().code();
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.shortText() + ' ' + BasicPaths.of(this.element).getDisplayName();
    }

    @NotNull
    public final T getElement() {
        return this.element;
    }

    @NotNull
    public final Function1<ElementProducer<T>, Unit> getDelegate() {
        return this.delegate;
    }

    public ElementProducer(@NotNull OperationType type, @NotNull T element, @NotNull Function1<? super ElementProducer<T>, Unit> delegate) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
        super(type);
        this.element = element;
        this.delegate = delegate;
    }
}

