/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.LegacyDeleteGenerator;
import com.intellij.database.scripting.LegacyScriptingService;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010:\u001a\u00020;2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010<\u001a\u00020;2\b\u0010=\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010>\u001a\u00020;H\u0016J\b\u0010?\u001a\u00020;H\u0002J\b\u0010@\u001a\u00020AH\u0016J\u0013\u0010B\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020+H\u0016J\u0010\u0010E\u001a\u00020\u000f2\u0006\u0010F\u001a\u00020GH\u0002J\u0016\u0010H\u001a\u00020;2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001b0JH\u0002J\u0016\u0010K\u001a\u00020;2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0JH\u0002J\u0016\u0010N\u001a\u00020;2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0JH\u0002J,\u0010O\u001a\u00020;2\u0018\u0010P\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0R0Q2\b\u0010=\u001a\u0004\u0018\u00010\u001bH\u0016J\u001a\u0010S\u001a\u00020;2\u0006\u0010F\u001a\u00020G2\b\u0010=\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010S\u001a\u00020;2\u0006\u0010F\u001a\u00020G2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0J2\u0006\u0010T\u001a\u00020\u000fH\u0016J\u001e\u0010S\u001a\u00020;2\u0006\u0010F\u001a\u00020G2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001b0'H\u0016J\u0010\u0010S\u001a\u00020;2\u0006\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u00020;H\u0002R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R@\u0010%\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*0)\u0018\u00010&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u0004\u0018\u00010\u0005*\u0002078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109\u00a8\u0006["}, d2={"Lcom/intellij/database/scripting/LegacyScriptingService;", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicDatabase;)V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "getBuilder", "()Lcom/intellij/database/util/DdlBuilder;", "considerOrderHeuristic", "", "getConsiderOrderHeuristic", "()Z", "setConsiderOrderHeuristic", "(Z)V", "<set-?>", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "value", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "markupBuilder", "Lcom/intellij/database/dataSource/srcStorage/PersistentMarkup$Builder;", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "nativeDefinitionsRetriever", "Lkotlin/Function1;", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "", "", "getNativeDefinitionsRetriever", "()Lkotlin/jvm/functions/Function1;", "setNativeDefinitionsRetriever", "(Lkotlin/jvm/functions/Function1;)V", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/scripting/ScriptingOptions;)V", "anyDatabase", "Lcom/intellij/database/model/basic/BasicRoot;", "getAnyDatabase", "(Lcom/intellij/database/model/basic/BasicRoot;)Lcom/intellij/database/model/basic/BasicDatabase;", "assumeCurrentDatabase", "", "assumeCurrentSchema", "schema", "clearScript", "ensureEoln", "getScript", "Lcom/intellij/database/scripting/CompositeText;", "getScriptStatements", "()[Ljava/lang/String;", "getScriptText", "isCreateTask", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "makeCreateSchemasScript", "schemas", "", "makeCreateScript", "objects", "Lcom/intellij/database/model/basic/BasicScriptable;", "makeDropScript", "makeRefactoringScript", "elementPairsToProcess", "", "Lkotlin/Pair;", "makeScript", "recursive", "schemata", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "unknownTask", "Companion", "VERSIONS", "intellij.database.impl"})
public final class LegacyScriptingService
implements ScriptingService {
    @NotNull
    private final DdlBuilder builder;
    @NotNull
    private final BasicModel model;
    @NotNull
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private ScriptingOptions options;
    private boolean considerOrderHeuristic;
    private final PersistentMarkup.Builder markupBuilder;
    private final StringBuilder buffer;
    @Nullable
    private Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> nativeDefinitionsRetriever;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DdlBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    private void setCurrentDatabase(BasicDatabase basicDatabase) {
        this.currentDatabase = basicDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    private void setCurrentSchema(BasicSchema value) {
        BasicNamespace basicNamespace;
        Rdbms rdbms = this.model.getRdbms();
        this.currentSchema = Intrinsics.areEqual((Object)rdbms, (Object)Mssql.RDBMS) || Intrinsics.areEqual((Object)rdbms, (Object)Sybase.RDBMS) ? ((basicNamespace = value) != null && (basicNamespace = basicNamespace.getDatabase()) != null ? ModelFun.getCurrentSchema((BasicDatabase)basicNamespace) : null) : value;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkParameterIsNotNull((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @Override
    public boolean getConsiderOrderHeuristic() {
        return this.considerOrderHeuristic;
    }

    @Override
    public void setConsiderOrderHeuristic(boolean bl) {
        this.considerOrderHeuristic = bl;
    }

    @Override
    @Nullable
    public Function1<List<? extends BasicElement>, Map<BasicElement, String[]>> getNativeDefinitionsRetriever() {
        return this.nativeDefinitionsRetriever;
    }

    @Override
    public void setNativeDefinitionsRetriever(@Nullable Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>> function1) {
        this.nativeDefinitionsRetriever = function1;
    }

    private final BasicDatabase getAnyDatabase(@NotNull BasicRoot $receiver) {
        BasicDatabase basicDatabase;
        BasicRoot basicRoot = $receiver;
        if (basicRoot instanceof BasicDatabase) {
            basicDatabase = (BasicDatabase)((Object)$receiver);
        } else if (basicRoot instanceof BasicMultiDatabaseRoot) {
            BasicMateDatabase basicMateDatabase = ((BasicMultiDatabaseRoot)$receiver).getCurrentDatabase();
            basicDatabase = basicMateDatabase != null ? (BasicDatabase)basicMateDatabase : (BasicDatabase)CollectionsKt.firstOrNull((Iterable)((BasicMultiDatabaseRoot)$receiver).getDatabases());
        } else {
            basicDatabase = $receiver.getCurrentDatabase();
        }
        return basicDatabase;
    }

    @Override
    public void assumeCurrentDatabase(@NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        if (Intrinsics.areEqual((Object)this.getCurrentDatabase(), (Object)database) ^ true) {
            this.setCurrentDatabase(database);
            this.setCurrentSchema(ModelFun.getCurrentSchema(database));
        }
    }

    @Override
    public void assumeCurrentSchema(@Nullable BasicSchema schema) {
        if (Intrinsics.areEqual((Object)this.getCurrentSchema(), (Object)schema) ^ true) {
            this.setCurrentSchema(schema);
            if (schema != null) {
                BasicElement basicElement = schema.getDasParent();
                if (basicElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicDatabase");
                }
                this.setCurrentDatabase((BasicDatabase)basicElement);
            }
        }
    }

    @Override
    public void makeScript(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        String string = "not implemented yet";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private final void makeCreateSchemasScript(Collection<? extends BasicSchema> schemas) {
        for (BasicSchema basicSchema : schemas) {
            this.builder.withCasing(basicSchema);
            this.builder.element(basicSchema);
            this.ensureEoln();
        }
    }

    private final boolean isCreateTask(ScriptCategory category) {
        return Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.CREATE_DEFINITION)) || Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.CREATE_COMPLETE)) || Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.CREATE_BEFORE_IMPORT)) || Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.CREATE_AFTER_IMPORT));
    }

    private final void ensureEoln() {
        CharSequence charSequence = this.buffer;
        if (!(charSequence.length() == 0) && this.buffer.charAt(this.buffer.length() - 1) != '\n') {
            this.buffer.append('\n');
            this.markupBuilder.add(CompositeText.Kind.SQL_DELIMITER, this.buffer.length());
        }
    }

    @Override
    public void makeScript(@NotNull ScriptCategory category, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        if (schema == null) {
            return;
        }
        if (this.isCreateTask(category)) {
            this.makeCreateSchemasScript(CollectionsKt.listOf((Object)schema));
        } else if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.DROP_COMPLETE))) {
            this.makeDropScript(CollectionsKt.listOf((Object)schema));
        } else {
            this.unknownTask();
        }
    }

    @Override
    public void makeScript(@NotNull ScriptCategory category, @NotNull List<? extends BasicSchema> schemata) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull(schemata, (String)"schemata");
        if (this.isCreateTask(category)) {
            this.makeCreateSchemasScript((Collection<? extends BasicSchema>)schemata);
        } else if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.DROP_COMPLETE))) {
            this.makeDropScript((Collection<? extends BasicScriptable>)schemata);
        } else {
            this.unknownTask();
        }
    }

    @Override
    public void makeScript(@NotNull ScriptCategory category, @NotNull Collection<? extends BasicScriptable> objects, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (this.isCreateTask(category)) {
            this.makeCreateScript(objects);
        } else if (Intrinsics.areEqual((Object)((Object)category), (Object)((Object)ScriptCategory.DROP_COMPLETE))) {
            this.makeDropScript(objects);
        } else {
            this.unknownTask();
        }
    }

    private final void unknownTask() {
        this.builder.comment("-- unsupported :(");
        this.ensureEoln();
    }

    private final void makeCreateScript(Collection<? extends BasicScriptable> objects) {
        BasicSchema basicSchema = this.getCurrentSchema();
        this.builder.withCasing(basicSchema != null ? (CasingProvider)basicSchema : (CasingProvider)this.getCurrentDatabase());
        for (BasicScriptable basicScriptable : objects) {
            this.builder.element(basicScriptable);
        }
        this.ensureEoln();
    }

    private final void makeDropScript(Collection<? extends BasicScriptable> objects) {
        Rdbms rdbms = this.model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        DatabaseDialectEx dialect = LegacyScriptingService.Companion.getDialect(rdbms);
        BasicSchema basicSchema = this.getCurrentSchema();
        this.builder.withCasing(basicSchema != null ? (CasingProvider)basicSchema : (CasingProvider)this.getCurrentDatabase());
        Iterable $receiver$iv = new LegacyDeleteGenerator(dialect, this.model, objects).generateQueries(ContainerUtil.newArrayList()).getStatements();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            CharSequence charSequence = it;
            if (charSequence.length() == 0) continue;
            this.builder.plain(it).newStatement();
        }
        if (this.builder.isEmpty()) {
            this.builder.comment("unable to generate drop :(");
        }
        this.ensureEoln();
    }

    @Override
    @NotNull
    public String[] getScriptStatements() {
        String string = "not implemented yet";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public String getScriptText() {
        String string = this.buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    @Override
    @NotNull
    public CompositeText getScript() {
        PersistentMarkup persistentMarkup = this.markupBuilder.build(this.buffer);
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentMarkup, (String)"markupBuilder.build(buffer)");
        return persistentMarkup;
    }

    @Override
    public void clearScript() {
        this.buffer.delete(0, this.buffer.length());
        this.markupBuilder.clear();
    }

    @Override
    public void makeRefactoringScript(@NotNull Iterable<? extends Pair<? extends BasicElement, ? extends BasicElement>> elementPairsToProcess, @Nullable BasicSchema schema) {
        Intrinsics.checkParameterIsNotNull(elementPairsToProcess, (String)"elementPairsToProcess");
    }

    public LegacyScriptingService(@NotNull BasicModel model, @Nullable BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.options = DefaultScriptingOptions.INSTANCE;
        this.markupBuilder = new PersistentMarkup.Builder();
        this.buffer = new StringBuilder(4096);
        this.builder = new DdlBuilder(new CharOut(){

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                Intrinsics.checkParameterIsNotNull((Object)seq, (String)"seq");
                buffer.append(seq);
                markupBuilder.add(CompositeText.Kind.PLAIN_TEXT, buffer.length());
                return this;
            }

            @Override
            public long length() {
                return buffer.length();
            }

            @Override
            @Nullable
            public <T> T tryCast(@Nullable Class<T> clazz) {
                return null;
            }
        }){

            @Override
            @NotNull
            public DdlBuilder element(@NotNull DasObject element) {
                CompositeText src;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                CompositeText compositeText = src = element instanceof BasicSourceAware ? ((BasicSourceAware)element).getSourceText() : null;
                if (src == null) {
                    DdlBuilder ddlBuilder = super.element(element);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"super.element(element)");
                    return ddlBuilder;
                }
                for (CompositeText.Fragment f : src.getFragments()) {
                    buffer.append(f.getText());
                    markupBuilder.add(f.getKind(), buffer.length());
                }
                return this;
            }
        };
        Rdbms rdbms = model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        this.builder.withDialect(LegacyScriptingService.Companion.getDialect(rdbms));
        this.model = model;
        BasicDatabase basicDatabase = database;
        if (basicDatabase == null) {
            basicDatabase = this.getAnyDatabase(model.getRoot());
        }
        if (basicDatabase == null) {
            throw (Throwable)new IllegalStateException("Model (" + model + ") has no databases");
        }
        this.setCurrentDatabase(basicDatabase);
        this.setCurrentSchema(ModelFun.getCurrentSchema(this.getCurrentDatabase()));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0086\u0002R!\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/LegacyScriptingService$VERSIONS;", "", "()V", "map", "", "Lorg/jetbrains/dekaf/Rdbms;", "Lcom/intellij/database/model/PerObjectVersion;", "getMap", "()Ljava/util/Map;", "get", "key", "intellij.database.impl"})
    public static final class VERSIONS {
        @NotNull
        private static final Map<Rdbms, PerObjectVersion> map;
        public static final VERSIONS INSTANCE;

        @NotNull
        public final Map<Rdbms, PerObjectVersion> getMap() {
            return map;
        }

        @Nullable
        public final PerObjectVersion get(@Nullable Rdbms key2) {
            return map.get(key2);
        }

        private VERSIONS() {
        }

        static {
            VERSIONS vERSIONS;
            INSTANCE = vERSIONS = new VERSIONS();
            Map map2 = FactoryMap.create((Function)map.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"FactoryMap.create{PerObjectVersion.DEFAULT}");
            map = map2;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/LegacyScriptingService$Companion;", "", "()V", "canDrop", "", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "", "getDialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "kotlin.jvm.PlatformType", "intellij.database.impl"})
    public static final class Companion {
        private final DatabaseDialectEx getDialect(Rdbms rdbms) {
            DatabaseDialectEx databaseDialectEx = DbImplUtil.guessDatabaseDialect(GenericIntrospectorLegacyModelUtils.findFamily(rdbms));
            if (databaseDialectEx == null) {
                databaseDialectEx = GenericDialect.INSTANCE;
            }
            return databaseDialectEx;
        }

        public final boolean canDrop(@NotNull Rdbms rdbms, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            return LegacyDeleteGenerator.canDeleteElement(this.getDialect(rdbms), kind, context);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

