/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.scripting.Effect;
import com.intellij.database.scripting.EffectType;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.OperationType;
import com.intellij.database.scripting.Producer;
import com.intellij.database.scripting.ScenarioOperations;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\u001a\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0006\u001a(\u0010\b\u001a\u0004\u0018\u0001H\n\"\n\b\u0000\u0010\n\u0018\u0001*\u00020\t*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010\r\u001a\u0017\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0086\u0002\u001a%\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0012*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0012H\u0086\u0002\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t\u001a'\u0010\u0014\u001a\u00020\u0006*\u00020\u00062\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u0016\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0017\u001a'\u0010\u0018\u001a\u00020\u0006*\u00020\u00062\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u0016\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0017\u001a\u001a\u0010\u0018\u001a\u00020\u0006*\u00020\u00062\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0012\u001a\u0018\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005*\u00020\u0006\u001a\n\u0010\u001a\u001a\u00020\f*\u00020\u0006\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"UNRESOLVED_PATH", "Lcom/intellij/database/vfs/ObjectPath;", "getUNRESOLVED_PATH", "()Lcom/intellij/database/vfs/ObjectPath;", "traversePreceders", "Lcom/intellij/util/containers/JBTreeTraverser;", "Lcom/intellij/database/scripting/Operation;", "kotlin.jvm.PlatformType", "element", "Lcom/intellij/database/model/basic/BasicElement;", "E", "t", "Lcom/intellij/database/scripting/OperationType;", "(Lcom/intellij/database/scripting/Operation;Lcom/intellij/database/scripting/OperationType;)Lcom/intellij/database/model/basic/BasicElement;", "invoke", "Lcom/intellij/database/scripting/Effect;", "Lcom/intellij/database/scripting/EffectType;", "e", "", "opt", "provides", "es", "", "(Lcom/intellij/database/scripting/Operation;[Lcom/intellij/database/scripting/Effect;)Lcom/intellij/database/scripting/Operation;", "requires", "traverse", "type", "withParents", "intellij.database.scripting"})
@JvmName(name="ScenarioOperations")
public final class ScenarioOperations {
    @NotNull
    private static final ObjectPath UNRESOLVED_PATH = ObjectPath.create((String)"unresolved", (ObjectKind)ObjectKind.NONE);

    @NotNull
    public static final ObjectPath getUNRESOLVED_PATH() {
        return UNRESOLVED_PATH;
    }

    @Nullable
    public static final Effect opt(@NotNull EffectType $receiver, @Nullable BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        if (e == null) {
            return null;
        }
        ObjectPath objectPath = BasicPaths.of(e);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(e)");
        return new Effect(objectPath, $receiver);
    }

    @NotNull
    public static final Effect invoke(@NotNull EffectType $receiver, @Nullable BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        ObjectPath objectPath = BasicPaths.of(e);
        if (objectPath == null) {
            ObjectPath objectPath2 = UNRESOLVED_PATH;
            objectPath = objectPath2;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectPath2, (String)"UNRESOLVED_PATH");
        }
        return new Effect(objectPath, $receiver);
    }

    @NotNull
    public static final Iterable<Effect> invoke(@NotNull EffectType $receiver, @NotNull Iterable<? extends BasicElement> e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        JBIterable jBIterable = JBIterable.from(e).filterMap(new Function<E, T>($receiver){
            final /* synthetic */ EffectType receiver$0;

            @NotNull
            public final Effect fun(@Nullable BasicElement it) {
                return ScenarioOperations.invoke(this.receiver$0, it);
            }
            {
                this.receiver$0 = effectType;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(e).filterMap { this(it) }");
        return (Iterable)jBIterable;
    }

    @NotNull
    public static final Iterable<Effect> withParents(@NotNull EffectType $receiver, @NotNull BasicElement e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        JBIterable jBIterable = JBIterable.generate((Object)BasicPaths.of(e), (Function)withParents.1.INSTANCE).map(new Function<E, T>($receiver){
            final /* synthetic */ EffectType receiver$0;

            @NotNull
            public final Effect fun(ObjectPath it) {
                ObjectPath objectPath = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"it");
                return new Effect(objectPath, this.receiver$0);
            }
            {
                this.receiver$0 = effectType;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.generate(Basi\u2026.map { Effect(it, this) }");
        return (Iterable)jBIterable;
    }

    @NotNull
    public static final Operation requires(@NotNull Operation $receiver, Effect ... es) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)es, (String)"es");
        for (Object element$iv : (Object[])es) {
            Effect it = (Effect)element$iv;
            if (it == null) continue;
            Collection collection = $receiver.getRequirements();
            collection.add(it);
        }
        return $receiver;
    }

    @NotNull
    public static final Operation requires(@NotNull Operation $receiver, @NotNull Iterable<Effect> es) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(es, (String)"es");
        Iterable<Effect> $receiver$iv = es;
        for (Effect element$iv : $receiver$iv) {
            Effect it = element$iv;
            if (it == null) continue;
            Collection collection = $receiver.getRequirements();
            collection.add(it);
        }
        return $receiver;
    }

    @NotNull
    public static final Operation provides(@NotNull Operation $receiver, Effect ... es) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)es, (String)"es");
        for (Object element$iv : (Object[])es) {
            Effect it = (Effect)element$iv;
            if (it == null) continue;
            Collection collection = $receiver.getEffects();
            collection.add(it);
        }
        return $receiver;
    }

    @NotNull
    public static final OperationType type(@NotNull Operation $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getProducer().getType();
    }

    @Nullable
    public static final BasicElement element(@NotNull Operation $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Producer producer = $receiver.getProducer();
        if (!(producer instanceof ElementProducer)) {
            producer = null;
        }
        ElementProducer elementProducer = (ElementProducer)producer;
        return elementProducer != null ? elementProducer.getElement() : null;
    }

    private static final <E extends BasicElement> E element(@NotNull Operation $receiver, OperationType t) {
        BasicElement basicElement;
        if (Intrinsics.areEqual((Object)ScenarioOperations.type($receiver), (Object)t)) {
            BasicElement basicElement2 = ScenarioOperations.element($receiver);
            Intrinsics.reifiedOperationMarker((int)2, (String)"E");
            basicElement = basicElement2;
        } else {
            basicElement = null;
        }
        return (E)basicElement;
    }

    @NotNull
    public static final JBTreeTraverser<Operation> traverse(@NotNull Operation $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (JBTreeTraverser)JBTreeTraverser.from((Function)traverse.1.INSTANCE).withRoot((Object)$receiver);
    }

    @NotNull
    public static final JBTreeTraverser<Operation> traversePreceders() {
        return JBTreeTraverser.from((Function)traversePreceders.1.INSTANCE);
    }
}

