/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ModelFun;
import com.intellij.database.scripting.ScriptCategoryKt;
import com.intellij.database.scripting.ScriptingOrder;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006!"}, d2={"Lcom/intellij/database/scripting/ScriptCategory;", "", "code", "", "applicableRdbms", "", "Lorg/jetbrains/dekaf/Rdbms;", "displayName", "order", "Lcom/intellij/database/scripting/ScriptingOrder;", "(Ljava/lang/String;ILjava/lang/String;Ljava/util/Set;Ljava/lang/String;Lcom/intellij/database/scripting/ScriptingOrder;)V", "getApplicableRdbms", "()Ljava/util/Set;", "getCode", "()Ljava/lang/String;", "getDisplayName", "getOrder", "()Lcom/intellij/database/scripting/ScriptingOrder;", "toString", "CREATE_COMPLETE", "CREATE_BEFORE_IMPORT", "CREATE_AFTER_IMPORT", "CREATE_DEFINITION", "NATIVE_DEFINITION", "ENABLE_CONSTRAINTS", "DISABLE_CONSTRAINTS", "RECOMPILE", "REFRESH", "EXECUTE", "DELETE_DATA", "DROP_COMPLETE", "ALTER", "Companion", "intellij.database.scripting"})
public final class ScriptCategory
extends Enum<ScriptCategory> {
    public static final /* enum */ ScriptCategory CREATE_COMPLETE;
    public static final /* enum */ ScriptCategory CREATE_BEFORE_IMPORT;
    public static final /* enum */ ScriptCategory CREATE_AFTER_IMPORT;
    public static final /* enum */ ScriptCategory CREATE_DEFINITION;
    public static final /* enum */ ScriptCategory NATIVE_DEFINITION;
    public static final /* enum */ ScriptCategory ENABLE_CONSTRAINTS;
    public static final /* enum */ ScriptCategory DISABLE_CONSTRAINTS;
    public static final /* enum */ ScriptCategory RECOMPILE;
    public static final /* enum */ ScriptCategory REFRESH;
    public static final /* enum */ ScriptCategory EXECUTE;
    public static final /* enum */ ScriptCategory DELETE_DATA;
    public static final /* enum */ ScriptCategory DROP_COMPLETE;
    public static final /* enum */ ScriptCategory ALTER;
    private static final /* synthetic */ ScriptCategory[] $VALUES;
    @NotNull
    private final String code;
    @NotNull
    private final Set<Rdbms> applicableRdbms;
    @NotNull
    private final String displayName;
    @NotNull
    private final ScriptingOrder order;
    private static final SortedMap<String, ScriptCategory> allCategories;
    public static final Companion Companion;

    static {
        ScriptCategory[] scriptCategoryArray = new ScriptCategory[13];
        ScriptCategory[] scriptCategoryArray2 = scriptCategoryArray;
        scriptCategoryArray[0] = CREATE_COMPLETE = new ScriptCategory("CREATE_COMPLETE", 0, "CreateComplete", ModelFun.ALL_RDBMS, "Creation script completely", null, 8, null);
        scriptCategoryArray[1] = CREATE_BEFORE_IMPORT = new ScriptCategory("CREATE_BEFORE_IMPORT", 1, "CreateBefore", ModelFun.ALL_RDBMS, "Creation script before data import", null, 8, null);
        scriptCategoryArray[2] = CREATE_AFTER_IMPORT = new ScriptCategory("CREATE_AFTER_IMPORT", 2, "CreateAfter", ModelFun.ALL_RDBMS, "Creation script after data import", null, 8, null);
        scriptCategoryArray[3] = CREATE_DEFINITION = new ScriptCategory("CREATE_DEFINITION", 3, "CreateDefinition", ModelFun.ALL_RDBMS, "Definitions 'as is'", null, 8, null);
        scriptCategoryArray[4] = NATIVE_DEFINITION = new ScriptCategory("NATIVE_DEFINITION", 4, "NativeDefinition", SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Mysql.RDBMS}), "Definitions provided by RDBMS server", null, 8, null);
        scriptCategoryArray[5] = ENABLE_CONSTRAINTS = new ScriptCategory("ENABLE_CONSTRAINTS", 5, "EnableConstraints", SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Mssql.RDBMS, Postgres.RDBMS}), "Enable constraints and triggers", null, 8, null);
        scriptCategoryArray[6] = DISABLE_CONSTRAINTS = new ScriptCategory("DisableConstraints", SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Mssql.RDBMS, Postgres.RDBMS}), "Disable constraints and triggers", ScriptingOrder.REVERS_ORDER);
        scriptCategoryArray[7] = RECOMPILE = new ScriptCategory("RECOMPILE", 7, "Recompile", SetsKt.setOf((Object)Oracle.RDBMS), "Recompile", null, 8, null);
        scriptCategoryArray[8] = REFRESH = new ScriptCategory("REFRESH", 8, "Refresh", SetsKt.setOf((Object)Oracle.RDBMS), "Refresh materialized views", null, 8, null);
        scriptCategoryArray[9] = EXECUTE = new ScriptCategory("EXECUTE", 9, "Execute", SetsKt.setOf((Object[])new Rdbms[]{Oracle.RDBMS, Postgres.RDBMS}), "Execute procedures and functions", null, 8, null);
        scriptCategoryArray[10] = DELETE_DATA = new ScriptCategory("DeleteData", ModelFun.ALL_RDBMS, "Delete data", ScriptingOrder.REVERS_ORDER);
        scriptCategoryArray[11] = DROP_COMPLETE = new ScriptCategory("Drop", ModelFun.ALL_RDBMS, "Drop objects", ScriptingOrder.REVERS_ORDER);
        scriptCategoryArray[12] = ALTER = new ScriptCategory("ALTER", 12, "Alter", ModelFun.ALL_RDBMS, "Alter elements", null, 8, null);
        $VALUES = scriptCategoryArray;
        Companion = new Companion(null);
        allCategories = ScriptCategoryKt.access$caseInsensitiveMapOf(TuplesKt.to((Object)ScriptCategory.CREATE_COMPLETE.code, (Object)((Object)CREATE_COMPLETE)), TuplesKt.to((Object)ScriptCategory.CREATE_BEFORE_IMPORT.code, (Object)((Object)CREATE_BEFORE_IMPORT)), TuplesKt.to((Object)ScriptCategory.CREATE_AFTER_IMPORT.code, (Object)((Object)CREATE_AFTER_IMPORT)), TuplesKt.to((Object)ScriptCategory.CREATE_DEFINITION.code, (Object)((Object)CREATE_DEFINITION)), TuplesKt.to((Object)ScriptCategory.ENABLE_CONSTRAINTS.code, (Object)((Object)ENABLE_CONSTRAINTS)), TuplesKt.to((Object)ScriptCategory.DISABLE_CONSTRAINTS.code, (Object)((Object)DISABLE_CONSTRAINTS)), TuplesKt.to((Object)ScriptCategory.RECOMPILE.code, (Object)((Object)RECOMPILE)), TuplesKt.to((Object)ScriptCategory.REFRESH.code, (Object)((Object)REFRESH)), TuplesKt.to((Object)ScriptCategory.EXECUTE.code, (Object)((Object)EXECUTE)), TuplesKt.to((Object)ScriptCategory.DELETE_DATA.code, (Object)((Object)DELETE_DATA)), TuplesKt.to((Object)ScriptCategory.DROP_COMPLETE.code, (Object)((Object)DROP_COMPLETE)));
    }

    @NotNull
    public String toString() {
        return this.displayName;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final Set<Rdbms> getApplicableRdbms() {
        return this.applicableRdbms;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final ScriptingOrder getOrder() {
        return this.order;
    }

    protected ScriptCategory(@NotNull String code, @NotNull Set<Rdbms> applicableRdbms, String displayName, ScriptingOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull(applicableRdbms, (String)"applicableRdbms");
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)order), (String)"order");
        this.code = code;
        this.applicableRdbms = applicableRdbms;
        this.displayName = displayName;
        this.order = order;
    }

    /* synthetic */ ScriptCategory(String string, int n, String string2, Set set, String string3, ScriptingOrder scriptingOrder, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            scriptingOrder = ScriptingOrder.NORMAL_ORDER;
        }
        this(string2, set, string3, scriptingOrder);
    }

    public static ScriptCategory[] values() {
        return (ScriptCategory[])$VALUES.clone();
    }

    public static ScriptCategory valueOf(String string) {
        return Enum.valueOf(ScriptCategory.class, string);
    }

    private static final SortedMap<String, ScriptCategory> getAllCategories() {
        return ScriptCategory.Companion.getAllCategories();
    }

    @JvmStatic
    @Nullable
    public static final ScriptCategory of(@NotNull String code) {
        return Companion.of(code);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/database/scripting/ScriptCategory$Companion;", "", "()V", "allCategories", "Ljava/util/SortedMap;", "", "Lcom/intellij/database/scripting/ScriptCategory;", "allCategories$annotations", "getAllCategories", "()Ljava/util/SortedMap;", "of", "code", "intellij.database.scripting"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void allCategories$annotations() {
        }

        private final SortedMap<String, ScriptCategory> getAllCategories() {
            return allCategories;
        }

        @JvmStatic
        @Nullable
        public final ScriptCategory of(@NotNull String code) {
            Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
            return (ScriptCategory)((Object)this.getAllCategories().get(code));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

