/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingOptions;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003JO\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 \u00a8\u00061"}, d2={"Lcom/intellij/database/scripting/ScriptingAlterTask;", "Lcom/intellij/database/scripting/ScriptingTask;", "sourceModel", "Lcom/intellij/database/model/basic/BasicModel;", "targetModel", "correspondence", "", "Lcom/intellij/database/model/delta/ElementDelta;", "currentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "options", "Lcom/intellij/database/scripting/ScriptingOptions;", "(Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/scripting/ScriptingOptions;)V", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "getCategory", "()Lcom/intellij/database/scripting/ScriptCategory;", "getCorrespondence", "()Ljava/util/Collection;", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "getOptions", "()Lcom/intellij/database/scripting/ScriptingOptions;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRdbms", "()Lorg/jetbrains/dekaf/Rdbms;", "getSourceModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getTargetModel", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.scripting"})
public final class ScriptingAlterTask
extends ScriptingTask {
    @NotNull
    private final ScriptCategory category;
    @NotNull
    private final BasicModel sourceModel;
    @NotNull
    private final BasicModel targetModel;
    @NotNull
    private final Collection<ElementDelta> correspondence;
    @Nullable
    private final BasicDatabase currentDatabase;
    @Nullable
    private final BasicSchema currentSchema;
    @NotNull
    private final ScriptingOptions options;

    @Override
    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = this.sourceModel.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"sourceModel.rdbms");
        return rdbms;
    }

    @Override
    @NotNull
    public ScriptCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final BasicModel getSourceModel() {
        return this.sourceModel;
    }

    @NotNull
    public final BasicModel getTargetModel() {
        return this.targetModel;
    }

    @NotNull
    public final Collection<ElementDelta> getCorrespondence() {
        return this.correspondence;
    }

    @Override
    @Nullable
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    public ScriptingAlterTask(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel, @NotNull Collection<? extends ElementDelta> correspondence, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkParameterIsNotNull((Object)targetModel, (String)"targetModel");
        Intrinsics.checkParameterIsNotNull(correspondence, (String)"correspondence");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        super(null);
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
        this.correspondence = correspondence;
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.options = options;
        this.category = ScriptCategory.ALTER;
        boolean bl2 = bl = this.getCurrentDatabase() == null || Intrinsics.areEqual((Object)this.getCurrentDatabase().getModel(), (Object)this.targetModel);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = this.getCurrentSchema() == null || Intrinsics.areEqual((Object)this.getCurrentSchema().getModel(), (Object)this.targetModel) && Intrinsics.areEqual((Object)this.getCurrentSchema().getDatabase(), (Object)this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    @NotNull
    public final BasicModel component1() {
        return this.sourceModel;
    }

    @NotNull
    public final BasicModel component2() {
        return this.targetModel;
    }

    @NotNull
    public final Collection<ElementDelta> component3() {
        return this.correspondence;
    }

    @Nullable
    public final BasicDatabase component4() {
        return this.getCurrentDatabase();
    }

    @Nullable
    public final BasicSchema component5() {
        return this.getCurrentSchema();
    }

    @NotNull
    public final ScriptingOptions component6() {
        return this.getOptions();
    }

    @NotNull
    public final ScriptingAlterTask copy(@NotNull BasicModel sourceModel, @NotNull BasicModel targetModel, @NotNull Collection<? extends ElementDelta> correspondence, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptingOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)sourceModel, (String)"sourceModel");
        Intrinsics.checkParameterIsNotNull((Object)targetModel, (String)"targetModel");
        Intrinsics.checkParameterIsNotNull(correspondence, (String)"correspondence");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return new ScriptingAlterTask(sourceModel, targetModel, correspondence, currentDatabase, currentSchema, options);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ScriptingAlterTask copy$default(ScriptingAlterTask scriptingAlterTask, BasicModel basicModel, BasicModel basicModel2, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptingOptions scriptingOptions, int n, Object object) {
        if ((n & 1) != 0) {
            basicModel = scriptingAlterTask.sourceModel;
        }
        if ((n & 2) != 0) {
            basicModel2 = scriptingAlterTask.targetModel;
        }
        if ((n & 4) != 0) {
            collection = scriptingAlterTask.correspondence;
        }
        if ((n & 8) != 0) {
            basicDatabase = scriptingAlterTask.getCurrentDatabase();
        }
        if ((n & 0x10) != 0) {
            basicSchema = scriptingAlterTask.getCurrentSchema();
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = scriptingAlterTask.getOptions();
        }
        return scriptingAlterTask.copy(basicModel, basicModel2, collection, basicDatabase, basicSchema, scriptingOptions);
    }

    public String toString() {
        return "ScriptingAlterTask(sourceModel=" + this.sourceModel + ", targetModel=" + this.targetModel + ", correspondence=" + this.correspondence + ", currentDatabase=" + this.getCurrentDatabase() + ", currentSchema=" + this.getCurrentSchema() + ", options=" + this.getOptions() + ")";
    }

    public int hashCode() {
        BasicModel basicModel = this.sourceModel;
        BasicModel basicModel2 = this.targetModel;
        Collection<ElementDelta> collection = this.correspondence;
        BasicDatabase basicDatabase = this.getCurrentDatabase();
        BasicSchema basicSchema = this.getCurrentSchema();
        ScriptingOptions scriptingOptions = this.getOptions();
        return (((((basicModel != null ? basicModel.hashCode() : 0) * 31 + (basicModel2 != null ? basicModel2.hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (basicDatabase != null ? basicDatabase.hashCode() : 0)) * 31 + (basicSchema != null ? basicSchema.hashCode() : 0)) * 31 + (scriptingOptions != null ? scriptingOptions.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ScriptingAlterTask)) break block3;
                ScriptingAlterTask scriptingAlterTask = (ScriptingAlterTask)object;
                if (!Intrinsics.areEqual((Object)this.sourceModel, (Object)scriptingAlterTask.sourceModel) || !Intrinsics.areEqual((Object)this.targetModel, (Object)scriptingAlterTask.targetModel) || !Intrinsics.areEqual(this.correspondence, scriptingAlterTask.correspondence) || !Intrinsics.areEqual((Object)this.getCurrentDatabase(), (Object)scriptingAlterTask.getCurrentDatabase()) || !Intrinsics.areEqual((Object)this.getCurrentSchema(), (Object)scriptingAlterTask.getCurrentSchema()) || !Intrinsics.areEqual((Object)this.getOptions(), (Object)scriptingAlterTask.getOptions())) break block3;
            }
            return true;
        }
        return false;
    }
}

