/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.ScriptingUtilsKt$WhenMappings;
import com.intellij.database.util.NumbersFun;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\u001a\t\u0010\u0007\u001a\u00020\bH\u0080\b\u001a\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0000\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a%\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0016\"\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0017\u001a\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0086\u0004\u001a\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0086\u0004\u001a\u0017\u0010\u001b\u001a\u00020\u001c*\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0001H\u0086\u0004\u001a\n\u0010\u001f\u001a\u00020\u0011*\u00020 \u001a\n\u0010!\u001a\u00020\u001d*\u00020\u001d\u001a\n\u0010\"\u001a\u00020\u0011*\u00020\f\u001a\n\u0010#\u001a\u00020\u0011*\u00020\u0006\u001a\f\u0010$\u001a\u00020\u0011*\u00020%H\u0002\u001a\f\u0010$\u001a\u00020\u0011*\u00020&H\u0002\u001a\n\u0010$\u001a\u00020\u0011*\u00020'\"\u0019\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"HeadingEmptyLinesPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getHeadingEmptyLinesPattern", "()Ljava/util/regex/Pattern;", "__0__", "", "abort", "", "combineScriptingPreliminaryOrderRecursively", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "makeTriggerEventString", "", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "phrase", "words", "", "([Ljava/lang/String;)Ljava/lang/String;", "concatIfNotNull", "that", "concatWithSpace", "matches", "", "", "pattern", "orderString", "Lcom/intellij/database/model/ObjectKind;", "removeHeadingEmptyLines", "scriptingMateOrder", "toFixedOrderString", "toOrderString", "Ljava/util/Date;", "", "", "intellij.database.scripting"})
public final class ScriptingUtilsKt {
    public static final short __0__ = 0;
    private static final Pattern HeadingEmptyLinesPattern = Pattern.compile("^(\\s*\\n)+", 32);

    @NotNull
    public static final Void abort() {
        throw (Throwable)new AbortException();
    }

    public static final boolean matches(@Nullable CharSequence $receiver, @NotNull Pattern pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return $receiver != null ? pattern.matcher($receiver).matches() : false;
    }

    @Nullable
    public static final String phrase(String ... words) {
        Intrinsics.checkParameterIsNotNull((Object)words, (String)"words");
        int n = ((Object[])words).length;
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return words[0];
        }
        StringBuilder b = new StringBuilder();
        for (String word : words) {
            if (word == null) continue;
            CharSequence charSequence = b;
            if (charSequence.length() > 0) {
                b.append(' ');
            }
            b.append(word);
        }
        CharSequence charSequence = b;
        return charSequence.length() > 0 ? b.toString() : null;
    }

    @Nullable
    public static final String concatWithSpace(@Nullable String $receiver, @Nullable String that) {
        boolean y2;
        CharSequence charSequence;
        boolean y1;
        CharSequence charSequence2;
        boolean bl = $receiver != null && (charSequence2 = (CharSequence)$receiver).length() > 0 ? true : (y1 = false);
        boolean bl2 = that != null && (charSequence = (CharSequence)that).length() > 0 ? true : (y2 = false);
        return y1 && y2 ? $receiver + ' ' + that : (y1 ? $receiver : (y2 ? that : null));
    }

    @Nullable
    public static final String concatIfNotNull(@Nullable String $receiver, @Nullable String that) {
        return $receiver != null && that != null ? $receiver + that : null;
    }

    public static final void combineScriptingPreliminaryOrderRecursively(@NotNull BasicElement element, @NotNull StringBuilder b) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        BasicElement parent = element.getParent();
        if (parent != null) {
            ScriptingUtilsKt.combineScriptingPreliminaryOrderRecursively(parent, b);
            b.append('\t');
        }
        b.append(ScriptingUtilsKt.orderString(element.getKind())).append('.').append(ScriptingUtilsKt.scriptingMateOrder(element));
    }

    @NotNull
    public static final String scriptingMateOrder(@NotNull BasicElement $receiver) {
        String name;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof BasicRoot) {
            return "";
        }
        if ($receiver instanceof BasicArrangedElement && ((BasicArrangedElement)$receiver).getPosition() != 0) {
            return ScriptingUtilsKt.toFixedOrderString(((BasicArrangedElement)$receiver).getPosition());
        }
        if ($receiver instanceof BasicIdentifiedElement) {
            if (((BasicIdentifiedElement)$receiver).getCreatedTimestamp() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("!");
                Date date = ((BasicIdentifiedElement)$receiver).getCreatedTimestamp();
                if (date == null) {
                    Intrinsics.throwNpe();
                }
                return stringBuilder.append(ScriptingUtilsKt.toOrderString(date)).toString();
            }
            if (((BasicIdentifiedElement)$receiver).getModifiedTimestamp() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("!");
                Date date = ((BasicIdentifiedElement)$receiver).getModifiedTimestamp();
                if (date == null) {
                    Intrinsics.throwNpe();
                }
                return stringBuilder.append(ScriptingUtilsKt.toOrderString(date)).toString();
            }
            if (((BasicIdentifiedElement)$receiver).getObjectId() != Long.MIN_VALUE) {
                return "#" + ScriptingUtilsKt.toOrderString(((BasicIdentifiedElement)$receiver).getObjectId());
            }
        }
        if ($receiver instanceof BasicNamedElement && (name = ((BasicNamedElement)$receiver).getRealName()) != null) {
            return (((BasicNamedElement)$receiver).isNameSurrogate() ? "N?." : "N!.") + name;
        }
        char c = '{';
        String string = String.valueOf($receiver.hashCode());
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('}').toString();
    }

    private static final String toOrderString(@NotNull Date $receiver) {
        return ScriptingUtilsKt.toOrderString($receiver.getTime());
    }

    /*
     * WARNING - void declaration
     */
    private static final String toOrderString(int $receiver) {
        if ($receiver == 0) {
            return "0";
        }
        if ($receiver > 0) {
            char c;
            String s = String.valueOf($receiver);
            int n = s.length();
            char c2 = c = (char)(65 + (n - 1));
            return String.valueOf(c2) + s;
        }
        if ($receiver < 0) {
            int p = -$receiver;
            StringBuilder b = new StringBuilder(14);
            b.append(p);
            int n = b.length();
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    char d = b.charAt((int)i2);
                    char c = (char)(90 - (d - 48));
                    StringBuilder stringBuilder = b;
                    char c3 = c;
                    stringBuilder.setCharAt((int)i2, c3);
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            b.insert(0, '-');
            b.insert(1, (char)(90 - n));
            String string = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
            return string;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toOrderString(long $receiver) {
        if ($receiver == 0L) {
            return "0";
        }
        if ($receiver > 0L) {
            char c;
            String s = String.valueOf($receiver);
            int n = s.length();
            char c2 = c = (char)(65 + (n - 1));
            return String.valueOf(c2) + s;
        }
        if ($receiver == Long.MIN_VALUE) {
            return "[NO_ID]";
        }
        if ($receiver < 0L) {
            long p = -$receiver;
            StringBuilder b = new StringBuilder(24);
            b.append(p);
            int n = b.length();
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    char d = b.charAt((int)i2);
                    char c = (char)(90 - (d - 48));
                    StringBuilder stringBuilder = b;
                    char c3 = c;
                    stringBuilder.setCharAt((int)i2, c3);
                    if (i2 == n3) break;
                    ++i2;
                }
            }
            b.insert(0, '-');
            b.insert(1, (char)(90 - n));
            String string = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
            return string;
        }
        return "";
    }

    @NotNull
    public static final String orderString(@NotNull ObjectKind $receiver) {
        int order;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = order = $receiver.getOrder();
        if (1 <= n && 9999 >= n) {
            return NumbersFun.toFixString(order, 4);
        }
        return "ZZZZ";
    }

    @NotNull
    public static final String toFixedOrderString(short $receiver) {
        if ($receiver < 0) {
            return "-X";
        }
        String s = String.valueOf($receiver);
        String string = "00000";
        int n = s.length();
        int n2 = 5;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        return stringBuilder.append(string3).append(s).toString();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String makeTriggerEventString(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        table = trigger.getLikeTable();
        turn = trigger.getTurn();
        events = trigger.getEvents();
        onInsert = events.contains(TrigEvent.INSERT);
        onUpdate = events.contains(TrigEvent.UPDATE);
        onDelete = events.contains(TrigEvent.DELETE);
        v0 = table;
        tableColumnsCount = v0 != null && (v0 = v0.getColumns()) != null ? v0.size() : 0;
        specificColumns = trigger.getColNames();
        explicitColumns = onUpdate != false && 1 <= (var10_9 = specificColumns.size()) && tableColumnsCount - 1 >= var10_9;
        v1 = turn;
        if (v1 == null) ** GOTO lbl-1000
        switch (ScriptingUtilsKt$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
            case 1: 
            case 2: {
                v2 = "before ";
                break;
            }
            case 3: 
            case 4: {
                v2 = "after ";
                break;
            }
            case 5: {
                v2 = "instead of ";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v2 = ev = "???";
            }
        }
        if (onInsert) {
            ev = ev + "insert";
        }
        if (onInsert && onUpdate) {
            ev = ev + " or ";
        }
        if (onUpdate) {
            ev = ev + "update";
        }
        if (explicitColumns) {
            ev = ev + " of " + CollectionsKt.joinToString$default((Iterable)specificColumns, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        }
        if ((onInsert || onUpdate) && onDelete) {
            ev = ev + " or ";
        }
        if (onDelete) {
            ev = ev + "delete";
        }
        return ev;
    }

    @NotNull
    public static final CharSequence removeHeadingEmptyLines(@NotNull CharSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Matcher m = HeadingEmptyLinesPattern.matcher($receiver);
        if (m.find()) {
            int emptyLength = m.group(0).length();
            return $receiver.subSequence(emptyLength, $receiver.length());
        }
        return $receiver;
    }

    public static final Pattern getHeadingEmptyLinesPattern() {
        return HeadingEmptyLinesPattern;
    }
}

