/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsSourceAware;
import com.intellij.database.model.mssql.MsStoredTable;
import com.intellij.database.model.mssql.MsTableOrView;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.mssql.MsTableTypeColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import java.math.BigInteger;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\f\u0010\u000b\u001a\u00060\fR\u00020\u0001H\u0014J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020 0\u0010H\u0002J\u0016\u0010!\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010H\u0014J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0014J\f\u0010*\u001a\u00020#*\u00020#H\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "canQualify", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "generateAliasType", "", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/mssql/MsAliasType;", "generateColumnComment", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateEncryptedTrigger", "Lcom/intellij/database/model/mssql/MsTrigger;", "generateSourceAwareUsingSources", "Lcom/intellij/database/model/basic/BasicSourceAware;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTableType", "Lcom/intellij/database/model/mssql/MsTableType;", "generateTrigger", "makeColumnSpecification", "", "makeIndexWord", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "makeKeyWord", "key", "Lcom/intellij/database/model/basic/BasicKey;", "quoteNameAsString", "MsCreateScenarioBuilder", "intellij.database.scripting"})
public final class MsCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    protected boolean canQualify(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !(element instanceof BasicIndex) && super.canQualify(element);
    }

    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateScenarioBuilder createScenarioBuilder() {
        return new MsCreateScenarioBuilder();
    }

    /*
     * WARNING - void declaration
     */
    private final void generateAliasType(ElementProducer<MsAliasType> producer) {
        void statement;
        MsAliasType aliasType = producer.getElement();
        String name = this.currentScopeName(aliasType);
        String type = aliasType.getDataType().getSpecification();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "create type " + name + " from " + type;
        if (aliasType.isNotNull()) {
            statement.element = (String)statement.element + " not null";
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (Ref.ObjectRef)statement){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ Ref.ObjectRef $statement;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), (String)this.$statement.element, null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$statement = objectRef;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableType(ElementProducer<MsTableType> producer) {
        MsTableType tableType = producer.getElement();
        String name = this.currentScopeName(tableType);
        AbstractCodeGenerator.coding$default(this, ScriptLocus.IN_TABLE, false, (Function0)new Function0<Unit>(this, name, tableType, producer){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ MsTableType $tableType;
            final /* synthetic */ ElementProducer $producer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "create type " + this.$name + " as table", null, false, 6, null);
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "(", null, false, 6, null);
                CodeTextBuilder this_$iv = MsCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    void $receiver$iv;
                    if (this.$tableType.getColumns().isEmpty()) {
                        CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "-- the table type " + this.$tableType.getName() + " has no columns", null, false, 6, null);
                    }
                    Iterable iterable = this.$producer.getNestedOperations();
                    MsCreatingGenerator msCreatingGenerator = this.this$0;
                    for (T element$iv : $receiver$iv) {
                        Operation p1 = (Operation)element$iv;
                        msCreatingGenerator.produce(p1);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
                MsCreatingGenerator.access$getBuilder$p(this.this$0).removeSuffixFromTheLastLine(',');
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), ")", null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$name = string;
                this.$tableType = msTableType;
                this.$producer = elementProducer;
                super(0);
            }
        }, 2, null);
    }

    @Override
    @Nullable
    protected String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        String s;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (Intrinsics.areEqual((Object)column2.getName(), (Object)"timestamp") && Intrinsics.areEqual((Object)column2.getDataType().typeName, (Object)"timestamp") && !column2.getDataType().custom) {
            s = column2.isNotNull() ? "not null" : "null";
        } else {
            SequenceIdentity q;
            s = super.makeColumnSpecification(column2);
            BasicLikeColumn basicLikeColumn = column2;
            if (!(basicLikeColumn instanceof BasicTableColumn)) {
                basicLikeColumn = null;
            }
            BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
            SequenceIdentity sequenceIdentity = q = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
            if (q != null) {
                String identityClause = Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ')';
                s = Intrinsics.stringPlus((String)s, (Object)identityClause);
            }
        }
        return s;
    }

    @Override
    @NotNull
    protected String makeKeyWord(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return key2 instanceof MsKey ? (((MsKey)key2).isPrimary() ? (((MsKey)key2).isClustering() ? "primary key" : "primary key nonclustered") : (((MsKey)key2).isClustering() ? "unique clustered" : "unique")) : super.makeKeyWord(key2);
    }

    @Override
    @NotNull
    protected String makeIndexWord(@NotNull BasicIndex index) {
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        MsIndex i2 = (MsIndex)index;
        if (i2.isUnique()) {
            boolean primary2;
            MsLikeTable table = ((MsIndex)index).getLikeTable();
            boolean bl = primary2 = table instanceof MsStoredTable && ((MsStoredTable)table).getKeys().has((Predicate<? extends MsKey>)new Predicate<MsKey>(i2){
                final /* synthetic */ MsIndex $i;

                public final boolean test(MsKey it) {
                    return it.isPrimary() && Intrinsics.areEqual((Object)it.getUnderlyingIndexName(), (Object)this.$i.getName());
                }
                {
                    this.$i = msIndex;
                }
            });
            String word = primary2 ? (i2.isClustering() ? "unique index" : "unique nonclustered index") : (i2.isClustering() ? "unique clustered index" : "unique index");
            return word;
        }
        return i2.isClustering() ? "clustered index" : "index";
    }

    @Override
    protected void generateTableComment(@NotNull BasicTableOrView table) {
        String string;
        ObjectKind kind;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        String name = this.quoteNameAsString(table.getName());
        String string2 = table.getComment();
        if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
            return;
        }
        String comment = string2;
        ObjectKind objectKind = kind = table.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            string = "TABLE";
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
            string = "VIEW";
        } else {
            return;
        }
        String tableWord = string;
        String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + name + "\n              "), null, (int)1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), this.$s, null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateColumnComment(@NotNull BasicLikeColumn column2) {
        String string;
        ObjectKind kind;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        BasicLikeTable basicLikeTable = column2.getLikeTable();
        if (basicLikeTable == null) {
            return;
        }
        BasicLikeTable table = basicLikeTable;
        String string2 = table.getRealName();
        if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
            return;
        }
        String tableName = string2;
        String string3 = column2.getRealName();
        if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
            return;
        }
        String columnName = string3;
        String string4 = column2.getComment();
        if (string4 == null || (string4 = this.quoteNameAsString(string4)) == null) {
            return;
        }
        String comment = string4;
        ObjectKind objectKind = kind = table.getKind();
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
            string = "TABLE";
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
            string = "VIEW";
        } else {
            return;
        }
        String tableWord = string;
        String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + tableName + ", N'COLUMN', N" + columnName + "\n              "), null, (int)1, null);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), this.$s, null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateTrigger(@NotNull ElementProducer<BasicTrigger> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicTrigger basicTrigger = producer.getElement();
        if (basicTrigger == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsTrigger");
        }
        MsTrigger trigger = (MsTrigger)basicTrigger;
        if (trigger.isEncrypted()) {
            this.generateEncryptedTrigger(trigger);
        } else {
            this.generateSourceAwareUsingSources(trigger);
        }
        if (trigger.isDisabled()) {
            this.generateDisableTrigger(trigger);
        }
    }

    private final void generateEncryptedTrigger(MsTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ MsTrigger $trigger;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "create trigger " + MsCreatingGenerator.access$currentScopeName(this.this$0, this.$trigger), null, false, 6, null);
                CodeTextBuilder this_$iv = MsCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder codeTextBuilder = MsCreatingGenerator.access$getBuilder$p(this.this$0);
                    StringBuilder stringBuilder = new StringBuilder().append("on ");
                    Object object = this.$trigger.getTable();
                    if (object == null || (object = MsCreatingGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) == null) {
                        object = this.$trigger.getTableName();
                    }
                    CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append((String)object).toString(), null, false, 6, null);
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "with encryption", null, false, 6, null);
                    CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "for " + CollectionsKt.joinToString$default((Iterable)this.$trigger.getEvents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "as", null, false, 6, null);
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "select null -- the original source text was encrypted", null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$trigger = msTrigger;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String triggerName = this.currentScopeName(trigger);
        BasicLikeTable basicLikeTable = trigger.getLikeTable();
        if (basicLikeTable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsTableOrView");
        }
        String tableName = this.currentScopeName((MsTableOrView)basicLikeTable);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName){
            final /* synthetic */ MsCreatingGenerator this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ String $tableName;

            public final void invoke() {
                CodeTextBuilder.append$default(MsCreatingGenerator.access$getBuilder$p(this.this$0), "disable trigger " + this.$triggerName + " on " + this.$tableName, null, false, 6, null);
            }
            {
                this.this$0 = msCreatingGenerator;
                this.$triggerName = string;
                this.$tableName = string2;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof MsSourceAware && ((MsSourceAware)element).isEncrypted()) {
            BasicSourceAware basicSourceAware = element;
            if (basicSourceAware instanceof MsTrigger) {
                this.generateEncryptedTrigger((MsTrigger)element);
            }
        } else {
            super.generateSourceAwareUsingSources(element);
        }
    }

    private final String quoteNameAsString(@NotNull String $receiver) {
        return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
    }

    public MsCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ void access$generateAliasType(MsCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateAliasType(producer);
    }

    public static final /* synthetic */ void access$generateTableType(MsCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateTableType(producer);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(MsCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(MsCreatingGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/mssql/MsCreatingGenerator$MsCreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "(Lcom/intellij/database/scripting/mssql/MsCreatingGenerator;)V", "makeCreateAliasType", "Lcom/intellij/database/scripting/Operation;", "element", "Lcom/intellij/database/model/mssql/MsAliasType;", "root", "makeCreateOperation", "Lcom/intellij/database/model/basic/BasicElement;", "makeCreateTableType", "Lcom/intellij/database/model/mssql/MsTableType;", "intellij.database.scripting"})
    private final class MsCreateScenarioBuilder
    extends BaseCreatingGenerator.CreateScenarioBuilder {
        @Override
        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof MsAliasType ? this.makeCreateAliasType((MsAliasType)element, root2) : (basicElement instanceof MsTableType ? this.makeCreateTableType((MsTableType)element, root2) : (basicElement instanceof MsTrigger ? this.makeCreateTrigger((BasicTrigger)element, root2) : (basicElement instanceof MsSourceAware ? this.makeCreateSourceAware((BasicSourceAware)element, root2) : super.makeCreateOperation(element, root2))));
        }

        private final Operation makeCreateAliasType(MsAliasType element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<MsAliasType>, Unit>(this){
                final /* synthetic */ MsCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<MsAliasType> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    MsCreatingGenerator.access$generateAliasType(this.this$0.MsCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = msCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateTableType(MsTableType element, Operation root2) {
            BasicNamedElement it;
            Operation operation;
            Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<MsTableType>, Unit>(this){
                final /* synthetic */ MsCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<MsTableType> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    MsCreatingGenerator.access$generateTableType(this.this$0.MsCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = msCreateScenarioBuilder;
                    super(1);
                }
            });
            Iterable $receiver$iv = element.getColumns();
            for (Object element$iv : $receiver$iv) {
                MsTableTypeColumn msTableTypeColumn = it = (MsTableTypeColumn)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)msTableTypeColumn, (String)"it");
                BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, msTableTypeColumn, $receiver, false, 4, null);
            }
            $receiver$iv = element.getKeys();
            for (Object element$iv : $receiver$iv) {
                BasicNamedElement basicNamedElement = it = (MsKey)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
                BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, basicNamedElement, $receiver, false, 4, null);
            }
            $receiver$iv = element.getChecks();
            for (Object element$iv : $receiver$iv) {
                BasicNamedElement basicNamedElement = it = (MsCheck)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicNamedElement, (String)"it");
                BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, basicNamedElement, $receiver, false, 4, null);
            }
            return operation;
        }
    }
}

