/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.oracle.OraBody;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraCollectionType;
import com.intellij.database.model.oracle.OraMatLog;
import com.intellij.database.model.oracle.OraMatView;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraSequence;
import com.intellij.database.model.oracle.OraSingleRoutine;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.oracle.OraCreatingGenerator;
import com.intellij.database.scripting.oracle.OraCreatingGenerator$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u00060\bR\u00020\u0001H\u0014J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0016\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\u0016\u0010\u0016\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0002J\u0016\u0010\u001a\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0002J\u0016\u0010\u001c\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002J\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0012H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020*0\u0012H\u0002J\u0010\u0010+\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0014J\u0016\u0010,\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020-0\u0012H\u0014J\u0016\u0010.\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020/0\u0012H\u0014J\u0016\u00100\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002010\u0012H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020-H\u0014\u00a8\u00068"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "gatherSequenceIdentityParameters", "", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "", "generateBody", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/oracle/OraBody;", "generateCluster", "Lcom/intellij/database/model/oracle/OraCluster;", "generateClusterIndex", "Lcom/intellij/database/model/oracle/OraClusterIndex;", "generateCollectionType", "Lcom/intellij/database/model/oracle/OraCollectionType;", "generateMatLog", "Lcom/intellij/database/model/oracle/OraMatLog;", "generateMatView", "Lcom/intellij/database/model/oracle/OraMatView;", "generateModule", "Lcom/intellij/database/model/oracle/OraModule;", "generateObjectTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "generatePublicSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "generateSimpleSourceAwareObject", "obj", "Lcom/intellij/database/model/oracle/OraSourceAware;", "generateSingleRoutine", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "generateSynonym", "generateTable", "Lcom/intellij/database/model/basic/BasicTable;", "generateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "Lcom/intellij/database/model/oracle/OraView;", "makeColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "OraCreateScenarioBuilder", "intellij.database.scripting"})
public final class OraCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateScenarioBuilder createScenarioBuilder() {
        return new OraCreateScenarioBuilder();
    }

    @Override
    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        super.gatherSequenceIdentityParameters(sequence, parameters);
        if (sequence instanceof OraSequence) {
            if (((OraSequence)sequence).isOrdered()) {
                parameters.add("order");
            }
            if (((OraSequence)sequence).isCycled()) {
                parameters.add("cycle");
            }
            if (((OraSequence)sequence).getCacheSize() > 0) {
                parameters.add("cache " + ((OraSequence)sequence).getCacheSize());
            }
            if (((OraSequence)sequence).getCacheSize() < 0) {
                parameters.add("nocache");
            }
        }
    }

    @Override
    protected void generateTable(@NotNull ElementProducer<BasicTable> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicTable table = producer.getElement();
        if (table instanceof OraTable && ((OraTable)table).getRowTypeObjectName() != null) {
            this.generateObjectTable((OraTable)table);
        } else {
            super.generateTable(producer);
        }
    }

    private final void generateObjectTable(OraTable table) {
        String string;
        String $receiver$iv;
        OraCreatingGenerator this_$iv;
        String objectSchemaName = table.getRowTypeSchemaName();
        if (Intrinsics.areEqual((Object)objectSchemaName, (Object)table.getSchemaName())) {
            objectSchemaName = null;
        }
        String string2 = table.getRowTypeObjectName();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String objectName = string2;
        if (objectSchemaName == null) {
            String string3 = objectName;
            this_$iv = this;
            string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
        } else {
            $receiver$iv = objectSchemaName;
            this_$iv = this;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            $receiver$iv = objectName;
            this_$iv = this;
            stringBuilder = stringBuilder.append(string4).append('.');
            string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            string = stringBuilder.append(string4).toString();
        }
        String n = string;
        String[] stringArray = new String[5];
        stringArray[0] = "create table";
        ObjectKind objectKind = ObjectKind.TABLE;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.TABLE");
        stringArray[1] = this.ifNotExists(objectKind);
        stringArray[2] = this.currentScopeName(table);
        stringArray[3] = "of";
        stringArray[4] = n;
        String s = ScriptingUtilsKt.phrase(stringArray);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $s;

            public final void invoke() {
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$s, null, false, 6, null);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$s = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @Nullable
    protected String makeColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String s = super.makeColumnSpecification(column2);
        if (column2 instanceof OraTableColumn && ((OraTableColumn)column2).isAutoInc()) {
            Collection collection;
            String x = ((OraTableColumn)column2).isDefaultOnNull() ? " generated by default on null as identity" : " generated as identity";
            ArrayList parameters = new ArrayList();
            SequenceIdentity sequenceIdentity = ((OraTableColumn)column2).getSequenceIdentity();
            if (sequenceIdentity != null) {
                this.gatherSequenceIdentityParameters(sequenceIdentity, (List<String>)parameters);
            }
            if (!(collection = (Collection)parameters).isEmpty()) {
                x = x + " (" + CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')';
            }
            s = Intrinsics.stringPlus((String)s, (Object)x);
        }
        return s;
    }

    private final void generateCluster(ElementProducer<OraCluster> producer) {
        OraCluster cluster = producer.getElement();
        String name = this.currentScopeName(cluster);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, name, cluster){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ OraCluster $cluster;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "create cluster " + this.$name, null, false, 6, null);
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "(", null, false, 6, null);
                AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateCluster.1 this$0;

                    public final void invoke() {
                        for (OraClusterColumn oraClusterColumn : this.this$0.$cluster.getColumns()) {
                            String name1 = OraCreatingGenerator.access$getScr$p(this.this$0.this$0, oraClusterColumn.getName());
                            String type1 = oraClusterColumn.getDataType().getSpecification();
                            String suffix = oraClusterColumn.isSorted() ? " sort" : "";
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0), "" + name1 + ' ' + type1 + "" + suffix + ',', null, false, 6, null);
                        }
                        if (this.this$0.$cluster.getColumns().isEmpty()) {
                            CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0), "-- looks like columns were not retrieved because the user had no SELECT_CATALOG_ROLE :(", null, false, 6, null);
                        }
                        OraCreatingGenerator.access$getBuilder$p(this.this$0.this$0).removeSuffixFromTheLastLine(',');
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 1, null);
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), ")", null, false, 6, null);
                CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$cluster.getBlockSize() > 0) {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "size " + this.$cluster.getBlockSize(), null, false, 6, null);
                    }
                    String singleTableClause = this.$cluster.isSingleTable() ? "single table" : null;
                    String cardinalityClause = this.$cluster.getHashCardinality() != 0 ? "hashkeys " + this.$cluster.getHashCardinality() : null;
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), ScriptingUtilsKt.concatWithSpace(singleTableClause, cardinalityClause), null, false, 6, null);
                    if (this.$cluster.getHashExpression() != null) {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "hash is " + this.$cluster.getHashExpression(), null, false, 6, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$name = string;
                this.$cluster = oraCluster;
                super(0);
            }
        }, 3, null);
    }

    private final void generateClusterIndex(ElementProducer<OraClusterIndex> producer) {
        OraClusterIndex index = producer.getElement();
        OraCluster oraCluster = index.getCluster();
        if (oraCluster == null) {
            return;
        }
        OraCluster cluster = oraCluster;
        String clusterName = this.currentScopeName(cluster);
        String indexName = this.currentScopeName(index);
        ClusterType clusterType = cluster.getClusterType();
        if (clusterType != null) {
            switch (OraCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[clusterType.ordinal()]) {
                case 1: {
                    AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, indexName, clusterName){
                        final /* synthetic */ OraCreatingGenerator this$0;
                        final /* synthetic */ String $indexName;
                        final /* synthetic */ String $clusterName;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                            CharSequence[] charSequenceArray = new CharSequence[3];
                            charSequenceArray[0] = "create index";
                            ObjectKind objectKind = ObjectKind.INDEX;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.INDEX");
                            charSequenceArray[1] = this.this$0.ifNotExists(objectKind);
                            charSequenceArray[2] = this.$indexName;
                            codeTextBuilder.phrase(charSequenceArray);
                            CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                            CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                            try {
                                OraCreatingGenerator.access$getBuilder$p(this.this$0).phrase("on cluster", this.$clusterName);
                            }
                            finally {
                                this_$iv.unindent();
                            }
                        }
                        {
                            this.this$0 = oraCreatingGenerator;
                            this.$indexName = string;
                            this.$clusterName = string2;
                            super(0);
                        }
                    }, 3, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        OraTable tab = (OraTable)table;
        String name = this.currentScopeName(table);
        String[] stringArray = new String[3];
        stringArray[0] = "create table";
        ObjectKind objectKind = ((OraTable)table).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
        stringArray[1] = this.ifNotExists(objectKind);
        stringArray[2] = name;
        String string = ScriptingUtilsKt.phrase(stringArray);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String h = string;
        String f = null;
        if (tab.getClusterName() != null) {
            void $receiver$iv;
            void $receiver$iv2;
            String string2 = tab.getClusterName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            OraCreatingGenerator this_$iv = this;
            String cn = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv2);
            Iterable $i$f$getScr = ((OraTable)table).getClusterColNames();
            OraCreatingGenerator this_$iv2 = this;
            String cols = CollectionsKt.joinToString$default((Iterable)$receiver$iv, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((AbstractCodeGenerator)this_$iv2){
                final /* synthetic */ AbstractCodeGenerator this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String $receiver$iv = it;
                    AbstractCodeGenerator this_$iv = this.this$0;
                    return AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                }
                {
                    this.this$0 = abstractCodeGenerator;
                    super(1);
                }
            }), (int)31, null);
            f = "\tcluster " + cn + " (" + cols + ')';
        } else if (Intrinsics.areEqual((Object)((Object)tab.getOrganization()), (Object)((Object)TableOrganization.INDEX))) {
            f = "\torganization index";
        } else if (tab.isTemporary()) {
            String string4;
            String[] stringArray2 = new String[3];
            stringArray2[0] = "create global temporary table";
            ObjectKind objectKind2 = ((OraTable)table).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"table.kind");
            stringArray2[1] = this.ifNotExists(objectKind2);
            stringArray2[2] = name;
            String string5 = ScriptingUtilsKt.phrase(stringArray2);
            if (string5 == null) {
                Intrinsics.throwNpe();
            }
            h = string5;
            boolean bl = tab.isTemporaryPreserve();
            if (!bl) {
                string4 = "\ton commit delete rows";
            } else if (bl) {
                string4 = "\ton commit preserve rows";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            f = string4;
        }
        return new HeaderFooter(h, f);
    }

    private final void generateCollectionType(ElementProducer<OraCollectionType> producer) {
        String string;
        OraCollectionType col = producer.getElement();
        String name = this.currentScopeName(col);
        int n = col.getUpperBound();
        DataType dataType = col.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"col.elementType");
        String d = this.script(dataType);
        if (col.isArray() && n > 0) {
            String[] stringArray = new String[4];
            ObjectKind objectKind = col.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = "type";
            stringArray[2] = name;
            stringArray[3] = "is varray(" + n + ") of " + d;
            string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            String[] stringArray = new String[5];
            ObjectKind objectKind = col.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"col.kind");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = "type";
            stringArray[2] = name;
            stringArray[3] = "as table of";
            stringArray[4] = d;
            string = ScriptingUtilsKt.phrase(stringArray);
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String s1 = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s1){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $s1;

            public final void invoke() {
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$s1, null, false, 6, null);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$s1 = string;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateTrigger(@NotNull ElementProducer<BasicTrigger> producer) {
        OraTable table;
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicTrigger basicTrigger = producer.getElement();
        if (basicTrigger == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraTrigger");
        }
        OraTrigger trigger = (OraTrigger)basicTrigger;
        String triggerName = this.currentScopeName(trigger);
        CharSequence charSequence = trigger.getOriginalSourceText();
        if (charSequence == null) {
            return;
        }
        CharSequence text2 = charSequence;
        BasicLikeTable basicLikeTable = trigger.getLikeTable();
        if (!(basicLikeTable instanceof OraTable)) {
            basicLikeTable = null;
        }
        if ((table = (OraTable)basicLikeTable) == null) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
                final /* synthetic */ OraCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;

                public final void invoke() {
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "-- Cannot generate trigger " + this.$triggerName + ": the table is unknown", null, false, 6, null);
                }
                {
                    this.this$0 = oraCreatingGenerator;
                    this.$triggerName = string;
                    super(0);
                }
            }, 3, null);
            return;
        }
        String tableName = this.currentScopeName(table);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, tableName, text2){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ OraTrigger $trigger;
            final /* synthetic */ String $tableName;
            final /* synthetic */ CharSequence $text;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[3];
                ObjectKind objectKind = ObjectKind.TRIGGER;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.TRIGGER");
                charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                charSequenceArray[1] = "trigger";
                charSequenceArray[2] = this.$triggerName;
                codeTextBuilder.phrase(charSequenceArray);
                CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), ev, null, false, 6, null);
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "on " + this.$tableName, null, false, 6, null);
                    TrigTurn turn = this.$trigger.getTurn();
                    if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                        String c;
                        String string;
                        CharSequence charSequence;
                        String s = "for each row";
                        String string2 = this.$trigger.getCondition();
                        if (string2 != null) {
                            charSequence = string2;
                            String string3 = charSequence;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        } else {
                            string = c = null;
                        }
                        if (c != null && (charSequence = (CharSequence)c).length() > 0) {
                            s = s + " when (" + c + ')';
                        }
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), s, null, false, 6, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$text, CompositeText.Kind.ORIGINAL_TEXT, false, 4, null);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$triggerName = string;
                this.$trigger = oraTrigger;
                this.$tableName = string2;
                this.$text = charSequence;
                super(0);
            }
        }, 3, null);
    }

    private final void generateMatLog(ElementProducer<OraMatLog> producer) {
        OraMatLog ml = producer.getElement();
        OraTable oraTable = ml.getTable();
        if (oraTable == null) {
            return;
        }
        OraTable masterTable = oraTable;
        String string = masterTable.getRealName();
        if (string == null) {
            return;
        }
        String masterName = string;
        String withOptions = ml.withOptions();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, masterName, withOptions, ml){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $masterName;
            final /* synthetic */ String $withOptions;
            final /* synthetic */ OraMatLog $ml;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                OraCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create materialized view log on " + this.$masterName);
                CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$withOptions, null, false, 6, null);
                    if (this.$ml.isWithNewValues()) {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "including new values", null, false, 6, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$masterName = string;
                this.$withOptions = string2;
                this.$ml = oraMatLog;
                super(0);
            }
        }, 3, null);
    }

    private final void generateMatView(ElementProducer<OraMatView> producer) {
        OraMatView view = producer.getElement();
        String name = this.currentScopeName(view);
        Object object = view.getSourceText();
        if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
            return;
        }
        Object sourceText = object;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view, name, (CompositeText.Fragment)sourceText){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ OraMatView $view;
            final /* synthetic */ String $name;
            final /* synthetic */ CompositeText.Fragment $sourceText;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[3];
                ObjectKind objectKind = this.$view.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                charSequenceArray[1] = "materialized view";
                charSequenceArray[2] = this.$name;
                codeTextBuilder.phrase(charSequenceArray);
                CodeTextBuilder this_$iv = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$view.isPrebuilt()) {
                        CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "on prebuilt table", null, false, 6, null);
                    }
                    CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$view.getRefreshSpecification(), null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), "as", null, false, 6, null);
                OraCreatingGenerator.access$getBuilder$p(this.this$0).append(this.$sourceText);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$view = oraMatView;
                this.$name = string;
                this.$sourceText = fragment;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(ElementProducer<OraView> producer) {
        OraView view = producer.getElement();
        String name = this.currentScopeName(view);
        Object object = view.getSourceText();
        if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
            return;
        }
        Object sourceText = object;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view, name, (CompositeText.Fragment)sourceText){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ OraView $view;
            final /* synthetic */ String $name;
            final /* synthetic */ CompositeText.Fragment $sourceText;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[4];
                ObjectKind objectKind = this.$view.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"view.kind");
                charSequenceArray[0] = this.this$0.createOrReplace(objectKind);
                charSequenceArray[1] = "view";
                charSequenceArray[2] = this.$name;
                charSequenceArray[3] = "as";
                codeTextBuilder.phrase(charSequenceArray);
                OraCreatingGenerator.access$getBuilder$p(this.this$0).append(this.$sourceText);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$view = oraView;
                this.$name = string;
                this.$sourceText = fragment;
                super(0);
            }
        }, 3, null);
    }

    private final void generateModule(ElementProducer<OraModule> producer) {
        OraModule module = producer.getElement();
        this.generateSimpleSourceAwareObject(module);
    }

    private final void generateBody(ElementProducer<OraBody> producer) {
        OraBody body = producer.getElement();
        this.generateSimpleSourceAwareObject(body);
    }

    private final void generateSingleRoutine(ElementProducer<OraSingleRoutine> producer) {
        OraSingleRoutine routine = producer.getElement();
        this.generateSimpleSourceAwareObject(routine);
    }

    private final void generateSimpleSourceAwareObject(OraSourceAware obj) {
        Object object = obj.getSourceText();
        if (object == null || (object = object.first(CompositeText.Kind.ORIGINAL_TEXT)) == null) {
            return;
        }
        Object sourceText = object;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, obj, (CompositeText.Fragment)sourceText){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ OraSourceAware $obj;
            final /* synthetic */ CompositeText.Fragment $sourceText;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = OraCreatingGenerator.access$getBuilder$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder();
                ObjectKind objectKind = this.$obj.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"obj.kind");
                CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(this.this$0.createOrReplace(objectKind)).append(" ").toString(), null, false, 2, null);
                OraCreatingGenerator.access$getBuilder$p(this.this$0).append(this.$sourceText);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$obj = oraSourceAware;
                this.$sourceText = fragment;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateSynonym(@NotNull BasicSynonym synonym) {
        Intrinsics.checkParameterIsNotNull((Object)synonym, (String)"synonym");
        if (Intrinsics.areEqual((Object)synonym.getSchemaName(), (Object)"PUBLIC")) {
            this.generatePublicSynonym(synonym);
        } else {
            super.generateSynonym(synonym);
        }
    }

    private final void generatePublicSynonym(BasicSynonym synonym) {
        String string;
        String targetSpec = this.makeSynonymTargetSpec(synonym);
        String name = this.currentScopeName(synonym);
        if (targetSpec != null) {
            String[] stringArray = new String[5];
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.SYNONYM");
            stringArray[0] = this.createOrReplace(objectKind);
            stringArray[1] = "public synonym";
            stringArray[2] = name;
            stringArray[3] = "for";
            stringArray[4] = targetSpec;
            string = ScriptingUtilsKt.phrase(stringArray);
        } else {
            string = "-- unknown what the public synonym " + name + " references on :(";
        }
        String text2 = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, text2){
            final /* synthetic */ OraCreatingGenerator this$0;
            final /* synthetic */ String $text;

            public final void invoke() {
                CodeTextBuilder.append$default(OraCreatingGenerator.access$getBuilder$p(this.this$0), this.$text, null, false, 6, null);
            }
            {
                this.this$0 = oraCreatingGenerator;
                this.$text = string;
                super(0);
            }
        }, 3, null);
    }

    public OraCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ void access$generateCluster(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateCluster(producer);
    }

    public static final /* synthetic */ void access$generateClusterIndex(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateClusterIndex(producer);
    }

    public static final /* synthetic */ void access$generateCollectionType(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateCollectionType(producer);
    }

    public static final /* synthetic */ void access$generateModule(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateModule(producer);
    }

    public static final /* synthetic */ void access$generateBody(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateBody(producer);
    }

    public static final /* synthetic */ void access$generateSingleRoutine(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateSingleRoutine(producer);
    }

    public static final /* synthetic */ void access$generateMatLog(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateMatLog(producer);
    }

    public static final /* synthetic */ void access$generateMatView(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateMatView(producer);
    }

    public static final /* synthetic */ void access$generateView(OraCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateView(producer);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(OraCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(OraCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/scripting/oracle/OraCreatingGenerator$OraCreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "(Lcom/intellij/database/scripting/oracle/OraCreatingGenerator;)V", "makeCreateBody", "Lcom/intellij/database/scripting/Operation;", "element", "Lcom/intellij/database/model/oracle/OraBody;", "root", "makeCreateCluster", "Lcom/intellij/database/model/oracle/OraCluster;", "makeCreateClusterIndex", "Lcom/intellij/database/model/oracle/OraClusterIndex;", "makeCreateCollectionType", "Lcom/intellij/database/model/oracle/OraCollectionType;", "makeCreateMatLog", "Lcom/intellij/database/model/oracle/OraMatLog;", "makeCreateMatView", "Lcom/intellij/database/model/oracle/OraMatView;", "makeCreateModule", "Lcom/intellij/database/model/oracle/OraModule;", "makeCreateOperation", "Lcom/intellij/database/model/basic/BasicElement;", "makeCreateSingleRoutine", "Lcom/intellij/database/model/oracle/OraSingleRoutine;", "makeCreateView", "Lcom/intellij/database/model/oracle/OraView;", "intellij.database.scripting"})
    private final class OraCreateScenarioBuilder
    extends BaseCreatingGenerator.CreateScenarioBuilder {
        @Override
        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof OraCluster ? this.makeCreateCluster((OraCluster)element, root2) : (basicElement instanceof OraClusterIndex ? this.makeCreateClusterIndex((OraClusterIndex)element, root2) : (basicElement instanceof OraCollectionType ? this.makeCreateCollectionType((OraCollectionType)element, root2) : (basicElement instanceof OraModule ? this.makeCreateModule((OraModule)element, root2) : (basicElement instanceof OraBody ? this.makeCreateBody((OraBody)element, root2) : (basicElement instanceof OraSingleRoutine ? this.makeCreateSingleRoutine((OraSingleRoutine)element, root2) : (basicElement instanceof OraMatLog ? this.makeCreateMatLog((OraMatLog)element, root2) : (basicElement instanceof OraMatView ? this.makeCreateMatView((OraMatView)element, root2) : (basicElement instanceof OraView ? this.makeCreateView((OraView)element, root2) : super.makeCreateOperation(element, root2)))))))));
        }

        private final Operation makeCreateCluster(OraCluster element, Operation root2) {
            Operation operation;
            block0: {
                OraClusterIndex oraClusterIndex;
                Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraCluster>, Unit>(this){
                    final /* synthetic */ OraCreateScenarioBuilder this$0;

                    public final void invoke(@NotNull ElementProducer<OraCluster> $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                        OraCreatingGenerator.access$generateCluster(this.this$0.OraCreatingGenerator.this, $receiver);
                    }
                    {
                        this.this$0 = oraCreateScenarioBuilder;
                        super(1);
                    }
                });
                OraClusterIndex oraClusterIndex2 = element.getIndices().get();
                if (oraClusterIndex2 == null) break block0;
                OraClusterIndex it = oraClusterIndex = oraClusterIndex2;
                BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, it, root2, false, 4, null);
            }
            return operation;
        }

        private final Operation makeCreateClusterIndex(OraClusterIndex element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraClusterIndex>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraClusterIndex> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateClusterIndex(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateCollectionType(OraCollectionType element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraCollectionType>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraCollectionType> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateCollectionType(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateModule(OraModule element, Operation root2) {
            Operation operation;
            block0: {
                OraBody oraBody;
                Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraModule>, Unit>(this){
                    final /* synthetic */ OraCreateScenarioBuilder this$0;

                    public final void invoke(@NotNull ElementProducer<OraModule> $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                        OraCreatingGenerator.access$generateModule(this.this$0.OraCreatingGenerator.this, $receiver);
                    }
                    {
                        this.this$0 = oraCreateScenarioBuilder;
                        super(1);
                    }
                });
                OraBody oraBody2 = element.getBodies().get();
                if (oraBody2 == null) break block0;
                OraBody it = oraBody = oraBody2;
                BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, it, root2, false, 4, null);
            }
            return operation;
        }

        private final Operation makeCreateBody(OraBody element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraBody>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraBody> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateBody(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateSingleRoutine(OraSingleRoutine element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraSingleRoutine>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraSingleRoutine> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateSingleRoutine(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateMatLog(OraMatLog element, Operation root2) {
            Operation operation;
            block1: {
                BasicIdentifiedElement basicIdentifiedElement;
                Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraMatLog>, Unit>(this){
                    final /* synthetic */ OraCreateScenarioBuilder this$0;

                    public final void invoke(@NotNull ElementProducer<OraMatLog> $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                        OraCreatingGenerator.access$generateMatLog(this.this$0.OraCreatingGenerator.this, $receiver);
                    }
                    {
                        this.this$0 = oraCreateScenarioBuilder;
                        super(1);
                    }
                });
                BasicIdentifiedElement basicIdentifiedElement2 = element.getTable();
                if (basicIdentifiedElement2 == null || (basicIdentifiedElement2 = basicIdentifiedElement2.getSchema()) == null) break block1;
                BasicIdentifiedElement schema = basicIdentifiedElement = basicIdentifiedElement2;
                OraTable oraTable = (OraTable)schema.getTables().get(element.getName());
                if (oraTable != null) {
                    OraTable oraTable2;
                    OraTable it = oraTable2 = oraTable;
                    this.prepareElement(it, $receiver, true);
                }
            }
            return operation;
        }

        private final Operation makeCreateMatView(OraMatView element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraMatView>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraMatView> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateMatView(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateView(OraView element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<OraView>, Unit>(this){
                final /* synthetic */ OraCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<OraView> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    OraCreatingGenerator.access$generateView(this.this$0.OraCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = oraCreateScenarioBuilder;
                    super(1);
                }
            });
        }
    }
}

