/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.oracle.OraRoot;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.oracle.OraCreatingGenerator;
import com.intellij.database.scripting.oracle.OraDropGenerator;
import com.intellij.database.scripting.oracle.OraExecuteGenerator;
import com.intellij.database.scripting.oracle.OraNativeDefinitionsGenerator;
import com.intellij.database.scripting.oracle.OraRefreshMatViewGenerator;
import com.intellij.database.scripting.oracle.OraScriptingService$PROVIDER$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/scripting/oracle/OraScriptingService;", "Lcom/intellij/database/scripting/AbstractScriptingService;", "Lcom/intellij/database/model/oracle/OraModel;", "Lcom/intellij/database/model/oracle/OraRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "model", "(Lcom/intellij/database/model/oracle/OraModel;)V", "statementDelimiterOwnsLine", "", "getStatementDelimiterOwnsLine", "()Z", "statementDelimiterStr", "", "getStatementDelimiterStr", "()Ljava/lang/String;", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "createExecuteGenerator", "createNativeDefinitionsGenerator", "createRefreshingGenerator", "PROVIDER", "intellij.database.scripting"})
public final class OraScriptingService
extends AbstractScriptingService<OraModel, OraRoot, OraSchema> {
    @NotNull
    private final String statementDelimiterStr = "/";
    private final boolean statementDelimiterOwnsLine = true;

    @Override
    @NotNull
    public String getStatementDelimiterStr() {
        return this.statementDelimiterStr;
    }

    @Override
    public boolean getStatementDelimiterOwnsLine() {
        return this.statementDelimiterOwnsLine;
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraCreatingGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createNativeDefinitionsGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraNativeDefinitionsGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createRefreshingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraRefreshMatViewGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createExecuteGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraExecuteGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createDropGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return new OraDropGenerator(this.getContext(), task);
    }

    public OraScriptingService(@NotNull OraModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModel basicModel = model;
        OraRoot oraRoot = model.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"model.root");
        super(basicModel, (BasicDatabase)oraRoot);
        this.statementDelimiterStr = "/";
        this.statementDelimiterOwnsLine = true;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/oracle/OraScriptingService$PROVIDER;", "Lcom/intellij/database/scripting/AbstractScriptingService$Provider;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "create", "Lcom/intellij/database/scripting/oracle/OraScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "isSupported", "", "category", "Lcom/intellij/database/scripting/ScriptCategory;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "", "scriptingVersion", "", "intellij.database.scripting"})
    public static final class PROVIDER
    implements AbstractScriptingService.Provider {
        private static final PerObjectVersion VERSION;
        public static final PROVIDER INSTANCE;

        @NotNull
        public OraScriptingService create(@NotNull BasicModel model, @Nullable BasicDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return new OraScriptingService((OraModel)model);
        }

        @Override
        public int scriptingVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.get(kind);
        }

        @Override
        public boolean isSupported(@NotNull ScriptCategory category, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)((Object)category), (String)"category");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            switch (OraScriptingService$PROVIDER$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                case 1: {
                    bl = OraDropGenerator.Companion.canDrop(kind, context);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        private PROVIDER() {
        }

        static {
            PROVIDER pROVIDER;
            INSTANCE = pROVIDER = new PROVIDER();
            VERSION = new PerObjectVersion();
        }
    }
}

