/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.postgres.PostgresCollation;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresForeignDataWrapper;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresForeignTable;
import com.intellij.database.model.postgres.PostgresForeignTableColumn;
import com.intellij.database.model.postgres.PostgresLocalTableColumn;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRole;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresBaseCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator;
import com.intellij.database.scripting.postgres.PostgresCreatingGenerator$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001PB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\f\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001fH\u0014J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0014J\u0016\u0010#\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\u0016\u0010'\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%H\u0014J\u0016\u0010(\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020)0%H\u0002J\u0016\u0010*\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020)0%H\u0002J\u0016\u0010+\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020)0%H\u0002J\u0016\u0010,\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020)0%H\u0002J\u0016\u0010-\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020.0%H\u0002J\u0016\u0010/\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002000%H\u0002J\u0016\u00101\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002020%H\u0002J\u0016\u00103\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002040%H\u0002J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002090%H\u0002J\u0016\u0010:\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%H\u0014J\u0016\u0010;\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020<0%H\u0014J\u0016\u0010=\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020>0%H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010@\u001a\u0004\u0018\u00010\u000b2\b\u0010A\u001a\u0004\u0018\u00010BH\u0014J\u0012\u0010C\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\"H\u0014J\u0012\u0010D\u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0014J\u001a\u0010J\u001a\u00020\u000b2\b\u0010K\u001a\u0004\u0018\u00010\u000b2\u0006\u0010L\u001a\u00020\u000bH\u0002J\u001e\u0010M\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010N\u001a\u00020OH\u0002\u00a8\u0006Q"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "appendOptions", "", "options", "", "", "appendRoutineAttributes", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "appendViewOptions", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "elementKindNameForCreate", "element", "Lcom/intellij/database/model/basic/BasicElement;", "floatAttributeName", "", "s", "gatherSequenceIdentityParameters", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "parameters", "", "generalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateCollation", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/postgres/PostgresCollation;", "generateColumn", "generateComposite", "Lcom/intellij/database/model/postgres/PostgresDefType;", "generateDefType", "generateDomain", "generateEnum", "generateForeignDataWrapper", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "generateForeignServer", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "generateOperator", "Lcom/intellij/database/model/postgres/PostgresOperator;", "generatePostgresDefTypeCheck", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "generatePostgresTrigger", "trigger", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "generateRole", "Lcom/intellij/database/model/postgres/PostgresRole;", "generateSequence", "generateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateUserMapping", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "getVolatilityKind", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "makeSerialColumnSpecification", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "table", "Lcom/intellij/database/model/basic/BasicTable;", "maybeQualified", "schemaName", "name", "optionsToString", "wrap", "", "PostgresCreateScenarioBuilder", "intellij.database.scripting"})
public final class PostgresCreatingGenerator
extends PostgresBaseCreatingGenerator {
    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateScenarioBuilder createScenarioBuilder() {
        return new PostgresCreateScenarioBuilder();
    }

    @Override
    protected void appendViewOptions(@NotNull PostgresBaseView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (!(view instanceof PostgresView) || Intrinsics.areEqual((Object)((Object)((PostgresView)view).getCheckOption()), (Object)((Object)PostgresCheckOption.NONE))) {
            return;
        }
        CodeTextBuilder.ensureEoln$default(this.getBuilder(), null, 1, null);
        String string = ((PostgresView)view).getCheckOption().name();
        StringBuilder stringBuilder = new StringBuilder().append("with ");
        CodeTextBuilder codeTextBuilder = this.getBuilder();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(string4).append(" check option").toString(), null, false, 6, null);
    }

    private final void generateForeignDataWrapper(ElementProducer<PostgresForeignDataWrapper> producer) {
        PostgresForeignDataWrapper element = producer.getElement();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresForeignDataWrapper $element;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create foreign data wrapper", PostgresCreatingGenerator.access$getScr$p(this.this$0, this.$element.getName()));
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$element.getHandler() != null) {
                        CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "handler";
                        String string = this.$element.getHandlerSchema();
                        String string2 = this.$element.getHandler();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.handler!!");
                        charSequenceArray[1] = PostgresCreatingGenerator.access$maybeQualified(this.this$0, string, string2);
                        codeTextBuilder.phrase(charSequenceArray);
                    }
                    if (this.$element.getValidator() != null) {
                        CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                        CharSequence[] charSequenceArray = new CharSequence[2];
                        charSequenceArray[0] = "validator";
                        String string = this.$element.getValidatorSchema();
                        String string3 = this.$element.getValidator();
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"element.validator!!");
                        charSequenceArray[1] = PostgresCreatingGenerator.access$maybeQualified(this.this$0, string, string3);
                        codeTextBuilder.phrase(charSequenceArray);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
                List<String> list = this.$element.getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                PostgresCreatingGenerator.access$appendOptions(this.this$0, list);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$element = postgresForeignDataWrapper;
                super(0);
            }
        }, 3, null);
    }

    private final void generateForeignServer(ElementProducer<PostgresForeignServer> producer) {
        PostgresForeignServer element = producer.getElement();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresForeignServer $element;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create server", PostgresCreatingGenerator.access$getScr$p(this.this$0, this.$element.getName()));
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$element.getType() != null) {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("type", '\'' + this.$element.getType() + '\'');
                    }
                    if (this.$element.getVersion() != null) {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("version", '\'' + this.$element.getVersion() + '\'');
                    }
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "foreign data wrapper";
                    BasicElement basicElement = this.$element.getDasParent();
                    if (basicElement == null) {
                        Intrinsics.throwNpe();
                    }
                    charSequenceArray[1] = PostgresCreatingGenerator.access$getScr$p(this.this$0, basicElement.getName());
                    codeTextBuilder.phrase(charSequenceArray);
                }
                finally {
                    this_$iv.unindent();
                }
                List<String> list = this.$element.getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                PostgresCreatingGenerator.access$appendOptions(this.this$0, list);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$element = postgresForeignServer;
                super(0);
            }
        }, 3, null);
    }

    private final void generateUserMapping(ElementProducer<PostgresUserMapping> producer) {
        PostgresUserMapping element = producer.getElement();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresUserMapping $element;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                String string;
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create user mapping for", (string = this.$element.getUser()) != null && (string = PostgresCreatingGenerator.access$getScr$p(this.this$0, string)) != null ? (CharSequence)string : (CharSequence)"public");
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                    CharSequence[] charSequenceArray = new CharSequence[2];
                    charSequenceArray[0] = "server";
                    BasicElement basicElement = this.$element.getDasParent();
                    if (basicElement == null) {
                        Intrinsics.throwNpe();
                    }
                    charSequenceArray[1] = PostgresCreatingGenerator.access$getScr$p(this.this$0, basicElement.getName());
                    codeTextBuilder.phrase(charSequenceArray);
                }
                finally {
                    this_$iv.unindent();
                }
                List<String> list = this.$element.getOptions();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"element.options");
                PostgresCreatingGenerator.access$appendOptions(this.this$0, list);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$element = postgresUserMapping;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendOptions(List<String> options) {
        if (options.isEmpty()) {
            return;
        }
        CodeTextBuilder this_$iv = this.getBuilder();
        CodeTextBuilder.indent$default(this_$iv, null, 1, null);
        try {
            CodeTextBuilder.append$default(this.getBuilder(), "options (", null, false, 2, null);
        }
        finally {
            this_$iv.unindent();
        }
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            CodeTextBuilder.append$default(this.getBuilder(), (CharSequence)CollectionsKt.first((List)keyValue), null, false, 2, null);
            CodeTextBuilder.append$default(this.getBuilder(), " ", null, false, 2, null);
            CodeTextBuilder.append$default(this.getBuilder(), '\'' + (String)CollectionsKt.last((List)keyValue) + '\'', null, false, 2, null);
            if (idx == options.size() - 1) continue;
            CodeTextBuilder.append$default(this.getBuilder(), ", ", null, false, 2, null);
        }
        CodeTextBuilder.append$default(this.getBuilder(), ")", null, false, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String optionsToString(List<String> options, boolean wrap) {
        if (options.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(wrap ? "\n" : " ");
        sb.append("options (");
        Iterable $receiver$iv = options;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void option;
            int n = index$iv++;
            String string = (String)item$iv;
            int idx = n;
            List keyValue = StringsKt.split$default((CharSequence)((CharSequence)option), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
            sb.append((String)CollectionsKt.first((List)keyValue));
            sb.append(" ");
            sb.append('\'' + (String)CollectionsKt.last((List)keyValue) + '\'');
            if (idx == options.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String maybeQualified(String schemaName, String name) {
        String string;
        String string2;
        String $receiver$iv;
        PostgresCreatingGenerator this_$iv;
        StringBuilder stringBuilder;
        if (this.useSchemaName(schemaName)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = schemaName;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            String string4 = string3;
            PostgresCreatingGenerator postgresCreatingGenerator = this;
            stringBuilder = stringBuilder2;
            string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
            string = stringBuilder.append(string2).append(".").toString();
        } else {
            string = "";
        }
        String schema = string;
        $receiver$iv = name;
        this_$iv = this;
        stringBuilder = new StringBuilder().append(schema);
        string2 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
        return stringBuilder.append(string2).toString();
    }

    private final void generateCollation(ElementProducer<PostgresCollation> producer) {
        PostgresCollation element = producer.getElement();
        String string = element.getCType();
        if (string == null) {
            return;
        }
        String cType = string;
        String string2 = element.getCollate();
        if (string2 == null) {
            return;
        }
        String collate = string2;
        boolean useLocale = Intrinsics.areEqual((Object)cType, (Object)collate);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element, useLocale, cType, collate){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresCollation $element;
            final /* synthetic */ boolean $useLocale;
            final /* synthetic */ String $cType;
            final /* synthetic */ String $collate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[4];
                charSequenceArray[0] = "create collation";
                ObjectKind objectKind = ObjectKind.COLLATION;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.COLLATION");
                charSequenceArray[1] = this.this$0.ifNotExists(objectKind);
                charSequenceArray[2] = PostgresCreatingGenerator.access$currentScopeName(this.this$0, this.$element);
                charSequenceArray[3] = "(";
                codeTextBuilder.phrase(charSequenceArray);
                if (this.$useLocale) {
                    CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("locale", "=", '\'' + this.$cType + '\'');
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("lc_collate", "=", '\'' + this.$collate + '\'');
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0).addSuffixToTheLastLine(',');
                }
                finally {
                    this_$iv.unindent();
                }
                this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("lc_ctype", "=", '\'' + this.$cType + '\'');
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), ")", null, false, 6, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$element = postgresCollation;
                this.$useLocale = bl;
                this.$cType = string;
                this.$collate = string2;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendRoutineAttributes(@NotNull PostgresBaseRoutine f) {
        Object it;
        Object this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        super.appendRoutineAttributes(f);
        PostgresRoutine postgresRoutine = (PostgresRoutine)f;
        if (postgresRoutine.isLeakproof()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "leakproof", null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isWindow()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "window", null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isStrict()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "strict", null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (postgresRoutine.isSecurityDefiner()) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "security definer", null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = postgresRoutine.getConcurrencyKind();
        if (postgresRoutineConcurrencyKind != null && Intrinsics.areEqual((Object)(it = (this_$iv = postgresRoutineConcurrencyKind)), (Object)((Object)PostgresRoutineConcurrencyKind.UNSAFE)) ^ true) {
            CodeTextBuilder this_$iv2 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv2, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "parallel " + ((PostgresRoutineConcurrencyKind)((Object)it)).getModifier(), null, false, 6, null);
            }
            finally {
                this_$iv2.unindent();
            }
        }
        if (PostgresModelFun.isCostDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getCost(), "cost") + ' ' + PostgresModelFun.costAsString(postgresRoutine), null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        if (PostgresModelFun.isRowsDefined(postgresRoutine)) {
            this_$iv = this.getBuilder();
            CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, 1, null);
            try {
                CodeTextBuilder.append$default(this.getBuilder(), "" + this.floatAttributeName(postgresRoutine.getRows(), "rows") + ' ' + PostgresModelFun.rowsAsString(postgresRoutine), null, false, 6, null);
            }
            finally {
                ((CodeTextBuilder)this_$iv).unindent();
            }
        }
        List<String> configurationParameters = postgresRoutine.getConfigurationParameters();
        for (String configurationParameter : configurationParameters) {
            CodeTextBuilder this_$iv3 = this.getBuilder();
            CodeTextBuilder.indent$default(this_$iv3, null, 1, null);
            try {
                this.getBuilder().phrase("SET", configurationParameter);
            }
            finally {
                this_$iv3.unindent();
            }
        }
    }

    private final String floatAttributeName(float f, String s) {
        float f2 = f;
        StringBuilder stringBuilder = new StringBuilder().append("");
        boolean bl = Float.isInfinite(f2);
        return stringBuilder.append(bl ? "--" : "").append("").append(s).toString();
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        if (Intrinsics.areEqual((Object)((Object)f.getVolatilityKind()), (Object)((Object)PostgresVolatilityKind.VOLATILE))) {
            string = null;
        } else {
            Object object = f.getVolatilityKind();
            if (object != null && (object = object.name()) != null) {
                Object object2;
                Object object3 = object2 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
        }
        return string;
    }

    @Override
    protected void generateSequence(@NotNull ElementProducer<BasicSequence> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicSequence sequence = producer.getElement();
        if (!(sequence instanceof PostgresSequence) || !((PostgresSequence)sequence).isBelongsToColumn()) {
            super.generateSequence(producer);
        }
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "foreign table" : super.elementKindNameForCreate(element);
    }

    @Override
    protected void gatherSequenceIdentityParameters(@NotNull BasicSequence sequence, @NotNull List<String> parameters) {
        block5: {
            PostgresSequence postgresSequence;
            PostgresSequence $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            BasicSequence basicSequence = sequence;
            if (!(basicSequence instanceof PostgresSequence)) {
                basicSequence = null;
            }
            PostgresSequence postgresSequence2 = (PostgresSequence)basicSequence;
            if (postgresSequence2 != null && !PostgresModelFun.hasDefaultType($receiver = (postgresSequence = postgresSequence2))) {
                parameters.add("as " + $receiver.getDataType());
            }
            super.gatherSequenceIdentityParameters(sequence, parameters);
            BasicSequence basicSequence2 = sequence;
            if (!(basicSequence2 instanceof PostgresSequence)) {
                basicSequence2 = null;
            }
            PostgresSequence postgresSequence3 = (PostgresSequence)basicSequence2;
            if (postgresSequence3 == null) break block5;
            postgresSequence = postgresSequence3;
            $receiver = postgresSequence;
            if (!PostgresModelFun.hasDefaultCacheSize($receiver)) {
                parameters.add("cache " + $receiver.getCacheSize());
            }
            if ($receiver.isCycled()) {
                parameters.add("cycle");
            }
        }
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        HeaderFooter hf = super.makeTableHeaderFooter(table);
        BasicTable basicTable = table;
        if (!(basicTable instanceof PostgresTable)) {
            basicTable = null;
        }
        PostgresTable postgresTable = (PostgresTable)basicTable;
        if (postgresTable == null) {
            return hf;
        }
        PostgresTable t = postgresTable;
        String footer = null;
        Collection collection = t.getAncestorIds();
        if (!collection.isEmpty()) {
            List<PostgresTable> ancestors = PostgresModelFun.getAncestors(t);
            footer = "inherits (" + CollectionsKt.joinToString$default((Iterable)ancestors, null, null, null, (int)0, null, (Function1)((Function1)new Function1<PostgresTable, String>(this){
                final /* synthetic */ PostgresCreatingGenerator this$0;

                @NotNull
                public final String invoke(@NotNull PostgresTable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return PostgresCreatingGenerator.access$currentScopeName(this.this$0, it);
                }
                {
                    this.this$0 = postgresCreatingGenerator;
                    super(1);
                }
            }), (int)31, null) + ")";
        }
        if (t instanceof PostgresForeignTable) {
            if (footer != null) {
                footer = footer + "\n";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = footer;
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string).append("server ").append(((PostgresForeignTable)t).getServer()).append("");
            List<String> list = ((PostgresForeignTable)t).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"t.options");
            footer = stringBuilder2.append(this.optionsToString(list, true)).toString();
        }
        return footer == null ? hf : new HeaderFooter(hf.getHeader(), footer);
    }

    @Override
    protected void generateColumn(@NotNull ElementProducer<BasicLikeColumn> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicLikeColumn column2 = producer.getElement();
        if (column2 instanceof PostgresTableColumn && ((PostgresTableColumn)column2).isInherited()) {
            return;
        }
        super.generateColumn(producer);
    }

    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return column2 instanceof PostgresLocalTableColumn && ((PostgresLocalTableColumn)column2).getSequenceName() != null ? this.makeSerialColumnSpecification((PostgresTableColumn)column2) : super.makeNormalColumnSpecification(column2);
    }

    @Override
    @NotNull
    protected String generalColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        StringBuilder stringBuilder = new StringBuilder().append(super.generalColumnSpecification(column2));
        if (column2 instanceof PostgresForeignTableColumn) {
            List<String> list = ((PostgresForeignTableColumn)column2).getOptions();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"column.options");
            string = this.optionsToString(list, false);
        } else {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String makeSerialColumnSpecification(PostgresTableColumn column2) {
        String specification;
        DataType dt = column2.getDataType();
        String string = StringsKt.startsWith$default((String)dt.typeName, (String)"small", (boolean)false, (int)2, null) ? "smallserial" : (specification = StringsKt.startsWith$default((String)dt.typeName, (String)"big", (boolean)false, (int)2, null) ? "bigserial" : "serial");
        if (column2.isNotNull()) {
            specification = specification + " not null";
        }
        return specification;
    }

    @Override
    protected void generateTrigger(@NotNull ElementProducer<BasicTrigger> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicTrigger trigger = producer.getElement();
        if (trigger instanceof PostgresTrigger) {
            this.generatePostgresTrigger((PostgresTrigger)trigger);
        } else if (trigger instanceof BasicSourceAware) {
            this.generateUnspecificSourceAwareElement((BasicSourceAware)((Object)trigger));
        }
    }

    private final void generatePostgresTrigger(PostgresTrigger trigger) {
        PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine(trigger);
        if (postgresRoutine == null) {
            return;
        }
        PostgresRoutine routine = postgresRoutine;
        String triggerName = this.currentScopeName(trigger);
        Object object = trigger.getLikeTable();
        if (object == null || (object = this.currentScopeName((BasicElement)object)) == null) {
            return;
        }
        Object tableName = object;
        String routineName = this.currentScopeName(routine);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, trigger, (String)tableName, routineName){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $triggerName;
            final /* synthetic */ PostgresTrigger $trigger;
            final /* synthetic */ String $tableName;
            final /* synthetic */ String $routineName;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create trigger", this.$triggerName);
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    String ev = ScriptingUtilsKt.makeTriggerEventString(this.$trigger);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), ev, null, false, 6, null);
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "on " + this.$tableName, null, false, 6, null);
                    TrigTurn turn = this.$trigger.getTurn();
                    if (Intrinsics.areEqual((Object)turn, (Object)TrigTurn.BEFORE_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.AFTER_ROW) || Intrinsics.areEqual((Object)turn, (Object)TrigTurn.INSTEAD_OF)) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "for each row", null, false, 6, null);
                    }
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "execute procedure " + this.$routineName + "()", null, false, 6, null);
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$triggerName = string;
                this.$trigger = postgresTrigger;
                this.$tableName = string2;
                this.$routineName = string3;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
    }

    private final void generateRole(ElementProducer<PostgresRole> producer) {
        PostgresRole role = producer.getElement();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresRole $role;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "create " + (this.$role.isCanLogin() ? "user" : "role") + ' ' + PostgresCreatingGenerator.access$getScr$p(this.this$0, this.$role.getName()), null, false, 6, null);
                CodeTextBuilder this_$iv = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$role.isSuperRole()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "superuser", null, false, 6, null);
                    }
                    if (this.$role.isCreateDb()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "createdb", null, false, 6, null);
                    }
                    if (this.$role.isCreateRole()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "createrole", null, false, 6, null);
                    }
                    if (!this.$role.isInherit()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "noinherit", null, false, 6, null);
                    }
                    if (this.$role.isReplication()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "replication", null, false, 6, null);
                    }
                    if (this.$role.isBypassRls()) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "bypassrls", null, false, 6, null);
                    }
                    if (this.$role.getConnectionLimit() >= 0L) {
                        CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "connection limit " + this.$role.getConnectionLimit(), null, false, 6, null);
                    }
                    if (this.$role.getValidUntil() != null) {
                        CodeTextBuilder codeTextBuilder = PostgresCreatingGenerator.access$getBuilder$p(this.this$0);
                        StringBuilder stringBuilder = new StringBuilder().append("valid until ");
                        String string = this.$role.getValidUntil();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append(PostgresCreatingGenerator.access$getSqlString$p(this.this$0, string)).toString(), null, false, 6, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$role = postgresRole;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDefType(ElementProducer<PostgresDefType> producer) {
        switch (PostgresCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[producer.getElement().getSubKind().ordinal()]) {
            case 1: {
                this.generateEnum(producer);
                break;
            }
            case 2: {
                this.generateDomain(producer);
                break;
            }
            case 3: {
                this.generateComposite(producer);
            }
        }
    }

    private final void generateEnum(ElementProducer<PostgresDefType> producer) {
        PostgresDefType e = producer.getElement();
        String name = this.currentScopeName(e);
        String labels2 = CollectionsKt.joinToString$default((Iterable)e.getLabels(), null, null, null, (int)0, null, (Function1)generateEnum.labels.1.INSTANCE, (int)31, null);
        String cmd = "create type " + name + " as enum (" + labels2 + ')';
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $cmd;

            public final void invoke() {
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), this.$cmd, null, false, 6, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$cmd = string;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDomain(ElementProducer<PostgresDefType> producer) {
        PostgresDefType d = producer.getElement();
        String name = this.currentScopeName(d);
        String def2 = d.getDefinition();
        String cmd = "create domain " + name + " as " + def2 + (d.isNotNull() ? " not null" : "");
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd, d, producer){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $cmd;
            final /* synthetic */ PostgresDefType $d;
            final /* synthetic */ ElementProducer $producer;

            public final void invoke() {
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), this.$cmd, null, false, 6, null);
                AbstractCodeGenerator.coding$default(this.this$0, null, true, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ generateDomain.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $receiver$iv;
                        if (this.this$0.$d.getDefaultExpression() != null) {
                            CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0.this$0), "default " + this.this$0.$d.getDefaultExpression(), null, false, 6, null);
                        }
                        Iterable iterable = this.this$0.$producer.getNestedOperations();
                        PostgresCreatingGenerator postgresCreatingGenerator = this.this$0.this$0;
                        for (T element$iv : $receiver$iv) {
                            Operation p1 = (Operation)element$iv;
                            postgresCreatingGenerator.produce(p1);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 1, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$cmd = string;
                this.$d = postgresDefType;
                this.$producer = elementProducer;
                super(0);
            }
        }, 3, null);
    }

    private final void generateComposite(ElementProducer<PostgresDefType> producer) {
        PostgresDefType struct = producer.getElement();
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, struct){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ PostgresDefType $struct;

            public final void invoke() {
                String name = PostgresCreatingGenerator.access$currentScopeName(this.this$0, this.$struct);
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "create type " + name + " as", null, false, 6, null);
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "(", null, false, 6, null);
                CodeTextBuilder.indent$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), null, 1, null);
                for (PostgresDefTypeAttribute postgresDefTypeAttribute : this.$struct.getAttributes()) {
                    String n = PostgresCreatingGenerator.access$getScr$p(this.this$0, postgresDefTypeAttribute.getName());
                    DataType t = postgresDefTypeAttribute.getDataType();
                    CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), "" + n + ' ' + t + ',', null, false, 6, null);
                }
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).removeSuffixFromTheLastLine(',');
                PostgresCreatingGenerator.access$getBuilder$p(this.this$0).unindent();
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), ")", null, false, 6, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$struct = postgresDefType;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateOperator(ElementProducer<PostgresOperator> producer) {
        PostgresOperator op = producer.getElement();
        ArrayList<String> props = new ArrayList<String>(4);
        if (op.getCallRoutineName() != null) {
            void $receiver$iv;
            void this_$iv;
            StringBuilder stringBuilder = new StringBuilder().append("procedure = ");
            String string = op.getCallRoutineName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            PostgresCreatingGenerator postgresCreatingGenerator = this;
            StringBuilder stringBuilder2 = stringBuilder;
            ArrayList<String> arrayList = props;
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            arrayList.add(stringBuilder2.append(string3).toString());
        }
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
            props.add("leftarg = " + op.getLeftType().getSpecification());
        }
        if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            props.add("rightarg = " + op.getRightType().getSpecification());
        }
        String specification = CollectionsKt.joinToString$default((Iterable)props, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String cmd = "create operator " + op.getName() + " (" + specification + ')';
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, cmd){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $cmd;

            public final void invoke() {
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), this.$cmd, null, false, 6, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$cmd = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePostgresDefTypeCheck(ElementProducer<PostgresDefTypeCheck> producer) {
        String string;
        PostgresDefTypeCheck check = producer.getElement();
        String string2 = check.getNaturalName();
        if (string2 != null) {
            void $receiver$iv;
            String string3 = string2;
            PostgresCreatingGenerator this_$iv = this;
            string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        } else {
            string = null;
        }
        String name = string;
        String string4 = check.getPredicate();
        if (string4 == null) {
            return;
        }
        String predicate = string4;
        String txt = (name != null ? "constraint " + name + ' ' : "") + "check " + predicate;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, txt){
            final /* synthetic */ PostgresCreatingGenerator this$0;
            final /* synthetic */ String $txt;

            public final void invoke() {
                CodeTextBuilder.append$default(PostgresCreatingGenerator.access$getBuilder$p(this.this$0), this.$txt, null, false, 6, null);
            }
            {
                this.this$0 = postgresCreatingGenerator;
                this.$txt = string;
                super(0);
            }
        }, 3, null);
    }

    public PostgresCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ void access$generateRole(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateRole(producer);
    }

    public static final /* synthetic */ void access$generateDefType(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateDefType(producer);
    }

    public static final /* synthetic */ void access$generateOperator(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateOperator(producer);
    }

    public static final /* synthetic */ void access$generatePostgresDefTypeCheck(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generatePostgresDefTypeCheck(producer);
    }

    public static final /* synthetic */ void access$generateCollation(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateCollation(producer);
    }

    public static final /* synthetic */ void access$generateForeignDataWrapper(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateForeignDataWrapper(producer);
    }

    public static final /* synthetic */ void access$generateForeignServer(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateForeignServer(producer);
    }

    public static final /* synthetic */ void access$generateUserMapping(PostgresCreatingGenerator $this, @NotNull ElementProducer producer) {
        $this.generateUserMapping(producer);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(PostgresCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$maybeQualified(PostgresCreatingGenerator $this, @Nullable String schemaName, @NotNull String name) {
        return $this.maybeQualified(schemaName, name);
    }

    public static final /* synthetic */ void access$appendOptions(PostgresCreatingGenerator $this, @NotNull List options) {
        $this.appendOptions(options);
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(PostgresCreatingGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(PostgresCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getSqlString($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0005H\u0014J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0005H\u0014J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator$PostgresCreateScenarioBuilder;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator$PgBaseCreateScenarioBuilder;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "(Lcom/intellij/database/scripting/postgres/PostgresCreatingGenerator;)V", "makeCreateCollation", "Lcom/intellij/database/scripting/Operation;", "element", "Lcom/intellij/database/model/postgres/PostgresCollation;", "root", "makeCreateDefType", "Lcom/intellij/database/model/postgres/PostgresDefType;", "makeCreateForeignDataWrapper", "Lcom/intellij/database/model/postgres/PostgresForeignDataWrapper;", "makeCreateForeignServer", "Lcom/intellij/database/model/postgres/PostgresForeignServer;", "makeCreateLikeColumn", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeCreateOperation", "Lcom/intellij/database/model/basic/BasicElement;", "makeCreateOperator", "Lcom/intellij/database/model/postgres/PostgresOperator;", "makeCreatePostgresDefTypeCheck", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "makeCreateRole", "Lcom/intellij/database/model/postgres/PostgresRole;", "makeCreateTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "makeCreateUserMapping", "Lcom/intellij/database/model/postgres/PostgresUserMapping;", "intellij.database.scripting"})
    private final class PostgresCreateScenarioBuilder
    extends PostgresBaseCreatingGenerator.PgBaseCreateScenarioBuilder {
        @Override
        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof PostgresRole ? this.makeCreateRole((PostgresRole)element, root2) : (basicElement instanceof PostgresDefType ? this.makeCreateDefType((PostgresDefType)element, root2) : (basicElement instanceof PostgresOperator ? this.makeCreateOperator((PostgresOperator)element, root2) : (basicElement instanceof PostgresDefTypeCheck ? this.makeCreatePostgresDefTypeCheck((PostgresDefTypeCheck)element, root2) : (basicElement instanceof PostgresCollation ? this.makeCreateCollation((PostgresCollation)element, root2) : (basicElement instanceof PostgresForeignDataWrapper ? this.makeCreateForeignDataWrapper((PostgresForeignDataWrapper)element, root2) : (basicElement instanceof PostgresForeignServer ? this.makeCreateForeignServer((PostgresForeignServer)element, root2) : (basicElement instanceof PostgresUserMapping ? this.makeCreateUserMapping((PostgresUserMapping)element, root2) : super.makeCreateOperation(element, root2))))))));
        }

        private final Operation makeCreateRole(PostgresRole element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresRole>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresRole> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateRole(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateDefType(PostgresDefType element, Operation root2) {
            Operation operation;
            Operation $receiver = operation = this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresDefType>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresDefType> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateDefType(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
            Iterable $receiver$iv = element.getChecks();
            for (Object element$iv : $receiver$iv) {
                PostgresDefTypeCheck it;
                PostgresDefTypeCheck postgresDefTypeCheck = it = (PostgresDefTypeCheck)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)postgresDefTypeCheck, (String)"it");
                this.prepareElement(postgresDefTypeCheck, $receiver, true);
            }
            return operation;
        }

        private final Operation makeCreateOperator(PostgresOperator element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresOperator>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresOperator> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateOperator(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreatePostgresDefTypeCheck(PostgresDefTypeCheck element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresDefTypeCheck>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresDefTypeCheck> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generatePostgresDefTypeCheck(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateCollation(PostgresCollation element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresCollation>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresCollation> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateCollation(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateForeignDataWrapper(PostgresForeignDataWrapper element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresForeignDataWrapper>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresForeignDataWrapper> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateForeignDataWrapper(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateForeignServer(PostgresForeignServer element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresForeignServer>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresForeignServer> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateForeignServer(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        private final Operation makeCreateUserMapping(PostgresUserMapping element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<PostgresUserMapping>, Unit>(this){
                final /* synthetic */ PostgresCreateScenarioBuilder this$0;

                public final void invoke(@NotNull ElementProducer<PostgresUserMapping> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    PostgresCreatingGenerator.access$generateUserMapping(this.this$0.PostgresCreatingGenerator.this, $receiver);
                }
                {
                    this.this$0 = postgresCreateScenarioBuilder;
                    super(1);
                }
            });
        }

        @Override
        @NotNull
        protected Operation makeCreateLikeColumn(@NotNull BasicLikeColumn element, @NotNull Operation root2) {
            Operation operation;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.makeCreateLikeColumn(element, root2);
                if (!(element instanceof PostgresLocalTableColumn) || ((PostgresLocalTableColumn)element).getSequenceName() == null) break block3;
                BasicNode basicNode = ((PostgresLocalTableColumn)element).getSchema();
                if (basicNode != null && (basicNode = basicNode.getSequences()) != null) {
                    String string = ((PostgresLocalTableColumn)element).getSequenceName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((basicNode = (PostgresSequence)basicNode.get(string)) != null) {
                        BasicNode basicNode2;
                        BasicNode it = basicNode2 = basicNode;
                        this.prepareElement((BasicElement)it, $receiver, true);
                    }
                }
            }
            return operation;
        }

        @Override
        @NotNull
        protected Operation makeCreateTrigger(@NotNull BasicTrigger element, @NotNull Operation root2) {
            Operation operation;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
                Operation $receiver = operation = super.makeCreateTrigger(element, root2);
                if (!(element instanceof PostgresTrigger)) break block2;
                PostgresRoutine callRoutine = PostgresModelFun.getCallRoutine((PostgresTrigger)element);
                if (Intrinsics.areEqual((Object)((Object)PostgresCreatingGenerator.this.getCategory()), (Object)((Object)ScriptCategory.CREATE_DEFINITION)) ^ true) {
                    PostgresRoutine postgresRoutine = callRoutine;
                    if (postgresRoutine != null) {
                        PostgresRoutine postgresRoutine2;
                        PostgresRoutine it = postgresRoutine2 = postgresRoutine;
                        BaseCreatingGenerator.CreateScenarioBuilder.prepareElement$default(this, it, root2, false, 4, null);
                    }
                }
            }
            return operation;
        }
    }
}

