/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.redshift;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.properties.RedshiftExternalTableStorageType;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftExternalSchema;
import com.intellij.database.model.redshift.RedshiftExternalTable;
import com.intellij.database.model.redshift.RedshiftExternalTableColumn;
import com.intellij.database.model.redshift.RedshiftModelFunKt;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import com.intellij.database.model.redshift.RedshiftUser;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.ScriptingUtilsKt;
import com.intellij.database.scripting.postgres.PostgresBaseCreatingGenerator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u00060\bR\u00020\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020\u001aH\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020-H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020-H\u0002\u00a8\u00061"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "elementKindNameForCreate", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "externalTableFooter", "table", "Lcom/intellij/database/model/redshift/RedshiftExternalTable;", "externalTableHeader", "findProperty", "properties", "", "key", "generateColumn", "", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateExternalSchema", "schema", "Lcom/intellij/database/model/redshift/RedshiftExternalSchema;", "generateRowFormat", "fieldDelimiter", "generateSerDeRowFormat", "generateUser", "role", "Lcom/intellij/database/model/redshift/RedshiftUser;", "getVolatilityKind", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "localTableFooter", "Lcom/intellij/database/model/redshift/RedshiftTable;", "makeColumnDefinition", "column", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "Lcom/intellij/database/model/basic/BasicTable;", "tableFooter", "tableHeader", "RedshiftCreateScenarioBuilder", "intellij.database.scripting"})
public final class RedshiftCreatingGenerator
extends PostgresBaseCreatingGenerator {
    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateScenarioBuilder createScenarioBuilder() {
        return new RedshiftCreateScenarioBuilder();
    }

    @Override
    @Nullable
    protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
        Object object = f.getVolatilityKind();
        if (object != null && (object = object.name()) != null) {
            Object object2;
            Object object3 = object2 = object;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object3).toLowerCase();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        return string;
    }

    private final void generateExternalSchema(RedshiftExternalSchema schema) {
        if (schema.getDatabase() == null) {
            return;
        }
        if (schema.getIamRole() == null) {
            return;
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, schema){
            final /* synthetic */ RedshiftCreatingGenerator this$0;
            final /* synthetic */ RedshiftExternalSchema $schema;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                CodeTextBuilder codeTextBuilder = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[4];
                charSequenceArray[0] = "create";
                charSequenceArray[1] = this.this$0.elementKindNameForCreate(this.$schema);
                ObjectKind objectKind = ObjectKind.EXTERNAL_SCHEMA;
                Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"ObjectKind.EXTERNAL_SCHEMA");
                charSequenceArray[2] = this.this$0.ifNotExists(objectKind);
                charSequenceArray[3] = RedshiftCreatingGenerator.access$getScr$p(this.this$0, this.$schema.getName());
                codeTextBuilder.phrase(charSequenceArray);
                CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "from", null, this.$schema.getSchemaKind() != 2, 2, null);
                if (this.$schema.getSchemaKind() == 2) {
                    RedshiftCreatingGenerator.access$getBuilder$p(this.this$0).phrase(" ", "hive", "metastore");
                }
                CodeTextBuilder codeTextBuilder2 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray2 = new CharSequence[2];
                charSequenceArray2[0] = "database";
                String string = this.$schema.getDatabaseName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                charSequenceArray2[1] = RedshiftCreatingGenerator.access$getSqlString$p(this.this$0, string);
                codeTextBuilder2.phrase(charSequenceArray2);
                CodeTextBuilder this_$iv = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    if (this.$schema.getRegion() != null) {
                        CodeTextBuilder codeTextBuilder3 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                        CharSequence[] charSequenceArray3 = new CharSequence[2];
                        charSequenceArray3[0] = "region";
                        String string2 = this.$schema.getRegion();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        charSequenceArray3[1] = RedshiftCreatingGenerator.access$getSqlString$p(this.this$0, string2);
                        codeTextBuilder3.phrase(charSequenceArray3);
                    }
                    if (this.$schema.getUri() != null) {
                        CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "uri ", null, false, 2, null);
                        CodeTextBuilder codeTextBuilder4 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                        String string3 = this.$schema.getUri();
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder4, RedshiftCreatingGenerator.access$getSqlString$p(this.this$0, string3), null, this.$schema.getPort() == null, 2, null);
                        if (this.$schema.getPort() != null) {
                            RedshiftCreatingGenerator.access$getBuilder$p(this.this$0).phrase("port", this.$schema.getPort());
                        }
                    }
                }
                finally {
                    this_$iv.unindent();
                }
                CodeTextBuilder codeTextBuilder5 = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray4 = new CharSequence[2];
                charSequenceArray4[0] = "iam_role";
                String string4 = this.$schema.getIamRole();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                charSequenceArray4[1] = RedshiftCreatingGenerator.access$getSqlString$p(this.this$0, string4);
                codeTextBuilder5.phrase(charSequenceArray4);
            }
            {
                this.this$0 = redshiftCreatingGenerator;
                this.$schema = redshiftExternalSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateUser(RedshiftUser role) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
            final /* synthetic */ RedshiftCreatingGenerator this$0;
            final /* synthetic */ RedshiftUser $role;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                RedshiftCreatingGenerator.access$getBuilder$p(this.this$0).phrase("create", "user", RedshiftCreatingGenerator.access$getScr$p(this.this$0, this.$role.getName()), "password", "disable");
                CodeTextBuilder this_$iv = RedshiftCreatingGenerator.access$getBuilder$p(this.this$0);
                CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                try {
                    String validUntil;
                    if (this.$role.isCreateDb()) {
                        CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "createdb", null, false, 6, null);
                    }
                    if (this.$role.isSuperUser()) {
                        CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "createuser", null, false, 6, null);
                    }
                    if (this.$role.getConnectionLimit() >= 0L) {
                        CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "connection limit " + this.$role.getConnectionLimit(), null, false, 6, null);
                    }
                    if ((validUntil = this.$role.getValidUntil()) != null) {
                        CodeTextBuilder.append$default(RedshiftCreatingGenerator.access$getBuilder$p(this.this$0), "valid until " + RedshiftCreatingGenerator.access$getSqlString$p(this.this$0, validUntil), null, false, 6, null);
                    }
                }
                finally {
                    this_$iv.unindent();
                }
            }
            {
                this.this$0 = redshiftCreatingGenerator;
                this.$role = redshiftUser;
                super(0);
            }
        }, 3, null);
        for (String param : role.getConfig()) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role, param){
                final /* synthetic */ RedshiftCreatingGenerator this$0;
                final /* synthetic */ RedshiftUser $role;
                final /* synthetic */ String $param;

                public final void invoke() {
                    RedshiftCreatingGenerator.access$getBuilder$p(this.this$0).phrase("alter", "user", RedshiftCreatingGenerator.access$getScr$p(this.this$0, this.$role.getName()), "set", this.$param);
                }
                {
                    this.this$0 = redshiftCreatingGenerator;
                    this.$role = redshiftUser;
                    this.$param = string;
                    super(0);
                }
            }, 3, null);
        }
    }

    @Override
    @Nullable
    protected String elementKindNameForCreate(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        ObjectKind objectKind = element.getKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE) ? "external table" : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.EXTERNAL_SCHEMA) ? "external schema" : super.elementKindNameForCreate(element));
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return new HeaderFooter(this.tableHeader(table), this.tableFooter(table));
    }

    private final String tableHeader(BasicTable table) {
        BasicTable basicTable = table;
        return basicTable instanceof RedshiftExternalTable ? this.externalTableHeader((RedshiftExternalTable)table) : super.makeTableHeaderFooter(table).getHeader();
    }

    private final String externalTableHeader(RedshiftExternalTable table) {
        String $receiver$iv;
        RedshiftCreatingGenerator this_$iv;
        String[] stringArray = new String[3];
        ObjectKind objectKind = table.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"table.kind");
        stringArray[0] = this.createOrReplace(objectKind);
        stringArray[1] = this.elementKindNameForCreate(table);
        StringBuilder stringBuilder = new StringBuilder().append("");
        String string = table.getSchemaName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        RedshiftCreatingGenerator redshiftCreatingGenerator = this;
        StringBuilder stringBuilder2 = stringBuilder;
        int n = 2;
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        String string3 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
        $receiver$iv = table.getName();
        this_$iv = this;
        stringBuilder2 = stringBuilder2.append(string3).append('.');
        string3 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
        stringArray2[n] = stringBuilder2.append(string3).toString();
        return ScriptingUtilsKt.phrase(stringArray3);
    }

    private final String tableFooter(BasicTable table) {
        BasicTable basicTable = table;
        return basicTable instanceof RedshiftTable ? this.localTableFooter((RedshiftTable)table) : (basicTable instanceof RedshiftExternalTable ? this.externalTableFooter((RedshiftExternalTable)table) : "");
    }

    /*
     * WARNING - void declaration
     */
    private final String localTableFooter(RedshiftTable table) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        RedshiftTableDistStyle style;
        StringBuilder sb = new StringBuilder();
        if (Intrinsics.areEqual((Object)((Object)table.getBackupMode()), (Object)((Object)RedshiftTableBackupMode.ON)) ^ true) {
            sb.append("backup no\n");
        }
        if (Intrinsics.areEqual((Object)((Object)(style = table.getDistStyle())), (Object)((Object)RedshiftTableDistStyle.EVEN)) ^ true) {
            String string = style.name();
            StringBuilder stringBuilder = new StringBuilder().append("diststyle ");
            StringBuilder stringBuilder2 = sb;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            stringBuilder2.append(stringBuilder.append(string4).append('\n').toString());
        }
        Iterable iterable = $receiver$iv = (Iterable)table.getColumns();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            RedshiftTableColumn it = (RedshiftTableColumn)element$iv$iv;
            if (!(it.getSortKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                RedshiftTableColumn it = (RedshiftTableColumn)a;
                Comparable comparable = Integer.valueOf(Math.abs(it.getSortKeyOrder()));
                it = (RedshiftTableColumn)b;
                Comparable comparable2 = comparable;
                Integer n = Math.abs(it.getSortKeyOrder());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List sortedColumns = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)comparator);
        if (sortedColumns.isEmpty()) {
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }
        if (RedshiftModelFunKt.hasInterleavedSortKey(table)) {
            sb.append("interleaved ");
        }
        sb.append("sortkey(");
        $receiver$iv = sortedColumns;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void col;
            Object element$iv$iv;
            int n = index$iv++;
            element$iv$iv = (RedshiftTableColumn)item$iv;
            int idx = n;
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append(col.getName());
        }
        sb.append(")\n");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String externalTableFooter(RedshiftExternalTable table) {
        Iterable $receiver$iv;
        boolean hasNullStorageFormats;
        boolean unknownStorage;
        block10: {
            boolean bl;
            unknownStorage = Intrinsics.areEqual((Object)((Object)table.getStorageType()), (Object)((Object)RedshiftExternalTableStorageType.UNKNOWN));
            for (String string : new String[]{table.getInputFormat(), table.getOutputFormat(), table.getLocation()}) {
                String it = string;
                if (!(it == null)) continue;
                bl = true;
                break block10;
            }
            bl = hasNullStorageFormats = false;
        }
        if (unknownStorage && hasNullStorageFormats) {
            return "-- unable to generate footer: broken storage attributes";
        }
        StringBuilder sb = new StringBuilder();
        Iterable iterable = $receiver$iv = (Iterable)table.getColumns();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : iterable) {
            RedshiftExternalTableColumn it = (RedshiftExternalTableColumn)element$iv$iv;
            if (!(it.getPartitionKeyOrder() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable iterable2 = $receiver$iv;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                RedshiftExternalTableColumn it = (RedshiftExternalTableColumn)a;
                Comparable comparable = Integer.valueOf(it.getPartitionKeyOrder());
                it = (RedshiftExternalTableColumn)b;
                Comparable comparable2 = comparable;
                Integer n = it.getPartitionKeyOrder();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        List partitionKeys = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)object);
        if (!($receiver$iv = (Collection)partitionKeys).isEmpty()) {
            sb.append("partitioned by (").append(CollectionsKt.joinToString$default((Iterable)partitionKeys, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<RedshiftExternalTableColumn, String>(this){
                final /* synthetic */ RedshiftCreatingGenerator this$0;

                @NotNull
                public final String invoke(RedshiftExternalTableColumn it) {
                    StringBuilder stringBuilder = new StringBuilder().append("").append(RedshiftCreatingGenerator.access$getScr$p(this.this$0, it.getName())).append(' ');
                    DataType dataType = it.getDataType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"it.dataType");
                    return stringBuilder.append(RedshiftCreatingGenerator.access$script(this.this$0, dataType)).toString();
                }
                {
                    this.this$0 = redshiftCreatingGenerator;
                    super(1);
                }
            }), (int)30, null)).append(")\n");
        }
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
        String fieldDelimiter = this.findProperty(list, "field.delim");
        List<String> list2 = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"table.serdeProperties");
        String string = this.findProperty(list2, "serialization.format");
        sb.append(Intrinsics.areEqual((Object)table.getSerializationLib(), (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe") && fieldDelimiter != null && Intrinsics.areEqual((Object)fieldDelimiter, (Object)string) ? this.generateRowFormat(table, fieldDelimiter) : this.generateSerDeRowFormat(table));
        sb.append("stored as\n");
        if (unknownStorage) {
            StringBuilder stringBuilder = new StringBuilder().append("inputformat ");
            String string2 = table.getInputFormat();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder2 = sb.append(stringBuilder.append(this.getSqlString(string2)).append('\n').toString());
            StringBuilder stringBuilder3 = new StringBuilder().append("outputformat ");
            String string3 = table.getOutputFormat();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder4 = stringBuilder2.append(stringBuilder3.append(this.getSqlString(string3)).append('\n').toString());
            StringBuilder stringBuilder5 = new StringBuilder().append("location ");
            String string4 = table.getLocation();
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            stringBuilder4.append(stringBuilder5.append(this.getSqlString(string4)).append('\n').toString());
        } else {
            sb.append("" + table.getStorageType().getSqlDefinition() + '\n');
        }
        object = table.getProps();
        if (!object.isEmpty()) {
            sb.append("table properties (" + CollectionsKt.joinToString$default((Iterable)table.getProps(), null, null, null, (int)0, null, null, (int)63, null) + ')');
        }
        String string5 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
        return string5;
    }

    private final String generateRowFormat(RedshiftExternalTable table, String fieldDelimiter) {
        StringBuffer sb = new StringBuffer();
        List<String> list = table.getSerdeProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"table.serdeProperties");
        String lineDelimiter = this.findProperty(list, "line.delim");
        sb.append("row format delimited\n").append("fields terminated by '" + fieldDelimiter + "'\n");
        if (lineDelimiter != null) {
            sb.append("lines terminated by '" + fieldDelimiter + "'\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String generateSerDeRowFormat(RedshiftExternalTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("row format serde '" + table.getSerializationLib() + "'\n");
        if (!table.getSerdeProperties().isEmpty()) {
            sb.append("with serdeproperties(" + CollectionsKt.joinToString$default((Iterable)table.getSerdeProperties(), null, null, null, (int)0, null, null, (int)63, null) + ")\n");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String findProperty(List<String> properties, String key2) {
        Iterator iterator;
        block5: {
            Iterable iterable;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)properties;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                void s;
                Iterable $receiver$iv2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Iterable iterable3 = $receiver$iv2 = (Iterable)StringUtil.splitHonorQuotes((String)s, (char)'=');
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv2 : $receiver$iv$iv2) {
                    void it;
                    void var16_16;
                    String string2 = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    void v0 = var16_16 = it;
                    if (v0 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string3 = StringUtil.unquoteString((String)((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString(), (char)'\'');
                    collection2.add(string3);
                }
                List list = (List)destination$iv$iv2;
                collection.add(list);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                List it = (List)element$iv$iv;
                if (!(it.size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable2 = iterable = (Iterable)((List)destination$iv$iv);
            for (Iterator iterator2 : iterable2) {
                List it = (List)((Object)iterator2);
                if (!Intrinsics.areEqual((Object)((String)CollectionsKt.first((List)it)), (Object)key2)) continue;
                iterator = iterator2;
                break block5;
            }
            iterator = null;
        }
        List list = (List)((Object)iterator);
        return list != null ? (String)CollectionsKt.last((List)list) : null;
    }

    @Override
    protected void generateColumn(@NotNull ElementProducer<BasicLikeColumn> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicLikeColumn column2 = producer.getElement();
        if (!(column2 instanceof RedshiftExternalTableColumn) || ((RedshiftExternalTableColumn)column2).getPartitionKeyOrder() == 0) {
            super.generateColumn(producer);
        }
    }

    @Override
    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        String string = super.makeColumnDefinition(column2);
        if (string == null) {
            return null;
        }
        String def2 = string;
        StringBuilder b = new StringBuilder();
        if (!(column2 instanceof RedshiftTableColumn)) {
            return def2 + b;
        }
        if (!RedshiftModelFunKt.isDefaultEncoding((RedshiftTableColumn)column2)) {
            b.append(" encode " + ((RedshiftTableColumn)column2).getEncoding());
        }
        if (((RedshiftTableColumn)column2).isDistKey()) {
            b.append(" distkey");
        }
        return def2 + b;
    }

    public RedshiftCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ void access$generateUser(RedshiftCreatingGenerator $this, @NotNull RedshiftUser role) {
        $this.generateUser(role);
    }

    public static final /* synthetic */ void access$generateExternalSchema(RedshiftCreatingGenerator $this, @NotNull RedshiftExternalSchema schema) {
        $this.generateExternalSchema(schema);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(RedshiftCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(RedshiftCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$getSqlString$p(RedshiftCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getSqlString($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$script(RedshiftCreatingGenerator $this, @NotNull DataType d) {
        return $this.script(d);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator$RedshiftCreateScenarioBuilder;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator$PgBaseCreateScenarioBuilder;", "Lcom/intellij/database/scripting/postgres/PostgresBaseCreatingGenerator;", "(Lcom/intellij/database/scripting/redshift/RedshiftCreatingGenerator;)V", "makeCreateExternalSchema", "Lcom/intellij/database/scripting/Operation;", "element", "Lcom/intellij/database/model/redshift/RedshiftExternalSchema;", "root", "makeCreateOperation", "Lcom/intellij/database/model/basic/BasicElement;", "makeCreateUser", "Lcom/intellij/database/model/redshift/RedshiftUser;", "intellij.database.scripting"})
    private final class RedshiftCreateScenarioBuilder
    extends PostgresBaseCreatingGenerator.PgBaseCreateScenarioBuilder {
        @Override
        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            BasicElement basicElement = element;
            return basicElement instanceof RedshiftUser ? this.makeCreateUser((RedshiftUser)element, root2) : (basicElement instanceof RedshiftExternalSchema ? this.makeCreateExternalSchema((RedshiftExternalSchema)element, root2) : super.makeCreateOperation(element, root2));
        }

        private final Operation makeCreateUser(RedshiftUser element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<RedshiftUser>, Unit>(this, element){
                final /* synthetic */ RedshiftCreateScenarioBuilder this$0;
                final /* synthetic */ RedshiftUser $element;

                public final void invoke(@NotNull ElementProducer<RedshiftUser> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    RedshiftCreatingGenerator.access$generateUser(this.this$0.RedshiftCreatingGenerator.this, this.$element);
                }
                {
                    this.this$0 = redshiftCreateScenarioBuilder;
                    this.$element = redshiftUser;
                    super(1);
                }
            });
        }

        private final Operation makeCreateExternalSchema(RedshiftExternalSchema element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<RedshiftExternalSchema>, Unit>(this, element){
                final /* synthetic */ RedshiftCreateScenarioBuilder this$0;
                final /* synthetic */ RedshiftExternalSchema $element;

                public final void invoke(@NotNull ElementProducer<RedshiftExternalSchema> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    RedshiftCreatingGenerator.access$generateExternalSchema(this.this$0.RedshiftCreatingGenerator.this, this.$element);
                }
                {
                    this.this$0 = redshiftCreateScenarioBuilder;
                    this.$element = redshiftExternalSchema;
                    super(1);
                }
            });
        }
    }
}

