/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.sqlite;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteCheck;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteKey;
import com.intellij.database.model.sqlite.SqliteTable;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.scripting.AbortException;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ElementProducer;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.Operation;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.sqlite.SqliteCreatingGenerator;
import com.intellij.database.scripting.sqlite.SqliteCreatingGenerator$SqliteCreateScenarioBuilder$WhenMappings;
import com.intellij.database.scripting.sqlite.SqliteCreatingGenerator$WhenMappings;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u00060\bR\u00020\u0001H\u0014J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0014J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0011H\u0014J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000fH\u0002\u00a8\u0006("}, d2={"Lcom/intellij/database/scripting/sqlite/SqliteCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "createScenarioBuilder", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "generateCheck", "", "producer", "Lcom/intellij/database/scripting/ElementProducer;", "Lcom/intellij/database/model/basic/BasicCheck;", "generateKey", "Lcom/intellij/database/model/basic/BasicKey;", "generateOnConflict", "", "onNullConflict", "Lcom/intellij/database/model/properties/SqliteOnConflictAlgorithm;", "generateVirtualTable", "table", "Lcom/intellij/database/model/sqlite/SqliteVirtualTable;", "isIndexExplicitFor", "", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "key", "makeCascadeRuleKeyword", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "makeNormalColumnSpecification", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "Lcom/intellij/database/model/basic/BasicTable;", "scriptIndexColumn", "shouldAddAutoIncToKey", "SqliteCreateScenarioBuilder", "intellij.database.scripting"})
public final class SqliteCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    @NotNull
    protected BaseCreatingGenerator.CreateScenarioBuilder createScenarioBuilder() {
        return new SqliteCreateScenarioBuilder();
    }

    private final void generateVirtualTable(SqliteVirtualTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ SqliteCreatingGenerator this$0;
            final /* synthetic */ SqliteVirtualTable $table;

            public final void invoke() {
                String name = SqliteCreatingGenerator.access$currentScopeName(this.this$0, this.$table);
                String module = this.$table.getModule();
                CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), "create virtual table " + name + " using " + module + '(', null, false, 6, null);
                for (String argument : this.$table.getArguments()) {
                    CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), argument, CompositeText.Kind.FIXED_TEXT, false, 4, null);
                    SqliteCreatingGenerator.access$getBuilder$p(this.this$0).addSuffixToTheLastLine(',');
                }
                SqliteCreatingGenerator.access$getBuilder$p(this.this$0).removeSuffixFromTheLastLine(',');
                CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), ")", null, false, 6, null);
            }
            {
                this.this$0 = sqliteCreatingGenerator;
                this.$table = sqliteVirtualTable;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected boolean isIndexExplicitFor(@Nullable BasicIndex index, @NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return index != null && index.getNaturalName() != null && index.getColNames().size() == key2.getColNames().size() && Intrinsics.areEqual((Object)index.getName(), (Object)key2.getName()) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generateKey(@NotNull ElementProducer<BasicKey> producer) {
        boolean indexIsExplicit;
        void index;
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicKey key2 = producer.getElement();
        if (!(key2 instanceof SqliteKey)) {
            super.generateKey(producer);
            return;
        }
        String w = ((SqliteKey)key2).isPrimary() ? "primary key" : "unique";
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        if (((SqliteKey)key2).getUnderlyingIndexName() != null) {
            SqliteIndex sqliteIndex;
            void v0 = index;
            BasicNode basicNode = ((SqliteKey)key2).getTable();
            if (basicNode != null && (basicNode = basicNode.getIndices()) != null) {
                Object v2;
                void var11_7;
                block7: {
                    void $receiver$iv;
                    Iterable iterable = (Iterable)((Object)basicNode);
                    var11_7 = v0;
                    for (Object element$iv : $receiver$iv) {
                        SqliteIndex it = (SqliteIndex)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((SqliteKey)key2).getUnderlyingIndexName())) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                Object var12_11 = v2;
                v0 = var11_7;
                sqliteIndex = var12_11;
            } else {
                sqliteIndex = null;
            }
            v0.element = sqliteIndex;
        }
        if ((BasicIndex)index.element != null && ((BasicIndex)index.element).getColNames().size() != ((SqliteKey)key2).getColNames().size()) {
            index.element = null;
        }
        boolean bl = indexIsExplicit = (BasicIndex)index.element != null && ((BasicIndex)index.element).getNaturalName() != null && Intrinsics.areEqual((Object)((BasicIndex)index.element).getName(), (Object)((SqliteKey)key2).getName()) ^ true;
        if (indexIsExplicit) {
            throw (Throwable)new AbortException();
        }
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, key2, w, (Ref.ObjectRef)index){
            final /* synthetic */ SqliteCreatingGenerator this$0;
            final /* synthetic */ BasicKey $key;
            final /* synthetic */ String $w;
            final /* synthetic */ Ref.ObjectRef $index;

            public final void invoke() {
                boolean autoinc = SqliteCreatingGenerator.access$shouldAddAutoIncToKey(this.this$0, this.$key);
                switch (SqliteCreatingGenerator$WhenMappings.$EnumSwitchMapping$0[SqliteCreatingGenerator.access$getLocus$p$s526720334(this.this$0).ordinal()]) {
                    case 1: {
                        SqliteCreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$key);
                        CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), this.$w, null, false, 6, null);
                        if (autoinc) {
                            CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), " autoincrement", null, false, 6, null);
                        }
                        if ((BasicIndex)this.$index.element == null) break;
                        BasicIndex basicIndex = (BasicIndex)this.$index.element;
                        if (basicIndex == null) {
                            Intrinsics.throwNpe();
                        }
                        if (basicIndex.getReverseColNames().isEmpty()) break;
                        CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), " desc", null, false, 6, null);
                        break;
                    }
                    case 2: {
                        SqliteCreatingGenerator.access$addInnerConstraintNameAndIndent(this.this$0, this.$key);
                        String columns2 = (BasicIndex)this.$index.element == null ? SqliteCreatingGenerator.access$getScr$p(this.this$0, ((SqliteKey)this.$key).getColNames()) : CollectionsKt.joinToString$default((Iterable)((SqliteKey)this.$key).getColNames(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(this){
                            final /* synthetic */ generateKey.2 this$0;

                            @NotNull
                            public final String invoke(String it) {
                                SqliteCreatingGenerator sqliteCreatingGenerator = this.this$0.this$0;
                                BasicIndex basicIndex = (BasicIndex)this.this$0.$index.element;
                                if (basicIndex == null) {
                                    Intrinsics.throwNpe();
                                }
                                String string = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                                return sqliteCreatingGenerator.scriptIndexColumn(basicIndex, string);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)31, null);
                        CodeTextBuilder.append$default(SqliteCreatingGenerator.access$getBuilder$p(this.this$0), this.$w + " (" + columns2 + (autoinc ? " autoincrement" : "") + ")", null, false, 6, null);
                        SqliteCreatingGenerator.access$getBuilder$p(this.this$0).addSuffixToTheLastLine(',');
                        break;
                    }
                    default: {
                        throw (Throwable)new AbortException();
                    }
                }
                if (((SqliteKey)this.$key).getOnConflict() != null) {
                    CodeTextBuilder codeTextBuilder = SqliteCreatingGenerator.access$getBuilder$p(this.this$0);
                    SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm = ((SqliteKey)this.$key).getOnConflict();
                    if (sqliteOnConflictAlgorithm == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqliteOnConflictAlgorithm), (String)"key.onConflict!!");
                    CodeTextBuilder.append$default(codeTextBuilder, SqliteCreatingGenerator.access$generateOnConflict(this.this$0, sqliteOnConflictAlgorithm), null, false, 6, null);
                }
            }
            {
                this.this$0 = sqliteCreatingGenerator;
                this.$key = basicKey;
                this.$w = string;
                this.$index = objectRef;
                super(0);
            }
        }, 3, null);
    }

    @Override
    @Nullable
    protected String makeCascadeRuleKeyword(@Nullable CascadeRule rule) {
        return rule != null && Intrinsics.areEqual((Object)((Object)rule), (Object)((Object)CascadeRule.no_action)) ^ true ? rule.keyWord : null;
    }

    @Override
    protected void generateCheck(@NotNull ElementProducer<BasicCheck> producer) {
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        BasicCheck check = producer.getElement();
        super.generateCheck(producer);
        if (check instanceof SqliteCheck && ((SqliteCheck)check).getOnConflict() != null) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, check){
                final /* synthetic */ SqliteCreatingGenerator this$0;
                final /* synthetic */ BasicCheck $check;

                public final void invoke() {
                    CodeTextBuilder codeTextBuilder = SqliteCreatingGenerator.access$getBuilder$p(this.this$0);
                    SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm = ((SqliteCheck)this.$check).getOnConflict();
                    if (sqliteOnConflictAlgorithm == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqliteOnConflictAlgorithm), (String)"check.onConflict!!");
                    CodeTextBuilder.append$default(codeTextBuilder, SqliteCreatingGenerator.access$generateOnConflict(this.this$0, sqliteOnConflictAlgorithm), null, false, 6, null);
                }
                {
                    this.this$0 = sqliteCreatingGenerator;
                    this.$check = basicCheck;
                    super(0);
                }
            }, 3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String scriptIndexColumn(@NotNull BasicIndex index, @NotNull String column2) {
        String string;
        boolean dirs;
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(index instanceof SqliteIndex)) {
            return super.scriptIndexColumn(index, column2);
        }
        CharSequence charSequence = column2;
        if (charSequence.length() == 0) {
            return "???";
        }
        Set<String> descendants = ((SqliteIndex)index).getReverseColNames();
        Collection collection = descendants;
        boolean bl = dirs = !collection.isEmpty();
        if (column2.charAt(0) == '\u001b') {
            String string2 = column2;
            int n = 1;
            int n2 = column2.length();
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            void $receiver$iv;
            String string4 = column2;
            SqliteCreatingGenerator this_$iv = this;
            string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        }
        String s = string;
        String collation = (String)CollectionsKt.getOrNull(((SqliteIndex)index).getColumnCollations(), (int)((SqliteIndex)index).getColNames().indexOf(column2));
        if (StringUtil.isNotEmpty((String)collation)) {
            s = s + " collate " + collation;
        }
        if (dirs) {
            s = s + (descendants.contains(column2) ? " desc" : " asc");
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        if (!(column2 instanceof SqliteTableColumn)) {
            return super.makeNormalColumnSpecification(column2);
        }
        DataType dataType = ((SqliteTableColumn)column2).getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String specification = this.script(dataType);
        if (((SqliteTableColumn)column2).getCollation() != null) {
            void $receiver$iv;
            void this_$iv;
            StringBuilder stringBuilder = new StringBuilder().append(specification).append(" collate ");
            String string2 = ((SqliteTableColumn)column2).getCollation();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = string2;
            SqliteCreatingGenerator sqliteCreatingGenerator = this;
            StringBuilder stringBuilder2 = stringBuilder;
            String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
            specification = stringBuilder2.append(string3).toString();
        }
        if (((SqliteTableColumn)column2).getDefaultExpression() != null) {
            specification = specification + " default " + ((SqliteTableColumn)column2).getDefaultExpression();
        }
        if (((SqliteTableColumn)column2).isNotNull()) {
            specification = specification + " not null";
        }
        SqliteOnConflictAlgorithm onNullConflict = ((SqliteTableColumn)column2).getOnNullConflict();
        if (!((SqliteTableColumn)column2).isNotNull() && (onNullConflict != null || this.getHelper().isNullExplicit(null))) {
            specification = specification + " null";
        }
        if (onNullConflict != null) {
            specification = specification + " " + this.generateOnConflict(onNullConflict);
        }
        String string4 = string = specification;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private final String generateOnConflict(SqliteOnConflictAlgorithm onNullConflict) {
        String string = onNullConflict.toString();
        StringBuilder stringBuilder = new StringBuilder().append("on conflict ");
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        return stringBuilder.append(string4).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAddAutoIncToKey(BasicKey key2) {
        if (!key2.isPrimary()) return false;
        BasicLikeColumn basicLikeColumn = ModelFun.singleColumn(key2);
        if (!(basicLikeColumn instanceof BasicTableColumn)) {
            basicLikeColumn = null;
        }
        BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
        if (basicTableColumn == null) return false;
        boolean bl = basicTableColumn.isAutoInc();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        HeaderFooter hf = super.makeTableHeaderFooter(table);
        if (table instanceof SqliteTable && ((SqliteTable)table).isWithoutRowId()) {
            hf = new HeaderFooter(hf.getHeader(), "without rowid");
        }
        return hf;
    }

    public SqliteCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ void access$generateVirtualTable(SqliteCreatingGenerator $this, @NotNull SqliteVirtualTable table) {
        $this.generateVirtualTable(table);
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(SqliteCreatingGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(SqliteCreatingGenerator $this) {
        return $this.getBuilder();
    }

    public static final /* synthetic */ boolean access$shouldAddAutoIncToKey(SqliteCreatingGenerator $this, @NotNull BasicKey key2) {
        return $this.shouldAddAutoIncToKey(key2);
    }

    @NotNull
    public static final /* synthetic */ ScriptLocus access$getLocus$p$s526720334(SqliteCreatingGenerator $this) {
        return super.getLocus();
    }

    public static final /* synthetic */ void access$setLocus$p$s526720334(SqliteCreatingGenerator $this, @NotNull ScriptLocus scriptLocus) {
        super.setLocus(scriptLocus);
    }

    public static final /* synthetic */ void access$addInnerConstraintNameAndIndent(SqliteCreatingGenerator $this, @NotNull BasicConstraint constraint) {
        $this.addInnerConstraintNameAndIndent(constraint);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(SqliteCreatingGenerator $this, @NotNull Iterable $receiver) {
        return $this.getScr($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$generateOnConflict(SqliteCreatingGenerator $this, @NotNull SqliteOnConflictAlgorithm onNullConflict) {
        return $this.generateOnConflict(onNullConflict);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/sqlite/SqliteCreatingGenerator$SqliteCreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator$CreateScenarioBuilder;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "(Lcom/intellij/database/scripting/sqlite/SqliteCreatingGenerator;)V", "canGenerateElementRightNow", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "makeCreateOperation", "Lcom/intellij/database/scripting/Operation;", "root", "makeCreateVirtualTable", "Lcom/intellij/database/model/sqlite/SqliteVirtualTable;", "intellij.database.scripting"})
    private final class SqliteCreateScenarioBuilder
    extends BaseCreatingGenerator.CreateScenarioBuilder {
        @Override
        @NotNull
        public Operation makeCreateOperation(@NotNull BasicElement element, @NotNull Operation root2) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
            return element instanceof SqliteVirtualTable ? this.makeCreateVirtualTable((SqliteVirtualTable)element, root2) : super.makeCreateOperation(element, root2);
        }

        private final Operation makeCreateVirtualTable(SqliteVirtualTable element, Operation root2) {
            return this.makeCreateNode((BasicElement)element, root2, (Function1)new Function1<ElementProducer<SqliteVirtualTable>, Unit>(this, element){
                final /* synthetic */ SqliteCreateScenarioBuilder this$0;
                final /* synthetic */ SqliteVirtualTable $element;

                public final void invoke(@NotNull ElementProducer<SqliteVirtualTable> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    SqliteCreatingGenerator.access$generateVirtualTable(this.this$0.SqliteCreatingGenerator.this, this.$element);
                }
                {
                    this.this$0 = sqliteCreateScenarioBuilder;
                    this.$element = sqliteVirtualTable;
                    super(1);
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
            if (!super.canGenerateHere(locus, element)) return false;
            switch (SqliteCreatingGenerator$SqliteCreateScenarioBuilder$WhenMappings.$EnumSwitchMapping$0[locus.ordinal()]) {
                case 1: {
                    if (!(element instanceof SqliteKey)) return true;
                    BasicIndex basicIndex = ((SqliteKey)element).getUnderlyingIndex();
                    if (!(basicIndex instanceof SqliteIndex)) {
                        basicIndex = null;
                    }
                    SqliteIndex sqliteIndex = (SqliteIndex)basicIndex;
                    if (sqliteIndex == null) return true;
                    SqliteIndex sqliteIndex2 = sqliteIndex;
                    SqliteIndex it = sqliteIndex2;
                    if (!it.getReverseColNames().isEmpty() && !((SqliteKey)element).isPrimary()) {
                        return false;
                    }
                    if (it.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
                        return true;
                    }
                    List<String> list = it.getColumnCollations();
                    List<String> it2 = list;
                    if (it2.isEmpty()) return true;
                    if (it2.size() != 1) return false;
                    if (!StringUtil.isEmpty((String)it2.get(0))) return false;
                    return true;
                }
                default: {
                    return true;
                }
            }
        }

        @Override
        protected boolean canGenerateElementRightNow(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (!super.canGenerateElementRightNow(element)) {
                return false;
            }
            if (!(element instanceof SqliteKey) || ((SqliteKey)element).getColNames().size() != 1) {
                return true;
            }
            SqliteIndex index = (SqliteIndex)((SqliteKey)element).getUnderlyingIndex();
            if (index == null || index.getColNames().size() != ((SqliteKey)element).getColNames().size()) {
                return true;
            }
            List<String> collations = index.getColumnCollations();
            return collations.isEmpty() || collations.size() == 1 && StringUtil.isEmpty((String)collations.get(0));
        }
    }
}

