/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.exasol;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class ExasolDefinitionProvider
extends DefinitionProviderImpl {
    public static final ExasolDefinitionProvider INSTANCE = new ExasolDefinitionProvider();
    private static final String VIEW_STMT = "SELECT VIEW_TEXT FROM SYS.EXA_ALL_VIEWS WHERE VIEW_NAME = ? AND VIEW_SCHEMA = ?";
    private static final String FUNCTION_STMT = "SELECT 'CREATE ' || FUNCTION_TEXT FROM SYS.EXA_ALL_FUNCTIONS WHERE FUNCTION_NAME = ? AND FUNCTION_SCHEMA = ?";
    private static final String SCRIPT_STMT = "SELECT SCRIPT_TEXT FROM SYS.EXA_ALL_SCRIPTS WHERE SCRIPT_NAME = ? AND SCRIPT_SCHEMA = ?";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            ExasolDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            ExasolDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            ExasolDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ExasolDefinitionProvider.$$$reportNull$$$0(3);
        }
        PreparedStatement viewStmt = null;
        PreparedStatement functionStmt = null;
        PreparedStatement scriptStmt = null;
        try {
            for (DasObject dasObject : objects) {
                PreparedStatement statement;
                ObjectKind kind = dasObject.getKind();
                if (kind == ObjectKind.VIEW) {
                    statement = viewStmt == null ? connection.prepareStatement(VIEW_STMT) : viewStmt;
                } else if (kind == ObjectKind.ROUTINE) {
                    statement = functionStmt == null ? connection.prepareStatement(FUNCTION_STMT) : functionStmt;
                } else {
                    if (kind != ObjectKind.SCRIPT) continue;
                    statement = scriptStmt == null ? connection.prepareStatement(SCRIPT_STMT) : scriptStmt;
                }
                statement.setString(1, DasUtil.getName((DasObject)dasObject));
                statement.setString(2, DasUtil.getSchema((DasObject)dasObject));
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe(viewStmt);
            JdbcUtil.closeStatementSafe(functionStmt);
            JdbcUtil.closeStatementSafe(scriptStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/exasol/ExasolDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

