/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class OracleDefinitionProvider
extends DefinitionProviderImpl {
    public static final OracleDefinitionProvider INSTANCE = new OracleDefinitionProvider();
    private static final String DBMS_METADATA_STMT = "SELECT DBMS_METADATA.GET_DDL(?, ?, ?) FROM SYS.DUAL";

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(0);
        }
        return ((kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.ROUTINE || kind == ObjectKind.INDEX || kind == ObjectKind.CLUSTER || kind == ObjectKind.SYNONYM || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || kind == ObjectKind.MAT_VIEW || kind == ObjectKind.TRIGGER || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.SEQUENCE) && OracleDefinitionProvider.getKindName(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            OracleDefinitionProvider.$$$reportNull$$$0(3);
        }
        PreparedStatement metadataStmt = null;
        try {
            for (DasObject dasObject : objects) {
                PreparedStatement statement = metadataStmt == null ? connection.prepareStatement(DBMS_METADATA_STMT) : metadataStmt;
                statement.setString(1, OracleDefinitionProvider.getKindName(dasObject));
                statement.setString(2, dasObject.getName());
                statement.setString(3, DasUtil.getSchema((DasObject)dasObject));
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
        finally {
            JdbcUtil.closeStatementSafe(metadataStmt);
        }
    }

    private static String getKindName(DasObject obj) {
        ObjectKind kind = obj.getKind();
        if (kind == ObjectKind.ROUTINE) {
            if (DasUtil.getKind((DasObject)obj.getDasParent()) != ObjectKind.SCHEMA) {
                return null;
            }
            if (obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.FUNCTION) {
                return "FUNCTION";
            }
            return "PROCEDURE";
        }
        if (kind == ObjectKind.CHECK) {
            return "CONSTRAINT";
        }
        if (kind == ObjectKind.MAT_VIEW) {
            return "MATERIALIZED_VIEW";
        }
        if (kind == ObjectKind.PACKAGE) {
            return "PACKAGE_SPEC";
        }
        if (kind == ObjectKind.BODY && DasUtil.getKind((DasObject)obj.getDasParent()) == ObjectKind.PACKAGE) {
            return "PACKAGE_BODY";
        }
        if (kind == ObjectKind.OBJECT_TYPE) {
            return "TYPE_SPEC";
        }
        if (kind == ObjectKind.COLLECTION_TYPE) {
            return "TYPE";
        }
        if (kind == ObjectKind.BODY && DasUtil.getKind((DasObject)obj.getDasParent()) == ObjectKind.OBJECT_TYPE) {
            return "TYPE_BODY";
        }
        return kind.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/oracle/OracleDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

