/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof DbElement)) {
            return null;
        }
        if (DatabaseSettings.getSettings().navigateToDdl) {
            return DatabaseTargetElementEvaluator.createToSourceNavigatable((DbElement)element);
        }
        return DatabaseTargetElementEvaluator.createToDatabaseViewNavigatable((DbElement)element);
    }

    @NotNull
    public static PsiElement createToDatabaseViewNavigatable(final @NotNull DbElement element) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        final Project project = element.getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new PomTarget(){

            public boolean isValid() {
                return element.isValid();
            }

            public void navigate(boolean requestFocus) {
                DatabaseView.getDatabaseView(project).selectElement(element);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
        if (psiElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement createToSourceNavigatable(final @NotNull DbElement element) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new PomTarget(){

            public boolean isValid() {
                return element.isValid();
            }

            public void navigate(boolean requestFocus) {
                DatabaseTargetElementEvaluator.navigateToSource(element, requestFocus);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
        if (psiElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(6);
        }
        Project project = dbElement.getProject();
        if (DbSqlUtil.isSqlElement(dbElement)) {
            SqlElement sqlElement = DbSqlUtil.getSqlElement(dbElement);
            if (sqlElement != null) {
                sqlElement.navigate(true);
            } else {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)"No code for item", (String)"Unable to navigate", null);
            }
            return;
        }
        DbElement navigateTo = DatabaseTargetElementEvaluator.adjustForNavigation(dbElement);
        VirtualFile file = DbImplUtil.findSourceVirtualFile(navigateTo, true);
        if (file != null) {
            Runnable runnable = () -> {
                if (dbElement == null) {
                    DatabaseTargetElementEvaluator.$$$reportNull$$$0(9);
                }
                int offset = OpenDataFileDescriptor.calcTargetOffset(project, file, (DasObject)dbElement);
                new OpenFileDescriptor(project, file, offset).navigate(requestFocus);
            };
            if (file instanceof DatabaseElementVirtualFileImpl) {
                DatabaseEditorHelper.reloadIfNeeded((DatabaseElementVirtualFileImpl)file).done(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
            } else {
                runnable.run();
            }
        } else {
            DatabaseView.select((PsiElement)dbElement, requestFocus);
        }
    }

    @NotNull
    public static DbElement adjustForNavigation(@NotNull DbElement element) {
        DatabaseFamilyId familyId;
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(7);
        }
        DbElement parent = element.getParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!(element instanceof DbTrigger) && !(element instanceof DbIndex)) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            DbElement body = (DbElement)parent.getDasChildren(ObjectKind.BODY).first();
            adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body, (Object)parent);
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(8);
        }
        return dbElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToDatabaseViewNavigatable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToSourceNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustForNavigation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createToDatabaseViewNavigatable";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToSourceNavigatable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateToSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustForNavigation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$navigateToSource$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

