/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicDistTableColumn;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.impl.ModelDescribing;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.PsiElement;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor {
    public static void updatePresentation(PresentationData presentation, DasObject element, Project project) {
        presentation.clear();
        presentation.setIcon(element instanceof DbDataSource ? ((DbDataSource)element).getIcon() : DbPresentation.getIcon(element));
        String nodeText = DbPresentation.getPresentableName(element, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(presentation, element);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? "<unnamed>" : nodeText, style);
        if (element instanceof DbDataSource) {
            DbNodeDescriptor.describeDataSource(presentation, (DbDataSource)element);
        }
        if (element instanceof DasNamespace) {
            DbNodeDescriptor.describeNamespace(presentation, (DasNamespace)element, project);
        } else if (element instanceof DasUserDefinedType) {
            DbNodeDescriptor.describeCustomType(presentation, (DasUserDefinedType)element);
        } else if (element instanceof DasColumn) {
            DbNodeDescriptor.describeColumn(presentation, (DasColumn)element);
        } else if (element instanceof DasTable) {
            DbNodeDescriptor.describeTable(presentation, (DasTable)element, project);
        } else if (element instanceof DasRoutine) {
            DbNodeDescriptor.describeRoutine(presentation, (DasRoutine)element, project);
        } else if (element instanceof DasTableKey) {
            DbNodeDescriptor.describeTableKey(presentation, (DasTableKey)element);
        } else if (element instanceof DasForeignKey) {
            DbNodeDescriptor.describeForeignKey(presentation, (DasForeignKey)element);
        } else if (element instanceof DasIndex) {
            DbNodeDescriptor.describeIndex(presentation, (DasIndex)element);
        } else if (element instanceof DasSynonym) {
            DbNodeDescriptor.describeSynonym(presentation, (DasSynonym)element);
        } else {
            DbNodeDescriptor.describeByDelegate(presentation, element);
        }
        String comment = element.getComment();
        if (comment != null && comment.length() > 0) {
            presentation.setTooltip("<html><pre>" + StringUtil.escapeXml((String)StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true)) + "</pre>");
        }
    }

    protected static void describeByDelegate(PresentationData presentation, Object delegate) {
        if (delegate instanceof DasTypedObject) {
            DbNodeDescriptor.describeTyped(presentation, (DasTypedObject)delegate);
        } else if (delegate instanceof BasicSequence) {
            DbNodeDescriptor.describeSequence(presentation, (BasicSequence)delegate);
        } else if (delegate instanceof DasOperator) {
            DbNodeDescriptor.describeOperator(presentation, (DasOperator)delegate);
        } else if (delegate instanceof BasicTrigger) {
            DbNodeDescriptor.describeTrigger(presentation, (BasicTrigger)delegate);
        } else if (delegate instanceof BasicCheck) {
            DbNodeDescriptor.describeCheck(presentation, (BasicCheck)delegate);
        }
    }

    protected static void describeCheck(PresentationData presentation, BasicCheck delegate) {
        DbNodeDescriptor.describePredicate(presentation, delegate.getPredicate());
    }

    private static void describePredicate(PresentationData presentation, String predicate) {
        if (predicate == null) {
            return;
        }
        String adjusted = predicate.startsWith("(") ? predicate : "(" + predicate + ")";
        predicate = StringUtil.shortenTextWithEllipsis((String)adjusted, (int)20, (int)1, (boolean)true);
        presentation.addText(" " + predicate, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeTrigger(PresentationData presentation, BasicTrigger delegate) {
        Set<TrigEvent> events;
        TrigTurn turn = delegate.getTurn();
        if (turn != null) {
            String turnText = StringUtil.join((Iterable)JBIterable.of((Object[])StringUtil.toLowerCase((String)turn.toString()).split("_")).filter(w -> !w.equals("stmt") && !w.equals("row")), (String)" ");
            presentation.addText(" " + turnText, DbNodeDescriptor.getGrayAttrs());
        }
        if (!(events = delegate.getEvents()).isEmpty()) {
            String eventsText = StringUtil.join((Iterable)JBIterable.from(events).transform(e -> {
                List<String> cols = delegate.getColNames();
                if (e == TrigEvent.UPDATE && !cols.isEmpty()) {
                    return "update of " + StringUtil.join(cols, (String)", ");
                }
                return StringUtil.toLowerCase((String)e.toString());
            }), (String)", ");
            presentation.addText(" " + eventsText, DbNodeDescriptor.getGrayAttrs());
        }
        String condition = delegate.getCondition();
        DbNodeDescriptor.describePredicate(presentation, condition);
        if (delegate instanceof PostgresTrigger) {
            String routineName = PostgresModelFun.getCallRoutineName((PostgresTrigger)delegate);
            presentation.addText(' ' + DbPresentation.arrow() + ' ' + routineName, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeOperator(PresentationData presentation, DasOperator delegate) {
        DasOperator.OperatorNotation notation = delegate.getOperatorNotation();
        StringBuilder res = new StringBuilder();
        List args2 = delegate.getArgumentTypes();
        String resType = delegate.getResultType().getSpecification();
        if (notation == DasOperator.OperatorNotation.INFIX) {
            res.append(StringUtil.join((Collection)args2, t -> t.getSpecification(), (String)(" " + delegate.getName() + " ")));
        } else {
            if (notation == DasOperator.OperatorNotation.PREFIX) {
                res.append(delegate.getName());
            }
            if (args2.size() != 1) {
                res.append("(");
            }
            res.append(StringUtil.join((Collection)args2, t -> t.getSpecification(), (String)", "));
            if (args2.size() != 1) {
                res.append(")");
            }
            if (notation == DasOperator.OperatorNotation.POSTFIX) {
                res.append(delegate.getName());
            }
        }
        presentation.addText("    " + res + " " + DbPresentation.arrow() + " " + resType, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeSequence(PresentationData presentation, BasicSequence delegate) {
        SequenceIdentity si = delegate.getSequenceIdentity();
        if (si != null) {
            String specification = si.getSpecification();
            presentation.addText(" " + specification, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeTyped(PresentationData presentation, DasTypedObject delegate) {
        String type = delegate.getDataType().getSpecification();
        presentation.addText(" " + type, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeSynonym(PresentationData presentation, DasSynonym element) {
        Iterable path = element.getTargetPath();
        String pathString = StringUtil.join((Iterable)path, (String)".");
        if (pathString.length() > 0) {
            String text2 = " " + DbPresentation.arrow() + " " + pathString;
            presentation.addText(text2, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeIndex(PresentationData presentation, DasIndex element) {
        String unique = element.isUnique() ? " UNIQUE" : "";
        BasicIndex basicIndex = (BasicIndex)ObjectUtils.tryCast((Object)element, BasicIndex.class);
        if (basicIndex != null) {
            String indexingItems = ModelDescribing.describeIndexingItems(basicIndex);
            presentation.addText(" (" + indexingItems + ")" + unique, DbNodeDescriptor.getGrayAttrs());
            String condition = basicIndex.getCondition();
            if (condition != null) {
                presentation.addText(" where " + condition, DbNodeDescriptor.getGrayAttrs());
            }
        } else {
            String columns2 = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
            presentation.addText(" " + columns2 + unique, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeForeignKey(PresentationData presentation, DasForeignKey element) {
        BasicForeignKey fk;
        String referencingColumns = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef());
        String refSchemaName = null;
        if (element instanceof BasicForeignKey && (fk = (BasicForeignKey)element).isReferencingAnotherSchema()) {
            refSchemaName = fk.getRefSchemaName();
        }
        String arrowToReferenced = DbPresentation.arrowToColumns(refSchemaName, element.getRefTableName(), (MultiRef<? extends DasTypedObject>)element.getRefColumns());
        presentation.addText(" " + referencingColumns + " " + arrowToReferenced, DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeTableKey(PresentationData presentation, DasTableKey element) {
        presentation.addText(" " + DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)element.getColumnsRef()), DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeRoutine(PresentationData presentation, DasRoutine procedure, Project project) {
        StringBuilder sb = new StringBuilder();
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)procedure);
        DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
        DdlBuilder builder = new DdlBuilder(sb).applyCodeStyle(project).withDialect(dialect);
        builder.getDialect().sqlDefinePrototype(builder, procedure, false, true);
        presentation.addText(sb.toString(), DbNodeDescriptor.getGrayAttrs());
    }

    protected static void describeTable(PresentationData presentation, DasTable delegate, Project project) {
        ObjectKind type = delegate.getKind();
        if (!DbImplUtil.isDataTable(type)) {
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)delegate);
            DatabaseDialectEx dialect = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
            String typeName = DbPresentation.getPresentableName(delegate.getKind(), dialect);
            presentation.addText(" " + typeName, DbNodeDescriptor.getGrayAttrs());
        }
        if (delegate instanceof PostgresTable) {
            PostgresTable pt = (PostgresTable)delegate;
            boolean hasAncestors = !pt.getAncestorIds().isEmpty();
            boolean hasSuccessors = !pt.getSuccessorIds().isEmpty();
            String s = "";
            if (hasAncestors) {
                s = " based on (" + ModelFun.namesAsString(PostgresModelFun.getAncestors(pt)) + ')';
            }
            if (hasAncestors && hasSuccessors) {
                s = s + " and";
            }
            if (hasSuccessors) {
                s = s + " the base for {" + ModelFun.namesAsString(PostgresModelFun.getSuccessors(pt)) + '}';
            }
            if (hasAncestors || hasSuccessors) {
                presentation.addText(" " + s, DbNodeDescriptor.getGrayAttrs());
            }
        } else if (delegate instanceof SqliteVirtualTable) {
            SqliteVirtualTable vt = (SqliteVirtualTable)delegate;
            String module = vt.getModule();
            List<String> args2 = vt.getArguments();
            StringBuilder spec = new StringBuilder();
            spec.append(" ");
            if (module != null) {
                spec.append(module);
            }
            spec.append("(");
            StringUtil.join(args2, (String)",", (StringBuilder)spec);
            spec.append(")");
            presentation.addText(spec.toString(), DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeColumn(PresentationData presentation, DasColumn column2) {
        String d = column2.getDataType().getSpecification();
        if (d.length() > 0) {
            presentation.addText(" " + d, DbNodeDescriptor.getGrayAttrs());
        }
        if (DasUtil.isAutoGenerated((DasColumn)column2)) {
            presentation.addText(" (auto increment)", DbNodeDescriptor.getGrayAttrs());
        }
        if (column2 instanceof BasicDistTableColumn && ((BasicDistTableColumn)column2).isDistKey()) {
            presentation.addText(" (in dist key)", DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeCustomType(PresentationData presentation, DasUserDefinedType element) {
        String description = DbImplUtil.getCustomTypeShortDescription(element);
        if (description != null) {
            presentation.addText(' ' + description, DbNodeDescriptor.getGrayAttrs());
        }
    }

    protected static void describeNamespace(PresentationData presentation, DasNamespace element, Project project) {
        DbNodeDescriptor.appendCollapsedNamespaces(presentation, (DasObject)element, project);
    }

    protected static void describeDataSource(PresentationData presentation, DbDataSource element) {
        DbNodeDescriptor.appendCollapsedNamespaces(presentation, (DasObject)element, element.getProject());
    }

    private static void appendCollapsedNamespaces(PresentationData presentation, DasObject element, Project project) {
        String textExt;
        DasObject root2;
        DatabaseViewOptions options = DatabaseView.getDatabaseView(project).getViewOptions();
        DasObject dasObject = options.SHOW_INTERMEDIATE ? element : (element instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element, options) : (root2 = element instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(element, options) : element));
        if (root2 != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText(" (" + textExt + ")", DbNodeDescriptor.getGrayAttrs());
        }
    }

    private static SimpleTextAttributes handleErrors(PresentationData presentation, Object element) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        boolean connected = false;
        if (element instanceof DbDataSource && ((DbDataSource)element).getDelegate() instanceof LocalDataSource) {
            LocalDataSource dataSource = (LocalDataSource)((DbDataSource)element).getDelegate();
            hasErrors = !DbImplUtil.canConnectTo(dataSource);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(element, null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connected = DbImplUtil.isConnected(((DbDataSource)element).getProject(), dataSource);
        } else if (element instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element instanceof DasObject && DbPresentation.isUnnamed((DasObject)element) ? DbNodeDescriptor.getGrayAttrs() : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)element)) {
            presentation.setTooltip("Can't find the driver, open preferences to download");
        }
        if (connected) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        return style;
    }

    static SimpleTextAttributes getGrayAttrs() {
        return UIUtil.isUnderDarcula() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    @Nullable
    public static Object getData(@NonNls String dataId, final Project project, final Object node) {
        if (!(node instanceof DasObject)) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && node instanceof Navigatable) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node instanceof PsiElement) {
                return node;
            }
            return null;
        }
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)node);
        if (dataSource == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (node instanceof DbDataSource) {
                final DatabaseSystem delegate = ((DbDataSource)node).getDelegate();
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile(delegate);
                if (virtualFile == null && !(delegate instanceof SqlDataSource)) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? node : new OpenFileDescriptor(project, virtualFile);
            }
            if (node instanceof Navigatable) {
                return node;
            }
            if (node instanceof DasNamespace && ((DasNamespace)node).getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo((DbElement)dataSource)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)dataSource.getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)node, false);
                        }
                    };
                }
                return DbImplUtil.findElement(dataSource, (DasObject)node);
            }
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DbImplUtil.findElement(dataSource, (DasObject)node);
        }
        return null;
    }
}

