/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DefaultScriptingOptions;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTask;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DeleteQueryGenerator {
    private final BasicModel myModel;
    private final Set<BasicScriptable> myItems;

    public static boolean canDeleteAnything(Iterable<DbElement> elements) {
        ScriptingFactory sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        return !JBIterable.from(elements).filter(e -> DeleteQueryGenerator.canDeleteElement(sf, e)).isEmpty();
    }

    private static boolean canDeleteElement(@NotNull ScriptingFactory sf, @NotNull DbElement e) {
        if (sf == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(0);
        }
        if (e == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(1);
        }
        if (DataImporter.isBusy(e)) {
            return false;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)e.getDataSource());
        Rdbms rdbms = (Rdbms)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findRdbms(dialect.getFamilyId()), (Object)UnknownDatabase.RDBMS);
        return sf.isSupported(ScriptCategory.DROP_COMPLETE, rdbms, e.getKind(), (Iterable<? extends ObjectKind>)DasUtil.dasParents((DasObject)e).skip(1).transform(DasUtil.TO_KIND));
    }

    public DeleteQueryGenerator(Collection<DbElement> elements) {
        this.myItems = JBIterable.from(elements).filter(e -> !DataImporter.isBusy(e)).transform(DbElement::getDelegate).filter(BasicScriptable.class).toSet();
        BasicScriptable item = (BasicScriptable)ContainerUtil.getFirstItem(this.myItems);
        this.myModel = item == null ? null : item.getModel();
    }

    @NotNull
    public CompositeText generateQueries(@Nullable DasNamespace currentNamespace, @NotNull List<String> messages) {
        if (messages == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(2);
        }
        if (this.myItems.isEmpty()) {
            SimpleCompositeText simpleCompositeText = new SimpleCompositeText("-- nothing :(", CompositeText.Kind.PLAIN_TEXT);
            if (simpleCompositeText == null) {
                DeleteQueryGenerator.$$$reportNull$$$0(3);
            }
            return simpleCompositeText;
        }
        ScriptingFactory sf = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        ScriptingService service = sf.createScriptingService(this.myModel, null);
        BasicElement cur = (BasicElement)DbImplUtil.unwrap((DasObject)currentNamespace);
        BasicSchema sc = (BasicSchema)ObjectUtils.tryCast((Object)cur, BasicSchema.class);
        BasicDatabase db = sc == null ? (BasicDatabase)ObjectUtils.tryCast((Object)cur, BasicDatabase.class) : sc.getDatabase();
        service.makeScript(new ScriptingSingleModelTask(this.myModel, this.myItems, db, sc, ScriptCategory.DROP_COMPLETE, DefaultScriptingOptions.INSTANCE));
        CompositeText compositeText = service.getScript();
        if (compositeText == null) {
            DeleteQueryGenerator.$$$reportNull$$$0(4);
        }
        return compositeText;
    }

    public void fillNamespacesToRemove(List<Pair<ObjectName, ObjectName>> toRemove) {
        for (BasicScriptable namespace : this.myItems) {
            ObjectKind kind = namespace.getKind();
            if (kind == ObjectKind.DATABASE) {
                toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)namespace.getName()), null));
                continue;
            }
            if (kind != ObjectKind.SCHEMA) continue;
            BasicElement parent = namespace.getDasParent();
            if (parent != null && parent.getKind() != ObjectKind.DATABASE) {
                parent = null;
            }
            toRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)ObjectName.quoted((String)(parent == null ? null : parent.getName())), (Object)ObjectName.quoted((String)namespace.getName())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DeleteQueryGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DeleteQueryGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateQueries";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

