/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import java.lang.reflect.Array;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorCapabilities {

    public static class DbEditorCaps {
        private final ObjectEditorCaps myNewDatabaseEditorCaps;
        private final ObjectEditorCaps myExistingDatabaseEditorCaps;
        private final ObjectEditorCaps myNewSchemaEditorCaps;
        private final ObjectEditorCaps myExistingSchemaEditorCaps;
        private final TableEditorCaps myNewTableEditorCaps;
        private final TableEditorCaps myExistingTableEditorCaps;

        public DbEditorCaps(@NotNull ObjectEditorCaps newDatabaseEditorCaps, @NotNull ObjectEditorCaps existingDatabaseEditorCaps, @NotNull ObjectEditorCaps newSchemaEditorCaps, @NotNull ObjectEditorCaps existingSchemaEditorCaps, @NotNull TableEditorCaps newTableEditorCaps, @NotNull TableEditorCaps existingTableEditorCaps) {
            if (newDatabaseEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(0);
            }
            if (existingDatabaseEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(1);
            }
            if (newSchemaEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(2);
            }
            if (existingSchemaEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(3);
            }
            if (newTableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(4);
            }
            if (existingTableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(5);
            }
            this.myNewDatabaseEditorCaps = newDatabaseEditorCaps;
            this.myExistingDatabaseEditorCaps = existingDatabaseEditorCaps;
            this.myNewSchemaEditorCaps = newSchemaEditorCaps;
            this.myExistingSchemaEditorCaps = existingSchemaEditorCaps;
            this.myNewTableEditorCaps = newTableEditorCaps;
            this.myExistingTableEditorCaps = existingTableEditorCaps;
        }

        @NotNull
        public ObjectEditorCaps getDatabaseEditorCaps(boolean existing) {
            ObjectEditorCaps objectEditorCaps = existing ? this.myExistingDatabaseEditorCaps : this.myNewDatabaseEditorCaps;
            if (objectEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(6);
            }
            return objectEditorCaps;
        }

        @NotNull
        public ObjectEditorCaps getSchemaEditorCaps(boolean existing) {
            ObjectEditorCaps objectEditorCaps = existing ? this.myExistingSchemaEditorCaps : this.myNewSchemaEditorCaps;
            if (objectEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(7);
            }
            return objectEditorCaps;
        }

        @NotNull
        public TableEditorCaps getTableEditorCaps(boolean existing) {
            TableEditorCaps tableEditorCaps = existing ? this.myExistingTableEditorCaps : this.myNewTableEditorCaps;
            if (tableEditorCaps == null) {
                DbEditorCaps.$$$reportNull$$$0(8);
            }
            return tableEditorCaps;
        }

        @Nullable
        public ObjectEditorCaps getModifyCaps(@NotNull ObjectKind kind) {
            if (kind == null) {
                DbEditorCaps.$$$reportNull$$$0(9);
            }
            if (kind == ObjectKind.DATABASE) {
                return this.getDatabaseEditorCaps(true);
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.getSchemaEditorCaps(true);
            }
            TableEditorCaps tcaps = this.getTableEditorCaps(true);
            if (kind == ObjectKind.TABLE) {
                return tcaps;
            }
            if (kind == ObjectKind.COLUMN) {
                return tcaps.getColumnCaps(true);
            }
            if (kind == ObjectKind.INDEX) {
                return tcaps.getIndexCaps(true);
            }
            if (kind == ObjectKind.KEY) {
                return tcaps.getKeyCaps(true);
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return tcaps.getForeignKeyCaps(true);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDatabaseEditorCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingDatabaseEditorCaps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSchemaEditorCaps";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingSchemaEditorCaps";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newTableEditorCaps";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingTableEditorCaps";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$DbEditorCaps";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDatabaseEditorCaps";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaEditorCaps";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getModifyCaps";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ForeignKeyEditorCaps
    extends ObjectEditorCaps {
        private final ValuesCapability<DasForeignKey.Deferrability> myDeferrability;
        private final ValuesCapability<DasForeignKey.RuleAction> myUpdateRule;
        private final ValuesCapability<DasForeignKey.RuleAction> myDeleteRule;

        public ForeignKeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ValuesCapability<DasForeignKey.Deferrability> deferrability, @NotNull ValuesCapability<DasForeignKey.RuleAction> updateRule, @NotNull ValuesCapability<DasForeignKey.RuleAction> deleteRule) {
            if (rename == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(1);
            }
            if (deferrability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(2);
            }
            if (updateRule == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(3);
            }
            if (deleteRule == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(4);
            }
            super(rename, comment);
            this.myDeferrability = deferrability;
            this.myUpdateRule = updateRule;
            this.myDeleteRule = deleteRule;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getUpdateRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myUpdateRule;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(5);
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.RuleAction> getDeleteRule() {
            ValuesCapability<DasForeignKey.RuleAction> valuesCapability = this.myDeleteRule;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(6);
            }
            return valuesCapability;
        }

        @NotNull
        public ValuesCapability<DasForeignKey.Deferrability> getDeferrability() {
            ValuesCapability<DasForeignKey.Deferrability> valuesCapability = this.myDeferrability;
            if (valuesCapability == null) {
                ForeignKeyEditorCaps.$$$reportNull$$$0(7);
            }
            return valuesCapability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUpdateRule().isAvailable() || this.getDeleteRule().isAvailable() || this.getDeferrability().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deferrability";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateRule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleteRule";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ForeignKeyEditorCaps";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdateRule";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeleteRule";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeferrability";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableKeyColumnEditorCaps {
    }

    public static class IndexColumnEditorCaps {
        private final Capability mySorting;

        public IndexColumnEditorCaps(@NotNull Capability sorting) {
            if (sorting == null) {
                IndexColumnEditorCaps.$$$reportNull$$$0(0);
            }
            this.mySorting = sorting;
        }

        @NotNull
        public Capability getSorting() {
            Capability capability = this.mySorting;
            if (capability == null) {
                IndexColumnEditorCaps.$$$reportNull$$$0(1);
            }
            return capability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorting";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexColumnEditorCaps";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorting";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableKeyEditorCaps
    extends KeyEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;

        public TableKeyEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull KeyEditorCaps caps, boolean tableHasPk, boolean isPk) {
            if (tableCaps == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(1);
            }
            super(caps.getRename(), caps.getComment(), caps.getColumnEditorCaps());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                TableKeyEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableKeyEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class KeyEditorCaps
    extends ObjectEditorCaps {
        private final TableKeyColumnEditorCaps myColumnEditorCaps;

        public KeyEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull TableKeyColumnEditorCaps caps) {
            if (rename == null) {
                KeyEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                KeyEditorCaps.$$$reportNull$$$0(1);
            }
            if (caps == null) {
                KeyEditorCaps.$$$reportNull$$$0(2);
            }
            super(rename, comment);
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public TableKeyColumnEditorCaps getColumnEditorCaps() {
            TableKeyColumnEditorCaps tableKeyColumnEditorCaps = this.myColumnEditorCaps;
            if (tableKeyColumnEditorCaps == null) {
                KeyEditorCaps.$$$reportNull$$$0(3);
            }
            return tableKeyColumnEditorCaps;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$KeyEditorCaps";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IndexEditorCaps
    extends ObjectEditorCaps {
        private final Capability myUnique;
        private final IndexColumnEditorCaps myColumnEditorCaps;

        public IndexEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability unique, @NotNull IndexColumnEditorCaps caps) {
            if (rename == null) {
                IndexEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                IndexEditorCaps.$$$reportNull$$$0(1);
            }
            if (unique == null) {
                IndexEditorCaps.$$$reportNull$$$0(2);
            }
            if (caps == null) {
                IndexEditorCaps.$$$reportNull$$$0(3);
            }
            super(rename, comment);
            this.myUnique = unique;
            this.myColumnEditorCaps = caps;
        }

        @NotNull
        public Capability getUnique() {
            Capability capability = this.myUnique;
            if (capability == null) {
                IndexEditorCaps.$$$reportNull$$$0(4);
            }
            return capability;
        }

        @NotNull
        public IndexColumnEditorCaps getColumnEditorCaps() {
            IndexColumnEditorCaps indexColumnEditorCaps = this.myColumnEditorCaps;
            if (indexColumnEditorCaps == null) {
                IndexEditorCaps.$$$reportNull$$$0(5);
            }
            return indexColumnEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getUnique().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unique";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$IndexEditorCaps";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnique";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableColumnEditorCaps
    extends ColumnEditorCaps {
        private final TableEditorCaps myTableCaps;
        private final boolean myTableHasPk;
        private final boolean myIsPk;
        private final boolean myIsUnique;

        public TableColumnEditorCaps(@NotNull TableEditorCaps tableCaps, @NotNull ColumnEditorCaps columnCaps, boolean tableHasPk, boolean isPk, boolean isUnique) {
            if (tableCaps == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(0);
            }
            if (columnCaps == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(1);
            }
            super(columnCaps.getRename(), columnCaps.getComment(), columnCaps.getDataType(), columnCaps.getAutoInc(), columnCaps.getDefault(), columnCaps.getNotNull());
            this.myTableCaps = tableCaps;
            this.myTableHasPk = tableHasPk;
            this.myIsPk = isPk;
            this.myIsUnique = isUnique;
        }

        @NotNull
        public Capability getPrimaryKey() {
            Capability capability = Capability.from(this.myTableCaps.getPrimaryKey().isSupported(), this.myTableCaps.getPrimaryKey().canSupersede(this.myIsPk, this.myTableHasPk));
            if (capability == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @NotNull
        public Capability getUnique() {
            Capability capability = Capability.from(this.myTableCaps.getIndices().isSupported(), this.myTableCaps.getIndices().canChange(this.myIsUnique));
            if (capability == null) {
                TableColumnEditorCaps.$$$reportNull$$$0(3);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().isAvailable() || this.getUnique().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableCaps";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnCaps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableColumnEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnique";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TableEditorCaps
    extends ObjectEditorCaps {
        private final ListCapability myColumns;
        private final ListCapability myIndices;
        private final ListCapability myForeignKeys;
        private final ListCapability myPrimaryKey;
        private final ListCapability myAltKeys;
        private final ListCapability myConstraints;
        private final ColumnEditorCaps myNewColumnCaps;
        private final ColumnEditorCaps myExistingColumnCaps;
        private final KeyEditorCaps myNewKeyCaps;
        private final KeyEditorCaps myExistingKeyCaps;
        private final IndexEditorCaps myNewIndexCaps;
        private final IndexEditorCaps myExistingIndexCaps;
        private final ForeignKeyEditorCaps myNewForeignKeyCaps;
        private final ForeignKeyEditorCaps myExistingForeignKeyCaps;

        public TableEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull ListCapability columns2, @NotNull ListCapability indices, @NotNull ListCapability foreignKeys, @NotNull ListCapability primaryKey, @NotNull ListCapability altKeys, @NotNull ListCapability constraints, @NotNull ColumnEditorCaps newColumnCaps, @NotNull ColumnEditorCaps existingColumnCaps, @NotNull KeyEditorCaps newKeyCaps, @NotNull KeyEditorCaps existingKeyCaps, @NotNull IndexEditorCaps newIndexCaps, @NotNull IndexEditorCaps existingIndexCaps, @NotNull ForeignKeyEditorCaps newForeignKeyCaps, @NotNull ForeignKeyEditorCaps existingForeignKeyCaps) {
            if (rename == null) {
                TableEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                TableEditorCaps.$$$reportNull$$$0(1);
            }
            if (columns2 == null) {
                TableEditorCaps.$$$reportNull$$$0(2);
            }
            if (indices == null) {
                TableEditorCaps.$$$reportNull$$$0(3);
            }
            if (foreignKeys == null) {
                TableEditorCaps.$$$reportNull$$$0(4);
            }
            if (primaryKey == null) {
                TableEditorCaps.$$$reportNull$$$0(5);
            }
            if (altKeys == null) {
                TableEditorCaps.$$$reportNull$$$0(6);
            }
            if (constraints == null) {
                TableEditorCaps.$$$reportNull$$$0(7);
            }
            if (newColumnCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(8);
            }
            if (existingColumnCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(9);
            }
            if (newKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(10);
            }
            if (existingKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(11);
            }
            if (newIndexCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(12);
            }
            if (existingIndexCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(13);
            }
            if (newForeignKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(14);
            }
            if (existingForeignKeyCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(15);
            }
            super(rename, comment);
            this.myPrimaryKey = primaryKey;
            this.myColumns = columns2;
            this.myIndices = indices;
            this.myForeignKeys = foreignKeys;
            this.myAltKeys = altKeys;
            this.myConstraints = constraints;
            this.myNewColumnCaps = newColumnCaps;
            this.myExistingColumnCaps = existingColumnCaps;
            this.myNewKeyCaps = newKeyCaps;
            this.myExistingKeyCaps = existingKeyCaps;
            this.myNewIndexCaps = newIndexCaps;
            this.myExistingIndexCaps = existingIndexCaps;
            this.myNewForeignKeyCaps = newForeignKeyCaps;
            this.myExistingForeignKeyCaps = existingForeignKeyCaps;
        }

        @NotNull
        public ListCapability getPrimaryKey() {
            ListCapability listCapability = this.myPrimaryKey;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(16);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getColumns() {
            ListCapability listCapability = this.myColumns;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(17);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getAltKeys() {
            ListCapability listCapability = this.myAltKeys;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(18);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getIndices() {
            ListCapability listCapability = this.myIndices;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(19);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getForeignKeys() {
            ListCapability listCapability = this.myForeignKeys;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(20);
            }
            return listCapability;
        }

        @NotNull
        public ListCapability getConstraints() {
            ListCapability listCapability = this.myConstraints;
            if (listCapability == null) {
                TableEditorCaps.$$$reportNull$$$0(21);
            }
            return listCapability;
        }

        @NotNull
        public ColumnEditorCaps getColumnCaps(boolean existing) {
            ColumnEditorCaps columnEditorCaps = existing ? this.myExistingColumnCaps : this.myNewColumnCaps;
            if (columnEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(22);
            }
            return columnEditorCaps;
        }

        @NotNull
        public IndexEditorCaps getIndexCaps(boolean existing) {
            IndexEditorCaps indexEditorCaps = existing ? this.myExistingIndexCaps : this.myNewIndexCaps;
            if (indexEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(23);
            }
            return indexEditorCaps;
        }

        @NotNull
        public ForeignKeyEditorCaps getForeignKeyCaps(boolean existing) {
            ForeignKeyEditorCaps foreignKeyEditorCaps = existing ? this.myExistingForeignKeyCaps : this.myNewForeignKeyCaps;
            if (foreignKeyEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(24);
            }
            return foreignKeyEditorCaps;
        }

        @NotNull
        public KeyEditorCaps getKeyCaps(boolean existing) {
            KeyEditorCaps keyEditorCaps = existing ? this.myExistingKeyCaps : this.myNewKeyCaps;
            if (keyEditorCaps == null) {
                TableEditorCaps.$$$reportNull$$$0(25);
            }
            return keyEditorCaps;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getPrimaryKey().canDoAnything() || this.getColumns().canDoAnything() || this.getIndices().canDoAnything() || this.getForeignKeys().canDoAnything() || this.getConstraints().canDoAnything() || this.getColumnCaps(true).canDoAnything() || this.getColumnCaps(false).canDoAnything() || this.getIndexCaps(true).canDoAnything() || this.getIndexCaps(false).canDoAnything() || this.getForeignKeyCaps(true).canDoAnything() || this.getForeignKeyCaps(false).canDoAnything();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foreignKeys";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryKey";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "altKeys";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newColumnCaps";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingColumnCaps";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newKeyCaps";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingKeyCaps";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newIndexCaps";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingIndexCaps";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newForeignKeyCaps";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingForeignKeyCaps";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$TableEditorCaps";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryKey";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAltKeys";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndices";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConstraints";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnCaps";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexCaps";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeyCaps";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ColumnEditorCaps
    extends ObjectEditorCaps {
        private final Capability myDataType;
        private final Capability myAutoInc;
        private final Capability myDefault;
        private final Capability myNotNull;

        public ColumnEditorCaps(@NotNull Capability rename, @NotNull Capability comment, @NotNull Capability dataType, @NotNull Capability autoInc, @NotNull Capability aDefault, @NotNull Capability notNull) {
            if (rename == null) {
                ColumnEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ColumnEditorCaps.$$$reportNull$$$0(1);
            }
            if (dataType == null) {
                ColumnEditorCaps.$$$reportNull$$$0(2);
            }
            if (autoInc == null) {
                ColumnEditorCaps.$$$reportNull$$$0(3);
            }
            if (aDefault == null) {
                ColumnEditorCaps.$$$reportNull$$$0(4);
            }
            if (notNull == null) {
                ColumnEditorCaps.$$$reportNull$$$0(5);
            }
            super(rename, comment);
            this.myDataType = dataType;
            this.myAutoInc = autoInc;
            this.myDefault = aDefault;
            this.myNotNull = notNull;
        }

        @NotNull
        public Capability getAutoInc() {
            Capability capability = this.myAutoInc;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(6);
            }
            return capability;
        }

        @NotNull
        public Capability getDefault() {
            Capability capability = this.myDefault;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(7);
            }
            return capability;
        }

        @NotNull
        public Capability getNotNull() {
            Capability capability = this.myNotNull;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(8);
            }
            return capability;
        }

        @NotNull
        public Capability getDataType() {
            Capability capability = this.myDataType;
            if (capability == null) {
                ColumnEditorCaps.$$$reportNull$$$0(9);
            }
            return capability;
        }

        @Override
        public boolean canDoAnything() {
            return super.canDoAnything() || this.getAutoInc().isAvailable() || this.getDefault().isAvailable() || this.getNotNull().isAvailable() || this.getDataType().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "autoInc";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aDefault";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notNull";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ColumnEditorCaps";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAutoInc";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotNull";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ObjectEditorCaps {
        private final Capability myRename;
        private final Capability myComment;

        public ObjectEditorCaps(@NotNull Capability rename, @NotNull Capability comment) {
            if (rename == null) {
                ObjectEditorCaps.$$$reportNull$$$0(0);
            }
            if (comment == null) {
                ObjectEditorCaps.$$$reportNull$$$0(1);
            }
            this.myRename = rename;
            this.myComment = comment;
        }

        @NotNull
        public Capability getRename() {
            Capability capability = this.myRename;
            if (capability == null) {
                ObjectEditorCaps.$$$reportNull$$$0(2);
            }
            return capability;
        }

        @NotNull
        public Capability getComment() {
            Capability capability = this.myComment;
            if (capability == null) {
                ObjectEditorCaps.$$$reportNull$$$0(3);
            }
            return capability;
        }

        public boolean canDoAnything() {
            return this.getRename().isAvailable() || this.getComment().isAvailable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ObjectEditorCaps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ValuesCapability<T> {
        private final Capability myCapability;
        private final T[] myValues;

        public static <T> ValuesCapability<T> unsupported(@NotNull Class<T> clazz) {
            if (clazz == null) {
                ValuesCapability.$$$reportNull$$$0(0);
            }
            return new ValuesCapability<Object>(Capability.UNSUPPORTED, (Object[])Array.newInstance(clazz, 0));
        }

        public static <T> ValuesCapability<T> supported(boolean avail, T ... values2) {
            if (values2 == null) {
                ValuesCapability.$$$reportNull$$$0(1);
            }
            return new ValuesCapability<T>(Capability.available(avail), values2);
        }

        private ValuesCapability(Capability capability, T[] values2) {
            this.myCapability = capability;
            this.myValues = values2;
        }

        public boolean isAvailable() {
            return this.myCapability.isAvailable();
        }

        public boolean isSupported() {
            return this.myCapability.isSupported();
        }

        public T[] values() {
            return this.myValues;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$ValuesCapability";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unsupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "supported";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ListCapability {
        private static final int REORDERABLE = 1;
        private static final int ADDABLE = 2;
        private static final int REMOVABLE = 4;
        private static final int UNSUPPORTED = 8;
        private static final ListCapability[] INSTANCES = new ListCapability[9];
        private final int myFlags;

        public static ListCapability unsupported() {
            return INSTANCES[8];
        }

        public static ListCapability supported(boolean reorder, boolean add, boolean remove) {
            return INSTANCES[(reorder ? 1 : 0) + (add ? 2 : 0) + (remove ? 4 : 0)];
        }

        public static ListCapability get(boolean supported, boolean reorder, boolean add, boolean remove) {
            return supported ? ListCapability.supported(reorder, add, remove) : ListCapability.unsupported();
        }

        public boolean canDoAnything() {
            return this.canAdd() || this.canRemove() || this.canReorder();
        }

        public boolean isSupported() {
            return this.myFlags != 8;
        }

        public boolean canSupersede(boolean addedMy, boolean addedAny) {
            return addedAny && !addedMy ? this.canReadd() : this.canChange(addedMy);
        }

        public boolean canReadd() {
            return this.canRemove() && this.canAdd();
        }

        public boolean canChange(boolean added) {
            return added ? this.canRemove() : this.canAdd();
        }

        public boolean canAdd() {
            return (this.myFlags & 2) != 0;
        }

        public boolean canRemove() {
            return (this.myFlags & 4) != 0;
        }

        public boolean canReorder() {
            return (this.myFlags & 1) != 0;
        }

        private ListCapability(int flags) {
            this.myFlags = flags;
        }

        static {
            for (int i2 = 0; i2 < INSTANCES.length; ++i2) {
                ListCapability.INSTANCES[i2] = new ListCapability(i2);
            }
        }
    }

    public static enum Capability {
        UNSUPPORTED,
        UNAVAILABLE,
        AVAILABLE;


        public boolean isAvailable() {
            return this == AVAILABLE;
        }

        public boolean isSupported() {
            return this != UNSUPPORTED;
        }

        public <T> T convert(T unsup, T unavail, T avail) {
            return this == UNSUPPORTED ? unsup : (this == UNAVAILABLE ? unavail : avail);
        }

        @NotNull
        public static Capability from(boolean supported, boolean avail) {
            Capability capability = !supported ? UNSUPPORTED : (avail ? AVAILABLE : UNAVAILABLE);
            if (capability == null) {
                Capability.$$$reportNull$$$0(0);
            }
            return capability;
        }

        @NotNull
        public static Capability available(boolean avail) {
            Capability capability = avail ? AVAILABLE : UNAVAILABLE;
            if (capability == null) {
                Capability.$$$reportNull$$$0(1);
            }
            return capability;
        }

        @NotNull
        public static Capability supported(boolean sup) {
            Capability capability = sup ? AVAILABLE : UNSUPPORTED;
            if (capability == null) {
                Capability.$$$reportNull$$$0(2);
            }
            return capability;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/editors/DatabaseEditorCapabilities$Capability";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "available";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supported";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

