/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.database.model.DasColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;
import org.jetbrains.annotations.NotNull;

public class SqlReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return element instanceof SqlDefinition;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        return element instanceof SqlVariableDefinition && ((SqlVariableDefinition)element).getInitializer() != null;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        if (!(referencedElement instanceof DasColumn) && !(referencedElement instanceof SqlAsExpression)) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(4);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(5);
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        PsiElement parent;
        if (expression == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(6);
        }
        if ((parent = expression.getParent()) instanceof SqlBinaryExpression) {
            SqlBinaryExpression binaryExpression = (SqlBinaryExpression)parent;
            ReadWriteAccessDetector.Access access = binaryExpression.getOpSign() == SqlTokens.SQL_OP_ASSIGN && binaryExpression.getLOperand() == expression ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(7);
            }
            return access;
        }
        SqlTableColumnsList tableColumnList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlTableColumnsList.class);
        if (tableColumnList != null) {
            ReadWriteAccessDetector.Access access = tableColumnList.getParent() instanceof SqlDmlInstruction && tableColumnList.getParent().getParent() instanceof SqlInsertStatement ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(8);
            }
            return access;
        }
        SqlSetClause setClause = (SqlSetClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSetClause.class);
        if (setClause != null) {
            PsiElement first = parent instanceof SqlReferenceList ? parent : expression;
            for (PsiElement child = first.getNextSibling(); child != null; child = child.getNextSibling()) {
                IElementType elementType = child.getNode().getElementType();
                if (elementType == SqlTokens.SQL_COMMA) {
                    ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
                    if (access == null) {
                        SqlReadWriteAccessDetector.$$$reportNull$$$0(9);
                    }
                    return access;
                }
                if (elementType != SqlTokens.SQL_OP_EQ) continue;
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(10);
                }
                return access;
            }
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(11);
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

