/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseModOperator;
import com.intellij.database.model.postgresbase.PostgresBaseModRoutine;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.database.SqlObjectBuilderImpl;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012JB\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0017H\u0004J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00152\b\u0010\u0007\u001a\u0004\u0018\u00010\u0011H\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u000eH\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/sql/dialects/postgres/PostgresBaseObjectBuilder;", "Lcom/intellij/sql/database/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "buildOperator", "Lcom/intellij/database/model/postgresbase/PostgresBaseModOperator;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineFromCreateFunction", "Lcom/intellij/sql/psi/impl/SqlCreateFunctionStatementImpl;", "findNumberInSiblings", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Float;", "findOptions", "", "", "nextElement", "Lkotlin/Function1;", "optionFormatter", "findString", "getPgOperatorKind", "Lcom/intellij/database/model/properties/PostgresOperatorKind;", "n", "Lcom/intellij/database/model/DasOperator$OperatorNotation;", "getRoutineArgumentsDefinition", "getRoutineResultDefinition", "getRoutineSourceText", "intellij.database.sql.dialects"})
public class PostgresBaseObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof PostgresBaseModOperator) {
            this.buildOperator((PostgresBaseModOperator)obj, source);
        } else {
            super.build(obj, source);
        }
    }

    @Override
    protected void buildRoutine(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source instanceof SqlCreateFunctionStatementImpl) {
            this.buildRoutineFromCreateFunction(obj, (SqlCreateFunctionStatementImpl)source);
        } else {
            super.buildRoutine(obj, source);
        }
    }

    @Nullable
    protected final String findString(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlCompositeElementType);
        if (!(psiElement instanceof SqlStringLiteralExpressionImpl)) {
            psiElement = null;
        }
        SqlStringLiteralExpressionImpl sqlStringLiteralExpressionImpl = (SqlStringLiteralExpressionImpl)psiElement;
        return sqlStringLiteralExpressionImpl != null ? sqlStringLiteralExpressionImpl.getValue() : null;
    }

    @Nullable
    protected final Float findNumberInSiblings(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findSibling(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toFloatOrNull((String)object) : null;
    }

    @NotNull
    protected final List<String> findOptions(@Nullable PsiElement source, @NotNull Function1<? super PsiElement, ? extends PsiElement> nextElement, @NotNull Function1<? super String, String> optionFormatter) {
        PsiElement leftParen;
        Intrinsics.checkParameterIsNotNull(nextElement, (String)"nextElement");
        Intrinsics.checkParameterIsNotNull(optionFormatter, (String)"optionFormatter");
        List result2 = new ArrayList();
        SqlTokenType sqlTokenType = SqlElementTypes.SQL_LEFT_PAREN;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlTokenType, (String)"SqlElementTypes.SQL_LEFT_PAREN");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlTokenType);
        if (psiElement == null) {
            return result2;
        }
        PsiElement current = leftParen = psiElement;
        while (true) {
            PsiElement psiElement2;
            block7: {
                PsiElement literal;
                PsiElement option;
                PsiElement psiElement3 = current;
                if ((psiElement3 != null ? this.getElementType(psiElement3) : null) == null || !(Intrinsics.areEqual((Object)this.getElementType(current), (Object)SqlElementTypes.SQL_RIGHT_PAREN) ^ true)) break;
                if ((PsiElement)nextElement.invoke((Object)current) == null) {
                    return result2;
                }
                PsiElement psiElement4 = option.getNextSibling();
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
                if (this.findSibling(psiElement4, (IElementType)sqlCompositeElementType) == null) {
                    return result2;
                }
                PsiElement psiElement5 = literal;
                if (psiElement5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl");
                }
                String literalValue = ((SqlStringLiteralExpressionImpl)psiElement5).getValue();
                if (literalValue != null) {
                    result2.add(option.getText() + "=" + (String)optionFormatter.invoke((Object)literalValue));
                }
                PostgresBaseObjectBuilder this_$iv = this;
                for (PsiElement tmp$iv = literal; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                    PsiElement it = tmp$iv;
                    if (!(Intrinsics.areEqual((Object)it, (Object)literal) ^ true && Intrinsics.areEqual((Object)this.getElementType(it), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                    psiElement2 = tmp$iv;
                    break block7;
                }
                psiElement2 = null;
            }
            current = psiElement2;
        }
        return result2;
    }

    private final void buildRoutineFromCreateFunction(BasicModRoutine obj, SqlCreateFunctionStatementImpl source) {
        BasicModRoutine basicModRoutine = obj;
        if (basicModRoutine == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgresbase.PostgresBaseModRoutine");
        }
        PostgresBaseModRoutine cfr_ignored_0 = (PostgresBaseModRoutine)basicModRoutine;
        super.buildRoutine(obj, (DasObject)source);
        ((PostgresBaseModRoutine)obj).setArgumentsDefinition(this.getRoutineArgumentsDefinition(source));
        ((PostgresBaseModRoutine)obj).setResultsDefinition(this.getRoutineResultDefinition(source));
        ((BasicModModel)((PostgresBaseModRoutine)obj).getModel()).writeSources(new Runnable(this, obj, source){
            final /* synthetic */ PostgresBaseObjectBuilder this$0;
            final /* synthetic */ BasicModRoutine $obj;
            final /* synthetic */ SqlCreateFunctionStatementImpl $source;

            public final void run() {
                SimpleCompositeText simpleCompositeText;
                PostgresBaseModRoutine postgresBaseModRoutine = (PostgresBaseModRoutine)this.$obj;
                String string = PostgresBaseObjectBuilder.access$getRoutineSourceText(this.this$0, this.$source);
                if (string != null) {
                    String string2 = string;
                    PostgresBaseModRoutine postgresBaseModRoutine2 = postgresBaseModRoutine;
                    String it = string2;
                    SimpleCompositeText simpleCompositeText2 = new SimpleCompositeText(it, CompositeText.Kind.ORIGINAL_TEXT);
                    postgresBaseModRoutine = postgresBaseModRoutine2;
                    simpleCompositeText = simpleCompositeText2;
                } else {
                    simpleCompositeText = null;
                }
                postgresBaseModRoutine.setSourceText(simpleCompositeText);
            }
            {
                this.this$0 = postgresBaseObjectBuilder;
                this.$obj = basicModRoutine;
                this.$source = sqlCreateFunctionStatementImpl;
            }
        });
    }

    private final String getRoutineArgumentsDefinition(SqlCreateFunctionStatementImpl source) {
        PsiElement rParen;
        PsiElement lParen;
        PsiElement params2;
        block7: {
            block6: {
                PsiElement psiElement = (PsiElement)source;
                IElementType iElementType = PgTypes.PG_PARAMETER_LIST;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PgTypes.PG_PARAMETER_LIST");
                PsiElement psiElement2 = this.findChild(psiElement, iElementType);
                if (psiElement2 == null) {
                    return null;
                }
                params2 = psiElement2;
                lParen = params2.getFirstChild();
                rParen = params2.getLastChild();
                PsiElement psiElement3 = lParen;
                if (Intrinsics.areEqual((Object)(psiElement3 != null ? this.getElementType(psiElement3) : null), (Object)PgTypes.PG_LEFT_PAREN) ^ true) break block6;
                PsiElement psiElement4 = rParen;
                if (!(Intrinsics.areEqual((Object)(psiElement4 != null ? this.getElementType(psiElement4) : null), (Object)PgTypes.PG_RIGHT_PAREN) ^ true)) break block7;
            }
            return null;
        }
        String string = params2.getText();
        int n = lParen.getStartOffsetInParent() + lParen.getTextLength();
        int n2 = rParen.getStartOffsetInParent();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (boolean)false, (int)1, null);
    }

    private final String getRoutineResultDefinition(SqlCreateFunctionStatementImpl source) {
        PsiElement returns;
        PsiElement psiElement = (PsiElement)source;
        IElementType iElementType = PgTypes.PG_RETURNS_CLAUSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PgTypes.PG_RETURNS_CLAUSE");
        PsiElement psiElement2 = this.findChild(psiElement, iElementType);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement params2 = psiElement2;
        PsiElement psiElement3 = returns = params2.getFirstChild();
        if (Intrinsics.areEqual((Object)(psiElement3 != null ? this.getElementType(psiElement3) : null), (Object)PgTypes.PG_RETURNS) ^ true) {
            return null;
        }
        String string = params2.getText();
        int n = returns.getStartOffsetInParent() + returns.getTextLength();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string4)).toString(), (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getRoutineSourceText(SqlCreateFunctionStatementImpl source) {
        String string;
        PsiElement code;
        PsiElement psiElement;
        PostgresBaseObjectBuilder postgresBaseObjectBuilder;
        block6: {
            PsiElement element$iv$iv;
            void this_$iv;
            postgresBaseObjectBuilder = this;
            PsiElement psiElement2 = (PsiElement)source;
            IElementType iElementType = PostgresElementTypes.PG_LAZY_CODE_BLOCK_PARENT;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"PostgresElementTypes.PG_LAZY_CODE_BLOCK_PARENT");
            PsiElement el$iv = this.findChild(psiElement2, iElementType);
            void var5_4 = this_$iv;
            PsiElement psiElement3 = el$iv;
            for (PsiElement tmp$iv$iv = element$iv$iv = (v1615293) != null ? (v1615293).getFirstChild() : null; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                IElementType type = this.getElementType(it);
                boolean bl = Intrinsics.areEqual((Object)type, (Object)PostgresElementTypes.PG_LAZY_CODE_BLOCK) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_STRING_LITERAL);
                if (!bl) continue;
                psiElement = tmp$iv$iv;
                break block6;
            }
            psiElement = null;
        }
        PsiElement psiElement4 = code = psiElement;
        Object object = postgresBaseObjectBuilder = psiElement4 != null ? this.getElementType(psiElement4) : null;
        if (Intrinsics.areEqual((Object)postgresBaseObjectBuilder, (Object)PostgresElementTypes.PG_LAZY_CODE_BLOCK)) {
            PsiElement psiElement5 = code;
            string = psiElement5 != null ? psiElement5.getText() : null;
        } else if (Intrinsics.areEqual((Object)postgresBaseObjectBuilder, (Object)SqlElementTypes.SQL_STRING_LITERAL)) {
            PsiElement psiElement6 = code;
            if (psiElement6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl");
            }
            SqlStringLiteralExpressionImpl cfr_ignored_0 = (SqlStringLiteralExpressionImpl)psiElement6;
            StringBuilder builder = new StringBuilder();
            TextRange innerRange = SqlStringLiteralManipulator.getStringTokenRange((SqlStringLiteralExpressionImpl)code);
            ((SqlStringLiteralExpressionImpl)code).createLiteralTextEscaper().decode(innerRange, builder);
            string = builder.toString();
        } else {
            string = null;
        }
        return string;
    }

    private final void buildOperator(PostgresBaseModOperator obj, DasObject source) {
        this.buildBasicElement(obj, source);
        if (source instanceof DasOperator) {
            DataType dataType = (DataType)CollectionsKt.getOrNull((List)((DasOperator)source).getArgumentTypes(), (int)0);
            if (dataType == null) {
                dataType = DataType.UNKNOWN;
            }
            obj.setLeftType(dataType);
            DataType dataType2 = (DataType)CollectionsKt.getOrNull((List)((DasOperator)source).getArgumentTypes(), (int)1);
            if (dataType2 == null) {
                dataType2 = DataType.UNKNOWN;
            }
            obj.setRightType(dataType2);
            obj.setResultType(((DasOperator)source).getResultType());
            DasOperator.OperatorNotation operatorNotation = ((DasOperator)source).getOperatorNotation();
            Intrinsics.checkExpressionValueIsNotNull((Object)operatorNotation, (String)"source.operatorNotation");
            obj.setOperatorKind(this.getPgOperatorKind(operatorNotation));
        }
    }

    private final PostgresOperatorKind getPgOperatorKind(DasOperator.OperatorNotation n) {
        if (Intrinsics.areEqual((Object)n, (Object)DasOperator.OperatorNotation.INFIX)) {
            return PostgresOperatorKind.BINARY;
        }
        if (Intrinsics.areEqual((Object)n, (Object)DasOperator.OperatorNotation.POSTFIX)) {
            return PostgresOperatorKind.POSTFIX;
        }
        return Intrinsics.areEqual((Object)n, (Object)DasOperator.OperatorNotation.PREFIX) ? PostgresOperatorKind.PREFIX : PostgresOperatorKind.UNKNOWN;
    }

    @Nullable
    public static final /* synthetic */ String access$getRoutineSourceText(PostgresBaseObjectBuilder $this, @NotNull SqlCreateFunctionStatementImpl source) {
        return $this.getRoutineSourceText(source);
    }
}

