/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import com.intellij.sql.psi.impl.ConcreteSqlTableType;
import com.intellij.sql.psi.impl.SqlTableTypeComposite;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableTypeBase
extends SqlTableType {
    public static final SqlTableType EMPTY_TABLE = new Empty(){

        @Override
        public SqlTableType join(SqlTableType type) {
            return type;
        }

        @Override
        public SqlTableType add(SqlTableType type) {
            return type;
        }
    };

    public static SqlTableType ensureTableType(SqlType type, @NotNull SqlElement element, @Nullable PsiElement qualifier) {
        if (element == null) {
            SqlTableTypeBase.$$$reportNull$$$0(0);
        }
        if (type instanceof SqlTableType) {
            return (SqlTableType)type;
        }
        return SqlTableTypeBase.createType(element, type, element instanceof SqlNameElement ? element.getName() : element.getText(), qualifier);
    }

    public static SqlTableType createType(final @NotNull SqlElement element, final @NotNull SqlType type, final @Nullable String name, final @Nullable PsiElement qualifier) {
        if (element == null) {
            SqlTableTypeBase.$$$reportNull$$$0(1);
        }
        if (type == null) {
            SqlTableTypeBase.$$$reportNull$$$0(2);
        }
        String colTypeSpec = type.getDataType().getSpecification();
        final DataType dataType = DataTypeFactory.of(null, "table", name == null ? colTypeSpec : name + " " + colTypeSpec, null);
        return new SqlTableTypeBase(){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int i2) {
                return name;
            }

            public SqlType getColumnType(int i2) {
                return type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                SqlElement sqlElement = element;
                if (sqlElement == null) {
                    2.$$$reportNull$$$0(1);
                }
                return sqlElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
            }

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                SqlElement e = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
                DasTable table = e instanceof PsiColumn ? ((PsiColumn)e).getTable() : null;
                return table instanceof PsiElement ? (PsiElement)table : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static SqlTableType createUnresolvedTableType(@NotNull PsiReference reference) {
        if (reference == null) {
            SqlTableTypeBase.$$$reportNull$$$0(3);
        }
        return new UnresolvedRefType(reference);
    }

    public static SqlTableType createType(@NotNull PsiTable info, @Nullable PsiElement place) {
        if (info == null) {
            SqlTableTypeBase.$$$reportNull$$$0(4);
        }
        return new TableBasedSqlTableTypeImpl<DasColumn>((PsiObject)info, place, DasColumn.class, ObjectKind.COLUMN);
    }

    public static SqlTableType createObjectTypeType(@NotNull PsiObject info, @Nullable PsiElement place) {
        if (info == null) {
            SqlTableTypeBase.$$$reportNull$$$0(5);
        }
        return new TableBasedSqlTableTypeImpl<DasTypedObject>(info, place, DasTypedObject.class, ObjectKind.OBJECT_ATTRIBUTE);
    }

    @NotNull
    public SqlType.Category getCategory() {
        SqlType.Category category = SqlType.Category.TABLE;
        if (category == null) {
            SqlTableTypeBase.$$$reportNull$$$0(6);
        }
        return category;
    }

    @Nullable
    public PsiElement getTypeElement() {
        return null;
    }

    @Nullable
    public String getTypeName() {
        return null;
    }

    @Nullable
    public String getColumnTypeAlias(int i2) {
        return null;
    }

    public boolean isColumnTypeAliasQuoted(int i2) {
        return (Boolean)ObjectUtils.chooseNotNull((Object)SqlTableTypeBase.isQuoted(this.getColumnQualifier(i2)), (Object)false);
    }

    public boolean isColumnQuoted(int i2) {
        Boolean quoted = SqlTableTypeBase.isQuoted(this.getSourceColumnElement(i2));
        return quoted == null ? ((Boolean)ObjectUtils.chooseNotNull((Object)SqlTableTypeBase.isQuoted(this.getColumnElement(i2)), (Object)false)).booleanValue() : quoted.booleanValue();
    }

    @Nullable
    private static Boolean isQuoted(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlNameElement) {
            return DbSqlUtil.isQuoted((SqlNameElement)element);
        }
        if (element instanceof DasObject) {
            return DbSqlUtil.isQuoted((DasObject)element);
        }
        return null;
    }

    public SqlTableType join(SqlTableType type) {
        return SqlTableTypeComposite.join(this, type);
    }

    public SqlTableType add(SqlTableType type) {
        return SqlTableTypeComposite.add(this, type);
    }

    public SqlTableType subtract(@Nullable PsiElement element) {
        return SubtractedSqlTableTypeImpl.subtract(this, element);
    }

    public SqlTableType alias(String aliasName, @Nullable PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
        if (newColumns == null) {
            SqlTableTypeBase.$$$reportNull$$$0(7);
        }
        return new AliasedSqlTableType(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType concretize(@Nullable SqlType.Category category) {
        return new ConcreteSqlTableType(this, category);
    }

    public static <T extends SqlNameElement> List<T> expand(List<T> aliases, int size) {
        ArrayList res = ContainerUtil.newArrayList(aliases);
        for (int i2 = res.size(); i2 < size; ++i2) {
            res.add(null);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureTableType";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedTableType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createObjectTypeType";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnresolvedRefType
    extends Empty {
        private final PsiReference myReference;

        public UnresolvedRefType(PsiReference reference) {
            this.myReference = reference;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myReference.getCanonicalText();
        }

        @Override
        @Nullable
        public PsiElement getTypeElement() {
            return this.myReference.getElement();
        }
    }

    public static class Empty
    extends SqlTableTypeBase {
        @NotNull
        public DataType getDataType() {
            DataType dataType = DataTypeFactory.of("table()");
            if (dataType == null) {
                Empty.$$$reportNull$$$0(0);
            }
            return dataType;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int i2) {
            throw new NoSuchElementException();
        }

        public SqlType getColumnType(int i2) {
            throw new NoSuchElementException();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            throw new NoSuchElementException();
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        public PsiElement getSourceColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public String getColumnTypeAlias(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public SqlTableType subtract(PsiElement element) {
            return this;
        }

        @Override
        public SqlTableType alias(String aliasName, PsiElement aliasElement, @NotNull List<? extends SqlNameElement> newColumns) {
            if (newColumns == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return newColumns.isEmpty() ? this : new AliasedSqlTableType(this, aliasName, aliasElement, newColumns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTableTypeBase$Empty";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "alias";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

