/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LightPsiParser;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.script.ReadOnlySqlFile;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlReaderImpl
extends SqlReader {
    private static final Logger LOG = Logger.getInstance(SqlReaderImpl.class);
    private static final int READER_BUF_SIZE = 102400;
    private static final int PARSER_CHUNK = 1024000;
    private final Project myProject;
    private final Language myHostLanguage;

    public SqlReaderImpl(@NotNull Project project) {
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public SqlReaderImpl(@NotNull Project project, @Nullable Language hostLanguage) {
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myHostLanguage = hostLanguage;
    }

    @NotNull
    public SqlFile getReadOnlyPsi(@NotNull SqlLanguageDialect language, @NotNull CharSequence text2) {
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(2);
        }
        if (text2 == null) {
            SqlReaderImpl.$$$reportNull$$$0(3);
        }
        SqlFile sqlFile = SqlReaderImpl.asPsi(SqlReaderImpl.sqlTraverser(this.myProject, language, text2, null, this.myHostLanguage), PsiManager.getInstance((Project)this.myProject));
        if (sqlFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(4);
        }
        return sqlFile;
    }

    @NotNull
    public static SqlFile asPsi(@NotNull SyntaxTraverser<LighterASTNode> traverser2, @NotNull PsiManager manager) {
        if (traverser2 == null) {
            SqlReaderImpl.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            SqlReaderImpl.$$$reportNull$$$0(6);
        }
        SqlFile sqlFile = SqlReaderImpl.asPsi(traverser2, null, manager, null);
        if (sqlFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(7);
        }
        return sqlFile;
    }

    @NotNull
    public static SqlFile asPsi(@NotNull SyntaxTraverser<LighterASTNode> traverser2, @Nullable SqlLanguageDialect dialect, @NotNull PsiManager manager, @Nullable PsiElement forcedContext) {
        if (traverser2 == null) {
            SqlReaderImpl.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            SqlReaderImpl.$$$reportNull$$$0(9);
        }
        LighterASTNode root2 = (LighterASTNode)ObjectUtils.assertNotNull((Object)traverser2.getRoot());
        ReadOnlySqlFile readOnlySqlFile = new ReadOnlySqlFile("a.sql", (Language)(dialect == null ? root2.getTokenType().getLanguage() : dialect), root2, traverser2, manager, forcedContext);
        if (readOnlySqlFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(10);
        }
        return readOnlySqlFile;
    }

    @NotNull
    public SyntaxTraverser<LighterASTNode> parseSql(@NotNull SqlLanguageDialect language, @NotNull CharSequence charSequence) {
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(11);
        }
        if (charSequence == null) {
            SqlReaderImpl.$$$reportNull$$$0(12);
        }
        SyntaxTraverser<LighterASTNode> syntaxTraverser = this.parseSql(language, null, charSequence);
        if (syntaxTraverser == null) {
            SqlReaderImpl.$$$reportNull$$$0(13);
        }
        return syntaxTraverser;
    }

    @NotNull
    public SyntaxTraverser<LighterASTNode> parseSql(@NotNull SqlLanguageDialect language, @Nullable IElementType forcedRootType, @NotNull CharSequence charSequence) {
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(14);
        }
        if (charSequence == null) {
            SqlReaderImpl.$$$reportNull$$$0(15);
        }
        SyntaxTraverser<LighterASTNode> syntaxTraverser = SqlReaderImpl.sqlTraverser(this.myProject, language, charSequence, forcedRootType, this.myHostLanguage);
        if (syntaxTraverser == null) {
            SqlReaderImpl.$$$reportNull$$$0(16);
        }
        return syntaxTraverser;
    }

    private static SyntaxTraverser<LighterASTNode> sqlTraverser(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull CharSequence charSequence, @Nullable IElementType forcedRootType, @Nullable Language hostLanguage) {
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(17);
        }
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(18);
        }
        if (charSequence == null) {
            SqlReaderImpl.$$$reportNull$$$0(19);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(parserDefinition.createLexer(project), (Language)language, hostLanguage, DatabaseSettings.getSettings());
        LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, lexer, charSequence);
        IElementType rootType = (IElementType)ObjectUtils.notNull((Object)forcedRootType, (Object)parserDefinition.getFileNodeType());
        parser.parseLight(rootType, builder);
        return SyntaxTraverser.lightTraverser((PsiBuilder)builder);
    }

    public JBIterable<SyntaxTraverser<LighterASTNode>> parseSql(final @NotNull SqlLanguageDialect language, final @NotNull VirtualFile virtualFile, final @NotNull Disposable disposable) {
        Document document;
        if (language == null) {
            SqlReaderImpl.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            SqlReaderImpl.$$$reportNull$$$0(21);
        }
        if (disposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(22);
        }
        Document document2 = document = SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile) ? null : FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document != null) {
            return JBIterable.of(SqlReaderImpl.getStatementTraverser(this.parseSql(language, document.getText())));
        }
        return new JBIterable<SyntaxTraverser<LighterASTNode>>(){

            @NotNull
            public Iterator<SyntaxTraverser<LighterASTNode>> iterator() {
                Iterator iterator;
                try {
                    long length = virtualFile.getLength();
                    final InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), virtualFile.getCharset());
                    Disposable inputDisposable = new Disposable(){

                        public void dispose() {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    };
                    Disposer.register((Disposable)disposable, (Disposable)inputDisposable);
                    iterator = SqlReaderImpl.processSyntaxImpl(SqlReaderImpl.this.myProject, (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language), reader, length, inputDisposable);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlReaderImpl$1", "iterator"));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static Iterator<SyntaxTraverser<LighterASTNode>> processSyntaxImpl(final @NotNull Project project, final @NotNull ParserDefinition parserDefinition, final @NotNull Reader reader, final long fileSize, @NotNull Disposable disposable) throws IOException {
        void inputDisposable;
        if (project == null) {
            SqlReaderImpl.$$$reportNull$$$0(23);
        }
        if (parserDefinition == null) {
            SqlReaderImpl.$$$reportNull$$$0(24);
        }
        if (reader == null) {
            SqlReaderImpl.$$$reportNull$$$0(25);
        }
        if (disposable == null) {
            SqlReaderImpl.$$$reportNull$$$0(26);
        }
        return new Iterator<SyntaxTraverser<LighterASTNode>>((Disposable)inputDisposable){
            long myMaxMemory = Runtime.getRuntime().maxMemory();
            int myChunkSize = 1024000;
            Lexer lexer = parserDefinition.createLexer(project);
            LightPsiParser parser = (LightPsiParser)parserDefinition.createParser(project);
            PsiBuilderFactory psiBuilderFactory = PsiBuilderFactory.getInstance();
            StringBuilder text = new StringBuilder(this.myChunkSize);
            char[] buf = new char[Math.min(102400, this.myChunkSize)];
            CharArrayCharSequence seq = new CharArrayCharSequence(this.buf);
            Exception error;
            boolean bufferPrepared;
            int partIndex;
            long partOffset;
            final /* synthetic */ Disposable val$inputDisposable;
            {
                this.val$inputDisposable = disposable;
            }

            @Override
            public boolean hasNext() {
                return this.bufferPrepared || this.prepareBuffer();
            }

            @Override
            public SyntaxTraverser<LighterASTNode> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (true) {
                    try {
                        SyntaxTraverser<LighterASTNode> s = this.buildTraverser();
                        this.bufferPrepared = false;
                        return s;
                    }
                    catch (TooLongStatementException e) {
                        if ((long)this.myChunkSize > this.myMaxMemory / 16L) {
                            throw e;
                        }
                        LOG.info(e.getMessage());
                        LOG.info("increasing parser buffer to: " + StringUtil.formatFileSize((long)this.myChunkSize) + " (file size " + StringUtil.formatFileSize((long)fileSize) + ")");
                        this.myChunkSize *= 2;
                        this.prepareBuffer();
                        continue;
                    }
                    break;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            boolean prepareBuffer() {
                int read2;
                do {
                    try {
                        read2 = reader.read(this.buf);
                    }
                    catch (IOException e) {
                        this.error = e;
                        return false;
                    }
                    if ((read2 > 0 || this.text.length() <= 0) && (read2 <= 0 || this.text.append(this.seq.subSequence(0, read2)).length() < this.myChunkSize)) continue;
                    this.bufferPrepared = true;
                    return true;
                } while (read2 > 0);
                Disposer.dispose((Disposable)this.val$inputDisposable);
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private SyntaxTraverser<LighterASTNode> buildTraverser() {
                int lastOffset;
                boolean isLast = this.text.length() < this.myChunkSize;
                String str = this.text.toString();
                SyntaxTraverser<LighterASTNode> traverser2 = this.parseImpl(str);
                int firstOffset = 0;
                if (!isLast) {
                    LighterASTNode lastToSkip = (LighterASTNode)traverser2.getRawDeepestLast();
                    if (lastToSkip != null && traverser2.api.typeOf((Object)lastToSkip) == SqlCompositeElementTypes.SQL_INSERT_STATEMENT && traverser2.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                        SyntaxTraverser s = (SyntaxTraverser)traverser2.reset();
                        LighterASTNode valuesExpr = (LighterASTNode)s.filterTypes(Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_VALUES_EXPRESSION)).traverse().first();
                        LighterASTNode valuesNode = (LighterASTNode)s.filterTypes(Conditions.equalTo((Object)SqlCommonKeywords.SQL_VALUES)).traverse().first();
                        Condition isParExpr = Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_PARENTHESIZED_EXPRESSION));
                        JBIterable parExprs = ((SyntaxTraverser)((SyntaxTraverser)((SyntaxTraverser)s.withRoot((Object)valuesExpr)).expand(Conditions.equalTo((Object)valuesExpr))).filter(isParExpr)).traverse();
                        LighterASTNode last = null;
                        LighterASTNode prev = null;
                        for (LighterASTNode expr : parExprs) {
                            prev = last;
                            last = expr;
                        }
                        if (valuesNode == null || last == null || prev == null) throw this.tooLongStatement(traverser2, lastToSkip);
                        lastToSkip = last;
                        firstOffset = traverser2.api.rangeOf((Object)valuesNode).getEndOffset() + 1;
                        traverser2 = this.parseImpl(str.substring(0, traverser2.api.rangeOf((Object)prev).getEndOffset()));
                    } else {
                        if (lastToSkip == null || traverser2.api.rangeOf((Object)lastToSkip).getStartOffset() == 0) {
                            throw this.tooLongStatement(traverser2, lastToSkip);
                        }
                        LighterASTNode forceIgnore = lastToSkip;
                        traverser2 = (SyntaxTraverser<LighterASTNode>)traverser2.forceIgnore(input -> input == forceIgnore);
                    }
                    lastOffset = traverser2.api.rangeOf((Object)lastToSkip).getStartOffset();
                    this.text = this.text.delete(firstOffset, lastOffset);
                } else {
                    lastOffset = this.text.length();
                    this.text.setLength(0);
                }
                traverser2.putUserData(SqlReader.PART_INDEX, (Object)this.partIndex++);
                traverser2.putUserData(SqlReader.PART_OFFSET, (Object)this.partOffset);
                this.partOffset += (long)lastOffset;
                return traverser2;
            }

            @NotNull
            private SyntaxTraverser<LighterASTNode> parseImpl(String s) {
                PsiBuilder builder = this.psiBuilderFactory.createBuilder(parserDefinition, this.lexer, (CharSequence)s);
                this.parser.parseLight((IElementType)parserDefinition.getFileNodeType(), builder);
                SyntaxTraverser syntaxTraverser = SqlReaderImpl.getStatementTraverser(SyntaxTraverser.lightTraverser((PsiBuilder)builder));
                if (syntaxTraverser == null) {
                    2.$$$reportNull$$$0(0);
                }
                return syntaxTraverser;
            }

            @NotNull
            private TooLongStatementException tooLongStatement(SyntaxTraverser<LighterASTNode> traverser2, LighterASTNode lastToSkip) {
                TooLongStatementException tooLongStatementException = new TooLongStatementException((lastToSkip == null ? "<unknown>" : traverser2.api.typeOf((Object)lastToSkip)) + " statement is longer than " + StringUtil.formatFileSize((long)this.myChunkSize));
                if (tooLongStatementException == null) {
                    2.$$$reportNull$$$0(1);
                }
                return tooLongStatementException;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/script/SqlReaderImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseImpl";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tooLongStatement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static <E> SyntaxTraverser<E> getStatementTraverser(@NotNull SyntaxTraverser<E> s) {
        if (s == null) {
            SqlReaderImpl.$$$reportNull$$$0(27);
        }
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)((SyntaxTraverser)s.forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).expand(Conditions.alwaysFalse())).filterTypes(SqlReaderImpl.sqlTypesCondition()).withTraversal(TreeTraversal.LEAVES_DFS);
        if (syntaxTraverser == null) {
            SqlReaderImpl.$$$reportNull$$$0(28);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static Condition<IElementType> sqlTypesCondition() {
        Condition condition = t -> {
            if (t instanceof IsExternal) {
                return false;
            }
            return t instanceof SqlCompositeElementType || t instanceof IStubElementType || t instanceof SqlFileElementType;
        };
        if (condition == null) {
            SqlReaderImpl.$$$reportNull$$$0(29);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputDisposable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlReaderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyPsi";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asPsi";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSql";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementTraverser";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTypesCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReadOnlyPsi";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 29: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "asPsi";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseSql";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlTraverser";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processSyntaxImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getStatementTraverser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

