/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.JavaAnalysisScope;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;

public class AnalysisScopeRule
implements GetDataRule {
    public Object getData(DataProvider dataProvider) {
        Object psiFile = dataProvider.getData(CommonDataKeys.PSI_FILE.getName());
        if (psiFile instanceof PsiJavaFile) {
            return new JavaAnalysisScope((PsiJavaFile)psiFile);
        }
        Object psiTarget = dataProvider.getData(CommonDataKeys.PSI_ELEMENT.getName());
        if (psiTarget instanceof PsiPackage) {
            PsiPackage pack = (PsiPackage)psiTarget;
            PsiManager manager = pack.getManager();
            if (!manager.isInProject((PsiElement)pack)) {
                return null;
            }
            PsiDirectory[] dirs = pack.getDirectories(GlobalSearchScope.projectScope((Project)manager.getProject()));
            if (dirs.length == 0) {
                return null;
            }
            return new JavaAnalysisScope(pack, (Module)dataProvider.getData(LangDataKeys.MODULE.getName()));
        }
        return null;
    }
}

