/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CatchTypeProvider
extends CompletionProvider<CompletionParameters> {
    static final ElementPattern<PsiElement> CATCH_CLAUSE_TYPE = PlatformPatterns.psiElement().insideStarting((ElementPattern)PlatformPatterns.psiElement(PsiTypeElement.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiCatchSection.class)));

    CatchTypeProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiTryStatement tryStatement;
        PsiCodeBlock tryBlock;
        if (parameters2 == null) {
            CatchTypeProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CatchTypeProvider.$$$reportNull$$$0(1);
        }
        PsiCodeBlock psiCodeBlock = tryBlock = (tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), PsiTryStatement.class)) == null ? null : tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        JavaCompletionSession session = new JavaCompletionSession(result);
        for (PsiClassType type3 : ExceptionUtil.getThrownExceptions((PsiElement[])tryBlock.getStatements())) {
            PsiClass typeClass = type3.resolve();
            if (typeClass == null) continue;
            result.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, type3));
            session.registerClass(typeClass);
        }
        List<PsiClassType> expectedClassTypes = Collections.singletonList(JavaPsiFacade.getElementFactory((Project)tryBlock.getProject()).createTypeByFQClassName("java.lang.Throwable"));
        JavaInheritorsGetter.processInheritors(parameters2, expectedClassTypes, result.getPrefixMatcher(), (Consumer<PsiType>)((Consumer)type2 -> {
            PsiClass psiClass;
            if (result == null) {
                CatchTypeProvider.$$$reportNull$$$0(3);
            }
            PsiClass psiClass2 = psiClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
            if (psiClass == null || psiClass instanceof PsiTypeParameter) {
                return;
            }
            if (!session.alreadyProcessed(psiClass)) {
                result.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, (PsiClassType)type2));
            }
        }));
    }

    @NotNull
    private static LookupElement createCatchTypeVariant(PsiCodeBlock tryBlock, PsiClassType type2) {
        TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)PsiTypeLookupItem.createLookupItem((PsiType)type2, (PsiElement)tryBlock), (TailType)TailType.HUMBLE_SPACE_BEFORE_WORD);
        if (tailTypeDecorator == null) {
            CatchTypeProvider.$$$reportNull$$$0(2);
        }
        return tailTypeDecorator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CatchTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CatchTypeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCatchTypeVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCompletions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

