/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class CreateInnerClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateInnerClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind2) {
        super(kind2, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", this.myKind.getDescription(), varName);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateInnerClassFromUsageFix.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null) {
            return;
        }
        String superClassName = this.getSuperClassName(element);
        PsiClass[] targets = CreateInnerClassFromUsageFix.getPossibleTargets(element);
        LOG.assertTrue(targets.length > 0);
        if (targets.length == 1) {
            this.doInvoke(targets[0], superClassName);
        } else {
            this.chooseTargetClass(targets, editor, superClassName);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateInnerClassFromUsageFix.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, file) && CreateInnerClassFromUsageFix.getPossibleTargets(this.getRefElement()).length > 0;
    }

    @NotNull
    private static PsiClass[] getPossibleTargets(PsiJavaCodeReferenceElement element) {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiJavaCodeReferenceElement run = element;
        PsiMember contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        while (contextMember != null) {
            if (contextMember instanceof PsiClass && !(contextMember instanceof PsiTypeParameter) && !CreateInnerClassFromUsageFix.isUsedInExtends((PsiElement)run, (PsiClass)contextMember)) {
                result.add((PsiClass)contextMember);
            }
            run = contextMember;
            contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        }
        PsiClass[] psiClassArray = result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            CreateInnerClassFromUsageFix.$$$reportNull$$$0(2);
        }
        return psiClassArray;
    }

    private static boolean isUsedInExtends(PsiElement element, PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getExtendsList();
        PsiReferenceList implementsList = psiClass.getImplementsList();
        if (extendsList != null && PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false)) {
            return true;
        }
        return implementsList != null && PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false);
    }

    private void chooseTargetClass(PsiClass[] classes2, Editor editor, String superClassName) {
        Project project = classes2[0].getProject();
        JBList list = new JBList((Object[])classes2);
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        list.setSelectionMode(0);
        list.setCellRenderer(renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        renderer.installSpeedSearch(builder);
        Runnable runnable = () -> this.lambda$chooseTargetClass$0((JList)list, superClassName);
        builder.setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    private void doInvoke(PsiClass aClass, String superClassName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref = this.getRefElement();
        assert (ref != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)aClass)) {
            return;
        }
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        PsiClass created = this.myKind == CreateClassKind.INTERFACE ? elementFactory.createInterface(refName) : (this.myKind == CreateClassKind.CLASS ? elementFactory.createClass(refName) : elementFactory.createEnum(refName));
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (aClass.isInterface() || PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            modifierList.setModifierProperty("packageLocal", true);
        } else {
            modifierList.setModifierProperty("private", true);
        }
        if (RefactoringUtil.isInStaticContext((PsiElement)ref, aClass) && !aClass.isInterface()) {
            modifierList.setModifierProperty("static", true);
        }
        if (superClassName != null) {
            CreateFromUsageUtils.setupSuperClassReference(created, superClassName);
        }
        CreateFromUsageBaseFix.setupGenericParameters(created, ref);
        WriteCommandAction.runWriteCommandAction((Project)aClass.getProject(), (String)this.getText(), null, () -> ref.bindToElement(aClass.add((PsiElement)created)), (PsiFile[])new PsiFile[]{aClass.getContainingFile()});
    }

    private /* synthetic */ void lambda$chooseTargetClass$0(JList list, String superClassName) {
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.doInvoke((PsiClass)list.getSelectedValue(), superClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateInnerClassFromUsageFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

