/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class SwitchStatementBranch {
    private final Set<PsiLocalVariable> m_pendingVariableDeclarations = new HashSet<PsiLocalVariable>(5);
    private final List<String> m_caseValues = new ArrayList<String>(2);
    private final List<PsiElement> m_bodyElements = new ArrayList<PsiElement>(5);
    private final List<PsiElement> m_pendingWhiteSpace = new ArrayList<PsiElement>(2);
    private boolean m_default;
    private boolean m_hasStatements;

    SwitchStatementBranch() {
    }

    public void addCaseValue(String labelString) {
        this.m_caseValues.add(labelString);
    }

    public void addStatement(PsiElement statement) {
        this.m_hasStatements = true;
        this.addElement(statement);
    }

    public void addComment(PsiElement comment) {
        this.addElement(comment);
    }

    private void addElement(PsiElement element) {
        this.m_bodyElements.addAll(this.m_pendingWhiteSpace);
        this.m_pendingWhiteSpace.clear();
        this.m_bodyElements.add(element);
    }

    public void addWhiteSpace(PsiElement statement) {
        if (!this.m_bodyElements.isEmpty()) {
            this.m_pendingWhiteSpace.add(statement);
        }
    }

    public List<String> getCaseValues() {
        return Collections.unmodifiableList(this.m_caseValues);
    }

    public List<PsiElement> getBodyElements() {
        return Collections.unmodifiableList(this.m_bodyElements);
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public void setDefault() {
        this.m_default = true;
    }

    public boolean hasStatements() {
        return this.m_hasStatements;
    }

    public void addPendingVariableDeclarations(Set<PsiLocalVariable> vars) {
        this.m_pendingVariableDeclarations.addAll(vars);
    }

    public Set<PsiLocalVariable> getPendingVariableDeclarations() {
        return Collections.unmodifiableSet(this.m_pendingVariableDeclarations);
    }
}

